(* persist.ml
 *
 * $Id: persist.ml,v 1.504 2004/12/22 15:27:08 zappa Exp $
 *
*** Copyright 2002-2004 The Netsem Team

    * Steve Bishop
    * Michael Compton
    * Matthew Fairbairn
    * Michael Norrish
    * Andrei Serjantov
    * Peter Sewell
    * Michael Smith
    * Keith Wansbrough

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

(* a tiny persistent-store library for use in testing pairs of Acute
programs that marshal and unmarshal - more convenient than TCP.  This
could be written in Acute, but for that testing want to avoid extra
reduction steps.  Put in the tcp subtree because, well, it's a bit
like tcp - we don't have a `right place' for this kind of thing, and I
don't want to make one up.  *)

let write s =
  let oc = open_out_bin "tmp-acute-store" in
  output_string oc s;
  close_out oc

let read () =
  let ic = open_in_bin "tmp-acute-store" in
  let len = in_channel_length ic in
  let s = String.create len in
  really_input ic s 0 len;     (* race, if the file changed *)
  close_in ic;
  s

let write2 s =
  let oc = open_out_bin "tmp-acute-store2" in
  output_string oc s;
  close_out oc

let read2 () =
  let ic = open_in_bin "tmp-acute-store2" in
  let len = in_channel_length ic in
  let s = String.create len in
  really_input ic s 0 len;     (* race, if the file changed *)
  close_in ic;
  s

