/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  en Automatique.  All rights reserved.  This file is distributed    */
/*  under the terms of the GNU Library General Public License, with    */
/*  the special exception on linking described in file LICENSE-OCAML.  */
/*                                                                     */
/***********************************************************************/

/* $Id: errmsg.c,v 1.505 2005/01/04 14:32:56 pes20 Exp $
 *
*** Copyright 2002-2004 The Netsem Team

    * Steve Bishop
    * Michael Compton
    * Matthew Fairbairn
    * Michael Norrish
    * Andrei Serjantov
    * Peter Sewell
    * Michael Smith
    * Keith Wansbrough

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- */

#include <errno.h>
#include <mlvalues.h>
#include <alloc.h>
#include <memory.h>
#include <misc.h>

extern int ns_error_table[];



// #ifdef HAS_STRERROR

#if 1  // hack to workaround strange includes

extern char * strerror(int);

CAMLprim value unix_error_message(value err)
{
  CAMLparam1(err);
  int errnum;
  errnum = Is_block(err) ? Int_val(Field(err, 0)) : ns_error_table[Int_val(err)];
  CAMLreturn(copy_string(strerror(errnum)));
}

#else

extern int sys_nerr;
extern char *sys_errlist[];

CAMLprim value unix_error_message(value err)
{
  CAMLparam1(err);
  int errnum;
  errnum = Is_block(err) ? Int_val(Field(err, 0)) : ns_error_table[Int_val(err)];
  if (errnum < 0 || errnum >= sys_nerr) {
    CAMLreturn(copy_string("Unknown error"));
  } else {
    CAMLreturn(copy_string(sys_errlist[errnum]));
  }
}

#endif
