(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * parser_hack_script_mli.ml                                      *
 *                                                                *
 * Version: $Id: parser_hack_script_mli.ml,v 1.503 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)
open Str;;
open Sys;;
open Unix;;

exception Fatal of string;;

let _ =
 (* Accept filename from commandline into which the token type is to be extracted *)
 let filename =
    let len = Array.length argv in
    if(len < 2) then
      raise(Fatal("Incorrect arguments: must specify a filename "))
    else
      Array.get argv 1
  in

  (* Create an input channel for the mli file *)
  let mli_fd = stdin in
  let mli_ch = in_channel_of_descr mli_fd in
  let mli_len = in_channel_length mli_ch in
  let mli_str = String.create mli_len in

  (* Input the mli file into a string buffer *)
  let _ = really_input mli_ch mli_str 0 mli_len in

  (* Do the some global search and replaces *)
  let mli_str = global_replace (regexp "\\bParsing\\b") "Myparsing" mli_str in
  let mli_str = global_replace (regexp "\\bLexing\\b") "Mylexing" mli_str in

  (* prefix "Myparsing.envp ->" to the right places *)
  let mli_str = global_replace
      (regexp "^\\(val \\)\\([a-z_][a-zA-Z_]*\\)\\( :\\)")
      "\\1\\2\\3 Myparsing.envp -> " mli_str in

  (* move the token type declaration (it will go in a separate file) *)
  let type_token_regexp =  regexp "^type token =\n\\(.+\n\\)*" in
  let _ = search_forward type_token_regexp mli_str 0 in
  let type_token_match = matched_string mli_str (* hate that hidden state in Str *) in
  let mli_str = global_replace type_token_regexp "" mli_str in
  let mli_str = "type token = " ^ String.capitalize filename ^ ".token\n" ^ mli_str in

  let _ = close mli_fd in

  (* Write the modified mli to stdout and the token decl to filename *)
  let mli_fd = stdout in
  let mli_ch = out_channel_of_descr mli_fd in
  let _ = output mli_ch mli_str 0 (String.length mli_str) in

  let mltok_fd = handle_unix_error (fun () -> openfile (filename ^ ".ml") [O_WRONLY; O_CREAT; O_TRUNC] 0o664) () in
  let mltok_ch = out_channel_of_descr mltok_fd in
  let _ = output mltok_ch type_token_match 0 (String.length type_token_match) in ();;

  ();;

