(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         *)
(*                                                                     *)
(*  Copyright 1996 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the GNU Library General Public License, with    *)
(*  the special exception on linking described in file LICENSE-OCAML.  *)
(*                                                                     *)
(***********************************************************************)

(* $Id: myparsing.mli,v 1.503 2004/12/22 15:27:07 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

(** The run-time library for parsers generated by [ocamlyacc]. *)

type parser_env
type current_lookahead_function
type envp = parser_env * current_lookahead_function

val symbol_start : envp -> int
(** [symbol_start] and {!Myparsing.symbol_end} are to be called in the
   action part of a grammar rule only. They return the offset of the
   string that matches the left-hand side of the rule: [symbol_start()]
   returns the offset of the first character; [symbol_end()] returns the
   offset after the last character. The first character in a file is at
   offset 0. *)

val symbol_end : envp -> int
(** See {!Myparsing.symbol_start}. *)

val rhs_start : envp -> int -> int
(** Same as {!Myparsing.symbol_start} and {!Myparsing.symbol_end}, but
   return the offset of the string matching the [n]th item on the
   right-hand side of the rule, where [n] is the integer parameter
   to [lhs_start] and [lhs_end]. [n] is 1 for the leftmost item. *)

val rhs_end : envp -> int -> int
(** See {!Myparsing.rhs_start}. *)

val symbol_start_pos : envp -> Mylexing.position;;
(** Same as [symbol_start], but return a [position] instead of an offset. *)

val symbol_end_pos : envp -> Mylexing.position
(** Same as [symbol_end], but return a [position] instead of an offset. *)

val rhs_start_pos : envp -> int -> Mylexing.position
(** Same as [rhs_start], but return a [position] instead of an offset. *)

val rhs_end_pos : envp -> int -> Mylexing.position
(** Same as [rhs_end], but return a [position] instead of an offset. *)

val clear_parser : envp -> unit
(** Empty the parser stack. Call it just after a parsing function
   has returned, to remove all pointers from the parser stack
   to structures that were built by semantic actions during parsing.
   This is optional, but lowers the memory requirements of the
   programs. *)

exception Parse_error
(** Raised when a parser encounters a syntax error.
   Can also be raised from the action part of a grammar rule,
   to initiate error recovery. *)
exception Unbound_identifier of string
exception Runtime_mismatch of string



(**/**)

(** {6  } *)

(** The following definitions are used by the generated parsers only.
   They are not intended to be used by user programs. *)

type parse_tables =
  { actions : (envp -> Obj.t) array;
    transl_const : int array;
    transl_block : int array;
    lhs : string;
    len : string;
    defred : string;
    dgoto : string;
    sindex : string;
    rindex : string;
    gindex : string;
    tablesize : int;
    table : string;
    check : string;
    error_function : string -> unit;
    names_const : string;
    names_block : string }

exception YYexit of Obj.t

val yyparse :
  envp -> parse_tables -> int -> (Mylexing.lexbuf -> 'a) -> Mylexing.lexbuf -> 'b
val peek_val : envp -> int -> 'a
val is_current_lookahead : envp -> 'a -> bool
val parse_error : string -> unit

val new_envp : unit -> envp
