(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         *)
(*                                                                     *)
(*  Copyright 1996 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the GNU Library General Public License, with    *)
(*  the special exception on linking described in file LICENSE-OCAML.  *)
(*                                                                     *)
(***********************************************************************)

(* $Id: location.mli,v 1.504 2004/12/22 16:17:02 leifer Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

(* Acute changes:
   - pushed Myparsing.envp throughout
*)

(* Source code locations (ranges of positions), used in parsetree. *)

open Format

type t = {
  loc_start: Mylexing.position;
  loc_end: Mylexing.position;
  loc_ghost: bool;
}

(* Note on the use of Mylexing.position in this module.
   If [pos_fname = ""], then use [!input_name] instead.
   If [pos_lnum = -1], then [pos_bol = 0]. Use [pos_cnum] and
     re-parse the file to get the line and character numbers.
   Else all fields are correct.
*)

val none : t
(** An arbitrary value of type [t]; describes an empty ghost range. *)
val init : Mylexing.lexbuf -> string -> unit
(** Set the file name and line number of the [lexbuf] to be the start
    of the named file. *)
val curr : Mylexing.lexbuf -> t
(** Get the location of the current token from the [lexbuf]. *)

val symbol_rloc: Myparsing.envp -> t
val symbol_gloc: Myparsing.envp -> t
val rhs_loc:  Myparsing.envp  -> int -> t
val print: unit -> t -> string

val get_pos_info : Mylexing.position -> string * int * int (* file, line, char *)

(*
val input_name: string ref
val input_lexbuf: Mylexing.lexbuf option ref



val print: formatter -> t -> unit
val print_warning: t -> formatter -> Warnings.t -> unit
val prerr_warning: t -> Warnings.t -> unit

val echo_eof: unit -> unit
val reset: unit -> unit

val highlight_locations: formatter -> t -> t -> bool
*)
