(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * linkok.ml                                                      *
 *                                                                *
 * Version: $Id: linkok.ml,v 1.513 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

open Ast
open Tysupp

exception Linkok_not of string

type vn_vc = VN of version | VC of version_constraint

(* M notes: this ruins the point of thunkifying! *)
let debug s = Debug.print' Opts.DBC_linkok (function () -> s)

let syntacticsubsig : signature_item list -> signature_item list -> unit
  = fun sign1_0 sign2_0 ->
    let fail sign1 sign2 reason =
      let ps = Dump.fresh_printer_state 1 0 false in
      let (s1,ps1) = Pretty.print_signature_ps ps (no_loc sign1_0) in
      let (s2,ps2) = Pretty.print_signature_ps ps (no_loc sign2_0) in
      let print_si psn = function
          [] -> "<end of signature>"
        | (si::_) -> Pretty.print_signature_item psn si
      in
      raise (Linkok_not (reason
                         ^ "\nActual signature: " ^ s1
                         ^ "\nExpected signature: " ^ s2
                         ^ "\nat actual field: " ^ print_si ps1 sign1
                         ^ "\nand expected field: " ^ print_si ps2 sign2))
    in
    let rec go tenv m1 m2 sign1 sign2 =
      match (sign1, sign2) with
        ([],[]) ->
          ()
      | ({desc=SVal(x1,ty1)}::sign1, {desc=SVal(x2,ty2)}::sign2) ->
          if not (ident_ext x1 = ident_ext x2) then
            (fail sign1 sign2 "signature value field name mismatch");
          if not (typ_eq0_with tenv m1 m2 ty1 ty2) then
            (fail sign1 sign2 "signature value field type mismatch");
          go tenv m1 m2 sign1 sign2
      | ({desc=STyp(tn1,k1)}::sign1, {desc=STyp(tn2,k2)}::sign2) ->
          (if not (typname_ext tn1 = typname_ext tn2) then
            (fail sign1 sign2 "signature type field name mismatch");
          let itn1 = typname_int tn1 in
          let itn2 = typname_int tn2 in
          let itn' = fresh_prettyname itn1 in
          let m1' = ITypnameMap.add itn1 itn' m1 in
          let m2' = ITypnameMap.add itn2 itn' m2 in
          match (k1,k2) with
            (KType   , KType   ) ->
              go tenv m1' m2' sign1 sign2
          | (KEq(ty1), KEq(ty2)) ->
              if not (typ_eq0_with tenv m1 m2 ty1 ty2) then
                (fail sign1 sign2 "signature concrete type field type mismatch");
              go tenv m1' m2' sign1 sign2
          | (KEq(ty1), KType   ) ->
              go (ITypnameMap.add itn' ty1 tenv) m1' m2' sign1 sign2
          | (KType   , KEq(ty2)) ->
              (fail sign1 sign2 "abstract type field where concrete expected"))
      | _ -> (fail sign1 sign2 "signature field mismatch")
    in
    go ITypnameMap.empty ITypnameMap.empty ITypnameMap.empty sign1_0 sign2_0


let linkok nenv definition' definition =
    begin debug "\n****\nlinkok.1";
      match definition with (* condition 1 *)
    | Import_compile (modname, ic_body) ->
	debug ("def " ^ modname_ext modname);
        let sign0 = ic_body.ic_sign0 in
        let ext_modname = modname_ext modname in
        let str = ic_body.ic_likestr in
        let vc = ic_body.ic_vc in
        let (modname', sign0', str', h', vn'_or_vc') =
          begin debug "linkok.2"; match definition' with (* condition 2 *)
          | Mod_compile ((ext, int) as modname', mc_body') -> debug ext;
              (modname', mc_body'.mc_sign0, mc_body'.mc_str, mc_body'.mc_hash,
               VN mc_body'.mc_vn)
          | Import_compile ((ext, int) as modname', ic_body') -> debug ext;
              (modname', ic_body'.ic_sign0, ic_body'.ic_likestr, ic_body'.ic_hash,
               VC ic_body'.ic_vc)
	  | Mod_fresh _ | Import_fresh _ -> raise (Linkok_not "trying to import against fresh modules")
	  | Mod_imod _ -> raise (Util.Never_happen "import an imod")
	  | Mark_compile _ -> raise (Linkok_not "trying to import a mark")
          end in
        begin  debug "linkok.3"; (* condition 3 *)
          let ext_modname' = modname_ext modname' in
          if mn_ext_eq ext_modname ext_modname' then () else raise (Linkok_not "Module names differ")
        end;
        begin  debug "linkok.4"; (* condition 4 *)
          if !Opts.linkok_sig_typecheck then
            try  Typecheck.tcheck_ssub (nenv,emptytypeenv) [] sign0' sign0
            with Typecheck.TCFail s ->
              raise (Linkok_not ("subsignature typecheck failed: " ^ s))
          else
            syntacticsubsig sign0'.desc sign0.desc
        end;
        begin  debug "linkok.5"; (* condition 5 *)
          if (match vc with
              | VCDotted _ ->
                  begin match vn'_or_vc' with
                  | VN vn' -> Tysupp.vn_isin_vc vn' vc
                  | VC vc' -> Tysupp.vc_subseteq_vc vc' vc
                  end
              | VCNameEqual (AVCHHash h) -> debug "linkok.5.nameequal hash"; Tysupp.h_eq h' h
              | VCNameEqual (AVCHModname _) -> assert false (* can't happen *)
             ) then () else raise (Linkok_not "version mismatch")
        end;
        begin  debug "linkok.6"; (* condition 6 *)
          let type_domain = str_typfieldnames str in
          let check_one_typname tn =
            let ext_tn = typname_ext tn in
            let (ty, ty') =
              begin try
                Util.the (lookup_structure_etn str ext_tn),
                Util.the (lookup_structure_etn str' ext_tn)
              with Invalid_argument _ -> assert false (* can't happen unless there's a typing bug *)
              end in
            Tysupp.typ_eq ty ty' in
          if List.for_all check_one_typname type_domain then () else raise (Linkok_not "representation type mismatch")
        end
    | _ -> raise (Linkok_not "not a cimport")
    end


