(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * Includes file for library.ml                                   *
 *                                                                *
 * Version: $Id: library.mli,v 1.508 2004/12/22 12:23:31 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

(* TODO: Fix up library to work directly with smallstep *)

(* type, arity, internal name, implementation*)
(* think about what we want to return here? *)
(* hand it config & tid expr, return config & tid expr *)
(* or just expr? *)
type libfunc = Ast.typ*int*bool*Ast.internal_ident*(Ast.prim_expr list -> Ast.prim_expr)


(* throws Not_found if the name is not known. *)
val find_libfunc : string -> libfunc

(* returns true if the string is the name of a library function, false otherwise *)
val is_libfunc : string -> bool

(* throws Not_found if the name is not known. *)
val libfunc_string_to_iident : string -> Ast.internal_ident

(* throws Not_found if the ident is not known. *)
val libfunc_iident_to_string : Ast.internal_ident -> string


(* the initial type external environment *)
val econst_env_list : Ast.typeenv_list


(* could use configuration instead of exp_config, but probably easier to have
   currently worked on expression in our hand? *)
(* A hack to get around OCaml's non-recursive module system
   Call from repl.ml before starting to do stuff *)
(* val register_eval : (Ast.nameenv -> Ast.esubst -> Ast.eqs -> Ast.exp_configuration -> Ast.exp_configuration) -> unit *)
