(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * lexer_hack_script.ml                                           *
 *                                                                *
 * Version: $Id: lexer_hack_script.ml,v 1.503 2004/12/22 12:23:31 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

open Str;;
open Sys;;
open Unix;;

exception Fatal of string;;

let _ =
  (* Create an input channel for the ml file *)
  let ml_fd = stdin in
  let ml_ch = in_channel_of_descr ml_fd in
  let ml_len = in_channel_length ml_ch in
  let ml_str = String.create ml_len in

  (* Input the ml file into a string buffer *)
  let _ = really_input ml_ch ml_str 0 ml_len in

  (* Do the some global search and replaces *)
  let ml_str = global_replace (regexp "\\bLexing\\b") "Mylexing" ml_str in

  let _ = close ml_fd in

  (* Write the modified file back out *)
  let ml_fd = stdout in
  let ml_ch = out_channel_of_descr ml_fd in
  let _ = output ml_ch ml_str 0 (String.length ml_str) in
  ();;


