(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * hashifysupp.mli                                                *
 *                                                                *
 * Version: $Id: hashifysupp.mli,v 1.5 2004/12/22 12:23:31 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

exception Hashify of Exceptions.hashify_exn

type compilation_map = Ast.definition Ast.ModnameMap.t

val empty_cm : compilation_map




val no_cfresh : (bool ref) option -> Ast.prim_expr -> bool
val no_hashMvf : (bool ref) option -> Ast.prim_expr -> bool
val no_tie : (bool ref) option -> Ast.prim_expr -> bool

val add_compiled_modules :
    compilation_map -> Ast.definitions -> compilation_map


val find_valuabilities : compilation_map  -> Ast.modname -> Ast.valuabilities


val check_valuability_expr : compilation_map -> Ast.expr -> Ast.valuability -> bool

val derive_valuabilities : compilation_map -> Ast.source_definition -> Ast.valuabilities
