(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * genlib.ml                                                      *
 *                                                                *
 * Generates a list of (name, function_definition) pairs          *
 * suitable for #including into library.ml                        *
 *                                                                *
 * Version: $Id: genlib.ml,v 1.525 2004/12/22 13:46:22 pes20 Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

(* Set these to the appropriate things on your system.... *)
(* let stdlibpath = "/usr/groups/netsem/ocaml/stdlib/" *)

(* let _ = Debug.debugon := true *)

let stdlibpath = "./libs/"
let mlifiles_full = [ (* Acute module, Ocaml library module, mli file, abstract types file, slowcalls file *)
                 ("Pervasives", "Apervasives", "../wrappers/apervasives.mli", None, Some "../wrappers/apervasives.slow");
              (* ("Graphics", "graphics.mli", None, None); *)
                 ("Agraphics","Agraphics", "../wrappers/agraphics.mli", None, None);
                 ("Char","Char", "char.mli", None, None);
                 ("String","String", "string.mli", None, None);
                 ("Sys", "Sys","sys.mli", None, None);
                 ("Tcp","Tcp",  "tcp.mli", Some "tcp.types", Some "tcp.slow");
                 ("Persist","Persist", "persist.mli", None, None);
                 ("Digest","Digest", "digest.mli", None, None);
                 ("Filename","Filename", "filename.mli", None, None);
                 ("Unix", "Unix", "unix.mli", None, None);
                 ("Atcp", "Atcp", "../wrappers/atcp.mli", None, Some "../wrappers/atcp.slow");
               ]
             (*    ("List.", "list.mli"); too polymorphic...*)
             (*    ("Testlib", "Testlib.mli") *)

let mlifiles_small = [
                 ("Pervasives", "Apervasives", "../wrappers/apervasives.mli", None, None);
(*                 ("Pervasives", "Apervasives_small", "../wrappers/apervasives_small.mli", None, None);
*)
             (*     ("Graphics", "graphics.mli", None);*)
             (*     ("Char", "char.mli", None);        *)
             (*     ("String", "string.mli", None); *)
             (*     ("Sys", "sys.mli", None);          *)
             (*     ("Tcp", "tcp.mli", Some "tcp.types"); *)
                  ("Persist", "Persist", "persist.mli", None, None);
             (*     ("Digest", "digest.mli", None);    *)
             (*     ("Filename", "filename.mli", None);*)
             (*    ("Atcp", "Atcp", "../wrappers/atcp.mli", None, None); *)
               ]

let mlifiles=mlifiles_full

(* to regenerate definitions_lib_semiauto_small.ac:
    replace "full" by "small" above
    make
    cp definitions_lib_auto.ac definitions_lib_semiauto_small.ac
*)

let typelist : (Ast.internal_typname * Ast.typ) list ref = ref []

open Ast
open Format
open Basecon
open Baseconty


(* open Pretty_simple *)

(* The dump_* functions pretty prints the given expression as an ML
constructor. *)

exception Fatal of string;;
exception Todo

let dump_hash (hash : hash) = raise (Util.Unimplemented "dump_hash")

let rec dump_typ (typ : typ) =
  match typ with
  | TTyCon0 tc0 -> "TTyCon0 "^dump_tycon0 tc0
  | TTyCon1(tc1,t) -> "TTyCon1("^dump_tycon1 tc1^","^dump_typ t^")"
  | TTup(ts) -> "TTup([" ^ dump_typs(ts) ^ "])"
  | TSum(ts) -> "TSum([" ^ dump_typs(ts) ^ "])"
  | TFunc(t1,t2) -> "TFunc(" ^ dump_typ(t1) ^ ", " ^ dump_typ(t2)  ^")"
  | TVar((t,i) as ti) ->
      (try
	let typ = List.assoc ti !typelist
	in dump_typ typ
      with Not_found -> raise (Fatal ("type " ^ i ^ " not previously defined"))
      (* "TVar(get_internal_typname \"" ^ t ^ "\")" *)
	  )
  | TTyName(n) -> raise (Util.Unimplemented "dump_typ: tyname")
  | TXDot(x,tn) -> "TXDot(\"" ^ dump_hash_or_modname x ^ "\", external_typname_of_string " ^ external_typname_to_string tn ^ "\")"
  | TForall(tn,t) -> raise (Util.Unimplemented "dump_typ: forall")
  | TExists(tn,t) -> raise (Util.Unimplemented "dump_typ: forall")


and dump_hash_or_modname (x : hash_or_modname) =
  match x with
    Hash(h)    -> "Hash("^dump_hash h^")"
  | Modname(m) -> "Modname("^external_modname_to_string (modname_ext m)^")"


and dump_typs ts =
  match ts with
    (t::ts) -> dump_typ t ^ "; " ^ dump_typs ts
  | [] -> ""

let rec dump_kind k =
  match k with KType -> "KType"
  | KEq t -> "KEq (" ^ dump_typ t ^ ")"

let rec dump_embedding typ =
  match typ with
  | TTyCon0 tc0 -> dump_tycon0_embedding tc0
  | TTup(ts) ->
      let n = List.length ts in
      if n < 2 || n > 8 then
        raise (Util.Unimplemented ("tuples of size "^string_of_int n^" unimplemented; edit library.mlp and genlib.ml to extend"))
      else
        "(tup"^string_of_int n^" "^String.concat " " (List.map dump_embedding ts)^")"
  | TTyCon1(TList,t) -> "(list " ^ dump_embedding t ^ ")"
  | TTyCon1(TOption,t) -> "(option " ^ dump_embedding t ^")"
  | TFunc(t1,t2) -> "(func " ^ dump_embedding t1 ^ " " ^ dump_embedding t2 ^ ")"
  | TTyCon1(TRef,t) -> "(ref_ep " ^ dump_embedding t  ^")"
  | TVar((t,i) as ti ) -> (* (* lookup type? *) "(var \"" ^ t ^ "\")"  *)
      (try
	let typ = List.assoc ti !typelist
	in dump_embedding typ
      with Not_found -> raise (Fatal ("type " ^ i ^ " not previously defined"))
	  )
  | _ -> raise (Util.Unimplemented ("don't know how to embed type "^Pretty.print_typ (Pretty.initial_printer_state None (Pretty.pm_debug ())) typ^"; edit genlib.ml to extend"))

(* A simple variation on map that also provides the index of the current list element *)
let mapn f lis =
 let rec loop lis n =
   match lis with
     (x::xs) -> (f(x,n))::(loop xs (n+1))
   | [] -> []
 in
   loop lis 0

let argname n =
  "arg" ^ string_of_int n


(* takes a type like int->string->(int*char)->bool and returs ([int; string; int*char], bool) *)
let rec curried_args typ =
  match typ with
    TFunc(t1,t2) -> let (t1', t2') = curried_args t2 in (t1::t1', t2')
  | t -> ([], t)

let function_def name argtypes rettype =
  "(function (["
  ^ String.concat "; " (mapn (function (t,n) -> argname n)  argtypes)
  ^ "]) ->\n     begin\n      try\n       "
(* M taken out all the setters here, and all the getters on return *)
(*  ^ " set_env(env);\n       "
  ^ "set_eqs(eqs);\n       "
  ^ "set_defs(d);\n       "
  ^ "set_store_env(se);\n       "
  ^ "set_store(s);\n       "
  ^ "set_runnable(r);\n       "
  ^ "set_mutexes(m);\n       "
  ^ "set_cvars(c);\n       " *)
  ^ "let result = embed " ^ (dump_embedding rettype)
  ^ " (( " ^ name ^ " ) "
  ^ String.concat " " (mapn (function (t,n) -> "(project " ^ dump_embedding t ^ " "^argname n ^")")
                            argtypes)
  ^ ") in\n         "
  ^ " result

\n     "

 ^ "with \n "
  ^ "  Failure(s) ->
      Raise(C1(B1 Fail,C0(B0(String(s)))))\n      "
  ^ " | Invalid_argument(s) ->
      Raise(C1(B1 InvalidArgument,C0(B0(String(s)))))\n      "
  ^ " | Not_found ->
      Raise(C0(B0(NotFound)))\n      "
  ^ " | Sys_error(s) ->
      Raise(C1(B1 SysError,C0(B0(String(s)))))\n      "
  ^ " | End_of_file ->
      Raise(C0(B0(EndOfFile)))\n      "
  ^ " | Division_by_zero ->
      Raise(C0(B0(DivisionByZero)))\n      "
  ^ " | Sys_blocked_io ->
      Raise(C0(B0(SysBlockedIO)))\n      "
  ^ " | Tcp.Unix_error(e, s1, s2) ->
      Raise(C1 (B1 UnixError, (Tup([C0 (B0(UnixErrorCode  (lookup_error e))); C0 (B0(String s1)); C0 (B0(String s2))]))))\n"
  ^ " | e ->
      Raise(C1 (B1 LibraryError, C0 (B0(String (Printexc.to_string e)))))"
  ^ "end\n  "
  ^ "| _ -> raise RT_type)"



let unquoted_econst_of_eident modref_name eident = modref_name^"_"^external_ident_to_string eident

let econst_of_eident modref_name eident = "%\""^modref_name^"_"^external_ident_to_string eident^"\""


let table_entry slowlist modref_name eident typ =
  let (econst_name, ocaml_name) =
    ((unquoted_econst_of_eident modref_name eident), (modref_name^"."^(external_ident_to_string eident))) in
  let (argtypes, rettype) = curried_args typ in
    "(\"" ^ econst_name ^ "\",\n"
    ^ " ((" ^ dump_typ typ ^ "),\n"
			          ^ "  " ^ string_of_int (List.length argtypes) ^ ",\n"
 ^ " (" ^ (if List.mem (external_ident_to_string eident) slowlist then "true" else "false") ^ "),\n"
     ^ " fresh_internal_ident \"" ^ econst_name ^ "\",\n"
    ^ "  " ^ function_def ocaml_name argtypes rettype ^ "));\n\n"

let rec squish s = match s with [] -> ("","","") | (x,y,z)::ws -> let (xx,yy,zz)=squish ws in (x^"\n"^xx,y^"\n"^yy,z^"\n"^zz)

(* mli_scan takes a module name, and input .mli file from the O'caml distributioin.
   Some caml code that can be directly included into library.ml is written to
   libout.  *)

let printer_state = ref (Pretty.initial_printer_state None (Pretty.pm_lib_hack))

let mli_scan modname modref_name input types_input slow_input libfuncout defnsout libdocsout= begin
  let slowlist =
  match slow_input with None -> []
  | Some c ->
      let rec readin c l =
	try
	  let s = input_line c in
	  if (String.length s != 0) && (String.get s 0 = '#')   (* skip empty lines and comments *)
	  then readin c l
	  else readin c (s::l)
	with End_of_file -> l
      in readin c []
  in

  try
    let envp = Myparsing.new_envp () in
    let parser_state = Parsertypes.new_parser_state (Parsertypes.Caml_mode, if !Opts.lithash then [Parsertypes.Lithash] else []) None in
    let inter = Parser_usersource.interface envp Mlilexer.token (Mylexing.from_channel input) parser_state in
    let inter_types_opt = match types_input with None -> None
    |  Some c -> Some (Parser_usersource.interface envp Mlilexer.token (Mylexing.from_channel c) parser_state) in
(* P replaced caml_interface by interface above *)
    let (sigpart,structpart,libfuncpart) =
      begin
        squish
          (List.map
          (function s -> match s.desc with
              SVal((eident,_), t) ->   (* JJLTODO: check that the user internal name is really superfluous *)
                ( "  val "^external_ident_to_string eident^" : "^(Pretty.print_typ !printer_state t),
                  "  let "^external_ident_to_string eident^" = "^econst_of_eident modref_name eident,
                  (table_entry slowlist modref_name eident t)
		 )
            | STyp((typnameext,itypname) as t, k) ->
                (
		let rep_type =
		  (
		  match k with KType ->  (
		  (* abstract, must be corresponding type in inter_types_opt *)
		    match inter_types_opt with
		      None -> raise (Fatal("typename "
					   ^ Pretty.print_typname_ext !printer_state typnameext
					   ^ " is abstract, representation type must be provided"))
		    | Some ts ->
		      (* we assume the types interface file is in the right order *)
			let rec find_type l = (
			  match l with [] -> raise (Fatal("typename "
							  ^ Pretty.print_typname_ext !printer_state typnameext
							  ^ " is abstract, representation type must be provided"))
			  | (v::ss) -> (match v.desc with
			      (STyp((tn,i), KEq(t))) ->
				if tn = typnameext then t
				else find_type ss
			    | _ -> raise (Fatal("Found unexpected thing in types file"))
				  )
				)
			in find_type ts.desc
			  )
		    | KEq(t) -> t (* does this work for, say, type t = M.t ? *)
			  )
		in
		typelist := (itypname,rep_type)::(!typelist);
		"  type "^Pretty.print_typname_ext !printer_state typnameext^" : "^(Pretty.print_kind !printer_state k),
                "  type "^Pretty.print_typname_ext !printer_state typnameext^" = " ^(Pretty.print_typ !printer_state rep_type),
                  ""

		))

          inter.desc)
      end in
    output_string libfuncout libfuncpart;
    output_string defnsout ("module hash!"^modname^ " : sig\n" ^ sigpart ^ "end\n=struct\n" ^ structpart ^ "end\n;;");
    output_string libdocsout ("module hash!"^modname^ " : sig\n" ^ sigpart ^ "end\n\n")
  with
    Myparsing.Parse_error -> print_string ("genlib: Parse error in \"" ^ modname ^ "\"\n")
  | Misc.Syntax_error s -> print_string ("genlib: Syntax error in \"" ^ modname ^ "\": " ^ s ^ "\n")
end



open Sys

let _ =
 (* Accept filename from commandline where the token type lives *)
 let (defn_filename,libfuncs_filename,libdocs_filename) =
    let len = Array.length argv in
    if(len < 4) then
      raise(Fatal("Incorrect arguments: must have three filenames: definitions_lib_auto.ac libfuncs.ml definitions_lib_auto_docs.txt"))
    else
      Array.get argv 1, Array.get argv 2, Array.get argv 3
 in
   let defn_out = open_out defn_filename in
   let libfuncs_out = open_out libfuncs_filename in
  let libdocs_out = open_out libdocs_filename in
  try
    output_string defn_out
      "(* definitions_lib_auto.ac automatically generated by genlib.ml. Do not edit directly! *)\n\n";
    output_string libfuncs_out
      "(* Automatically generated by genlib.ml. Do not edit directly! *)\n\n";
    output_string libdocs_out
      "(* Automatically generated by genlib.ml. Do not edit directly! *)\n\n";

    let f (modname, modref_name, filename, typename_opt, slowname_opt) =
      let instream_main = open_in (stdlibpath ^ filename)  in
      let instream_types_opt = match typename_opt with
	None -> None
      |	Some s -> Some (open_in (stdlibpath ^ s)) in
      let instream_types_opt = match typename_opt with
	None -> None
      |	Some s -> Some (open_in (stdlibpath ^ s)) in

      let instream_slow_opt = match slowname_opt with
	None -> None
      |	Some s -> Some (open_in (stdlibpath ^ s)) in

      mli_scan modname modref_name instream_main instream_types_opt instream_slow_opt libfuncs_out defn_out libdocs_out;
      close_in instream_main;
      (match instream_types_opt with Some c -> close_in c | None -> ()) in
    ignore (List.map f mlifiles);
     close_out defn_out;
    close_out libfuncs_out;
    close_out libdocs_out
  with e ->
    close_out defn_out;
    close_out libfuncs_out;
    close_out libdocs_out;
    raise e

