(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * The Evaluator                                                  *
 *                                                                *
 * Version: $Id: eval.mli,v 1.529 2004/12/22 12:23:31 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

(*exception TerminateOnRTTC of Ast.configuration
 exception TerminateOnUnmarshalFailure of string*Ast.configuration
*)
(* argh, horrible ref, but we can't trust eval_mode *)
val skipdefs_ref : int ref

val reset : unit -> unit

val execute_program :  Ast.nameenv * Ast.program -> (* Ast.configuration *) Exceptions.top_exn

val eval_trace_or_typecheck : Ast.smallstep_outer -> unit

(* P: these refs are on their way out, replaced by the pure eval_mode *)
(* that was: trace, fast, paranoid *)

(* P: the pure eval_mode is now on its way out, replaced by refs - at
least for trace output control.  It's still threaded through, though,
for future use *)

exception Stuck of string
exception Typecheck_of_configuration of Ast.configuration
exception Typecheck_on_unmarshal of  Ast.marshalled_body
exception Typecheck_on_marshal
exception Typecheck_on_get_URI of  string
exception Runtime_mismatch of string


(* ultimately these shouldn't need to be in here, but collecting them for
  documentation purposes *)

(* here the significance of using smallstep_outer rather than configuration
   is merely that any other processes in the queue may be partially evaluated
 *)


val reduce_op : (bool * bool) -> Ast.op -> Ast.prim_expr list -> Ast.threaded_smallstep_inner -> Ast.smallstep_outer -> Ast.smallstep_outer * Ast.prim_expr option

val reduce_redex :
    (Ast.smallstep_outer * Ast.threaded_smallstep_inner) ->
     (Ast.smallstep_outer * Ast.threaded_smallstep_inner option)


(* need to distinguish between blocked and value *)
(* use exceptions rather than option and let outer loop deal with it *)
(* option if the thread has been killed *)
val reduce_expr :
    (Ast.smallstep_outer * Ast.threaded_smallstep_inner) ->
      (Ast.smallstep_outer * Ast.threaded_smallstep_inner option)



(* Doesn't need to be an option? Or can a thread performing module initialisation kill itself too? *)
val reduce_defs_expr :
    (Ast.smallstep_outer * Ast.threaded_smallstep_inner) ->
      (Ast.smallstep_outer * Ast.threaded_smallstep_inner option)

val reduce_process_once : Ast.smallstep_outer -> Ast.smallstep_outer option

val reduce_process_lots : Ast.configuration -> Ast.configuration

(* M notes 1: flow in eval:
   Reduce process to carry out one of the steps on p100 of spec:
   Pull item off process;
   Either (1) defs is empty:
     call reduce_expr on item
   Or (2) defs is non-empty
     call reduce_defs_expr on item

   Reduce_defs_expr will either
      (1) call hashify
      (2) shift def to main defs in cfg
      (3) carry out a reduction step in the definition

   Reduce_process_lots will carry out reduce_process steps until some termination condition is reached.

   Reduce_program will take the original defs and expr and build up a config for it and call the reduce_process thing.
*)

(* M notes 2: reduce_expr type

   (1) We tend to pass around a config & a current expression,
       where the current expression has been plucked off the runnable in the config

   (2)   To avoid repeating all the non-threaded reductions, we use a single reduce_expr of a form which takes
   a collection of process info; if we're doing one of the pseudo_configuration type reductions (top three on p100),
   then the scfg_runnble, mutexes, cvars will be empty.

   We represent 'current expression' here by separating the prim_expr and the thread info, and making thread info an
   option type. If we're doing one of the pseudo-configuration type reductions, the option is None, otherwise it's Some blah.
   This is a bit messy, but it saves repeating all the simple reductions.
   We can clean it up a bit by shoving all these things into record types?

   (3) reduce_expr may
       i) perform a reduction, returning a new expr &c
       ii) raise Blocked
       iii) raise Not_a_redex
            (was a value: should be unit if we're in the expression part of a process, or any value if we're valuifying a module)

   The caller of reduce_expr (reduce_defs_expr, reduce_process_once) should handle these exceptions.
   *)



