(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * dump.mli                                                       *
 *                                                                *
 * Version: $Id: dump.mli,v 1.506 2004/12/22 12:23:31 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

open Ast
open Util

val fresh_printer_state : int -> int -> bool -> Pretty.printer_state
val fresh_printer_state_all : unit -> Pretty.printer_state
val safe_open_out : bool -> out_channel
val safe_close_out : out_channel -> unit
val safe_open_final_out : bool -> out_channel
val safe_close_final_out : out_channel -> unit
val safe_open_dumpfinal_out  : bool -> out_channel
val safe_open_check_in : bool -> in_channel
val safe_close_check_in : in_channel -> unit
val last_utime : float option ref
val showpass : string -> unit

val dump_expr:
  Pretty.printer_state ref option -> string -> expr -> unit

(* bool: true => skip these defs *)
val dump_source_definitions:
  Pretty.printer_state ref option -> string -> source_definitions -> bool -> unit

val dump_definitions:
  Pretty.printer_state ref option -> string -> definitions -> bool -> unit

val dump :
  string ->
  (source_definitions,definitions) sum -> expr option ->
  (internal_typname * 'a) list -> int -> int -> bool -> bool -> bool -> unit

val dump_cu :
  string ->
  'a compilation_unit ->
  (internal_typname * 'a) list -> int -> int -> bool -> bool -> unit
val dump_defs_eo :
  string ->
  definitions * expr option ->
  (internal_typname * 'a) list -> int -> int -> bool -> bool -> unit

val dump_final : string -> configuration -> int -> int -> bool -> bool -> unit
