/*
Copyright (c) 2006, Peng Li
              2006, Stephan A. Zdancewic
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

* Neither the name of the copyright owners nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/epoll.h>

#define _REENTRANT
#define MAXEVENT 100

int c_epoll_create(int size) {
  int epoll_device = epoll_create(size);
  //printf("epoll_device=%d\n",epoll_device);
  assert(epoll_device>0);
  return epoll_device;
}

void c_epoll_add(int epoll_dev, int fd, int isread, void * ref) {
  struct epoll_event ev;
  //printf("epoll_add in\n");
  if (isread ==0) 
    ev.events = EPOLLOUT | EPOLLET | EPOLLONESHOT;
  else
    ev.events = EPOLLIN | EPOLLET | EPOLLONESHOT;
  ev.data.ptr = ref;
  int res;
  res = epoll_ctl(epoll_dev, EPOLL_CTL_ADD, fd, &ev);
  //printf("epoll_add out\n");
  if (res < 0) {
    printf("res=%d in epoll\n", res);
    perror("epoll add");
  }
  assert(res == 0);
}

void c_epoll_del(int epoll_dev, int fd) {
  struct epoll_event ev;
  int res = epoll_ctl(epoll_dev, EPOLL_CTL_DEL, fd, &ev);
  if (res < 0) {
    printf("device=%d fd=%d res=%d in epoll\n", epoll_dev, fd, res);
    perror("epoll del");
  }
  assert(res == 0);
}


typedef struct {
  int count;
  struct epoll_event evt[MAXEVENT];
} epoll_wait_result;


void* c_epoll_wait(int epoll_dev, int timeout) {
  epoll_wait_result* res = malloc(sizeof(epoll_wait_result));
  res->count = epoll_wait(epoll_dev, res->evt, MAXEVENT, timeout);
  if (res->count < 0) {
    printf("epoll_wait res = %s\n", strerror(-(res->count)));
  }
  assert((res->count) >=0);
  return res;
  // -n: error
  //  0: nothing
  //  n: number of events read
}

int c_epoll_wait_getcnt(void*p) {
  epoll_wait_result * res = (epoll_wait_result *) p;
  return (res->count);
}

void* c_epoll_wait_getevt(void*p, int index) {
  epoll_wait_result * res = (epoll_wait_result *) p;
  return (res->evt)[index].data.ptr;
}
