/*
Program to draw the syntax diagram for Bexp
*/

GET "libhdr"
GET "plotflow.h"

/*
                                                                 <yt
								 
                                                              y6 <y6

                    -----------------------------             y5 <y5
          ------   |      -------       ----     |
      ---( Bexp )--------| n<3 ^ |------( E2 )---|            y4 <y4
          ------      |   -------       ----     |
                      |   -----------    ----    |
                      |--| n<2 mulop |--( E2 )---|            y3 <y3
                      |   -----------    ----    |
                      |   -----------    ----    |
                      |--| n<1 addop |--( E1 )---             y2 <y2
                      |   -----------    ----
                       ------------------------------->       y1 <y1
 
                                                              y0 <y0
								 
   x0 x1 x2        x3 x4 x5             x6       x7   x8   x9    <yb

^  ^  ^  ^         ^  ^  ^              ^        ^    ^    ^  ^
xl x0 x1 x2        x3 x4 x5             x6       x7   x8   x9 xr
*/

MANIFEST {
  xl = 5
  x0 = xl + 40
  x1 = x0 + 40
  x2 = x1 + wtl
  x3 = x2 + wl4 + wcl
  x4 = x3 + wcc          // wcc to make it big enough 
  x5 = x4 + wlt
  x6 = x5 + wl9 + wtc
  x7 = x6 + wl2 + wcl
  x8 = x7 + 60
  x9 = x8 + 50
  xr = x9 + 30
  
  yb = 40
  y0 = yb + 40
  y1 = y0 + 30
  y2 = y1 + hcc
  y3 = y2 + hcc
  y4 = y3 + hcc
  y5 = y4 + hcl
  y6 = y5 + 30
  yt = y6 + 20
  
  width  = xr+3 & -4
  height = yt + 15

  col_lightgray = #x0F0F0F
}

LET drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3
  setcolour(col_lightgray)

  moveto(x3+r, y5)
  drawto(x7-r, y5)
  rndcorner(1, x3, y5, r)
  rndcorner(0, x7, y5, r)
  moveto(x3, y5-r)
  drawto(x3, y4+r)
  moveto(x7, y5-r)
  drawto(x7, y2+r)

  setcolour(col_black)

  drawcatboxL (y4, x1, x2, x5,   "Bexp")
  drawtestboxL(y4, x5, x5, x6,   "n<3 ^")
  drawcatboxL (y4, x6, x6, x7-r, "E2")
  rndcorner(2, x3, y4, r)
  rndcorner(0, x4, y4, r)
  rndcorner(3, x7, y4, r)
  moveto(x4, y4-r)
  drawto(x4, y1+r)

  setcolour(col_lightgray)

  drawtestboxL(y3, x4+r, x5, x6, "n<2 mulop")
  drawcatboxL(y3, x6, x6, x7-r, "E2")
  rndcorner(2, x4, y3, r)
  rndcorner(3, x7, y3, r)

  drawtestboxL(y2, x4+r, x5, x6,   "n<1 addop")
  drawcatboxL (y2, x6,   x6, x7-r, "E1")
  rndcorner(2, x4, y2, r)
  rndcorner(3, x7, y2, r)

  moveto(x4+r, y1)
  drawto(x8, y1)
  rndcorner(2, x4, y1, r)
  drawarrow(0, x8, y1, 20)

  // Draw the grid
  currpen := penS1
  setcolour(col_red)
  drawgrid()
  
  { LET mmwidth = width * 10 / 150 * 254 / 10 // mm at 150 DPI
    newline()
    //sawritef("hll=%n htl=%n htt=%n htc=%n hcc=%n*n",
    //          hll,   htl,   htt,   htc,   hcc)
    //sawritef("width = %n height = %n*n", width, height)
    sawritef("width = %5.1d mm*n*n*n", mmwidth)
  }

}

AND drawgrid() BE
{ setcolour(col_red)

  moveto(x0, y6); drawto(x8, y6)
  moveto(x0, y5); drawto(x8, y5)
  moveto(x0, y4); drawto(x8, y4)
  moveto(x0, y3); drawto(x8, y3)
  moveto(x0, y2); drawto(x8, y2)
  moveto(x0, y1); drawto(x8, y1)
  moveto(x0, y0); drawto(x8, y0)

  moveto(x0, y6); drawto(x0, y0)
  moveto(x1, y6); drawto(x1, y0)
  moveto(x2, y6); drawto(x2, y0)
  moveto(x3, y6); drawto(x3, y0)
  moveto(x4, y6); drawto(x4, y0)
  moveto(x5, y6); drawto(x5, y0)
  moveto(x6, y6); drawto(x6, y0)
  moveto(x7, y6); drawto(x7, y0)
  moveto(x8, y6); drawto(x8, y0)

  selectfont(12)
  
  drawstrcentred(x0, yb, "x0")
  drawstrcentred(x1, yb, "x1")
  drawstrcentred(x2, yb, "x2")
  drawstrcentred(x3, yb, "x3")
  drawstrcentred(x4, yb, "x4")
  drawstrcentred(x5, yb, "x5")
  drawstrcentred(x6, yb, "x6")
  drawstrcentred(x7, yb, "x7")
  drawstrcentred(x8, yb, "x8")

  drawstrM(x9, y0, "y0")
  drawstrM(x9, y1, "y1")
  drawstrM(x9, y2, "y2")
  drawstrM(x9, y3, "y3")
  drawstrM(x9, y4, "y4")
  drawstrM(x9, y5, "y5")
  drawstrM(x9, y6, "y6")

  selectfont(16)
  setcolour(col_black)
}

AND drawstrcentred(x, y, s) BE drawstr(x-strpixels(s)/2, y, s)

AND drawstrM(x, y, str) BE drawstr(x, y-fontH/2, str)

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for n2prog, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }

sawritef("*nBefore calling drawdiagram xsize=%n ysize=%n*n", xsize, ysize)

  drawdiagram()

draw:
  wrbmp(tofilename)
sawritef("*nAfter calling mrbmp xsize=%n ysize=%n*n", xsize, ysize)

fin:
  closebdraw()

  RESULTIS 0
}


