// This is the header file for ploting flow graphs

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  testboxH    = 24*3/2 // Assuming 24x16 font
  testboxHby2 = testboxH/2

  catboxH    = 24*2    // Assuming 24x16 font
  catboxHby2 = catboxH/2

  bendradius = 15      // Radius of bends
  catradius  = 15      // Radius of cat box round corners

  wl1  =  3*16 +  2*3  // Length of a box containing 1 character 
  wl2  =  4*16 +  3*3  // Length of a box containing 2 characters 
  wl3  =  5*16 +  4*3  // Length of a box containing 3 characters
  wl4  =  6*16 +  5*3  // Length of a box containing 4 characters
  wl5  =  7*16 +  6*3  // Length of a box containing 5 characters
  wl6  =  8*16 +  7*3  // Length of a box containing 6 characters
  wl7  =  9*16 +  8*3  // Length of a box containing 7 characters
  wl8  = 10*16 +  9*3  // Length of a box containing 8 characters
  wl9  = 11*16 + 10*3  // Length of a box containing 8 characters
  wl10 = 12*16 + 11*3  // Length of a box containing 8 characters
  wl11 = 13*16 + 12*3  // Length of a box containing 8 characters
  wl12 = 14*16 + 13*3  // Length of a box containing 8 characters

  fac = 90

  hll  = testboxH*fac/130                      // V sep:  line  line
  hlt  = (hll+testboxHby2)*fac/100             // V sep:  line  test
  htl  = hlt
  hlc  = (hll+catboxHby2)*fac/100              // V sep:  line  cat
  hcl  = hlc
  
  htt  = (testboxHby2+hll+testboxHby2)*fac/100 // V sep: test  test
  htc  = (testboxHby2 +hll+catboxHby2)*fac/100 // V sep: test  cat

  hcc  = (catboxHby2 +hll+catboxHby2) *fac/100 // V sep: cat   cat
  
  wll   = 25
  wtl   = 30
  wlt   = 30
  wcl   = 30
  wlc   = 30
  
  wtt   = 40
  wtc   = 30
  wct   = 30
  
  wcc   = 40
}

GLOBAL {
  tofilename: ug
}

LET drawtestboxL(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // left justified at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET bx1, by1 = x2,          y-testboxHby2
  LET bx2, by2 = x2+boxwidth, y+testboxHby2
  // Draw the initial line
  moveto(x1, y); drawto(x2, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstr(x2+fontW+charHsep, y, str)
  // draw the final line
  moveto(x2+boxwidth, y); drawto(x3, y)  
}

AND drawtestboxC(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // centred at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET boxwidthby2 = boxwidth/2
  LET bx1, by1 = x2-boxwidthby2, y-testboxHby2
  LET bx2, by2 = x2+boxwidthby2, y+testboxHby2
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxL(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // The left edge of the cat box is at x position x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2, y-catboxHby2
  LET bx2, by2 = x2+catwidth, y+catboxHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2+catwidthby2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxC(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2-catwidthby2, y-catboxHby2
  LET bx2, by2 = x2+catwidthby2, y+catboxHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(x2+catwidthby2, y); drawto(x3, y)
}
