/*
Program to draw the syntax diagram for Bexp
*/

GET "libhdr"
GET "plotflow.h"

/*
.--                                                   --.   <y6
|                                                       |
                 -----------------------------              <y5
       ------   |      -------       ----     |
   ---( Bexp )--------| n<3 ^ |------( E2 )---|             <y4
       ------      |   -------       ----     |
                   |   -----------    ----    |
                   |--| n<2 mulop |--( E2 )---|             <y3
                   |   -----------    ----    |
                   |   -----------    ----    |
                   |--| n<1 addop |--( E1 )---              <y2
                   |   -----------    ----
                    ------------------------------->        <y1
|                                                       |
.--                                                   --.   <y0
^  ^  ^         ^  ^  ^              ^        ^    ^    ^
x0 x1 x2        x3 x4 x5             x6       x7   x8   x9
*/

MANIFEST {
  x0 = 5
  x1 = x0 + 20
  x2 = x1 + wtl
  x3 = x2 + wl4 + wcl
  x4 = x3 + wcc          // wcc to make it big enough 
  x5 = x4 + wlt
  x6 = x5 + wl9 + wtc
  x7 = x6 + wl2 + wcl
  x8 = x7 + 60
  x9 = x8 + 20
  
  y0 = 5
  y1 = y0 + 30
  y2 = y1 + hcc
  y3 = y2 + hcc
  y4 = y3 + hcc
  y5 = y4 + hcl
  y6 = y5 + 20
  
  width  = x9+3 & -4
  height = y6 + 15
}

LET drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  moveto(x3+r, y5)
  drawto(x7-r, y5)
  rndcorner(1, x3, y5, r)
  rndcorner(0, x7, y5, r)
  moveto(x3, y5-r)
  drawto(x3, y4+r)
  moveto(x7, y5-r)
  drawto(x7, y2+r)
  
  drawcatboxL (y4, x1, x2, x5,   "Bexp")
  drawtestboxL(y4, x5, x5, x6,   "n<3 ^")
  drawcatboxL (y4, x6, x6, x7-r, "E2")
  rndcorner(2, x3, y4, r)
  rndcorner(0, x4, y4, r)
  rndcorner(3, x7, y4, r)
  moveto(x4, y4-r)
  drawto(x4, y1+r)

  drawtestboxL(y3, x4+r, x5, x6, "n<2 mulop")
  drawcatboxL(y3, x6, x6, x7-r, "E2")
  rndcorner(2, x4, y3, r)
  rndcorner(3, x7, y3, r)

  drawtestboxL(y2, x4+r, x5, x6,   "n<1 addop")
  drawcatboxL (y2, x6,   x6, x7-r, "E1")
  rndcorner(2, x4, y2, r)
  rndcorner(3, x7, y2, r)

  moveto(x4+r, y1)
  drawto(x8, y1)
  rndcorner(2, x4, y1, r)
  drawarrow(0, x8, y1, 20)

  { LET mmwidth = width * 10 / 150 * 254 / 10 // mm at 150 DPI
    newline()
    //sawritef("hll=%n htl=%n htt=%n htc=%n hcc=%n*n",
    //          hll,   htl,   htt,   htc,   hcc)
    //sawritef("width = %n height = %n*n", width, height)
    sawritef("width = %5.1d mm*n*n*n", mmwidth)
  }

}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for n2prog, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }

sawritef("*nBefore calling drawdiagram xsize=%n ysize=%n*n", xsize, ysize)

  drawdiagram()

draw:
  wrbmp(tofilename)
sawritef("*nAfter calling mrbmp xsize=%n ysize=%n*n", xsize, ysize)

fin:
  closebdraw()

  RESULTIS 0
}


