
/*
Program to draw a compact syntax diagram for Bexp
*/
GET "libhdr"
GET "plotflow.h"

/*
.--                                      --.  <y5
|                                          |
            ----
   --------[name]---------------------->      <y4
      |     ----                  |
      |     ------                |
      |----|number|---------------|           <y3
      |     ------                |
      |     ---    ----    ---    |
      |----| ( |--( E0 )--| ) |---|           <y2
      |     ---    ----    ---    |
      |     -------    ----       |
       ----| addop |--( E1 )------            <y1
|           -------    ----                |
.--                                      --.  <y0
^  ^  ^    ^      ^   ^   ^       ^    ^   ^
x0 x1 x2   x3     x4  x5  x6      x7   x8  x9
*/

MANIFEST {
  x0 = 5
  x1 = x0 + 20
  x2 = x1 + wtl
  x3 = x2 + 30
  x4 = x3 + wl1 + wtc
  x5 = x3 + wl5 + wtc
  x6 = x4 + wl2 + wct
  x7 = x6 + wl1 + wtl
  x8 = x7 + 60
  x9 = x8 + 20

  y0 = 0
  y1 = y0 + 40
  y2 = y1 + hcc
  y3 = y2 + htc
  y4 = y3 + htt
  y5 = y4 + testboxHby2 + 20

  width  = x9+3 & -4
  height = y5 + 20
}

LET drawdiagram() BE
{ LET r = bendradius

  currpen := penS3

  drawtestboxL(y4, x1, x3, x8, "name")
  drawarrow(0, x8, y4, 20)
  rndcorner(0, x2, y4, r) 
  rndcorner(1, x7, y4, r) 
  moveto(x2, y4-r)
  drawto(x2, y1+r)
  moveto(x7, y4-r)
  drawto(x7, y1+r)
  
  drawtestboxL(y3, x2+r, x3, x7-r, "number")
  rndcorner(2, x2, y3, r) 
  rndcorner(3, x7, y3, r) 

  drawtestboxL(y2, x2+r, x3, x4, "(")
  drawcatboxL (y2, x4, x4, x6, "E0")
  drawtestboxL(y2, x6, x6, x7-r, ")")
  rndcorner(2, x2, y2, r) 
  rndcorner(3, x7, y2, r) 

  drawtestboxL(y1, x2+r, x3, x5, "addop")
  drawcatboxL (y1, x5, x5, x7-r, "E1")
  rndcorner(2, x2, y1, r) 
  rndcorner(3, x7, y1, r) 

  { LET mmwidth = width * 10 / 150 * 254 / 10 // mm at 150 DPI
    newline()
    //sawritef("hll=%n htl=%n htt=%n htc=%n hcc=%n*n",
    //          hll,   htl,   htt,   htc,   hcc)
    //sawritef("width = %n height = %n*n", width, height)
    sawritef("width = %5.1d mm*n*n*n", mmwidth)
  }
}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for n2prog, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }

//sawritef("*nBefore calling drawdiagram xsize=%n ysize=%n*n", xsize, ysize)

  drawdiagram()

draw:
  wrbmp(tofilename)
//sawritef("*nAfter calling mrbmp xsize=%n ysize=%n*n", xsize, ysize)

fin:
  closebdraw()

  RESULTIS 0
}


