
GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  boxH    = 24*3/2 // Assuming 24x16 font
  boxHby2 = boxH/2

  catH    = 24*2   // Assuming 24x16 font
  catHby2 = catH/2

  bendradius = 15      // Radius of bends
  catradius  = 15      // Radius of cat box round corners

  wl1  =  3*16 +  2*3  // Length of a box containing 1 character 
  wl2  =  4*16 +  3*3  // Length of a box containing 2 characters 
  wl3  =  5*16 +  4*3  // Length of a box containing 3 characters
  wl4  =  6*16 +  5*3  // Length of a box containing 4 characters
  wl5  =  7*16 +  6*3  // Length of a box containing 5 characters
  wl6  =  8*16 +  7*3  // Length of a box containing 6 characters
  wl7  =  9*16 +  8*3  // Length of a box containing 7 characters
  wl8  = 10*16 +  9*3  // Length of a box containing 8 characters
  wl9  = 11*16 + 10*3  // Length of a box containing 8 characters
  wl10 = 12*16 + 11*3  // Length of a box containing 8 characters
  wl11 = 13*16 + 12*3  // Length of a box containing 8 characters
  wl12 = 14*16 + 13*3  // Length of a box containing 8 characters

  fac = 130

  htt  = 50*fac/100    // Vertical distance between test boxes
  htc  = 55*fac/100    // Vertical distance between a test and cat box
  hcc  = 60*fac/100    // Vertical distance between two cat boxes
  
  htl  = 40*fac/100    // Vertical distance between a test box and a line
  hcl  = 40*fac/100    // Vertical distance between a cat box and a line
  hll  = 25*fac/100    // Vertical distance between two horizontal lines
  
  wbb   = 40
  wbv   = 30
  wvb   = 30
  wvv   = 40//45
  
  
  x01  = 20
  x02  = x01+50         // Left virtical line
  x03  = x02+wvb        // relop
  x04  = x03+wl5+wbv    // vertical after relop
  x05  = x04+wvb        // ( after relop 
  x06  = x05+wl1+wbb    // E0 after relop (
  x07  = x06+wl2+wbb    // ) after relop ( E0

  x06a = x05            // range after bpat same a ( after relop
  x06b = x06a+wl4+wbb   // bpat after bpat range
  x08  = x06b+wl4+wbv   // vertical after bpat range bpat
  
  x09  = x03+wl1+wbb    // P0
  x10  = x09+wl2+wbb    // ]
  
  x11  = x08+wvv        // middle vertical between ) and ,
  x12  = x11+wvv        // vertical befor , P0
  x13  = x12+wvb        // ,  n<1
  x14  = x13+wl6+wbb    // P0
  x15  = x14+wl2+wbv    // arrow and right vertical

  y01 = 25              // fname    bottom line
  y02 = y01+htt         // bpat range bpat
  y03 = y02+htt         // [ P0 ]
  y04 = y03+htt         // ( P0 )
  y04a = y04+htt        // jcom
  y05 = y04a+htt        // bpat
  y06 = y05+htt         // relop ( E0 )
  y07 = y06+htt         // top line
    
  width = (x15+53) & #xFFFC
  height = y07+10


}

LET drawtestboxL(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // left justified at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET bx1, by1 = x2,          y-boxHby2
  LET bx2, by2 = x2+boxwidth, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(x2, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstr(x2+fontW+charHsep, y, str)
  // draw the final line
  moveto(x2+boxwidth, y); drawto(x3, y)  
}

AND drawtestboxC(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // centred at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET boxwidthby2 = boxwidth/2
  LET bx1, by1 = x2-boxwidthby2, y-boxHby2
  LET bx2, by2 = x2+boxwidthby2, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxL(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2, y-catHby2
  LET bx2, by2 = x2+catwidth, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2+catwidthby2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxC(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2-catwidthby2, y-catHby2
  LET bx2, by2 = x2+catwidthby2, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(x2+catwidthby2, y); drawto(x3, y)
}

AND drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  drawtestboxL(y01, x02+r, x03, x08-r,  "fname") 

  drawtestboxL(y02, x02+r, x03,  x05,   "bpat") 
  drawtestboxL(y02, x05,   x05,  x06b,  "range") 
  drawtestboxL(y02, x06b,  x06b, x08-r, "bpat") 

  drawtestboxL(y03, x02+r, x03, x09,   "[") 
  drawcatboxL (y03, x09,   x09, x10,   "P0") 
  drawtestboxL(y03, x10,   x10, x08-r, "]") 

  drawtestboxL(y04, x02+r, x03, x09,   "(") 
  drawcatboxL (y04, x09,   x09, x10,   "P0") 
  drawtestboxL(y04, x10,   x10, x08-r, ")") 

  drawtestboxL(y04a, x02+r, x03, x08-r, "jcom") 

  drawtestboxC (y05, x04+r, x06+wl2/2, x08-r, "bpat") 

  drawtestboxL(y06, x01,   x03, x05,   "relop") 
  drawtestboxL(y06, x05,   x05, x06,   "(") 
  drawcatboxL (y06, x06,   x06, x07,   "E0") 
  drawtestboxL(y06, x07,   x07, x13,   ")") 

  drawtestboxL(y06, x13,   x13, x14,   ",  n<1") 
  drawcatboxL (y06, x14,   x14, x15-r, "P1")

  drawtestboxL(y05, x12+r, x13, x14,   "|  n<2") 
  drawcatboxL (y05, x14,   x14, x15-r, "P2") 

  drawcatboxL (y04a, x12+r, x14, x15-r, "P3") 

  // Draw the vertical lines
  moveto(x02, y01+r);   drawto(x02, y06-r)
  moveto(x04, y01+r);   drawto(x04, y02-r)
  moveto(x04, y05+r);   drawto(x04, y06-r)
  moveto(x08, y01+r);   drawto(x08, y06-r)
  moveto(x11, y06+r);   drawto(x11, y07-r)
  moveto(x12, y04+r);   drawto(x12, y06-r)
  moveto(x15, y04a+r);  drawto(x15, y07-r)
  
  // Draw the horizontal lines
  
  moveto(x12+r, y04); drawto(x15,   y04)
  moveto(x11+r, y07); drawto(x15-r, y07)

  // Draw the arrow heads
  drawarrow(0, x15, y04, 20)  // Arrow at bottom right

  // Draw path bends
  rndcorner(2, x02, y01, r)
  rndcorner(2, x02, y02, r)
//  rndcorner(2, x02, y02a, r)
  rndcorner(2, x02, y03, r)
  rndcorner(2, x02, y04, r)
  rndcorner(2, x02, y04a, r)
  rndcorner(0, x02, y06, r)

  rndcorner(2, x04, y01, r)
  rndcorner(0, x04, y02, r)
  rndcorner(2, x04, y05, r)
  rndcorner(0, x04, y06, r)

  rndcorner(3, x08, y01, r)
  rndcorner(3, x08, y02, r)
//  rndcorner(3, x08, y02a, r)
  rndcorner(3, x08, y02, r)
  rndcorner(3, x08, y03, r)
  rndcorner(3, x08, y04, r)
  rndcorner(3, x08, y04a, r)
  rndcorner(3, x08, y05, r)
  rndcorner(1, x08, y06, r)

  rndcorner(2, x11, y06, r)
  rndcorner(1, x11, y07, r)

  rndcorner(2, x12, y04, r)
  rndcorner(2, x12, y04a, r)
  rndcorner(2, x12, y05, r)
  rndcorner(0, x12, y06, r)

  rndcorner(3, x15, y04a, r)
  rndcorner(3, x15, y05, r)
  rndcorner(3, x15, y06, r)
  rndcorner(0, x15, y07, r)


  // Draw the text
  charleveloffset := charmidleveloffset

  //drawstr(x00,  y02, "currco")
  //drawstrcentred(c05m,  y04m,  "fn")

  charleveloffset := 0

  writef("width = %n height = %n %5.1d in*n",
          width, height, 10*width / 300 *150/100) // 300 DPI
  { LET mmwidth = width * 10 / 150 * 254 / 10 // mm at 150 DPI
    newline()
    sawritef("width = %5.1d mm*n*n*n", mmwidth)
  }
}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }


  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}


