
GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  boxH    = 24*3/2 // Assuming 24x16 font
  boxHby2 = boxH/2

  catH    = 24*2   // Assuming 24x16 font
  catHby2 = catH/2

  bendradius = 15      // Radius of bends
  catradius  = 15      // Radius of cat box round corners

  wl1  =  3*16 +  2*3  // Length of a box containing 1 character 
  wl2  =  4*16 +  3*3  // Length of a box containing 2 characters 
  wl3  =  5*16 +  4*3  // Length of a box containing 3 characters
  wl4  =  6*16 +  5*3  // Length of a box containing 4 characters
  wl5  =  7*16 +  6*3  // Length of a box containing 5 characters
  wl6  =  8*16 +  7*3  // Length of a box containing 6 characters
  wl7  =  9*16 +  8*3  // Length of a box containing 7 characters
  wl8  = 10*16 +  9*3  // Length of a box containing 8 characters
  wl9  = 11*16 + 10*3  // Length of a box containing 8 characters
  wl10 = 12*16 + 11*3  // Length of a box containing 8 characters
  wl11 = 13*16 + 12*3  // Length of a box containing 8 characters
  wl12 = 14*16 + 13*3  // Length of a box containing 8 characters

  fac = 130

  htt  = 50*fac/100    // Vertical distance between test boxes
  htc  = 55*fac/100    // Vertical distance between a test and cat box
  hcc  = 60*fac/100    // Vertical distance between two cat boxes
  
  htl  = 40*fac/100    // Vertical distance between a test box and a line
  hcl  = 40*fac/100    // Vertical distance between a cat box and a line
  hll  = 25*fac/100    // Vertical distance between two horizontal lines
  
  wbb   = 40
  wbv   = 30
  wvb   = 30
  wvv   = 40

  x01  = 20
  x02  = x01+60         // Left virtical line
  x03  = x02+wbv        // :
  x04  = x03+wl1+wvb    // vertical after :
  x05  = x04+wvb        // P0
  x06  = x05+wl2+wbv    // Vertical after P0
  x07  = x06+wvv        // Two verticals after P0
  x08  = x07+wvb        // BE
  x09  = x08+wl2+wvb    // C
  x10  = x09+wl2+wbv    // Two verticals after C
  x11  = x10+wvv        // middle vertical
  x12  = x11+wvv        // vertical before .
  x13  = x12+wvb        // .
  x14  = x13+wl1+wbv    // vertical after .
  x15  = x14+50         // Arrow

  y01 = 30              // BE  C
  y02 = y01+hcc/2       // : P0
  y03 = y02+hcc/2       // => E0
  y04 = y03+hcl         // top line

  width = (x15+53) & #xFFFC
  height = y04+10


}

LET drawtestboxL(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // left justified at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET bx1, by1 = x2,          y-boxHby2
  LET bx2, by2 = x2+boxwidth, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(x2, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstr(x2+fontW+charHsep, y, str)
  // draw the final line
  moveto(x2+boxwidth, y); drawto(x3, y)  
}

AND drawtestboxC(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // centred at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET boxwidthby2 = boxwidth/2
  LET bx1, by1 = x2-boxwidthby2, y-boxHby2
  LET bx2, by2 = x2+boxwidthby2, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxL(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2, y-catHby2
  LET bx2, by2 = x2+catwidth, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2+catwidthby2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxC(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2-catwidthby2, y-catHby2
  LET bx2, by2 = x2+catwidthby2, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(x2+catwidthby2, y); drawto(x3, y)
}

AND drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  drawtestboxL(y01, x07+r, x08, x09,   "BE") 
  drawcatboxL (y01, x09,   x09, x10-r, "C") 

  drawtestboxL(y02, x01,   x03, x05,   ":") 
  drawcatboxL (y02, x05,   x05, x07-r, "P0") 
  drawtestboxL(y02, x10+r, x13, x15,   ".") 

  drawtestboxL(y03, x07+r, x08, x09,   "=>") 
  drawcatboxL (y03, x09,   x09, x10-r, "E0") 

  // Draw the vertical lines
  moveto(x02, y02+r);   drawto(x02, y04-r)
  moveto(x04, y02+r);   drawto(x04, y03-r)
  moveto(x06, y02+r);   drawto(x06, y03-r)
  moveto(x07, y02+r);   drawto(x07, y03-r)
  moveto(x07, y02-r);   drawto(x07, y01+r)
  moveto(x10, y02+r);   drawto(x10, y03-r)
  moveto(x10, y02-r);   drawto(x10, y01+r)
  moveto(x11, y02+r);   drawto(x11, y04-r)
  moveto(x12, y02-r);   drawto(x12, y01+r)
  moveto(x14, y02-r);   drawto(x14, y01+r)
  
  // Draw the horizontal lines
  
  moveto(x02+r, y04); drawto(x11-r, y04)
  moveto(x04+r, y03); drawto(x06-r, y03)
  moveto(x12+r, y01); drawto(x14-r, y01)

  // Draw the arrow heads
  drawarrow(0, x15, y02, 20)  // Arrow at bottom right

  // Draw path bends
  rndcorner(2, x02, y02, r)
  rndcorner(1, x02, y04, r)
  rndcorner(3, x04, y02, r)
  rndcorner(1, x04, y03, r)
  rndcorner(2, x06, y02, r)
  rndcorner(0, x06, y03, r)
  rndcorner(2, x07, y01, r)
  rndcorner(0, x07, y02, r)
  rndcorner(3, x07, y02, r)
  rndcorner(1, x07, y03, r)

  rndcorner(3, x10, y01, r)
  rndcorner(1, x10, y02, r)
  rndcorner(2, x10, y02, r)
  rndcorner(0, x10, y03, r)

  rndcorner(3, x11, y02, r)
  rndcorner(0, x11, y04, r)

  rndcorner(2, x12, y01, r)
  rndcorner(0, x12, y02, r)

  rndcorner(3, x14, y01, r)
  rndcorner(1, x14, y02, r)

  // Draw the text
  charleveloffset := charmidleveloffset

  //drawstr(x00,  y02, "currco")
  //drawstrcentred(c05m,  y04m,  "fn")

  charleveloffset := 0

  writef("width = %n height = %n %5.1d in*n",
          width, height, 10*width / 300 *120/100) // 300 DPI
  { LET mmwidth = width * 10 / 150 * 254 / 10 // mm at 150 DPI
    newline()
    sawritef("width = %5.1d mm*n*n*n", mmwidth)
  }
}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }


  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}


