GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  boxH    = 24*3/2 // Assuming 24x16 font
  boxHby2 = boxH/2

  catH    = 24*2   // Assuming 24x16 font
  catHby2 = catH/2

  bendradius = 15      // Radius of bends
  catradius  = 15      // Radius of cat box round corners

  dl1  =  3*16 +  2*3  // Length of a box containing 1 character 
  dl2  =  4*16 +  3*3  // Length of a box containing 2 characters 
  dl3  =  5*16 +  4*3  // Length of a box containing 3 characters
  dl4  =  6*16 +  5*3  // Length of a box containing 4 characters
  dl5  =  7*16 +  6*3  // Length of a box containing 5 characters
  dl6  =  8*16 +  7*3  // Length of a box containing 6 characters
  dl7  =  9*16 +  8*3  // Length of a box containing 7 characters
  dl8  = 10*16 +  9*3  // Length of a box containing 8 characters
  dl9  = 11*16 + 10*3  // Length of a box containing 8 characters
  dl10 = 12*16 + 11*3  // Length of a box containing 8 characters
  dl11 = 13*16 + 12*3  // Length of a box containing 8 characters
  dl12 = 14*16 + 13*3  // Length of a box containing 8 characters

  fac = 130

  dtt  = 50*fac/100    // Vertical distance between test boxes
  dtc  = 55*fac/100    // Vertical distance between a test and cat box
  dct  = dtc
  dcc  = 60*fac/100    // Vertical distance between two cat boxes
  
  dtl  = 40*fac/100    // Vertical distance between a test box and a line
  dlt  = dtl           // Vertical distance between a test box and a line
  dcl  = 40*fac/100    // Vertical distance between a cat box and a line
  dlc  = dcl           // Vertical distance between a cat box and a line
  dll  = 25*fac/100
  
  wbb   = 40
  wbv   = 30
  wvb   = 30
  wvv   = 45
  
  hw1 =  80 // Half length of a box containing 1 character
  hw2 = 100 // Half length of a box containing 2 characters
  hw3 = 150 // Half length of a box containing 3 characters

  

  y51 = 20            // right bottom edge

  y53 = y51+30        // line arrow
  y54 = y53+dtc       // fcond E0 -> E0, E0
  y55 = y54+dtc       // XOR
  y56 = y55+dtc       // EQV     E1
  y58 = y56+dtt       // |       E2
  y60 = y58+dtt       // &       E3

  y62 = y60+dtt       // >>
  y64 = y62+dtt       // <<      E4

  y66 = y64+dtt       // E4 below relop
  y68 = y66+dtc       // relop   E4
  y72 = y68+dtc       // addop   E5
  y76 = y72+dtt       // mulop   E6

  y78 = y76+dtt       // %
  y80 = y78+dtt       // !
  y82 = y80+dtt       // OF    E8

  y84 = y82+dtt       // [ E0 ]    subscription

  y86 = y84+dtt       // #( E0 ,..., E0 )    method call
  y88 = y86+dtt       // ,  above #( E0 )

  y89 = y88+dtl       // line
  y90 = y89+dtl       // ( E0 ,..., E0 )    function call
  y92 = y90+dtt       // ,  above ( E0 )
  y94 = y92+dcc       // line above ,  above ( E0 )
  y96 = y94+dcc       // top edge


  


  x01 = 20
  x02 = x01+40         // Bexp
  x03 = x02+dl4+wbv    // first vertical after Bexp
  x04 = x03+wvv        // second vertical after Bexp
  x05 = x04+wvb        // nonl
  x10 = x05+dl4+wbv    // vertical after nonl
  x11 = x10+wvb        // Dyadic ops
  x12 = x11+250        // Vertical after dyadic ops
  x13 = x12+80         // E0 after ->
  x14 = x13+50         // Position to the right of E0
  x15 = x12+hw3        // Operands of eg << and &
  x16 = x15+hw3        // Categories such as E8 and E6
  x17 = x15+200        // Second E0 after ->
  x18 = x17+100        // Right hand vertical line
    
  width = (x18+50) &-4
  height = y96+60
}

LET drawtestboxL(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // left justified at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET bx1, by1 = x2,          y-boxHby2
  LET bx2, by2 = x2+boxwidth, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(x2, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstr(x2+fontW+charHsep, y, str)
  // draw the final line
  moveto(x2+boxwidth, y); drawto(x3, y)  
}

AND drawtestboxC(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // centred at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET boxwidthby2 = boxwidth/2
  LET bx1, by1 = x2-boxwidthby2, y-boxHby2
  LET bx2, by2 = x2+boxwidthby2, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxL(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2, y-catHby2
  LET bx2, by2 = x2+catwidth, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2+catwidthby2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)  
}

AND drawcatboxC(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2-catwidthby2, y-catHby2
  LET bx2, by2 = x2+catwidthby2, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(x2+catwidthby2, y); drawto(x3, y)
}

AND drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  drawtestboxC(y92, x15-hw1+r, x15, x15+hw1-r,   ",")
  drawcatboxL (y90, x01,   x02, x05,   "Bexp")
  drawtestboxL(y90, x05,   x05, x11,   "nonl")
  drawtestboxL(y90, x11,   x11, x12,   "(     n<9")

  drawcatboxC (y90, x12,   x15, x16,   "E0")
  drawtestboxL(y90, x16,   x17, x18-r, ")")
  
  drawtestboxC(y88, x15-hw1+r, x15, x15+hw1-r,   ",")
  drawtestboxL(y86, x10+r, x11, x12,   "#(    n<9")
  drawcatboxC (y86, x12,   x15, x16,   "E0")
  drawtestboxL(y86, x16,   x17, x18-r, ")")
  
  drawtestboxL(y84, x10+r, x11, x12,   "[     n<9")
  drawcatboxC (y84, x12,   x15, x16,   "E0")
  drawtestboxL(y84, x16,   x17, x18-r, "]")
  
  drawtestboxL(y82, x10+r, x11, x12,   "OF    n<8")
  drawcatboxC (y82, x12,   x15, x18-r, "E8")
  drawtestboxL(y80, x10+r, x11, x12-r, "!     n<8")
  drawtestboxL(y78, x10+r, x11, x12-r, "%     n<8")

  drawtestboxL(y76, x10+r, x11, x12,   "mulop n<6")
  drawcatboxC (y76, x12,   x15, x18-r, "E6")
  
  drawtestboxL(y72, x10+r, x11, x12,   "addop n<5")
  drawcatboxC (y72, x12,   x15, x18-r, "E5")

  drawtestboxL(y68, x10+r, x11, x12-r, "relop n<5")
  drawtestboxC(y68, x12+r, x15, x16-r, "relop n<5")
  drawcatboxC (y66, x12+r, x15, x18-r, "E4")

  drawtestboxL(y64, x10+r, x11, x12,   "<<    n<4")
  drawcatboxC (y64, x12,   x15, x18-r, "E4")
  drawtestboxL(y62, x10+r, x11, x12-r, ">>    n<4")

  drawtestboxL(y60, x10+r, x11, x12,   "&     n<3")
  drawcatboxC (y60, x12,   x15, x18-r, "E3")

  drawtestboxL(y58, x10+r, x11, x12,   "|     n<2")
  drawcatboxC (y58, x12,   x15, x18-r, "E2")

  drawtestboxL(y56, x10+r, x11, x12,   "EQV   n<1")
  drawcatboxC (y56, x12,   x15, x18-r, "E1")
  drawtestboxL(y55, x10+r, x11, x12-r, "XOR   n<1")

  drawtestboxL(y54, x10+r, x11, x12,   "fcond n<1")
  drawcatboxC (y54, x12, x13, x14, "E0")
  drawtestboxC(y54, x14, (x13+x17)/2, x16, ",")
  drawcatboxC(y54, x16, x17, x18-r, "E0")

  // Draw the vertical lines

  moveto(x03, y90+r); drawto(x03, y94-r)

  moveto(x04, y53+r); drawto(x04, y90-r) // Left of nonl

  moveto(x15-hw1, y90+r); drawto(x15-hw1, y92-r)
  moveto(x15+hw1, y90+r); drawto(x15+hw1, y92-r)
  moveto(x15-hw2, y89+r); drawto(x15-hw2, y90-r)
  moveto(x15+hw2, y89+r); drawto(x15+hw2, y90-r)

  moveto(x15-hw1, y86+r); drawto(x15-hw1, y88-r)
  moveto(x15+hw1, y86+r); drawto(x15+hw1, y88-r)

  moveto(x12, y78+r); drawto(x12, y82-r)

  moveto(x12, y66+r); drawto(x12, y68-r)
  moveto(x16, y66+r); drawto(x16, y68-r)

  moveto(x12, y62+r); drawto(x12, y64-r)
  moveto(x12, y55+r); drawto(x12, y56-r)

  moveto(x10, y53+r); drawto(x10, y90-r)
  moveto(x18, y54+r); drawto(x18, y94-r)
  
  // Draw the horizontal lines
  
  moveto(x03+r,     y94);  drawto(x18-r,     y94)
  moveto(x15-hw2+r, y89);  drawto(x15+hw2-r, y89)

  moveto(x04+r, y53);   drawto(x18,    y53)
/*
  
  
  moveto(x10+r, y01); drawto(x18, y01)
*/

  // Draw the arrow heads
  drawarrow(0, x18, y53, 20)  // Arrow at bottom right

  // Draw path bends
  


  rndcorner(1, x03, y94, r)  // 
  rndcorner(2, x03, y90, r)  // 

  rndcorner(0, x04, y90, r)  // 
  rndcorner(2, x04, y53, r)  // 

  rndcorner(1, x15-hw1, y92, r)  // , above ( E0 )
  rndcorner(0, x15+hw1, y92, r)  // . above ( E0 )
  rndcorner(2, x15-hw1, y90, r)  // ( E0  )
  rndcorner(3, x15+hw1, y90, r)  // ( E0  )

  rndcorner(0, x15-hw2, y90, r)  // ( E0  )
  rndcorner(1, x15+hw2, y90, r)  // ( E0  )
  rndcorner(2, x15-hw2, y89, r)  // , below ( E0 )
  rndcorner(3, x15+hw2, y89, r)  // , below ( E0 )

  rndcorner(0, x10, y90, r)  // ( E0  )

  rndcorner(1, x15-hw1, y88, r)  // , above #( E0 )
  rndcorner(0, x15+hw1, y88, r)  // . above #( E0 )
  rndcorner(2, x15-hw1, y86, r)  // #( E0  )
  rndcorner(3, x15+hw1, y86, r)  // #( E0  )

  rndcorner(2, x10, y86, r)  // #( E0  )
  rndcorner(2, x10, y84, r)  // [  E0  ]
  rndcorner(2, x10, y82, r)  // OF
  rndcorner(2, x10, y80, r)  // !
  rndcorner(2, x10, y78, r)  // %
  rndcorner(2, x10, y76, r)  // mulop
  rndcorner(2, x10, y72, r)  // addop
  rndcorner(2, x10, y68, r)  // relop
  rndcorner(2, x10, y64, r)  // <<
  rndcorner(2, x10, y62, r)  // >>
  rndcorner(2, x10, y60, r)  // &
  rndcorner(2, x10, y58, r)  // |
  rndcorner(2, x10, y56, r)  // EQV
  rndcorner(2, x10, y55, r)  // XOR
  rndcorner(2, x10, y54, r)  // fcond

  rndcorner(1, x12, y82, r)  // OF
  rndcorner(3, x12, y80, r)  // !
  rndcorner(3, x12, y78, r)  // %
  rndcorner(0, x12, y68, r)  // relop
  rndcorner(1, x12, y68, r)  // relop
  rndcorner(2, x12, y66, r)  // E4

  rndcorner(1, x12, y64, r)  // <<
  rndcorner(3, x12, y62, r)  // >>

  rndcorner(1, x12, y56, r)  // EQV
  rndcorner(3, x12, y55, r)  // XOR

  rndcorner(0, x16, y68, r)  // relop
  rndcorner(3, x16, y66, r)  // E4


  rndcorner(0, x18, y94, r)  // top line
  rndcorner(3, x18, y90, r)  // ( E0  )
  rndcorner(3, x18, y86, r)  // #( E0  )
  rndcorner(3, x18, y84, r)  // [  E0  ]
  rndcorner(3, x18, y82, r)  // OF

  rndcorner(3, x18, y76, r)  // mulop
  rndcorner(3, x18, y72, r)  // addop
  rndcorner(3, x18, y66, r)  // E4 below relop
  rndcorner(3, x18, y64, r)  // <<

  rndcorner(3, x18, y60, r)  // &
  rndcorner(3, x18, y58, r)  // |
  rndcorner(3, x18, y56, r)  // EQV

  rndcorner(3, x18, y54, r)  // fcond

  rndcorner(2, x10, y53, r)  // arrow




  // Draw the text
  charleveloffset := charmidleveloffset

  //drawstr(x00,  y02, "currco")
  //drawstrcentred(c05m,  y04m,  "fn")

  charleveloffset := 0

  //drawcurlyH(x06, y18, x12-x06, 20)
  //drawcurlyH(x12, y18, x17-x12, 20)

  writef("width = %n height = %n %5.1d in*n",
          width, height, 10*width / 300 *120/100) // 300 DPI
  { LET mmwidth = width * 10 / 150 * 254 / 10 // mm at 150 DPI
    newline()
    sawritef("width = %5.1d mm*n*n*n", mmwidth)
  }
}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }


  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}


