GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

LET start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = 144, 70
  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

currcol := col_black
selectfont(24)

// Draw            ------
//                |      |
//              --*  En  *--
//                |      |
//                 ------
{ LET x1, y1, x2, y2, width = 30, 35, 0, 0, 0
  currpen := penS3
  x2 := rndtextbox(x1, y1, "En")
  writef("x1=%n y1=%n x2=%n*n", x1, y1, x2)
  width := x2+20+10
  writef("width = %n  %5.1d mm*n", width, 22_0 * width / 238)
  currpen := penV3
  moveto (x1,y1); drawby(-20, 0)
  moveto (x2,y1); drawby( 20, 0)
}

draw:
  writef("Writing file %s*n", tofilename)
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

