
GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  boxH    = 24*3/2 // Assuming 24x16 font
  boxHby2 = boxH/2

  catH    = 24*2   // Assuming 24x16 font
  catHby2 = catH/2

  bendradius = 15      // Radius of bends
  catradius  = 15      // Radius of cat box round corners

  dl1  =  3*16 +  2*3  // Length of a box containing 1 character 
  dl2  =  4*16 +  3*3  // Length of a box containing 2 characters 
  dl3  =  5*16 +  4*3  // Length of a box containing 3 characters
  dl4  =  6*16 +  5*3  // Length of a box containing 4 characters
  dl5  =  7*16 +  6*3  // Length of a box containing 5 characters
  dl6  =  8*16 +  7*3  // Length of a box containing 6 characters
  dl7  =  9*16 +  8*3  // Length of a box containing 7 characters
  dl8  = 10*16 +  9*3  // Length of a box containing 8 characters
  dl9  = 11*16 + 10*3  // Length of a box containing 8 characters
  dl10 = 12*16 + 11*3  // Length of a box containing 8 characters
  dl11 = 13*16 + 12*3  // Length of a box containing 8 characters
  dl12 = 14*16 + 13*3  // Length of a box containing 8 characters

  fac = 130

  dtt  = 50*fac/100    // Vertical distance between test boxes
  dtc  = 55*fac/100    // Vertical distance between a test and cat box
  dcc  = 60*fac/100    // Vertical distance between two cat boxes
  
  dtl  = 40*fac/100    // Vertical distance between a test box and a line
  dcl  = 40*fac/100    // Vertical distance between a cat box and a line
  dll  = 25*fac/100
  
  wbb   = 40
  wbv   = 30
  wvb   = 30
  wvv   = 45
  
  x01 = 40
  x02 = x01+40
  x03 = x02+wbv
  
  y01  = 30              // DEFAULT
  y02  = y01+dtt         // CASE
  y04  = y02+dtt         // isname
  y03  = y04-dcl         // line
  y05  = y04+dtt         // iscall
  y06  = y05+dtt         // assop
  y07  = y06+dcc         // E0
  y08  = y07+dtl         // ,

  y09c  = y08+dtc        // EVERY
  y09b  = y09c+dtt       // MATCH
  y09a  = y09b+dtl       // , above MATCH

  y09x = y09a+dll        // C above ,
  y09y = y09x+dtl        // ; above C
  y09  = y09y+dtl        // SWITCHON
  
  y10  = y09+dtc         // C above SWITCHON
  y10a = y10+dtl         // D above C
  y10b = y10a+dtl        // ; above D
  y12  = y10b+dtl        // {

  y14  = y12+dtt         // UNTIL
  y15  = y14+dtl         // WHILE            
  y16  = y15+dtl         // UNLESS
  y17  = y16+dtl         // IF
  y18  = y17+dcc         // DO
  y19  = y18+dcl         // FOR
  y20  = y19+dcl         // line
  y22  = y20+dtl         // TEST
  y25  = y22+dtt         // RESULTIS
  y26  = y25+dtt         // GOTO      line
  y27  = y26+dtt         // SKIP      REPEAT
  y28  = y27+dtt         // FINISH    REPEATUNTIL
  y29  = y28+dtt         // RETURN    REPEATWHILE
  y30  = y29+dtt         // jcom
  y31  = y30+dcc         // Entry line  <>   Arrow
  
  xay19 = x03+dl3+wbb     // name after FOR
  xby19 = xay19+dl4+wbb   // =
  xcy19 = xby19+dl1+wbb   // E0 
  xpy19 = xcy19+dl2+wbv   // vertical
  xdy19 = xpy19+wvb       // TO 
  xey19 = xdy19+dl2+wbb   // E0 
  xqy19 = xey19+dl2+wbv   // vertical
  xfy19 = xqy19+wvv       // vertical
  xgy19 = xfy19+wvb       // BY 
  xhy19 = xgy19+dl2+wbb   // E0
  xiy19 = xhy19+dl2+wbv   // vertical
  xjy19 = xiy19+wvv       // vertical 
  xky19 = xjy19+wvb       // DO
  xly19 = xky19+dl2+wbv   // vertical
  xmy19 = xly19+wvb       // C 
  xny19 = xmy19+dl2+wbv   // vertical at right hand side

  xfy30 = xny19-120       // vertical after REPEAT
  xey30 = xfy30-dl2-wbv   // E0
  xdy30 = xey30-wvb       // Vertical
  xcy30 = xdy30-dl11-wbv  // REPEATWHILE
  xby30 = xcy30-wvb       // Vertical
  xay30 = xby30-200       // Vertical after BREAK

  xay24 = x03+dl8+wbv     // Vertical after GOTO
  xby24 = xay24+wvb       // E0
  xcy24 = xay30

  xay22 = xby24+dl2+wbv   // Vertical after TEST E0
  xby22 = xay22+wvb       // THEN
  xcy22 = xby22+dl4+wbv   // vertical
  xdy22 = xcy22+wvb       // C
  xey22 = xdy22+dl2+wbb   // ELSE
  xfy22 = xey22+dl4+wbb   // C

  xay09 = xby24           // E0 after SWITCHON
  xby09 = xay09+dl2+wbb   // INTO
  xcy09 = xby09+dl4+wbb   // {
  xdy09 = xcy09+dl1+wbv   // Vertical after {
  xey09 = xdy09+wvb       // C at level y09x after vertical
  xfy09 = xey09+dl1+wbv   // Vertical after C
  xgy09 = xfy09+wvb       // ; at level y09y after vertical
  xhy09 = xgy09+dl1+wbv   // Vertical after ;
  xiy09 = xhy09+wvb       // } at level y09 after vertical

  xay12 = xay24+wvv       // Vertical after { at atart of block
  xby12 = xay12+wvb       // D at level 
  xcy12 = xby12+dl1+wbv   // Vertical after D
  xdy12 = xcy12+wvb       // ; at level y10b after vertical
  xey12 = xdy12+dl1+wvb   // vertical after ;

  xfy12 = xdy09 //xey12+wbb       // Vertical before C
  xgy12 = xfy12+wvb       // C at level y10
  xhy12 = xgy12+dl1+wbv   // Vertical after C
  xiy12 = xhy12+wvb       // ; at level y10a after vertical
  xjy12 = xiy12+dl1+wbv   // Vertical after ;
  xky12 = xjy12+wvb       // } at level y12
  

  y09bxa = x03+dl5+wbv     // Vertical after MATCH
  y09bxb = y09bxa+wvb      // ( in MATCH
  y09bxc = y09bxb+dl1+wvb  // vertical after (
  y09bxd = y09bxc+wvb      // E0
  y09bxe = y09bxd+dl2+wbv  // Vertical before )
  y09bxf = y09bxe+wvb      // )
  y09bxg = y09bxf+dl1+wbb  // Mlist
  y09bxh = y09bxg+dl5+wbv  // Vertical after Mlist



  xay07 = x03+dl2+wbv     // Vertical after E0
  xby07 = xay07+wvb       // ,
  xcy07 = xby07+dl1+wbv   // Vertical
  xdy07 = xcy07+wvb       // E0
  xey07 = xdy07+dl2+wbv   // Vertical after E0
  xfy07 = xey07+wvb       // assop
  xgy07 = xfy07+dl5+wbv   // Vertical
  xhy07 = xgy07+wvb       // E0
  xiy07 = xhy07+dl2+wbv   // Vertical

  xay04 = xby07+dl6+wbv   // Vertical after isname
  xby04 = xay04+wvb       // :
  xcy04 = xby04+dl1+wbv   // Vertical
  xdy04 = xcy04+wvb       // C
  xey04 = xdy04+dl1+wbv   // Vertical


  xay02 = x03+dl7+wbb     // E0 after CASE

  x25 = xny19             // Right hand edge of REPEAT
  x24 = xfy30
  x26 = x25
  x27 = x26+60            // Arrow head

  entrylevel = y31     // Set when known

  width = (x27+53) & -4
  height = y31+40


}

LET drawtestboxL(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // left justified at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET bx1, by1 = x2,          y-boxHby2
  LET bx2, by2 = x2+boxwidth, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(x2, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstr(x2+fontW+charHsep, y, str)
  // draw the final line
  moveto(x2+boxwidth, y); drawto(x3, y)  
}

AND drawtestboxC(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // centred at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET boxwidthby2 = boxwidth/2
  LET bx1, by1 = x2-boxwidthby2, y-boxHby2
  LET bx2, by2 = x2+boxwidthby2, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxL(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2, y-catHby2
  LET bx2, by2 = x2+catwidth, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2+catwidthby2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxC(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2-catwidthby2, y-catHby2
  LET bx2, by2 = x2+catwidthby2, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(x2+catwidthby2, y); drawto(x3, y)
  
}

AND drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  drawtestboxC(y31, x02+r, (x27-x01)/2,   x26-r, "<>")

  drawtestboxL(y30, x02+r,     x03, xby30-r, "jcom")
  
  drawtestboxL(y29, x02+r,     x03, xay30-r, "RETURN")
  drawtestboxL(y29, xby30+r, xcy30, xey30,   "REPEATWHILE")
  drawcatboxL (y29, xey30,   xey30, x24-r,    "E0")

  drawtestboxL(y28, x02+r,     x03, xay30-r, "FINISH")
  drawtestboxL(y28, xby30+r, xcy30, xdy30-r, "REPEATUNTIL")

  drawtestboxL(y27, x02+r,     x03, xay30-r, "SKIP")
  drawtestboxL(y27, xby30+r, xcy30, x24-r,   "REPEAT")
  
  drawtestboxL(y26, x02+r,     x03, xby24,   "GOTO")
  drawcatboxL (y26, xby24,   xby24, xcy24-r, "E0")
  
  drawtestboxL(y25, x02+r,     x03, xay24-r, "RESULTIS")
  
  drawtestboxL(y22, x02+r,     x03, xby24,   "TEST")
  drawcatboxL (y22, xby24,   xby24, xby22,   "E0")
  drawtestboxL(y22, xby22,   xby22, xdy22,   "THEN")
  drawcatboxL (y22, xdy22,   xdy22, xey22,   "C")
  drawtestboxL(y22, xey22,   xey22, xfy22,   "ELSE")
  drawcatboxL (y22, xfy22,   xfy22, xny19-r, "C")
  
  drawtestboxL(y19, x02+r,     x03, xay19,   "FOR")
  drawtestboxL(y19, xay19,   xay19, xby19,   "name")
  drawtestboxL(y19, xby19,   xby19, xcy19,   "=")
  drawcatboxL (y19, xcy19,   xcy19, xdy19,   "E0")
  drawtestboxL(y19, xdy19,   xdy19, xey19,   "TO")
  drawcatboxL (y19, xey19,   xey19, xgy19,   "E0")
  drawtestboxL(y19, xgy19,   xgy19, xhy19,   "BY")
  drawcatboxL (y19, xhy19,   xhy19, xky19,   "E0")
  drawtestboxL(y19, xky19,   xky19, xmy19,   "DO")
  drawcatboxL (y19, xmy19,   xmy19, xny19-r, "C")
  
  drawtestboxL(y17, x02+r,     x03, xby24,   "IF")
  drawcatboxL (y17, xby24,   xby24, xky19,   "E0")
  drawtestboxL(y17, xky19,   xky19, xmy19,   "DO")
  drawcatboxL (y17, xmy19,   xmy19, xny19-r, "C")
  
  drawtestboxL(y16, x02+r,     x03, xay24-r, "UNLESS")

  drawtestboxL(y15, x02+r,     x03, xay24-r, "WHILE")

  drawtestboxL(y14, x02+r,     x03, xay24-r, "UNTIL")

  drawtestboxL(y12,  x02+r,     x03, xky12,   "{")
  drawcatboxL (y10a, xay12+r, xby12, xey12-r, "D")
  drawtestboxL(y10b, xay12+r, xdy12, xey12-r, ";")
  drawcatboxL (y10,  xay12+r, xgy12, xjy12-r, "C")
  drawtestboxL(y10a, xfy12+r, xiy12, xjy12-r, ";")
  drawtestboxL(y12,  xky12,   xky12, xny19-r, "}")

  drawtestboxL(y09,  x02+r,     x03, xay09,   "SWITCHON")
  drawcatboxL (y09,  xay09,   xay09, xby09,   "E0")
  drawtestboxL(y09,  xby09,   xby09, xcy09,   "INTO")
  drawtestboxL(y09,  xcy09,   xcy09, xiy09,   "{")
  drawcatboxL (y09x, xdy09+r, xey09, xhy09-r, "C")
  drawtestboxL(y09y, xdy09+r, xgy09, xhy09-r, ";")
  drawtestboxL(y09,  xiy09,   xiy09, xny19-r, "}")


  drawtestboxL(y09a, y09bxc+r, y09bxd+(dl2-dl1)/2, y09bxe-r, ",")

  drawtestboxL(y09b, x02+r,  x03,    y09bxb,   "MATCH")
  drawtestboxL(y09b, y09bxb, y09bxb, y09bxd,   "(")
  drawcatboxL (y09b, y09bxd, y09bxd, y09bxf,   "E0")
  drawtestboxL(y09b, y09bxf, y09bxf, y09bxg,   ")")
  drawcatboxL (y09b, y09bxg, y09bxg, xny19-r,  "Mlist")

  drawtestboxL(y09c, x02+r,  x03,    y09bxa-r, "EVERY")



  drawtestboxL(y08, xcy07+r, xdy07+(dl2-dl1)/2, xey07-r,  ",")
  drawtestboxL(y08, xgy07+r, xhy07+(dl2-dl1)/2, xiy07-r,  ",")

  drawcatboxL (y07, x02+r,     x03, xby07,   "E0")
  drawtestboxL(y07, xby07,   xby07, xdy07,   ",")
  drawtestboxL(y07, xdy07,   xdy07, xfy07,   "E0")
  drawtestboxL(y07, xfy07,   xfy07, xhy07,   "assop")
  drawcatboxL (y07, xhy07,   xhy07, xny19-r, "E0")

  drawtestboxL(y06, xay07+r, xfy07, xhy07,   "assop")
  drawcatboxL (y06, xhy07,   xhy07, xny19-r, "E0")

  drawtestboxL(y05, xay07+r, xby07, xny19-r, "iscall")

  drawtestboxL(y04, xay07+r, xby07, xby04,   "isname")
  drawtestboxL(y04, xby04,   xby04, xdy04,   ":")
  drawcatboxL (y04, xdy04,   xdy04, xny19-r, "C")

  drawtestboxL(y02, x02+r,     x03, xay02,   "CASE")
  drawcatboxL (y02, xay02,   xay02, xay04-r, "E0")

  drawtestboxL(y01, x02+r,     x03, xay04-r, "DEFAULT")

  // Draw the vertical lines
  
  moveto(xby30, y30-r);   drawto(xby30, y26+r)
  moveto(x24,   y30-r);   drawto(x24,   y27+r)  // vertical after REPEAT

  moveto(x26,   y31-r);   drawto(x26,   y26+r)  // topright vertical

  moveto(x02,   y31-r);   drawto(x02,   y01+r)  // left long vertical
  moveto(xay30, y30-r);   drawto(xay30, y25+r)
  moveto(xdy30, y29-r);   drawto(xdy30, y28+r)

  moveto(xay24, y26-r);   drawto(xay24, y25+r)  // vertical after RESULTIS
  moveto(xny19, y25-r);   drawto(xny19, y04+r)

  moveto(xay22, y22-r);   drawto(xay22, y20+r)
  moveto(xcy22, y22-r);   drawto(xcy22, y20+r)

  moveto(xpy19, y19-r);   drawto(xpy19, y18+r)
  moveto(xqy19, y19-r);   drawto(xqy19, y18+r)
  moveto(xfy19, y19-r);   drawto(xfy19, y18+r)
  moveto(xiy19, y19-r);   drawto(xiy19, y18+r)
  moveto(xjy19, y19-r);   drawto(xjy19, y18+r)
  moveto(xly19, y19-r);   drawto(xly19, y18+r)

  moveto(xjy19, y17-r);   drawto(xjy19, y16+r)
  moveto(xly19, y17-r);   drawto(xly19, y16+r)

  moveto(xay24, y17-r);   drawto(xay24, y14+r)

  moveto(xay12, y12-r);   drawto(xay12, y10+r)
  moveto(xcy12, y10b-r);  drawto(xcy12, y10a+r)
  moveto(xey12, y12-r);   drawto(xey12, y10a+r)

  moveto(xfy12, y10a-r);  drawto(xfy12, y10+r)
  moveto(xhy12, y10a-r);  drawto(xhy12, y10+r)
  moveto(xjy12, y12-r);   drawto(xjy12, y10+r)

  moveto(xdy09, y09-r);   drawto(xdy09, y09x+r)
  moveto(xfy09, y09y-r);  drawto(xfy09, y09x+r)
  moveto(xhy09, y09-r);   drawto(xhy09, y09x+r)

  moveto(y09bxc, y09a-r);   drawto(y09bxc, y09b+r)
  moveto(y09bxe, y09a-r);   drawto(y09bxe, y09b+r)

  moveto(y09bxa, y09b-r);   drawto(y09bxa, y09c+r)

  moveto(xcy07, y08-r);   drawto(xcy07, y07+r)
  moveto(xey07, y08-r);   drawto(xey07, y07+r)
  moveto(xgy07, y08-r);   drawto(xgy07, y07+r)
  moveto(xiy07, y08-r);   drawto(xiy07, y07+r)

  moveto(xay07, y07-r);   drawto(xay07, y04+r)

  moveto(xay04, y04-r);   drawto(xay04, y01+r)
  moveto(xcy04, y04-r);   drawto(xcy04, y03+r)
  moveto(xey04, y04-r);   drawto(xey04, y03+r)

  // Draw the horizontal lines
  
  moveto(x01,     y31); drawto(x02-r,   y31)
  moveto(x26+r,   y31); drawto(x27,     y31)
  moveto(xby30+r, y30); drawto(x24-r,   y30)   // line above REPEATWHILE
  moveto(xby30+r, y26); drawto(x26-r,   y26)
  moveto(xcy24+r, y25); drawto(x25-r,   y25)   // line after
  moveto(xay22+r, y20); drawto(xcy22-r, y20)

  moveto(xpy19+r, y18); drawto(xqy19-r, y18)
  moveto(xfy19+r, y18); drawto(xiy19-r, y18)
  moveto(xjy19+r, y18); drawto(xly19-r, y18)

  moveto(xjy19+r, y16); drawto(xly19-r, y16)

  moveto(xcy04+r, y03); drawto(xey04-r, y03)

  // Draw the arrow heads
  drawarrow(0, x27, y31, 20)  // Arrow

  // Draw path bends

  rndcorner(0, x02,   y31, r)
  rndcorner(1, x02,   y31, r)
  rndcorner(0, x26,   y31, r)
  rndcorner(1, x26,   y31, r)
  rndcorner(2, x02,   y30, r)
  rndcorner(1, xay30, y30, r)
  rndcorner(0, xby30, y30, r)
  rndcorner(1, xby30, y30, r)
  //rndcorner(0, xny19, y30, r)
  rndcorner(0, x24,   y30, r)

  rndcorner(2, x02,   y29, r)
  rndcorner(3, xay30, y29, r)
  rndcorner(2, xby30, y29, r)
  rndcorner(1, xdy30, y29, r)
  rndcorner(3, x24,   y29, r)

  rndcorner(2, x02,   y28, r)
  rndcorner(3, xay30, y28, r)
  rndcorner(2, xby30, y28, r)
  rndcorner(3, xdy30, y28, r)

  rndcorner(2, x02,   y27, r)
  rndcorner(3, xay30, y27, r)
  rndcorner(2, xby30, y27, r)
  rndcorner(3, x24,   y27, r)

  rndcorner(2, x02,   y26, r)
  rndcorner(3, xay30, y26, r)
  rndcorner(2, xby30, y26, r)

  rndcorner(2, x02,   y25, r)
  rndcorner(3, x26,   y26, r)

  //rndcorner(2, x02,   y24, r)
  rndcorner(1, xay24, y26, r)
  //rndcorner(3, xcy24, y24, r)
  rndcorner(2, xcy24, y25, r)
  rndcorner(0, x25,   y25, r)

  //rndcorner(2, x02,   y23, r)
  rndcorner(3, xay24, y25, r)

  rndcorner(2, x02,   y22, r)
  rndcorner(0, xay22, y22, r)
  rndcorner(1, xcy22, y22, r)
  rndcorner(3, xny19, y22, r)

  rndcorner(2, xay22, y20, r)
  rndcorner(3, xcy22, y20, r)

  rndcorner(2, x02,   y19, r)
  rndcorner(0, xpy19, y19, r)
  rndcorner(1, xqy19, y19, r)
  rndcorner(0, xfy19, y19, r)
  rndcorner(1, xiy19, y19, r)
  rndcorner(0, xjy19, y19, r)
  rndcorner(1, xly19, y19, r)
  rndcorner(3, xny19, y19, r)

  rndcorner(2, xpy19, y18, r)
  rndcorner(3, xqy19, y18, r)
  rndcorner(2, xfy19, y18, r)
  rndcorner(3, xiy19, y18, r)
  rndcorner(2, xjy19, y18, r)
  rndcorner(3, xly19, y18, r)

  rndcorner(2, x02,   y17, r)
  rndcorner(1, xay24, y17, r)
  rndcorner(0, xjy19, y17, r)
  rndcorner(1, xly19, y17, r)
  rndcorner(3, xny19, y17, r)

  rndcorner(2, x02,   y16, r)
  rndcorner(3, xay24, y16, r)
  rndcorner(2, xjy19, y16, r)
  rndcorner(3, xly19, y16, r)

  rndcorner(2, x02,   y15, r)
  rndcorner(3, xay24, y15, r)

  rndcorner(2, x02,   y14, r)
  rndcorner(3, xay24, y14, r)

  rndcorner(2, x02,   y12, r)
  rndcorner(0, xay12, y12, r)
  rndcorner(1, xey12, y12, r)
  rndcorner(1, xjy12, y12, r)
  rndcorner(3, xny19, y12, r)

  rndcorner(1, xay12, y10b, r)
  rndcorner(0, xcy12, y10b, r)
  rndcorner(0, xey12, y10b, r)

  rndcorner(2, xay12, y10a, r)
  rndcorner(3, xcy12, y10a, r)
  rndcorner(3, xey12, y10a, r)

  rndcorner(1, xfy12, y10a, r)
  rndcorner(0, xhy12, y10a, r)
  rndcorner(0, xjy12, y10a, r)

  rndcorner(2, xay12, y10,  r)
  rndcorner(2, xfy12, y10,  r)
  rndcorner(3, xhy12, y10,  r)
  rndcorner(3, xjy12, y10,  r)

  rndcorner(2, x02,   y09, r)
  rndcorner(0, xdy09, y09, r)
  rndcorner(1, xhy09, y09, r)
  rndcorner(3, xny19, y09, r)

  rndcorner(1, xdy09, y09y, r)
  rndcorner(0, xfy09, y09y, r)
  rndcorner(0, xhy09, y09y, r)

  rndcorner(2, xdy09, y09x, r)
  rndcorner(3, xfy09, y09x, r)
  rndcorner(3, xhy09, y09x, r)

  rndcorner(1, y09bxc,   y09a, r)  // , above MATCH
  rndcorner(0, y09bxe,   y09a, r)  // , above MATCH
  
  rndcorner(2, x02,      y09b, r)  // MATCH
  rndcorner(1, y09bxa,   y09b, r)  // MATCH
  rndcorner(2, y09bxc,   y09b, r)  // MATCH
  rndcorner(3, y09bxe,   y09b, r)  // MATCH
  rndcorner(3, xny19,    y09b, r)  // MATCH
  
  rndcorner(2, x02,      y09c, r)  // EVERY
  rndcorner(3, y09bxa,   y09c, r)  // EVERY

  rndcorner(1, xcy07, y08, r)
  rndcorner(0, xey07, y08, r)
  rndcorner(1, xgy07, y08, r)
  rndcorner(0, xiy07, y08, r)

  rndcorner(2, x02,   y07, r)
  rndcorner(0, xay07, y07, r)
  rndcorner(2, xcy07, y07, r)
  rndcorner(3, xey07, y07, r)
  rndcorner(2, xgy07, y07, r)
  rndcorner(3, xiy07, y07, r)
  rndcorner(3, xny19, y07, r)

  rndcorner(2, xay07, y06, r)
  rndcorner(3, xny19, y06, r)


  rndcorner(2, xay07, y05, r)
  rndcorner(3, xny19, y05, r)

  rndcorner(2, xay07, y04, r)
  rndcorner(1, xay04, y04, r)
  rndcorner(0, xcy04, y04, r)
  rndcorner(1, xey04, y04, r)
  rndcorner(3, xny19, y04, r)

  rndcorner(2, xcy04, y03, r)
  rndcorner(3, xey04, y03, r)

  rndcorner(2, x02,   y02, r)
  rndcorner(3, xay04, y02, r)


  rndcorner(2, x02,   y01, r)
  rndcorner(3, xay04, y01, r)

  writef("width = %n height = %n %5.1d in*n",
          width, height, 10*width / 300 *120/100) // 300 DPI
}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }


  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}


