GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  cellH   = 48
  cellW   = 48
  cellHby2   = cellH/2
  cellWby2   = cellW/2
  cellHby4   = cellH/4
  cellWby4   = cellW/4
  zigzagW    = cellWby2
  radius = 30             // Radius of round corners
}

LET start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = 1250, 1000

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
charleveloffset := 0
charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }

  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

AND strut(x, y) BE
{ LET prevcurrpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby(0, cellH)
  currpen := prevcurrpen
}

AND zigzag(x, y) BE
{ LET prevcurrpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby( cellHby4, cellHby4)
  drawby(-cellHby2, cellHby2)
  drawby( cellHby4, cellHby4)
  currpen := prevcurrpen
}

AND drawdiagram() BE
{ MANIFEST {
    c01 = 100           // 
    c02 = c01+cellW     // The new coroutine cells
    c03 = c02+cellW
    c04 = c03+cellW     // zigzag 1 L
    c05 = c04+cellW     // zigzag 1 R
    c06 = c05+cellW     // P2  createco stack frame
    c07 = c06+cellW     // L2
    c08 = c07+cellW     // blank
    c09 = c08+100       // zigzad L
    c10 = c09+zigzagW   // zigzag R
    c11 = c10+100       // end

    c02m = c02+cellHby2
    c03m = c03+cellHby2
    c04m = c04+cellHby2
    c05m = c05+cellHby2
    c06m = c06+cellHby2
    c07m = c07+cellHby2

    x00 = 10            // currco and colist
    x01 = 100           // main coroutine
    x02 = x01+cellW
    x03 = x02+cellW
    x04 = x03+cellW     // zigzag 1 L
    x05 = x04+zigzagW   // zigzag 1 R
    x06 = x05+cellW     // P2       createco stack frame
    x07 = x06+cellW     // L2
    x08 = x07+cellW     // blank
    x09 = x08+cellW     // fn
    x10 = x09+cellW     // sz
    x11 = x10+cellW     // c
    x12 = x11+cellW     // P1
    x13 = x12+cellW     // L1
    x14 = x13+cellW     // blank
    x15 = x14+cellW     // 0
    x16 = x15+cellW     // c
    x17 = x16+cellW     // blank
    x18 = x17+120       // zigzag 1 L
    x19 = x18+zigzagW   // zigzag 1 R
    x20 = x19+120       // end

    width = x20
    
    x01m = x01+cellWby2
    x02m = x02+cellWby2
    x03m = x03+cellWby2
    x04m = x04+cellWby2
    x05m = x05+cellWby2
    x06m = x06+cellWby2
    x07m = x07+cellWby2
    x08m = x08+cellWby2
    x09m = x09+cellWby2
    x10m = x10+cellWby2
    x11m = x11+cellWby2
    x12m = x12+cellWby2
    x13m = x13+cellWby2
    x14m = x14+cellWby2
    x15m = x15+cellWby2
    x16m = x16+cellWby2
    
    y01 = 60             // P      The new coroutine
    y02 = y01+50         // currco
    y03 = y02+cellH      // colist
    y04 = y03+80         // Lower edge 1
    y05 = y04+cellH      // Upper edge 1
    y06 = y05+80         // coroutine chain
    y07 = y06+24         // J -7
    y08 = y07+24         // SP8
    y09 = y08+24         // K6
    y10 = y09+24         // LP3
    y11 = y10+24         // K9G 24
    y12 = y11+24         // LP5
    y13 = y12+24         // LP5
    y14 = y13+24         // line
    y15 = y14+80         // Lower edge 2
    y16 = y15+cellH      // Upper edge 2
    y17 = y16+80         // lines
    y18 = y17+20         // curly bracket
    
    height = y18+50
    
    y02m = y02+cellHby2
    y04m = y04+cellHby2
    y07m = y07+cellHby2
    y15m = y15+cellHby2
    y16m = y16+cellHby2
  }

  // Draw the cells
  currpen := penS3

  moveto(100, 100)
  drawstr(100, 100, "Dummy Diagram")
  
  // Draw the vertical lines

  // Draw the horizontal lines

  // Draw the arrow heads
  //drawarrow(1, c02m,   y04-16, 20)  //

  // Draw round corners
  //rndcorner(3, c02m, y02, radius)
  
  // Draw the text
  charleveloffset := charmidleveloffset

  //drawstr(x00,  y02, "currco")
  //drawstrcentred(c05m,  y04m,  "fn")

  charleveloffset := 0

  //drawcurlyH(x06, y18, x12-x06, 20)
  //drawcurlyH(x12, y18, x17-x12, 20)

  writef("width = %n height = %n %5.1d mm*n",
          width, height, 22_0 * width / 238)
}

