GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  cellH   = 48
  cellW   = 48
  cellHby2   = cellH/2
  cellWby2   = cellW/2
  cellHby4   = cellH/4
  cellWby4   = cellW/4
  zigzagW    = cellWby2
  radius = 30             // Radius of round corners
}

LET start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = 1250, 1000

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
charleveloffset := 0
charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }

  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

AND strut(x, y) BE
{ LET prevcurrpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby(0, cellH)
  currpen := prevcurrpen
}

AND zigzag(x, y) BE
{ LET prevcurrpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby( cellHby4, cellHby4)
  drawby(-cellHby2, cellHby2)
  drawby( cellHby4, cellHby4)
  currpen := prevcurrpen
}

AND drawdiagram() BE
{ MANIFEST {
    c01 = 100           // 
    c02 = c01+cellW     // The new coroutine cells
    c03 = c02+cellW
    c04 = c03+cellW     // zigzag 1 L
    c05 = c04+cellW     // zigzag 1 R
    c06 = c05+cellW     // P2  createco stack frame
    c07 = c06+cellW     // L2
    c08 = c07+cellW     // blank
    c09 = c08+100       // zigzad L
    c10 = c09+zigzagW   // zigzag R
    c11 = c10+100       // end

    c02m = c02+cellHby2
    c03m = c03+cellHby2
    c04m = c04+cellHby2
    c05m = c05+cellHby2
    c06m = c06+cellHby2
    c07m = c07+cellHby2

    x00 = 10            // currco and colist
    x01 = 100           // main coroutine
    x02 = x01+cellW
    x03 = x02+cellW
    x04 = x03+cellW     // zigzag 1 L
    x05 = x04+zigzagW   // zigzag 1 R
    x06 = x05+cellW     // P2       createco stack frame
    x07 = x06+cellW     // L2
    x08 = x07+cellW     // blank
    x09 = x08+cellW     // fn
    x10 = x09+cellW     // sz
    x11 = x10+cellW     // c
    x12 = x11+cellW     // P1
    x13 = x12+cellW     // L1
    x14 = x13+cellW     // blank
    x15 = x14+cellW     // 0
    x16 = x15+cellW     // c
    x17 = x16+cellW     // blank
    x18 = x17+120       // zigzag 1 L
    x19 = x18+zigzagW   // zigzag 1 R
    x20 = x19+120       // end

    width = x20
    
    x01m = x01+cellWby2
    x02m = x02+cellWby2
    x03m = x03+cellWby2
    x04m = x04+cellWby2
    x05m = x05+cellWby2
    x06m = x06+cellWby2
    x07m = x07+cellWby2
    x08m = x08+cellWby2
    x09m = x09+cellWby2
    x10m = x10+cellWby2
    x11m = x11+cellWby2
    x12m = x12+cellWby2
    x13m = x13+cellWby2
    x14m = x14+cellWby2
    x15m = x15+cellWby2
    x16m = x16+cellWby2
    
    y01 = 60             // P      The new coroutine
    y02 = y01+50         // currco
    y03 = y02+cellH      // colist
    y04 = y03+80         // Lower edge 1
    y05 = y04+cellH      // Upper edge 1
    y06 = y05+80         // coroutine chain
    y07 = y06+24         // J -7
    y08 = y07+24         // SP8
    y09 = y08+24         // K6
    y10 = y09+24         // LP3
    y11 = y10+24         // K9G 24
    y12 = y11+24         // LP5
    y13 = y12+24         // LP5
    y14 = y13+24         // line
    y15 = y14+80         // Lower edge 2
    y16 = y15+cellH      // Upper edge 2
    y17 = y16+80         // lines
    y18 = y17+20         // curly bracket
    
    height = y18+50
    
    y02m = y02+cellHby2
    y04m = y04+cellHby2
    y07m = y07+cellHby2
    y15m = y15+cellHby2
    y16m = y16+cellHby2
  }

  // Draw the cells
  currpen := penS3
  moveto(c02, y04); drawto(c09, y04)        // Lower edge part 1
  moveto(c02, y05); drawto(c09, y05)        // Upper edge part 1
  moveto(c10, y04); drawto(c11, y04)        // Lower edge part 2
  moveto(c10, y05); drawto(c11, y05)        // Upper edge part 2

  moveto(x01, y15); drawto(x04, y15)        // Lower edge part 1
  moveto(x01, y16); drawto(x04, y16)        // Upper edge part 1
  moveto(x05, y15); drawto(x18, y15)        // Lower edge part 2
  moveto(x05, y16); drawto(x18, y16)        // Upper edge part 2
  moveto(x19, y15); drawto(x20, y15)        // Lower edge part 3
  moveto(x19, y16); drawto(x20, y16)        // Upper edge part 3

  currpen := penS3

  strut( c02,  y04); strut(x02+2, y04)    // Cell boundaries
  strut( c03,  y04)
  strut( c04,  y04)
  strut( c05,  y04)
  strut( c06,  y04)
  strut( c07,  y04)
  strut( c08,  y04)
  zigzag(c09,  y04)   // zigzag L
  zigzag(c10,  y04)   // zigzag R
  strut( c11,  y04)

  strut( x01,  y15); strut(x01+2, y15)    // Cell boundaries
  strut( x02,  y15)
  strut( x03,  y15)
  zigzag(x04,  y15)   // zigzag 1 L
  zigzag(x05,  y15)   // zigzag 1 R
  strut( x06,  y15)
  strut( x07,  y15)   //
  strut( x08,  y15)
  strut( x09,  y15)
  strut( x10,  y15)
  strut( x11,  y15)
  strut( x12,  y15)
  strut( x13,  y15)
  strut( x14,  y15)
  strut( x15,  y15)   // zigzag 3
  strut( x16,  y15)
  strut( x17,  y15)
  zigzag(x18,  y15)   // zigzag 2 L
  zigzag(x19,  y15)   // zigzag 2 R
  strut( x20,  y15)

  // Draw the vertical lines
  moveto(c02m, y02-8); drawto(c02m, y04-16)      // Line above P
  moveto(c07m, y03+radius); drawto(c07m, y04+8)
  moveto(x01m, y06+radius); drawto(x01m, y15-16) //
  moveto(c03m, y06-radius); drawto(c03m, y04m)
  moveto(c04m, y06-radius); drawto(c04m, y04m)
  moveto(c02m, y05+16); drawto(c02m, y14-radius) // Above P
  moveto(x11m, y15+8); drawto(x11m, y14+radius)  // Below c
  moveto(x16m, y15+8); drawto(x16m, y14+radius)  // Below c
  moveto(x13m, y15+8); drawto(x13m, y11+radius)  // Below L1
  moveto(x13m, y11-radius); drawto(x13m, y06+radius)  // Below L1
  moveto(x01m, y15m);   drawto(x01m, y17-radius) // Above cell1
  //moveto(x10, y15-8);  drawto(x14, y15-8) // Trst line
  moveto(x12m, y16-8);   drawto(x12m, y17-radius) // Above P2
  moveto(x06m, y16+16);  drawto(x06m, y17-radius) // Above P1

  // Draw the horizontal lines
  moveto(c02m+radius, y03); drawto(c07m-radius, y03)
  moveto(x01m+radius, y06); drawto(c03m-radius, y06) // Line level coroutine
  moveto(c04m+radius, y06); drawto(c06, y06)         // Line level coroutine
  moveto(x02m+radius, y14); drawto(x16m-radius, y14)
  moveto(x13, y11); drawto(x16-16, y11)
  moveto(x13m+radius, y06); drawto(x16-16, y06)
  moveto(x01m+radius, y17); drawto(x06m-radius, y17)
  moveto(x06m+radius, y17); drawto(x12m-radius, y17)

  // Draw the arrow heads
  drawarrow(1, c02m,   y04-16, 20)  //
  drawarrow(3, c02m,   y05+16, 20)  //
  drawarrow(0, c06,    y06, 20)     //
  drawarrow(1, x01m,   y15-16, 20)  //
  drawarrow(0, x16-16, y11, 20)     //  -> LP5
  drawarrow(3, x06m,   y16+16, 20)  //

  // Draw the horizontal lines
//  moveto(x09+8, y01); drawto(x12, y01) // PC arrow line

  // Draw the verical lines
//  moveto(x10m, y02+8); drawto(x10m, y01+radius)   // L1 vertical

  // Draw round corners
  rndcorner(3, c02m, y02, radius)
  rndcorner(3, c02m, y03, radius)
  rndcorner(2, c02m, y03, radius)
  rndcorner(3, c07m, y03, radius)
  
  rndcorner(2, x01m, y06, radius)  // coroutine chain
  rndcorner(0, c03m, y06, radius)
  rndcorner(1, c04m, y06, radius)
  rndcorner(2, x13m, y06, radius)

  rndcorner(1, x13m, y11, radius)
  rndcorner(2, x13m, y11, radius)

  rndcorner(1, x02m, y14, radius)
  rndcorner(3, x11m, y14, radius)
  rndcorner(3, x16m, y14, radius)

  rndcorner(1, x01m, y17, radius)
  rndcorner(0, x06m, y17, radius)
  rndcorner(1, x06m, y17, radius)
  rndcorner(0, x12m, y17, radius)
  
  // Draw the text
  charleveloffset := charmidleveloffset

  drawstr(x00,  y02, "currco")
  drawstr(x00,  y03, "colist")

  drawstrcentred(c05m,  y04m,  "fn")
  drawstrcentred(c06m,  y04m,  "sz")
  drawstrcentred(c07m,  y04m,  "c")

  drawstr(c06+10, y06, "coroutine chain")
  
  drawstr(x12,  y11, "PC")
  drawstr(x16,  y11, "LP5     {")
  drawstr(x16,  y10, "K9G 24    cowait()")
  drawstr(x16,  y09, "LP3")
  drawstr(x16,  y08, "K6        fn(...)")
  drawstr(x16,  y07, "SP5       c := ...")
  drawstr(x16,  y06, "J -7    }")

  drawstrcentred(x06m, y15m, "P2")
  drawstrcentred(x07m, y15m, "L2")
  drawstrcentred(x09m, y15m, "fn")
  drawstrcentred(x10m, y15m, "sz")
  drawstrcentred(x11m, y15m, "c")
  drawstrcentred(x12m, y15m, "P1")
  drawstrcentred(x13m, y15m, "L1")
  drawstrcentred(x15m, y15m, "0")
  drawstrcentred(x16m, y15m, "c")


  charleveloffset := 0
  drawstrcentred(c02m, y02-16-fontH,  "P")
  drawstrcentred(x08m, y18+66, "createco")
  drawstrcentred(x08m, y18+36, "stack frame")
  drawstrcentred(x14m, y18+66, "changeco")
  drawstrcentred(x14m, y18+36, "stack frame")

  drawcurlyH(x06, y18, x12-x06, 20)
  drawcurlyH(x12, y18, x17-x12, 20)

  drawcurlyH(c02, y01, c11-c02, -20)
  drawstrcentred((c02+c11)/2, y01-2*fontH, "The new coroutine")


  writef("width = %n height = %n %5.1d mm*n",
          width, height, 22_0 * width / 238)
}

