/*
This program draws sym2prog.bmp
*/

GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  cellheight   = 48
  radius = 30
}

LET start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = 1150, 450

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

currcol := col_black
selectfont(24)
charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
{ currpen := penS3
  moveto(1, yupb-1); drawto(xupb-2, yupb-1)
  moveto(1, 1);      drawto(xupb-2, 1)
  moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
  moveto(1, 1);      drawto(1, yupb-1)
}

drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

AND strut(x, y) BE
{ LET prevcurrpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby(0, cellheight)
  currpen := prevcurrpen
}

AND zigzag(x, y) BE
{ LET prevcurrpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby( cellheight/4, cellheight/4)
  drawby(-cellheight/2, cellheight/2)
  drawby( cellheight/4, cellheight/4)
  currpen := prevcurrpen
}

AND drawdiagram() BE
{ LET width, height = 0, 0
  MANIFEST {
    x01 = 40
    x02 = x01+50
    x01m = (x01+x02)/2
    x03 = x02+50
    x02m = (x02+x03)/2
    x04 = x03+50
    x03m = (x03+x04)/2
    x05 = x04+50
    x04m = (x04+x05)/2
    x06 = x05+50
    x05m = (x05+x06)/2
    x07 = x06+50
    x06m = (x06+x07)/2
    x08 = x07+200     // Start of gap 1
    x09 = x08+24     // End of gap 1
    x10 = x09+100
    x11 = x10+50
    x10m = (x10+x11)/2
    x12 = x11+50
    x11m = (x11+x12)/2
    x13 = x12+100
    x14 = x13+80     // Start of gap 2
    x15 = x14+24     // End of gap 2
    x16 = x15+140

    y01 = 50             // parent link
    y02 = y01+50         // coroutine chain
    y03 = y02+80         // Lower edge
    y04 = y03+cellheight // Upper edge
    y05 = y04+80         // Top line
    
    y03m = (y03+y04)/2
  }
  
  currpen := penS3
  moveto(x01, y03); drawto(x08, y03)        // Lower edge part 1
  moveto(x09, y03); drawto(x14, y03)        // Lower edge part 2
  moveto(x15, y03); drawto(x16, y03)        // Lower edge part 3

  moveto(x01, y04); drawto(x08, y04)        // Upper edge part 1
  moveto(x09, y04); drawto(x14, y04)        // Upper edge part 2
  moveto(x15, y04); drawto(x16, y04)        // Upper edge part 3

  currpen := penS3
  moveto(x01m, y03m); drawto(x01m, y05-radius)
  rndcorner(1, x01m, y05, radius)
  moveto(x01m+radius, y05); drawto(x10m-radius, y05)   // Top line
  rndcorner(0, x10m, y05, radius)
  moveto(x10m, y05-radius); drawto(x10m, y04+16)
  drawarrow(3, x10m, y04+16, 20)

  strut(x01, y03); strut(x01+2, y03)    // Cell boundaries
  strut(x02, y03)
  strut(x03, y03)
  strut(x04, y03)
  strut(x05, y03)
  strut(x06, y03)
  strut(x07, y03)
  zigzag(x08, y03)
  zigzag(x09, y03)
  strut(x10, y03)
  strut(x11, y03)
  strut(x12, y03)
  strut(x13, y03)
  zigzag(x14, y03)
  zigzag(x15, y03)

  drawcurlyH(x10, y03-20, x13-x10, -20)
  currpen := penS3

  strut(x16, y03); strut(x16-2, y03)
//  moveto(x16, y03); drawto(x16, y04)

  moveto(x03m, y03m); drawto(x03m, y02+radius)
  rndcorner(2, x03m, y02, radius)
  moveto(x03m+radius, y02); drawto(x05, y02)
  drawarrow(0, x05, y02, 20)

  moveto(x02m, y03m); drawto(x02m, y01+radius)
  rndcorner(2, x02m, y01, radius)
  moveto(x02m+radius, y01); drawto(x05, y01)
  drawarrow(0, x05, y01, 20)

  moveto(x01m, y01+12); drawto(x01m, y03-16)
  drawarrow(1, x01m, y03-16, 20)
  
  charleveloffset := charmidleveloffset
  drawstrcentred(x04m, y03m, "fn")
  drawstrcentred(x05m, y03m, "sz")
  drawstrcentred(x06m, y03m, "c")

  drawstrcentred(x10m, y03m, "P1")
  drawstrcentred(x11m, y03m, "L1")

  drawstr(x05+20, y02, "coroutine chain")
  drawstr(x05+20, y01, "parent link")

charleveloffset := 0
  drawstrcentred((x10+x13)/2, y03-80, "suspended")
  drawstrcentred((x10+x13)/2, y03-80-fontH-charVsep, "stack frame")
  drawstrcentred(x01m, y01-fontH, "cptr")
  drawstrcentred((x01m+x10m)/2, y05+12, "resumption point")

  width := x16
  writef("width = %n height = %n %5.1d mm*n",
          width, height, 22_0 * width / 238)
}

