GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  cellH   = 48
  cellW   = 48
  cellHby2   = cellH/2
  cellWby2   = cellW/2
  cellHby4   = cellH/4
  cellWby4   = cellW/4
  zigzagW    = cellWby2
  radius = 30             // Radius of round corners
}

LET start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = 1060, 700

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

currcol := col_black
selectfont(24)
charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
{ currpen := penS3
  moveto(1, yupb-1); drawto(xupb-2, yupb-1)
  moveto(1, 1);      drawto(xupb-2, 1)
  moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
  moveto(1, 1);      drawto(1, yupb-1)
}

drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

AND strut(x, y) BE
{ LET prevcurrpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby(0, cellH)
  currpen := prevcurrpen
}

AND zigzag(x, y) BE
{ LET prevcurrpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby( cellHby4, cellHby4)
  drawby(-cellHby2, cellHby2)
  drawby( cellHby4, cellHby4)
  currpen := prevcurrpen
}


AND drawdiagram() BE
{ MANIFEST {
    x01 = 40         // currco
    x02 = x01+cellW
    x03 = x02+cellW
    x04 = x03+20        // zigzag 1 L
    x05 = x04+zigzagW   // zigzag 1 R
    x06 = x05+30        // calling stack frame
    x07 = x06+100       // zigzag 2 L
    x08 = x07+zigzagW   // zigzag 2 R
    x09 = x08+40        // P1   changeco stack frame
    x10 = x09+cellW     // L1
    x11 = x10+cellW     // pointer to CHGCO
    x12 = x11+cellW     // a
    x13 = x12+cellW     // cptr
    x14 = x13+cellW     //
    x15 = x14+40        // zigzag 3 L
    x16 = x15+zigzagW   // zigzag 3 R
    x17 = x16+50        // currco
    x18 = x17+20
    x19 = x18+cellW     //
    x20 = x19+cellW     // cptr
    x21 = x20+30        //
    x22 = x21+zigzagW   // zigzag 4 L
    x23 = x22+30        // 
    x24 = x23+50        // P     zigzag 5 L
    x25 = x24+zigzagW   // zigzag 5 R
    x26 = x25+30        // Last strut position
    width = x26
    
    x01m = x01+cellWby2
    x02m = x02+cellWby2
    x03m = x03+cellWby2
    x04m = x04+cellWby2
    x05m = x05+cellWby2
    x06m = x06+cellWby2
    x07m = x07+cellWby2
    x09m = x09+cellWby2
    x10m = x10+cellWby2
    x11m = x11+cellWby2
    x12m = x12+cellWby2
    x13m = x13+cellWby2
    x14m = x14+cellWby2
    
    x18m = x18+cellWby2
    x23m = x23+cellWby2

    y01 = 40             // PC      currcoKparent link
    y02 = y01+100        // Lower edge 1
    y03 = y02+cellH      // Upper edge 1
    y04 = y03+80         // Middle line
    y05 = y04+50         // P     CHGCO
    y06 = y05+cellH      // cprt line
    y07 = y06+80         // Lower edge 2
    y08 = y07+cellH      // Upper edge 1
    y09 = y08+80         // resumption line
    y10 = y09+15         // curly bracket
    y11 = y10+15         // curly bracket top
    height = y11+30

    y02m = y02+cellHby2
    y05m = y05+cellHby2
    y07m = y07+cellHby2
  }

  // Draw the cells
  currpen := penS3

  IF FALSE DO
  { selectfont(24)
    charleveloffset := charmidleveloffset
    moveto(10, 80); drawto(100, 80)
    drawstr(110, 80, "ABCDabcd<>()#")
    selectfont(18)
    charleveloffset := charmidleveloffset
    moveto(450, 80); drawto(500, 80)
    drawstr(510, 80, "ABCDabcd<>()#")
    selectfont(12)
    charleveloffset := charmidleveloffset
    moveto(850, 80); drawto(900, 80)
    drawstr(910, 80, "ABCDabcd<>()#")
    selectfont(24)
  }
  
  moveto(x01, y02); drawto(x04, y02)        // Lower edge part 1
  moveto(x01, y03); drawto(x04, y03)        // Upper edge part 1
  moveto(x05, y02); drawto(x07, y02)        // Lower edge part 2
  moveto(x05, y03); drawto(x07, y03)        // Upper edge part 2
  moveto(x08, y02); drawto(x15, y02)        // Lower edge part 3
  moveto(x08, y03); drawto(x15, y03)        // Upper edge part 3
  moveto(x16, y02); drawto(x17, y02)        // Lower edge part 4
  moveto(x16, y03); drawto(x17, y03)        // Lower edge part 4
  moveto(x18, y02); drawto(x21, y02)        // Lower edge part 5
  moveto(x18, y03); drawto(x21, y03)        // Upper edge part 5
  moveto(x22, y02); drawto(x24, y02)        // Lower edge part 6
  moveto(x22, y03); drawto(x24, y03)        // Lower edge part 6
  moveto(x25, y02); drawto(x26, y02)        // Lower edge part 8
  moveto(x25, y03); drawto(x26, y03)        // Upper edge part 8

  moveto(x01, y07); drawto(x04, y07)        // Lower edge part 1
  moveto(x01, y08); drawto(x04, y08)        // Upper edge part 1
  moveto(x05, y07); drawto(x07, y07)        // Lower edge part 2
  moveto(x05, y08); drawto(x07, y08)        // Upper edge part 2
  moveto(x08, y07); drawto(x15, y07)        // Lower edge part 3
  moveto(x08, y08); drawto(x15, y08)        // Upper edge part 3
  moveto(x16, y07); drawto(x17, y07)        // Lower edge part 4
  moveto(x16, y08); drawto(x17, y08)        // Lower edge part 4
  moveto(x18, y07); drawto(x21, y07)        // Lower edge part 5
  moveto(x18, y08); drawto(x21, y08)        // Upper edge part 5
  moveto(x22, y07); drawto(x24, y07)        // Lower edge part 6
  moveto(x22, y08); drawto(x24, y08)        // Lower edge part 6
  moveto(x25, y07); drawto(x26, y07)        // Lower edge part 8
  moveto(x25, y08); drawto(x26, y08)        // Upper edge part 8



  currpen := penS3
  //moveto(x01m, y03m); drawto(x01m, y05-radius)
  //rndcorner(1, x01m, y05)

  strut( x01,  y02); strut(x01+2, y02)    // Cell boundaries
  strut( x02,  y02)
  strut( x03,  y02)
  zigzag(x04,  y02)   // zigzag 1
  zigzag(x05,  y02)
  strut( x06,  y02)
  zigzag(x07,  y02)   // zigzag 2
  zigzag(x08,  y02)
  strut( x09,  y02)
  strut( x10,  y02)
  strut( x11,  y02)
  strut( x12,  y02)
  strut( x13,  y02)
  strut( x14,  y02)
  zigzag(x15,  y02)   // zigzag 3
  zigzag(x16,  y02)
  strut( x17,  y02)
  strut( x18,  y02)
  strut( x19,  y02)
  
  strut( x20,  y02)
  zigzag(x21,  y02)   // zigzag 4
  zigzag(x22,  y02)
  strut( x23,  y02)
  zigzag(x24,  y02)   // zigzag 5
  zigzag(x25,  y02)
  strut( x26,  y02)

  strut( x10+8,  y05)
  strut( x13-8,  y05)

  strut( x01,  y07); strut(x01+2, y07)    // Cell boundaries
  strut( x02,  y07)
  strut( x03,  y07)
  zigzag(x04,  y07)   // zigzag 1
  zigzag(x05,  y07)
  strut( x06,  y07)
  zigzag(x07,  y07)   // zigzag 2
  zigzag(x08,  y07)
  strut( x09,  y07)
  strut( x10,  y07)
  strut( x11,  y07)
  strut( x12,  y07)
  strut( x13,  y07)
  strut( x14,  y07)
  zigzag(x15,  y07)   // zigzag 3
  zigzag(x16,  y07)
  strut( x17,  y07)
  strut( x18,  y07)
  strut( x19,  y07)
  
  strut( x20,  y07)
  zigzag(x21,  y07)   // zigzag 4
  zigzag(x22,  y07)
  strut( x23,  y07)
  zigzag(x24,  y07)   // zigzag 5
  zigzag(x25,  y07)
  strut( x26,  y07)

  // Draw the arrow heads
  drawarrow(0, x12,  y01   , 20)  // PC right arrow
  drawarrow(1, x18m, y02-16, 20)  // Arrow currco
  drawarrow(1, x23m, y02-16, 20)  // Arrow P
  drawarrow(3, x06m, y03+16, 20)  // Arrow resumption point
  drawarrow(3, x18m, y03+16, 20)  // Arrow currco
  drawarrow(1, x11m, y05-16, 20)  // Arrow above PC
  
  drawarrow(1, x09m, y07-16, 20)  // Arrow above P
  drawarrow(3, x11m, y06+20, 20)  // Arrow above CHGCO
  drawarrow(1, x18m, y07-16, 20)  // Arrow to cptr coroutine
  drawarrow(3, x01m, y08+16, 20)  // Arrow from currco
  drawarrow(3, x06m, y08+16, 20)  // Arrow from P1
  drawarrow(3, x23m, y08+16, 20)  // Arrow from for resumption point

  // Draw the horizontal lines
  moveto(x09+8, y01); drawto(x12, y01) // PC arrow line

  moveto(x01m+radius, y04); drawto(x06m-radius, y04) // Resumption lines
  moveto(x06m+radius, y04); drawto(x09m-radius, y04)
  moveto(x13m+radius, y04); drawto(x18m-radius, y04)
  moveto(x13m+radius, y06); drawto(x18m-radius, y06)

  moveto(x10+8, y06); drawto(x13-9, y06)
  moveto(x10+8, y05); drawto(x13-8, y05)

  moveto(x06m+radius, y09); drawto(x09m-radius, y09)
  moveto(x18m+radius, y09); drawto(x23m-radius, y09)

  // Draw the verical lines
  moveto(x10m, y02+8); drawto(x10m, y01+radius)   // L1 vertical
  moveto(x18m, y02-16); drawto(x18m, y01+16)      // currco arrow line
  moveto(x23m, y02-16); drawto(x23m, y01+16)      // P arrow line
  
  moveto(x01m, y02m); drawto(x01m, y04-radius)    // resumption from x01
  moveto(x06m, y04-radius); drawto(x06m, y03+16)  // resumption to x06m
  moveto(x09m, y03-8); drawto(x09m, y04-radius)   // resumption from x09m
  moveto(x13m, y02m); drawto(x13m, y04-radius)    // resumption from x01
  moveto(x18m, y04-radius); drawto(x18m, y03+16)  // resumption to x06m

  moveto(x11m, y03+60); drawto(x11m, y05-16) // line beteen PC and chgco

  moveto(x09m, y07-20); drawto(x09m, y06)         // above P
  moveto(x11m, y07m); drawto(x11m, y06+20)        // above CHGCO
  moveto(x13m, y07m); drawto(x13m, y06+radius)    // cptr line
  moveto(x18m, y07-20); drawto(x18m, y06+radius)  //

  moveto(x01m, y08+20); drawto(x01m, y09)         // currco line
  moveto(x06m, y08+20); drawto(x06m, y09-radius)  //
  moveto(x09m, y08-8); drawto(x09m, y09-radius)  //
  moveto(x09m, y08-8); drawto(x09m, y09-radius)  //
  moveto(x18m, y07m); drawto(x18m, y09-radius)  //
  moveto(x23m, y08+20); drawto(x23m, y09-radius)    //

  // Draw round corners
  rndcorner(2, x10m, y01, radius)
  
  rndcorner(1, x01m, y04, radius)
  rndcorner(0, x06m, y04, radius)
  rndcorner(1, x06m, y04, radius)
  rndcorner(0, x09m, y04, radius)
  rndcorner(1, x13m, y04, radius)
  rndcorner(0, x18m, y04, radius)

  rndcorner(2, x13m, y06, radius)
  rndcorner(3, x18m, y06, radius)

  rndcorner(1, x06m, y09, radius)
  rndcorner(0, x09m, y09, radius)
  rndcorner(1, x18m, y09, radius)
  rndcorner(0, x23m, y09, radius)

  // Draw the text
  selectfont(24)
  charleveloffset := charmidleveloffset

  drawstrcentred(x09m, y07m, "P1")
  drawstrcentred(x10m, y07m, "L1")
  drawstrcentred(x12m, y07m, "a")

  drawstrcentred(x09m, y02m, "P1")
  drawstrcentred(x10m, y02m, "L1")
  drawstrcentred(x12m, y02m, "a")

  drawstrcentred(x09m, y05m, "P")
  drawstrcentred(x11m, y05m, "CHGCO")

  charleveloffset := 0

  drawstr(x08,  y01-16, "PC")
  drawstrcentred(x18m, y01-16, "currco")
  drawstrcentred(x23m, y01-16, "P")
  
  drawstrcentred(x11m, y03+30, "PC")
  
  drawstrcentred((x13m+x18m)/2, y06+8, "cptr")

  drawstrcentred(x01m, y10, "currco")
  drawstrcentred((x18m+x23m)/2, y10, "resumption point")
  
  drawstrcentred(x11m, y11+46, "changeco")
  drawstrcentred(x11m, y11+16, "stack frame")

  drawcurlyH(x09, y10, x14-x09, 20)


  writef("width = %n height = %n %5.1d mm*n",
          width, height, 22_0 * width / 238)
}

