
GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  boxH    = 24*3/2 // Assuming 24x16 font
  boxHby2 = boxH/2

  catH    = 24*2   // Assuming 24x16 font
  catHby2 = catH/2

  bendradius = 15      // Radius of bends
  catradius  = 15      // Radius of cat box round corners

  dl1 =  3*16 + 2*3      // Length of a box containing 1 character 
  dl2 =  4*16 + 3*3      // Length of a box containing 2 characters 
  dl3 =  5*16 + 4*3      // Length of a box containing 3 characters
  dl4 =  6*16 + 5*3      // Length of a box containing 4 characters
  dl5 =  7*16 + 6*3      // Length of a box containing 5 characters
  dl6 =  8*16 + 7*3      // Length of a box containing 6 characters
  dl7 =  9*16 + 8*3      // Length of a box containing 7 characters
  dl8 = 10*16 + 9*3      // Length of a box containing 8 characters

  dl9  = 11*16 + 10*3  // Length of a box containing 8 characters
  dl10 = 12*16 + 11*3  // Length of a box containing 8 characters
  dl11 = 13*16 + 12*3  // Length of a box containing 8 characters
  dl12 = 14*16 + 13*3  // Length of a box containing 8 characters

  fac = 130

  dtt  = 50*fac/100    // Vertical distance between test boxes
  dtc  = 55*fac/100    // Vertical distance between a test and cat box
  dcc  = 60*fac/100    // Vertical distance between two cat boxes
  
  dtl  = 40*fac/100    // Vertical distance between a test box and a line
  dcl  = 40*fac/100    // Vertical distance between a cat box and a line
  dll  = 25*fac/100
  
  wbb   = 40
  wbv   = 30
  wvb   = 30
  wvv   = 40//45
  
  dw1 =  dl1/2 + 10    // Half size of a 1 character box
  dw2 =  dl2/2 + 10    // Half size of a 2 character box
  
  x01  = 20
  x02  = x01+60         // Left virtical line
  x03  = x02+wvv        // Second left virtical line
  x04  = x03+wvb        // LET etc

  y01 = 40             // BE  C
  y02 = y01+dcc/2      // LET
  y02a = y02+dtt       // , above name
  y03 = y02+dcc/2      // =   E0
  y04 = y02a+dtl       // AND
  y05 = y04+dtc        // GLOBAL
  y05a = y05+dll       // line
  y06 = y05a+dtl       // name : E0 
  y07 = y06+dtl        // line above name : E0
  y08 = y07+dtl        // STATIC
  y09 = y08+dtt        // MANIFEST
  y10 = y08+dcc        // name = E0
  y10a = y10+dcl       // line above name = E0
  y11 = y10a+dll       // second line above name = E0 
  y13 = y11+dcl+dll    // NEEDS
  y12 = y13-dtl        // line below ; after NEEDS
  y14 = y13+dtt        // line above NEEDS
  y16 = y14+dcl+dll    // SECTION
  y15 = y16-dtl        // line below ; after SECTION
  y17 = y16+dcc        // 

  xay02 = x04+dl3+wbv   // Vertical after LET
  xby02 = xay02+wvb     // name
  xcy02 = xby02+dl4+wbb // (
  xdy02 = xcy02+dl1+wbv // vertical after (
  xey02 = xdy02+wvv-20  // second vertical after (
  xfy02 = xey02+wvb     // name
  xgy02 = xfy02+dl4+wbv // vertical
  xhy02 = xgy02+wvv-20  // vertical
  xiy02 = xhy02+wvb     // )
  xjy02 = xiy02+dl1+wbv // vertical
  xky02 = xjy02+wvb     // BE on level 01
  xly02 = xky02+dl2+wbb // E0 on level 03

  xay08 = x04+dl8+wbv   // Vertical after STATIC
  xby08 = xay08+wvb     // {
  xay10 = xay08+dl1     // Vertical after {
  xby10 = xay10+wvb     // name
  xcy10 = xby10+dl4+wbv // Vertical
  xdy10 = xcy10+wvb     // =
  xey10 = xdy10+dl1+wbb // E0
  xfy10 = xey10+dl2+wbv // Vertical
  xgy10 = xfy10+wvv     // Vertical
  xhy10 = xgy10+wvb     // ;
  xiy10 = xhy10+dl1+wbv // Vertical
  xjy10 = xiy10+wvv     // Vertical
  xky10 = xjy10+wvb     // }
  xly10 = xky10+dl1+wbv // Vertical
  xmy10 = xly10+wvv     // Vertical
  xny10 = xmy10+wvb     // ;
  xoy10 = xny10+dl1+wbv // Vertical
  xpy10 = xoy10+wvv     // Vertical
  xqy10 = xpy10+wvb     // eof
  xry10 = xqy10+dl3+65 // Arrow
  
  xay16 = x04+dl8+wbb   // string after SECTION
  xby16 = xay16+dl6+wbv // Vertical after string
  xcy16 = xby16+wvb     // ;
  xdy16 = xcy16+dl1+wbv // Vertical after ;
  xey16 = xdy16+wbb     // Second vertical
  
  width = (xry10+53) & #xFFFC
  height = y17+40


}

LET drawtestboxL(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // left justified at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET bx1, by1 = x2,          y-boxHby2
  LET bx2, by2 = x2+boxwidth, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(x2, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstr(x2+fontW+charHsep, y, str)
  // draw the final line
  moveto(x2+boxwidth, y); drawto(x3, y)  
}

AND drawtestboxC(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // centred at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET boxwidthby2 = boxwidth/2
  LET bx1, by1 = x2-boxwidthby2, y-boxHby2
  LET bx2, by2 = x2+boxwidthby2, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxL(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2, y-catHby2
  LET bx2, by2 = x2+catwidth, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2+catwidthby2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxC(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2-catwidthby2, y-catHby2
  LET bx2, by2 = x2+catwidthby2, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(x2+catwidthby2, y); drawto(x3, y)
  
}

AND drawdiagram() BE
{ LET r = bendradius

  //writef("xay02 = %i5  %i5*n", xay02, xay02-x04)
  //writef("xby02 = %i5  %i5*n", xby02, xby02-xay02)
  //writef("xcy02 = %i5  %i5*n", xcy02, xcy02-xby02)
  //writef("xdy02 = %i5  %i5*n", xdy02, xdy02-xcy02)
  //writef("xei02 = %i5  %i5*n", xey02, xey02-xdy02)
  //writef("xfy02 = %i5  %i5*n", xfy02, xfy02-xey02)
  //writef("xgy02 = %i5  %i5*n", xgy02, xgy02-xfy02)
  //writef("xhy02 = %i5  %i5*n", xhy02, xhy02-xgy02)
  //writef("xiy02 = %i5  %i5*n", xiy02, xiy02-xhy02)
  //writef("xjy02 = %i5  %i5*n", xjy02, xjy02-xiy02)
  //writef("xky02 = %i5  %i5*n", xky02, xky02-xjy02)
  //writef("xly02 = %i5  %i5*n", xly02, xly02-xky02)

  // Draw the boxes
  currpen := penS3

  drawtestboxC(y17, x02+r, xey10, xpy10-r,   ".")
  
  drawtestboxL(y16, x01,   x04  , xay16,   "SECTION")
  drawtestboxL(y16, xay16, xay16, xcy16,   "string")
  drawtestboxL(y16, xcy16, xcy16, xey16-r, ";")

  drawtestboxL(y13, x03+r, x04,   xay16,   "NEEDS")
  drawtestboxL(y13, xay16, xay16, xby16,   "string")
  drawtestboxL(y13, xby16, xcy16, xey16-r, ";")

  drawtestboxL(y10, xay10+r, xby10, xcy10, "name") 
  drawtestboxL(y10, xcy10,   xdy10, xey10, "=") 
  drawcatboxL (y10, xey10,   xey10, xfy10, "E0") 
  drawtestboxL(y10, xfy10,   xhy10, xiy10, ";") 
  drawtestboxL(y10, xiy10,   xky10, xny10, "}") 
  drawtestboxL(y10, xny10,   xny10, xoy10, ";") 
  drawtestboxL(y10, xoy10,   xqy10, xry10, "eof") 

  drawtestboxL(y09, x03+r, x04,   xay08-r, "MANIFEST") 
  drawtestboxL(y08, x03+r, x04,   xby08,   "STATIC")
  drawtestboxL(y08, xby08, xby08, xiy10-r, "{")

  drawtestboxL(y06, xay10+r, xby10, xcy10,   "name") 
  drawtestboxL(y06, xcy10,   xdy10, xey10,   ":") 
  drawcatboxL (y06, xey10,   xey10, xfy10,   "E0") 
  drawtestboxL(y06, xfy10,   xhy10, xiy10,   ";") 
  drawtestboxL(y06, xiy10,   xky10, xly10-r, "}") 

  drawtestboxL(y05, x03+r, x04,   xby08,   "GLOBAL")
  drawtestboxL(y05, xby08, xby08, xiy10-r, "{")

  drawtestboxL(y04, xay02+r, xby02, xly10-r,     "AND") 

  drawtestboxL(y02a, xey02+r, xfy02+(dl4-dl1)/2, xgy02-r, ",") 
  drawtestboxL(y03,  xjy02+r, xky02+(dl2-dl1)/2, xly02,   "=") 
  drawcatboxL (y03,  xly02,   xly02,             xly10-r, "E0") 

  drawtestboxL(y02, x03+r,   x04, xby02,   "LET")
  drawtestboxL(y02, xby02, xby02, xcy02,   "name")
  drawtestboxL(y02, xcy02, xcy02, xfy02,   "(")
  drawtestboxL(y02, xfy02, xfy02, xiy02,   "name")
  drawtestboxL(y02, xiy02, xiy02, xjy02-r, ")")

  drawtestboxL(y01, xjy02+r, xky02, xly02, "BE") 
  drawcatboxL (y01, xly02, xly02+(dl2-dl1)/2, xly10-r, "C") 

  
  // Draw the vertical lines
  moveto(x02, y16+r);   drawto(x02, y17-r)
  moveto(xpy10, y10+r); drawto(xpy10, y17-r)
  
  moveto(x03,   y02+r); drawto(x03,   y16-r)
  moveto(xby16, y15+r); drawto(xby16, y16-r)
  moveto(xdy16, y15+r); drawto(xdy16, y16-r)
  moveto(xey16, y14+r); drawto(xey16, y16-r)
  
  moveto(xey16, y13+r); drawto(xey16, y14-r)
  
  moveto(xby16, y12+r); drawto(xby16, y13-r)
  moveto(xdy16, y12+r); drawto(xdy16, y13-r)

  moveto(xay10, y10+r); drawto(xay10, y10+dtl-r)
  moveto(xjy10, y10+r); drawto(xjy10, y10+dtl-r)

  moveto(xcy10, y10-dtl+r); drawto(xcy10, y10-r)
  moveto(xfy10, y10-dtl+r); drawto(xfy10, y10-r)
  moveto(xgy10, y08+r);     drawto(xgy10, y10-r)
  moveto(xiy10, y08+r);     drawto(xiy10, y10-r)
  moveto(xly10, y01+r);     drawto(xly10, y10-r)
  moveto(xmy10, y10-dtl+r); drawto(xmy10, y10-r)
  moveto(xoy10, y10-dtl+r); drawto(xoy10, y10-r)

  moveto(xay08, y08+r); drawto(xay08, y09-r)

  moveto(xay10, y06+r); drawto(xay10, y06+dtl-r)
  moveto(xjy10, y06+r); drawto(xjy10, y06+dtl-r)

  moveto(xcy10, y06-dtl+r); drawto(xcy10, y06-r)
  moveto(xfy10, y06-dtl+r); drawto(xfy10, y06-r)
  moveto(xgy10, y05+r);     drawto(xgy10, y06-r)
  moveto(xiy10, y05+r);     drawto(xiy10, y06-r)
  
  moveto(xay02, y02+r); drawto(xay02, y04-r)

  moveto(xey02, y02+r); drawto(xey02, y02a-r)
  moveto(xgy02, y02+r); drawto(xgy02, y02a-r)
  moveto(xjy02, y02+r); drawto(xjy02, y03-r)

  moveto(xdy02, y01+r); drawto(xdy02, y02-r)
  moveto(xhy02, y01+r); drawto(xhy02, y02-r)
  moveto(xjy02, y01+r); drawto(xjy02, y02-r)

  // Draw the horizontal lines
  
  moveto(xby16+r, y15); drawto(xdy16-r, y15)
  moveto(x03+r, y14); drawto(xey16-r, y14)
  moveto(xby16+r, y12); drawto(xdy16-r, y12)
  moveto(x03+r, y11); drawto(xpy10-r, y11)
  
  moveto(xay10+r, y10+dtl); drawto(xjy10-r, y10+dtl)
  
  moveto(xcy10+r, y10-dtl); drawto(xfy10-r, y10-dtl)
  moveto(xmy10+r, y10-dtl); drawto(xoy10-r, y10-dtl)

  moveto(xay10+r, y06+dtl); drawto(xjy10-r, y06+dtl)

  moveto(xcy10+r, y06-dtl); drawto(xfy10-r, y06-dtl)

  moveto(xdy02+r, y01); drawto(xhy02-r, y01)

  // Draw the arrow heads
  drawarrow(0, xry10, y10, 20)  // Arrow at bottom right

  // Draw path bends
  rndcorner(1, x02, y17, r)
  rndcorner(0, xpy10, y17, r)
  
  rndcorner(2, x02,     y16, r)
  rndcorner(0, x03,     y16, r)
  rndcorner(0, xby16,   y16, r)
  rndcorner(1, xdy16,   y16, r)
  rndcorner(0, xey16,   y16, r)
  
  rndcorner(2, xby16, y15, r)
  rndcorner(3, xdy16, y15, r)

  rndcorner(1, x03,   y14, r)
  rndcorner(3, xey16, y14, r)
  rndcorner(0, xey16, y14, r)

  rndcorner(2, x03,   y13, r)
  rndcorner(0, xby16, y13, r)
  rndcorner(1, xdy16, y13, r)
  rndcorner(3, xey16, y13, r)

  rndcorner(2, xby16, y12, r)
  rndcorner(3, xdy16, y12, r)

  rndcorner(1, x03, y11, r)
  rndcorner(0, xpy10, y11, r)
  
  rndcorner(1, xay10, y10+dtl, r)
  rndcorner(0, xjy10, y10+dtl, r)

  rndcorner(2, xcy10, y10-dtl, r)
  rndcorner(3, xfy10, y10-dtl, r)
  rndcorner(2, xmy10, y10-dtl, r)
  rndcorner(3, xoy10, y10-dtl, r)

  rndcorner(2, xay10, y10, r)
  rndcorner(0, xcy10, y10, r)
  rndcorner(1, xfy10, y10, r)
  rndcorner(0, xgy10, y10, r)
  rndcorner(1, xiy10, y10, r)
  rndcorner(3, xjy10, y10, r)
  rndcorner(1, xly10, y10, r)
  rndcorner(0, xmy10, y10, r)
  rndcorner(1, xoy10, y10, r)
  rndcorner(3, xpy10, y10, r)
  
  rndcorner(2, x03,   y09, r)
  rndcorner(0, xay08, y09, r)

  rndcorner(2, x03,   y08, r)
  rndcorner(2, xay08, y08, r)
  rndcorner(2, xgy10, y08, r)
  rndcorner(3, xiy10, y08, r)

  rndcorner(1, xay10, y06+dtl, r)
  rndcorner(0, xjy10, y06+dtl, r)

  rndcorner(2, xay10, y06, r)
  rndcorner(0, xcy10, y06, r)
  rndcorner(1, xfy10, y06, r)
  rndcorner(0, xgy10, y06, r)
  rndcorner(1, xiy10, y06, r)
  rndcorner(3, xjy10, y06, r)
  rndcorner(3, xly10, y06, r)

  rndcorner(2, xcy10, y06-dtl, r)
  rndcorner(3, xfy10, y06-dtl, r)

  rndcorner(2, x03,   y05, r)
  rndcorner(2, xgy10, y05, r)
  rndcorner(3, xiy10, y05, r)
  
  rndcorner(1, xay02, y04, r)
  rndcorner(0, xly10, y04, r)

  rndcorner(1, xey02, y02a, r)
  rndcorner(0, xgy02, y02a, r)
  rndcorner(1, xjy02, y03, r)
  rndcorner(3, xly10, y03, r)

  rndcorner(2, x03,   y02, r)
  rndcorner(2, xay02, y02, r)
  rndcorner(0, xdy02, y02, r)
  rndcorner(2, xey02, y02, r)
  rndcorner(3, xgy02, y02, r)
  rndcorner(1, xhy02, y02, r)
  rndcorner(3, xjy02, y02, r)
  rndcorner(0, xjy02, y02, r)
  
  rndcorner(2, xdy02, y01, r)
  rndcorner(3, xhy02, y01, r)
  rndcorner(2, xjy02, y01, r)
  rndcorner(3, xly10, y01, r)

  // Draw the text
  charleveloffset := charmidleveloffset

  //drawstr(x00,  y02, "currco")
  //drawstrcentred(c05m,  y04m,  "fn")

  charleveloffset := 0

  writef("width = %n height = %n %5.1d in*n",
          width, height, 10*width / 300 *120/100) // 300 DPI
}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }


  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}


