SECTION "TRN"

//    TRNHDR
 
GET "libhdr"
 
MANIFEST $(   // Parse tree operators
s_number=1; s_name=2; s_string=3; s_true=4; s_false=5
s_valof=6; s_lv=7; s_rv=8; s_vecap=9; s_fnap=10
s_mult=11; s_div=12; s_rem=13; s_plus=14; s_minus=15
s_query=16; s_neg=17; s_abs=19
s_eq=20; s_ne=21; s_ls=22; s_gr=23; s_le=24; s_ge=25; s_byteap = 28
s_not=30; s_lshift=31; s_rshift=32; s_logand=33; s_logor=34
s_eqv=35; s_neqv=36; s_cond=37; s_comma=38; s_table=39
s_and=40; s_valdef=41; s_vecdef=42; s_constdef=43
s_fndef=44; s_rtdef=45; s_needs=48; s_section=49
s_ass=50; s_rtap=51; s_goto=52; s_resultis=53; s_colon=54
s_test=55; s_for=56; s_if=57; s_unless=58
s_while=59; s_until=60; s_repeat=61; s_repeatwhile=62
s_repeatuntil=63; s_loop=65; s_break=66; s_return=67; s_finish=68
s_endcase=69; s_switchon=70; s_case=71; s_default=72
s_seq=73; s_let=74; s_manifest=75; s_global=76
s_local=77; s_label=78; s_static=79
$)

MANIFEST $(    //  Selectors
h1=0; h2=1; h3=2; h4=3; h5=4; h6=5; h7=6
$)

MANIFEST $(
s_lf=39; s_lp=40; s_lg=41; s_ln=42; s_lstr=43
s_ll=44; s_llp=45; s_llg=46; s_lll=47 
s_sp=80; s_sg=81; s_sl=82; s_stind=83
s_jump=85; s_jt=86; s_jf=87; s_endfor=88
s_lab=90; s_stack=91; s_store=92; s_rstack=93; s_entry=94
s_save=95; s_fnrn=96; s_rtrn=97; s_res=98
s_datalab=100; s_itemn=102
s_endproc=103; s_getbyte=120; s_putbyte=121
$)

GLOBAL  $(
nametable:248; nametablesize:249
fin_p:237; fin_l:238; plist:252; treep:269; treevec:270
 
errcount:291; errmax:292; sysprint:294; ocodeout:295
 
trnext:300; trans:301; declnames:302; decldyn:303
declstat:304; checkdistinct:305; addname:306; cellwithname:307
transdef:308; scanlabel:309
decllabels:310; undeclare:311; trnerr:312
jumpcond:320; transswitch:321; transfor:322
assign:330; load:331; fnbody:332; loadlv:333; loadlist:334
isconst:335; evalconst:336; transname:337
nextlab:343; labnumber:344; translate:345; newblk:346
wrc:350; ocount:351; wrn:353; wrpn:354
dvec:360; dvece:361; dvecp:362; dvect:363
caselist:365; casecount:366; comline:370; procname:371
resultlab:372; defaultlab:373; endcaselab:374
looplab:375; breaklab:376; ssp:380; vecssp:381; savespacesize:382
gdeflist:385; gdefcount:386
outstring:389; out1:390; out2:391
$)

LET nextlab() = VALOF
$( labnumber := labnumber + 1
   RESULTIS labnumber
$)
 
AND trnerr(mess, a) BE
$( selectoutput(sysprint)
   writes("Error ")
   UNLESS procname=0 DO writef("in %s ", @h3!procname)
   writef("near line %n:    ", comline)
   writef(mess, a)
   newline()
   errcount := errcount + 1
   IF errcount >= errmax DO $( writes("*nCompilation aborted*n")
                               longjump(fin_p, fin_l)
                            $)
   selectoutput(ocodeout)
$)

AND newblk(x, y, z) = VALOF
$( LET p = dvect - 3
   IF dvece>p DO $( errmax := 0        // Make it fatal.
                    trnerr("More workspace needed")
                 $)
   p!0, p!1, p!2 := x, y, z
   dvect := p
   RESULTIS p
$)

AND translate(x) BE
$( dvec,  dvect := treevec, treep
   h1!dvec, h2!dvec, h3!dvec := 0, 0, 0
   dvece := dvec+3
   dvecp := dvece
//selectoutput(sysprint)
   FOR i = 0 TO nametablesize-1 DO
   $( LET name = nametable!i
      UNTIL name=0 DO
      $( LET next = h2!name
         h2!name := 0 // Mark undeclared
//   writef("Undeclare %s*n", name+2)
         name := next
      $)
   $)

   gdeflist, gdefcount := 0, 0
   caselist, casecount, defaultlab := 0, -1, 0
   resultlab, breaklab, looplab, endcaselab := -2, -2, -2, -2
   comline, procname, ocount, labnumber := 1, 0, 0, 0
   ssp, vecssp := savespacesize, savespacesize

   WHILE x~=0 & (h1!x=s_section | h1!x=s_needs) DO
   $( LET op, a = h1!x, h2!x
      out1(op)
      outstring(@h2!a)
      x:=h3!x
   $)

   trans(x, 0)
   out2(s_global, gdefcount)
   UNTIL gdeflist=0 DO $( out2(h2!gdeflist, h3!gdeflist)
                          gdeflist := h1!gdeflist
                       $)  
   newline()
$)

LET trnext(next) BE $( IF next<0 DO out1(s_rtrn)
                       IF next>0 DO out2(s_jump, next)
                    $)
 
LET trans(x, next) BE
// x       is the command to translate
// next<0  compile x followed by RTRN
// next>0  compile x followed by JUMP next
// next=0  compile x only
$( LET sw = FALSE
   IF x=0 DO $( trnext(next); RETURN $)
 
   SWITCHON h1!x INTO
   $( DEFAULT: trnerr("Compiler error in Trans"); RETURN
 
      CASE s_let:
      $( LET cc = casecount
         LET e, s, s1 = dvece, ssp, 0
         LET v = vecssp
         casecount := -1 // Disallow CASE and DEFAULT labels
         comline := h4!x
         declnames(h2!x)
         checkdistinct(e)
         vecssp, s1 := ssp, ssp
         ssp := s
         comline := h4!x
         transdef(h2!x)
         UNLESS ssp=s1 DO trnerr("Lhs and rhs do not match")
         UNLESS ssp=vecssp DO $( ssp := vecssp; out2(s_stack, ssp) $)
         out1(s_store)
         decllabels(h3!x)
         trans(h3!x, next)
         vecssp := v
         UNLESS ssp=s DO out2(s_stack, s)
         ssp := s
         casecount := cc
         undeclare(e)
         RETURN
      $)
 
      CASE s_static:
      CASE s_global:
      CASE s_manifest:
      $( LET cc = casecount
         LET e, s = dvece, ssp
         AND op = h1!x
         AND y = h2!x
         
         casecount := -1 // Disallow CASE and DEFAULT labels
         comline := h4!x
 
         UNTIL y=0 DO
         $( LET n = evalconst(h4!y)
            IF op=s_static DO $( LET k = n
                                 n := nextlab()
                                 out2(s_datalab, n)
                                 out2(s_itemn, k)
                              $)
            addname(h3!y, op, n)
            y := h2!y
         $)
 
         decllabels(h3!x)
         trans(h3!x, next)
         ssp := s
         casecount := cc
         undeclare(e)
         RETURN
      $)
 
 
      CASE s_ass:
         comline := h4!x
         assign(h2!x, h3!x)
         trnext(next)
         RETURN
 
      CASE s_rtap:
      $( LET s = ssp
         comline := h4!x
         ssp := ssp+savespacesize
         out2(s_stack, ssp)
         loadlist(h3!x)
         load(h2!x)
         out2(s_rtap, s)
         ssp := s
         trnext(next)
         RETURN
      $)
 
      CASE s_goto:
         comline := h3!x
         load(h2!x)
         out1(s_goto)
         ssp := ssp-1
         RETURN
 
      CASE s_colon:
         comline := h5!x
         out2(s_lab, h4!x)
         trans(h3!x, next)
         RETURN
 
      CASE s_unless: sw := TRUE
      CASE s_if:
         comline := h4!x
         TEST next>0 THEN $( jumpcond(h2!x, sw, next)
                             trans(h3!x, next)
                          $)
                     ELSE $( LET l = nextlab()
                             jumpcond(h2!x, sw, l)
                             trans(h3!x, next)
                             out2(s_lab, l)
                             trnext(next)
                          $)
         RETURN
 
      CASE s_test:
      $( LET l, m = nextlab(), 0
         comline := h5!x
         jumpcond(h2!x, FALSE, l)
         
         TEST next=0 THEN $( m := nextlab(); trans(h3!x, m) $)
                     ELSE trans(h3!x, next)
                     
         out2(s_lab, l)
         trans(h4!x, next)
         UNLESS m=0 DO out2(s_lab, m)
         RETURN
      $)
 
      CASE s_loop:
         comline := h2!x
         IF looplab<0 DO trnerr("Illegal use of LOOP")
         IF looplab=0 DO looplab := nextlab()
         out2(s_jump, looplab)
         RETURN
 
      CASE s_break:
         comline := h2!x
         IF breaklab=-2 DO trnerr("Illegal use of BREAK")
         IF breaklab=-1 DO $( out1(s_rtrn); RETURN $)
         IF breaklab= 0 DO breaklab := nextlab()
         out2(s_jump, breaklab)
         RETURN
 
      CASE s_return:
         comline := h2!x
         out1(s_rtrn)
         RETURN
 
      CASE s_finish:
         comline := h2!x
         out1(s_finish)
         RETURN
 
      CASE s_resultis:
         comline := h3!x
         IF resultlab=-1 DO $( fnbody(h2!x); RETURN $)
         UNLESS resultlab>0 DO trnerr("RESULTIS out of context")
         load(h2!x)
         out2(s_res, resultlab)
         ssp := ssp - 1
         RETURN
 
      CASE s_while: sw := TRUE
      CASE s_until:
      $( LET l, m = nextlab(), next
         LET bl, ll = breaklab, looplab
         comline := h4!x
         breaklab, looplab := next, 0
         IF next<=0 DO m := nextlab()
         IF next =0 DO breaklab := m
         jumpcond(h2!x, ~sw, m)
         out2(s_lab, l)
         trans(h3!x, 0)
         UNLESS looplab=0 DO out2(s_lab, looplab)
         comline := h4!x
         jumpcond(h2!x, sw, l)
         IF next<=0 DO out2(s_lab, m)
         trnext(next)
         breaklab, looplab := bl, ll
         RETURN
      $)
 
      CASE s_repeatwhile: sw := TRUE
      CASE s_repeatuntil:
      $( LET l, bl, ll = nextlab(), breaklab, looplab
         comline := h4!x
         breaklab, looplab := next, 0
         out2(s_lab, l)
         trans(h2!x, 0)
         UNLESS looplab=0 DO out2(s_lab, looplab)
         comline := h4!x
         jumpcond(h3!x, sw, l)

//       UNLESS breaklab=0 DO out2(s_lab, breaklab)
         IF next=0 & breaklab>0 DO out2(s_lab, breaklab)

         trnext(next)
         breaklab, looplab := bl, ll
         RETURN
      $)
 
      CASE s_repeat:
      $( LET bl, ll = breaklab, looplab
         comline := h4!x
         breaklab, looplab := next, nextlab()
         out2(s_lab, looplab)

         trans(h2!x, looplab)

         IF next=0 & breaklab>0 DO out2(s_lab, breaklab)

         breaklab, looplab := bl, ll
         RETURN
      $)
 
      CASE s_case:
      $( LET l, k, cl = nextlab(), ?, caselist
         comline := h4!x
         k := evalconst(h2!x)
         IF casecount<0 DO trnerr("CASE label out of context")
         UNTIL cl=0 DO
         $( IF h2!cl=k DO trnerr("'CASE %n:' occurs twice", k)
            cl := h1!cl
         $)
         caselist := newblk(caselist, k, l)
         casecount := casecount + 1
         out2(s_lab, l)
         trans(h3!x, next)
         RETURN
      $)
 
      CASE s_default:
         comline := h3!x
         IF casecount<0 | defaultlab~=0 DO trnerr("Bad DEFAULT label")
         defaultlab := nextlab()
         out2(s_lab, defaultlab)
         trans(h2!x, next)
         RETURN
 
      CASE s_endcase:
         comline := h2!x
         IF endcaselab=-2 DO trnerr("Illegal use of ENDCASE")
         IF endcaselab=-1 DO out1(s_rtrn)
         // endcaselab is never equal to 0
         IF endcaselab>0  DO out2(s_jump, endcaselab)
         RETURN
 
      CASE s_switchon:
         transswitch(x, next)
         RETURN
 
      CASE s_for:
         transfor(x, next)
         RETURN
 
      CASE s_seq:
         trans(h2!x, 0)
         x := h3!x
   $)
$) REPEAT

LET declnames(x) BE UNLESS x=0 SWITCHON h1!x INTO
 
$(  DEFAULT:       trnerr("Compiler error in Declnames")
                   RETURN
 
    CASE s_vecdef:
    CASE s_valdef: decldyn(h2!x)
                   RETURN
 
    CASE s_rtdef:
    CASE s_fndef:  h5!x := nextlab()
                   declstat(h2!x, h5!x)
                   RETURN
 
    CASE s_and:    declnames(h2!x)
                   comline := h4!x
                   declnames(h3!x)
$)
 
AND decldyn(x) BE UNLESS x=0 DO
 
$( IF h1!x=s_name  DO $( addname(x, s_local, ssp)
                         ssp := ssp + 1
                         RETURN
                      $)
 
   IF h1!x=s_comma DO $( addname(h2!x, s_local, ssp)
                         ssp := ssp + 1
                         decldyn(h3!x)
                         RETURN
                      $)
 
   trnerr("Compiler error in Decldyn")
$)
 
AND declstat(x, lab) BE
$( LET c = cellwithname(x)
 
   TEST h2!c=s_global THEN $( LET gn = h3!c
                              gdeflist := newblk(gdeflist, gn, lab)
                              gdefcount := gdefcount + 1
                              addname(x, s_global, gn)
                           $)
                      ELSE    addname(x, s_label, lab)
$)
 
AND decllabels(x) BE
$( LET e = dvece
   scanlabels(x)
   checkdistinct(e)
$)
 
AND checkdistinct(p) BE
$( LET lim = dvece - 3
   FOR q = p TO lim-3 BY 3 DO
   $( LET n = h1!q
      FOR c = q+3 TO lim DO
          IF h1!c=n DO trnerr("Name %s defined twice", @h3!n)
   $)
$)
 
AND addname(name, k, a) BE
$( LET p = dvece + 3
   IF p>dvect DO trnerr("More workspace needed")
   h1!dvece, h2!dvece, h3!dvece := name, k, a
   h2!name := dvece // Remember the declaration
   dvece := p
$)
 
AND undeclare(e) BE 
$( FOR t = e TO dvece-3 BY 3 DO
   $( LET name = h1!t
      h2!name := 0   // Forget its declaration
   $)
   dvece := e
$)

AND cellwithname(n) = VALOF
$( LET t = h2!n
   UNLESS t=0 RESULTIS t  // It has been looked up before
   t := dvece
   t := t - 3 REPEATUNTIL h1!t=n | h1!t=0
   h2!n := t  // Associate the name with declaration item
   RESULTIS t
$)
 
AND scanlabels(x) BE UNLESS x=0 SWITCHON h1!x INTO
 
$( CASE s_colon:   comline := h5!x
                   h4!x := nextlab()
                   declstat(h2!x, h4!x)
 
   CASE s_if: CASE s_unless: CASE s_while: CASE s_until:
   CASE s_switchon: CASE s_case:
                   scanlabels(h3!x)
                   RETURN
 
   CASE s_seq:     scanlabels(h3!x)
 
   CASE s_repeat: CASE s_repeatwhile: CASE s_repeatuntil:
   CASE s_default: scanlabels(h2!x)
                   RETURN
 
   CASE s_test:    scanlabels(h3!x)
                   scanlabels(h4!x)
   DEFAULT:        RETURN
$)
 
AND transdef(x) BE
$( LET ln = comline
   transdyndefs(x)
   comline := ln
   IF statdefs(x) DO $( LET l, s= nextlab(), ssp
                        out2(s_jump, l)
                        transstatdefs(x)
                        ssp := s
                        out2(s_stack, ssp)
                        out2(s_lab, l)
                     $)
   comline := ln
$)
 
 
AND transdyndefs(x) BE SWITCHON h1!x INTO
$( CASE s_and:    transdyndefs(h2!x)
                  comline := h4!x
                  transdyndefs(h3!x)
                  RETURN
 
   CASE s_vecdef: out2(s_llp, vecssp)
                  ssp := ssp + 1
                  vecssp := vecssp + 1 + evalconst(h3!x)
                  RETURN
 
   CASE s_valdef: loadlist(h3!x)
 
   DEFAULT:       RETURN
$)
 
AND transstatdefs(x) BE SWITCHON h1!x INTO
$( CASE s_and:  transstatdefs(h2!x)
                comline := h4!x
                transstatdefs(h3!x)
                RETURN
 
   CASE s_fndef:
   CASE s_rtdef:
             $( LET e, p = dvece, dvecp
                AND oldpn = procname
                AND bl, ll = breaklab,  looplab
                AND rl, el = resultlab, endcaselab
                AND cl, cc = caselist,  casecount
                breaklab,  looplab    := -2, -2
                resultlab, endcaselab := -2, -2
                caselist,  casecount  :=  0, -1
                procname := h2!x

                out2(s_entry, h5!x)
                outstring(@h3!procname)
                ssp := savespacesize
                dvecp := dvece
                decldyn(h3!x)
                checkdistinct(e)
                decllabels(h4!x)
                out2(s_save, ssp)
                TEST h1!x=s_rtdef THEN trans(h4!x, -1)
                                  ELSE fnbody(h4!x)
                out1(s_endproc)
 
                breaklab,  looplab    := bl, ll
                resultlab, endcaselab := rl, el
                caselist,  casecount  := cl, cc
                procname := oldpn
                dvecp := p
                undeclare(e)
             $)
 
   DEFAULT:     RETURN
$)
 
AND statdefs(x) = h1!x=s_fndef | h1!x=s_rtdef -> TRUE,
                  h1!x ~= s_and               -> FALSE,
                  statdefs(h2!x)              -> TRUE,
                  statdefs(h3!x)
 
 
LET jumpcond(x, b, l) BE
$( LET sw = b

   SWITCHON h1!x INTO
   $( CASE s_false:  b := NOT b
      CASE s_true:   IF b DO out2(s_jump, l)
                     RETURN
 
      CASE s_not:    jumpcond(h2!x, NOT b, l)
                     RETURN
 
      CASE s_logand: sw := NOT sw
      CASE s_logor:  TEST sw THEN $( jumpcond(h2!x, b, l)
                                     jumpcond(h3!x, b, l)
                                     RETURN
                                  $)
 
                             ELSE $( LET m = nextlab()
                                     jumpcond(h2!x, NOT b, m)
                                     jumpcond(h3!x, b, l)
                                     out2(s_lab, m)
                                     RETURN
                                  $)
 
        DEFAULT:     load(x)
                     out2(b -> s_jt, s_jf, l)
                     ssp := ssp - 1
                     RETURN
   $)
$)
 
AND transswitch(x, next) BE
$( LET cl, cc = caselist, casecount 
   LET dl, el = defaultlab, endcaselab
   LET l, dlab = nextlab(), ?
   caselist, casecount, defaultlab := 0, 0, 0
   endcaselab := next=0 -> nextlab(), next
 
   comline := h4!x
   out2(s_jump, l)
   trans(h3!x, endcaselab)
 
   comline := h4!x
   out2(s_lab, l)
   load(h2!x)

   dlab := defaultlab>0 -> defaultlab,
           endcaselab>0 -> endcaselab,
           nextlab()

   out2(s_switchon, casecount); out1(dlab) 
   UNTIL caselist=0 DO $( out2(h2!caselist, h3!caselist)
                          caselist := h1!caselist
                       $)
   ssp := ssp - 1

   IF next=0                DO    out2(s_lab, endcaselab)
   IF next<0 & defaultlab=0 DO $( out2(s_lab, dlab)
                                  out1(s_rtrn)
                               $)

   defaultlab, endcaselab := dl, el
   caselist,   casecount  := cl, cc
$)
 
AND transfor(x, next) BE
$( LET e, m, blab = dvece, nextlab(), 0
   LET bl, ll = breaklab, looplab
   LET cc = casecount
   LET k, n, step = 0, 0, 1
   LET s = ssp

   casecount := -1  // Disallow CASE and DEFAULT labels.   
   breaklab, looplab := next, 0
   
   comline := h7!x
 
   addname(h2!x, s_local, s)
   load(h3!x)
 
   TEST h1!(h4!x)=s_number THEN    k, n := s_ln, h2!(h4!x)
                           ELSE $( k, n := s_lp, ssp
                                   load(h4!x)
                                $)
 
   UNLESS h5!x=0 DO step := evalconst(h5!x)
 
   out1(s_store)
   
   TEST k=s_ln & h1!(h3!x)=s_number  // check for constant limits 
   THEN $( LET initval = h2!(h3!x)
           IF step>=0 & initval>n | step<0 & initval<n DO
           $( TEST next<0
              THEN out1(s_rtrn)
              ELSE TEST next>0
                   THEN out2(s_jump, next)
                   ELSE $( blab := breaklab>0 -> breaklab, nextlab()
                           out2(s_jump, blab)
                        $)
           $)
        $)
   ELSE $( IF next<=0 DO blab := nextlab()
           out2(s_lp, s)
           out2(k, n)
           out1(step>=0 -> s_gr, s_ls)
           out2(s_jt, next>0 -> next, blab)
        $)

   IF breaklab=0 & blab>0 DO breaklab := blab
   
   comline := h7!x
   decllabels(h6!x)
   comline := h7!x
   out2(s_lab, m)
   trans(h6!x, 0)
   UNLESS looplab=0 DO out2(s_lab, looplab)
   out2(s_lp, s); out2(s_ln, step); out1(s_plus); out2(s_sp, s)
   out2(s_lp,s); out2(k,n); out1(step>=0 -> s_le, s_ge)
   out2(s_jt, m)
 
   IF next<=0 TEST blab>0 
              THEN                  out2(s_lab, blab)
              ELSE IF breaklab>0 DO out2(s_lab, breaklab)
   trnext(next)
   casecount := cc
   breaklab, looplab, ssp := bl, ll, s
   out2(s_stack, ssp)
   undeclare(e)
$)
 
LET load(x) BE
$( LET op = h1!x

   IF isconst(x) DO
   $( out2(s_ln, evalconst(x))
      ssp := ssp + 1
      RETURN
   $)
 
   SWITCHON op INTO
   $( DEFAULT:          trnerr("Compiler error in Load")
                        out2(s_ln, 0)
                        ssp := ssp + 1
                        RETURN
 
      CASE s_byteap:    op:=s_getbyte

      CASE s_div: CASE s_rem: CASE s_minus:
      CASE s_ls: CASE s_gr: CASE s_le: CASE s_ge:
      CASE s_lshift: CASE s_rshift:
                        load(h2!x); load(h3!x); out1(op)
                        ssp := ssp - 1
                        RETURN
 
      CASE s_vecap: CASE s_mult: CASE s_plus: CASE s_eq: CASE s_ne:
      CASE s_logand: CASE s_logor: CASE s_eqv: CASE s_neqv:
         $( LET a, b = h2!x, h3!x
            TEST h1!a=s_name |
                 h1!a=s_number THEN $( load(b); load(a) $)
                               ELSE $( load(a); load(b) $)
            TEST op=s_vecap THEN out2(s_plus, s_rv)
                            ELSE out1(op)
            ssp := ssp - 1
            RETURN
         $)
 
      CASE s_neg: CASE s_not: CASE s_rv: CASE s_abs:
                       load(h2!x)
                       out1(op)
                       RETURN
 
      CASE s_true: CASE s_false: CASE s_query:
                       out1(op)
                       ssp := ssp + 1
                       RETURN
 
      CASE s_lv:       loadlv(h2!x); RETURN
 
      CASE s_number:   out2(s_ln, h2!x); ssp := ssp + 1; RETURN
 
      CASE s_string:   out1(s_lstr)
                       outstring(@ h2!x)
                       ssp := ssp + 1
                       RETURN
 
      CASE s_name:     transname(x, s_lp, s_lg, s_ll, s_lf, s_ln)
                       ssp := ssp + 1
                       RETURN
 
      CASE s_valof: $( LET e, rl, cc = dvece, resultlab, casecount
                       casecount := -1 // Disallow CASE & DEFAULT labels
                       resultlab := nextlab()
                       decllabels(h2!x)
                       trans(h2!x, 0)
                       out2(s_lab, resultlab)
                       out2(s_rstack, ssp)
                       ssp := ssp + 1
                       resultlab, casecount := rl, cc
                       undeclare(e)
                       RETURN
                    $)
 
      CASE s_fnap:  $( LET s = ssp
                       ssp := ssp + savespacesize
                       out2(s_stack, ssp)
                       loadlist(h3!x)
                       load(h2!x)
                       out2(s_fnap, s)
                       ssp := s + 1
                       RETURN
                    $)
 
      CASE s_cond:  $( LET l, m = nextlab(), nextlab()
                       LET s = ssp
                       jumpcond(h2!x, FALSE, m)
                       load(h3!x)
                       out2(s_res,l)
                       ssp := s; out2(s_stack, ssp)
                       out2(s_lab, m)
                       load(h4!x)
                       out2(s_res,l)
                       out2(s_lab, l)
                       out2(s_rstack,s)
                       RETURN
                    $)
 
      CASE s_table: $( LET m = nextlab()
                       out2(s_datalab, m)
                       x := h2!x
                       WHILE h1!x=s_comma DO
                       $( out2(s_itemn, evalconst(h2!x))
                          x := h3!x
                       $)
                       out2(s_itemn, evalconst(x))
                       out2(s_lll, m)
                       ssp := ssp + 1
                       RETURN
                    $)
   $)
$)

AND fnbody(x) BE SWITCHON h1!x INTO
$( DEFAULT:         load(x)
                    out1(s_fnrn)
                    ssp := ssp - 1
                    RETURN
                   
   CASE s_valof: $( LET e, rl, cc = dvece, resultlab, casecount
                    casecount := -1 // Disallow CASE & DEFAULT labels
                    resultlab := -1
                    decllabels(h2!x)
                    trans(h2!x, -1)
                    resultlab, casecount := rl, cc
                    undeclare(e)
                    RETURN
                 $)

   CASE s_cond:  $( LET l = nextlab()
                    jumpcond(h2!x, FALSE, l)
                    fnbody(h3!x)
                    out2(s_lab, l)
                    fnbody(h4!x)
                 $)
$)
 
 
AND loadlv(x) BE
$( UNLESS x=0 SWITCHON h1!x INTO
   $( DEFAULT:         ENDCASE
 
      CASE s_name:     transname(x, s_llp, s_llg, s_lll, 0, 0)
                       ssp := ssp + 1
                       RETURN
 
      CASE s_rv:       load(h2!x)
                       RETURN
 
      CASE s_vecap: $( LET a, b = h2!x, h3!x
                       IF h1!a=s_name DO a, b := h3!x, h2!x
                       load(a)
                       load(b)
                       out1(s_plus)
                       ssp := ssp - 1
                       RETURN
                    $)
   $)

  trnerr("Ltype expression needed")
  out2(s_ln, 0)
  ssp := ssp + 1
$)
 
AND loadlist(x) BE UNLESS x=0 TEST h1!x=s_comma
                              THEN $( loadlist(h2!x); loadlist(h3!x) $)
                              ELSE load(x)

LET isconst(x) = VALOF
$( IF x=0 RESULTIS FALSE
 
   SWITCHON h1!x INTO
   $( CASE s_name:
        $( LET c = cellwithname(x)
           RESULTIS h2!c=s_manifest
        $)
 
      CASE s_number:
      CASE s_true:
      CASE s_false:  RESULTIS TRUE
 
      CASE s_neg:
      CASE s_abs:
      CASE s_not:    RESULTIS isconst(h2!x)
       
      CASE s_mult:
      CASE s_div:
      CASE s_rem:
      CASE s_plus:
      CASE s_minus:
      CASE s_lshift:
      CASE s_rshift:
      CASE s_logor:
      CASE s_logand:
      CASE s_eqv:
      CASE s_neqv:   IF isconst(h2!x) & isconst(h3!x) RESULTIS TRUE

      DEFAULT:       RESULTIS FALSE

   $)
$)

LET evalconst(x) = VALOF
$( LET a, b = 0, 0

   IF x=0 DO $( trnerr("Compiler error in Evalconst")
                RESULTIS 0
             $)
 
   SWITCHON h1!x INTO
   $( CASE s_name:
        $( LET c = cellwithname(x)
           IF h2!c=s_manifest RESULTIS h3!c
           trnerr("Variable %s in manifest expression", @h3!x)
           RESULTIS 0
        $)
 
      CASE s_number: RESULTIS h2!x
      CASE s_true:   RESULTIS TRUE
      CASE s_false:  RESULTIS FALSE
      CASE s_query:  RESULTIS 0
 
      CASE s_neg:
      CASE s_abs:
      CASE s_not:    a := evalconst(h2!x)
                     ENDCASE
       
      CASE s_mult:
      CASE s_div:
      CASE s_rem:
      CASE s_plus:
      CASE s_minus:
      CASE s_lshift:
      CASE s_rshift:
      CASE s_logor:
      CASE s_logand:
      CASE s_eqv:
      CASE s_neqv:   a, b := evalconst(h2!x), evalconst(h3!x)
                     ENDCASE

      DEFAULT:
   $)
    
   SWITCHON h1!x INTO
   $( CASE s_neg:    RESULTIS  -  a
      CASE s_abs:    RESULTIS ABS a
      CASE s_not:    RESULTIS NOT a
       
      CASE s_mult:   RESULTIS a   *    b
      CASE s_plus:   RESULTIS a   +    b
      CASE s_minus:  RESULTIS a   -    b
      CASE s_lshift: RESULTIS a   <<   b
      CASE s_rshift: RESULTIS a   >>   b
      CASE s_logor:  RESULTIS a   |    b
      CASE s_logand: RESULTIS a   &    b
      CASE s_eqv:    RESULTIS a  EQV   b
      CASE s_neqv:   RESULTIS a  NEQV  b
      CASE s_div:    UNLESS b=0 RESULTIS a   /    b
      CASE s_rem:    UNLESS b=0 RESULTIS a  REM   b
       
      DEFAULT:
   $)

   trnerr("Error in manifest expression")
   RESULTIS 0
$)

AND assign(x, y) BE
$( IF x=0 | y=0 DO $( trnerr("Compiler error in assign")
                      RETURN
                   $)
   
   UNLESS (h1!x=s_comma)=(h1!y=s_comma) DO
   $( trnerr("Bad simultaneous assignment")
      RETURN
   $)
 
   SWITCHON h1!x INTO
   $( CASE s_comma:  assign(h2!x, h2!y)
                     assign(h3!x, h3!y)
                     RETURN
 
      CASE s_name:   load(y)
                     transname(x, s_sp, s_sg, s_sl, 0, 0)
                     ssp := ssp - 1
                     RETURN
 
      CASE s_byteap: load(y)
                     load(h2!x)
                     load(h3!x)
                     out1(s_putbyte)
                     ssp:=ssp-3
                     RETURN
 
      CASE s_rv:
      CASE s_vecap:  load(y)
                     loadlv(x)
                     out1(s_stind)
                     ssp := ssp - 2
                     RETURN
 
      DEFAULT:       trnerr("Ltype expression needed")
   $)
$)
 
 
AND transname(x, p, g, l, f, n) BE
$( LET c = cellwithname(x)
   LET k, a = h2!c, h3!c
   LET name = @h3!x
 
   SWITCHON k INTO
   $( DEFAULT:        trnerr("Name '%s' not declared", name)
   
      CASE s_global:  out2(g, a); RETURN
 
      CASE s_local:   IF c<dvecp DO
                         trnerr("Dynamic free variable '%s' used", name)
                      out2(p, a); RETURN
 
      CASE s_static:  out2(l, a); RETURN
 
      CASE s_label:   IF f=0 DO
                      $( trnerr("Misuse of entry name '%s'", name)
                         f := p
                      $)
                      out2(f, a); RETURN

      CASE s_manifest:IF n=0 DO
                      $( trnerr("Misuse of MANIFEST name '%s'", name)
                         n := p
                      $)
                      out2(n, a)
  $)
$)
 
AND out1(x) BE $( wrn(x); wrc('*s') $)
 
AND out2(x, y) BE $( out1(x); out1(y) $)
 
AND outstring(s) BE FOR i = 0 TO s%0 DO out1(s%i)
 
AND wrn(n) BE
$( IF n<0 DO $( wrc('-'); n := - n
                IF n<0 DO $( LET ndiv10 = (n>>1)/5
                             wrpn(ndiv10)
                             n:=n-ndiv10*10
                          $)
             $)
   wrpn(n)
$)
 
AND wrpn(n) BE $( IF n>9 DO wrpn(n/10)
                  wrc(n REM 10 + '0')
               $)
 
AND wrc(ch) BE
$( ocount := ocount + 1
   IF ocount>62 & ch='*s' DO ocount, ch := 0, '*n'
   wrch(ch)
$)
 

