SECTION "SYN"

//   SYNHDR
 
GET "libhdr"
 
MANIFEST $(                          // Parse Tree operators

s_number=1; s_name=2; s_string=3; s_true=4; s_false=5
s_valof=6; s_lv=7; s_rv=8; s_vecap=9; s_fnap=10
s_mult=11; s_div=12; s_rem=13
s_plus=14; s_minus=15; s_query=16; s_neg=17; s_abs=19
s_eq=20; s_ne=21; s_ls=22; s_gr=23; s_le=24; s_ge=25
s_byteap = 28
s_not=30; s_lshift=31; s_rshift=32; s_logand=33; s_logor=34
s_eqv=35; s_neqv=36; s_cond=37; s_comma=38; s_table=39
s_and=40; s_valdef=41; s_vecdef=42; s_constdef=43
s_fndef=44; s_rtdef=45; s_needs=48; s_section=49
s_ass=50; s_rtap=51; s_goto=52; s_resultis=53; s_colon=54
s_test=55; s_for=56; s_if=57; s_unless=58
s_while=59; s_until=60; s_repeat=61; s_repeatwhile=62
s_repeatuntil=63
s_loop=65; s_break=66; s_return=67; s_finish=68
s_endcase=69; s_switchon=70; s_case=71; s_default=72
s_seq=73; s_let=74; s_manifest=75; s_global=76; s_static=79
 
// OTHER BASIC SYMBOL CODES
s_be=89; s_end=90; s_lsect=91; s_rsect=92; s_get=93
s_semicolon=97; s_into=98
s_to=99; s_by=100; s_do=101; s_else=102
s_vec=103; s_lparen=105; s_rparen=106
$)
 
GLOBAL $(                    // Globals used in LEX
chbuf:200; decval:201; getstreams:202; charv:203
readnumber:212; rdstrch:213
symb:215; wordnode:216; ch:217
rdtag:218; performget:219
lex:220; dsw:221; declsyswords:222; nlpending:223
lookupword:225; rch:226;
skiptag:230; wrchbuf:231; chcount:232; lineno:233
nulltag:234; rec_p:235; rec_l:236; fin_p:237; fin_l:238
 
// GLOBALS USED IN SYN
rdblockbody:240;  rdsect:241
rnamelist:242; rname:243
rdef:245; rcom:246
rdcdefs:247; nametable:248; nametablesize:249
formtree:250; synerr:251; plist:252
rexplist:255; rdseq:256
list1:261; list2:262; list3:263
list4:264; list5:265; list6:266; list7:267
newvec:268; treep:269; treevec:270
rnexp:271; rexp:272; rbexp:274
errcount:291; errmax:292
sourcestream:293; sysprint:294; ocodeout:295; ocodein:296
gostream: 297; eqcases: 298; prtree: 299
translate:345
savespacesize:382
$)
 
 
MANIFEST $(                         //  Selectors
h1=0; h2=1; h3=2; h4=3; h5=4; h6=5; h7=6

c_backspace =  8
c_tab       =  9
c_newline   = 10
c_newpage   = 12
c_return    = 13
c_escape    = 27
c_space     = 32
$)
 
GLOBAL $(
codegenerate:399

bigender : 550
naming   : 551
debug    : 552
bining   : 553

$)

LET start() = VALOF
$( LET treesize = 30000
   AND argv = VEC 50
   AND argform =
   "FROM/A,TO/K,VER/K,TREE/S,NONAMES/S,D1/S,D2/S,OENDER/S,EQCASES/S"
   LET stdout = output()

   errmax   := 30
   errcount := 0
   fin_p, fin_l := level(), fin

   treevec      := 0
   sourcestream := 0
   ocodeout     := 0
   ocodein      := 0
   gostream     := 0
   
   sysprint := stdout
   selectoutput(sysprint)
 
   writef("*nBCPL (24 November 1995)*n")
 
   IF rdargs(argform, argv, 50)=0 DO $( writes("Bad arguments*n")
                                        errcount := 1
                                        GOTO fin
                                     $)

   prtree        := argv!3
   savespacesize := 3

   // Code generator options 

   bining := TRUE
   naming := TRUE
   debug := 0
   bigender := (!"AAA" & 255) = 'A' // =TRUE if running on a bigender
   IF argv!4 DO naming   := FALSE         // NONAMES
   IF argv!5 DO debug    := debug+1       // D1
   IF argv!6 DO debug    := debug+2       // D2
   IF argv!7 DO bigender := ~bigender     // OENDER
   eqcases := argv!8                      // EQCASES

   sourcestream := findinput(argv!0)      // FROM

   IF sourcestream=0 DO $( writef("Trouble with file %s*n", argv!0)
                           errcount := 1
                           GOTO fin
                        $)

   selectinput(sourcestream)
 
   ocodeout := findoutput("OCODE")

   IF ocodeout=0 DO $( writes("Trouble with file OCODE*n")
                       errcount := 1
                       GOTO fin
                    $)
 
   treevec := getvec(treesize)

   IF treevec=0 DO $( writes("Insufficient memory*n")
                      errcount := 1
                      GOTO fin
                   $)
   
   UNLESS argv!2=0 DO       // VER
   $( sysprint := findoutput(argv!2)
      IF sysprint=0 DO
      $( sysprint := stdout
         writef("Trouble with file %s*n", argv!2)
         errcount := 1
         GOTO fin
      $)
   $)
   
   selectoutput(sysprint)

   $( LET b = VEC 64/bytesperword
      chbuf := b
      FOR i = 0 TO 63 DO chbuf%i := 0
      chcount, lineno := 0, 1
      rch()
 
      UNTIL ch=endstreamch DO
      $( LET tree = ?
         treep := treevec + treesize
 
         tree := formtree()
         IF tree=0 BREAK
 
         writef("*nTree size %n*n", treesize+treevec-treep)
 
         IF prtree DO $( writes("Parse Tree*n")
                         plist(tree, 0, 20)
                         newline()
                      $)
  
         UNLESS errcount=0 GOTO fin
 
         selectoutput(ocodeout)
         translate(tree)
         selectoutput(sysprint)
      $)
   $)
   
   selectinput(sourcestream);  endread();   sourcestream := 0
   selectoutput(ocodeout);     endwrite();  ocodeout := 0

   selectoutput(sysprint)

   UNLESS errcount=0 GOTO fin

   UNLESS argv!1=0 DO                         // TO
   $( ocodein := findinput("OCODE")
      IF ocodein=0 DO
      $( writef("Trouble reading file OCODE*n")
         errcount := 1
         GOTO fin
      $)

      gostream := findoutput(argv!1)
      IF gostream=0 DO
      $( writef("Trouble with code file %s*n", argv!1)
         errcount := 1
         GOTO fin
      $)

      selectinput(ocodein)
      codegenerate(treevec, treesize)

      selectoutput(sysprint)
   $)

fin:
   UNLESS treevec=0       DO freevec(treevec)
   UNLESS sourcestream=0  DO $( selectinput(sourcestream); endread()  $)
   UNLESS ocodeout=0      DO $( selectoutput(ocodeout);    endwrite() $)
   UNLESS ocodein=0       DO $( selectinput(ocodein);      endread()  $)
   UNLESS gostream=0      DO $( selectoutput(gostream)
                                UNLESS gostream=stdout DO  endwrite() $)
   UNLESS sysprint=stdout DO $( selectoutput(sysprint);    endwrite() $)

   selectoutput(stdout)
   RESULTIS errcount=0 -> 0, 20
$)
 
LET lex() BE
$( nlpending := FALSE
 
   $( SWITCHON ch INTO
 
      $( CASE '*p':
         CASE '*n':
               lineno := lineno + 1
               nlpending := TRUE  // IGNORABLE CHARACTERS
         CASE '*t':
         CASE '*s':
               rch() REPEATWHILE ch='*s'
               LOOP

         CASE '0':CASE '1':CASE '2':CASE '3':CASE '4':
         CASE '5':CASE '6':CASE '7':CASE '8':CASE '9':
              symb := s_number
              readnumber(10)
              RETURN
 
         CASE 'a':CASE 'b':CASE 'c':CASE 'd':CASE 'e':
         CASE 'f':CASE 'g':CASE 'h':CASE 'i':CASE 'j':
         CASE 'k':CASE 'l':CASE 'm':CASE 'n':CASE 'o':
         CASE 'p':CASE 'q':CASE 'r':CASE 's':CASE 't':
         CASE 'u':CASE 'v':CASE 'w':CASE 'x':CASE 'y':
         CASE 'z':
         CASE 'A':CASE 'B':CASE 'C':CASE 'D':CASE 'E':
         CASE 'F':CASE 'G':CASE 'H':CASE 'I':CASE 'J':
         CASE 'K':CASE 'L':CASE 'M':CASE 'N':CASE 'O':
         CASE 'P':CASE 'Q':CASE 'R':CASE 'S':CASE 'T':
         CASE 'U':CASE 'V':CASE 'W':CASE 'X':CASE 'Y':
         CASE 'Z':
              symb := lookupword(rdtag(ch))
              IF symb=s_get DO $( performget(); LOOP  $)
              RETURN
 
         CASE '$':
              rch()
              IF ch='$' | ch='<' | ch='>' DO
              $( LET k = ch
                 symb := lookupword(rdtag('<'))
 
                 IF k='>' DO
                 $( IF skiptag=wordnode DO skiptag := 0
                    LOOP
                 $)
 
                 UNLESS skiptag=0 LOOP
 
                 IF k='$' DO
                 $( h1!wordnode := symb=s_true -> s_false, s_true
                    LOOP
                 $)
 
                 // K must be '<'
                 IF symb=s_true LOOP
                 skiptag := wordnode
                 UNTIL skiptag=0 DO lex()
                 RETURN
              $)
 
              UNLESS ch='(' | ch=')' DO synerr("'$' out of context")
              symb := ch='(' -> s_lsect, s_rsect
              lookupword(rdtag('$'))
              RETURN
 
         CASE '{': symb, wordnode := s_lsect, nulltag; BREAK
         CASE '}': symb, wordnode := s_rsect, nulltag; BREAK

         CASE '#':
              symb := s_number
              rch()
              IF '0'<=ch<='7'    DO $(        readnumber(8);  RETURN  $)
              IF ch='b' | ch='B' DO $( rch(); readnumber(2);  RETURN  $)
              IF ch='o' | ch='O' DO $( rch(); readnumber(8);  RETURN  $)
              IF ch='x' | ch='X' DO $( rch(); readnumber(16); RETURN  $)
              synerr("Bad number")
 
         CASE '[':
         CASE '(': symb := s_lparen;    BREAK
         CASE ']':
         CASE ')': symb := s_rparen;    BREAK 
         CASE '?': symb := s_query;     BREAK
         CASE '+': symb := s_plus;      BREAK
         CASE ',': symb := s_comma;     BREAK
         CASE ';': symb := s_semicolon; BREAK
         CASE '@': symb := s_lv;        BREAK
         CASE '&': symb := s_logand;    BREAK
         CASE '|': symb := s_logor;     BREAK
         CASE '=': symb := s_eq;        BREAK
         CASE '!': symb := s_vecap;     BREAK
         CASE '%': symb := s_byteap;    BREAK
         CASE '**':symb := s_mult;      BREAK
 
         CASE '/':
              rch()
              IF ch='\' DO $( symb := s_logand; BREAK $)
              IF ch='/' DO
              $( rch() REPEATUNTIL ch='*n' | ch=endstreamch
                 LOOP
              $)
 
              UNLESS ch='**' DO $( symb := s_div; RETURN  $)
 
              $( rch()
                 IF ch='**' DO
                 $( rch() REPEATWHILE ch='**'
                    IF ch='/' BREAK
                 $)
                 IF ch='*n' DO lineno := lineno+1
                 IF ch=endstreamch DO synerr("'**/' missing")
              $) REPEAT
 
              rch()
              LOOP
 
         CASE '~':
              rch()
              IF ch='=' DO $( symb := s_ne;     BREAK $)
              symb := s_not
              RETURN
 
         CASE '\':
              rch()
              IF ch='/' DO $( symb := s_logor;  BREAK $)
              IF ch='=' DO $( symb := s_ne;     BREAK $)
              symb := s_not
              RETURN
 
         CASE '<': rch()
              IF ch='=' DO $( symb := s_le;     BREAK $)
              IF ch='<' DO $( symb := s_lshift; BREAK $)
              symb := s_ls
              RETURN
 
         CASE '>': rch()
              IF ch='=' DO $( symb := s_ge;     BREAK $)
              IF ch='>' DO $( symb := s_rshift; BREAK $)
              symb := s_gr
              RETURN
 
         CASE '-': rch()
              IF ch='>' DO $( symb := s_cond; BREAK  $)
              symb := s_minus
              RETURN
 
         CASE ':': rch()
              IF ch='=' DO $( symb := s_ass; BREAK  $)
              symb := s_colon
              RETURN
 
         CASE '"':
           $( LET len = 0
              rch()
 
              UNTIL ch='"' DO
              $( IF len=255 DO synerr("Bad string constant")
                 len := len + 1
                 charv%len := rdstrch()
              $)
 
              charv%0 := len
              wordnode := newvec(len/bytesperword+2)
              h1!wordnode := s_string
              FOR i = 0 TO len DO (@h2!wordnode)%i := charv%i
              symb := s_string
              BREAK
           $)
 
         CASE '*'':
              rch()
              decval := rdstrch()
              symb := s_number
              UNLESS ch='*'' DO synerr("Bad character constant")
              BREAK
 
 
         DEFAULT:
              UNLESS ch=endstreamch DO
              $( LET badch = ch
                 ch := '*s'
                 synerr("Illegal character %x2", badch)
              $)

         CASE '.':
              IF getstreams=0 DO $( symb := s_end
                                    IF ch='.' DO rch()
                                    RETURN
                                 $)
              endread()
              ch           := h4!getstreams
              lineno       := h3!getstreams
              sourcestream := h2!getstreams
              getstreams   := h1!getstreams
              selectinput(sourcestream)
              LOOP
      $)
   $) REPEAT
 
   rch()
$)
 
LET lookupword(word) = VALOF
$( LET len, i = word%0, 0
   LET hashval = 19609 // This and 31397 are primes.
   FOR i = 0 TO len DO hashval := (hashval NEQV word%i) * 31397
   hashval := (hashval>>1) REM nametablesize

   wordnode := nametable!hashval
 
   UNTIL wordnode=0 | i>len TEST (@h3!wordnode)%i=word%i
                            THEN i := i+1
                            ELSE wordnode, i := h2!wordnode, 0
 
   IF wordnode=0 DO
   $( wordnode := newvec(len/bytesperword+3)
      h1!wordnode, h2!wordnode := s_name, nametable!hashval
      FOR i = 0 TO len DO (@h3!wordnode)%i := word%i
      nametable!hashval := wordnode
   $)
 
   RESULTIS h1!wordnode
$)
 
AND dsw(word, sym) BE $( lookupword(word); h1!wordnode := sym  $)
 
AND declsyswords() BE
$( dsw("AND", s_and)
   dsw("ABS", s_abs)
   dsw("BE", s_be)
   dsw("BREAK", s_break)
   dsw("BY", s_by)
   dsw("CASE", s_case)
   dsw("DO", s_do)
   dsw("DEFAULT", s_default)
   dsw("EQ", s_eq)
   dsw("EQV", s_eqv)
   dsw("ELSE", s_else)
   dsw("ENDCASE", s_endcase)
   dsw("FALSE", s_false)
   dsw("FOR", s_for)
   dsw("FINISH", s_finish)
   dsw("GOTO", s_goto)
   dsw("GE", s_ge)
   dsw("GR", s_gr)
   dsw("GLOBAL", s_global)
   dsw("GET", s_get)
   dsw("IF", s_if)
   dsw("INTO", s_into)
   dsw("LET", s_let)
   dsw("LV", s_lv)
   dsw("LE", s_le)
   dsw("LS", s_ls)
   dsw("LOGOR", s_logor)
   dsw("LOGAND", s_logand)
   dsw("LOOP", s_loop)
   dsw("LSHIFT", s_lshift)
   dsw("MANIFEST", s_manifest)
   dsw("NE", s_ne)
   dsw("NOT", s_not)
   dsw("NEQV", s_neqv)
   dsw("NEEDS", s_needs)
   dsw("OR", s_else)
   dsw("RESULTIS", s_resultis)
   dsw("RETURN", s_return)
   dsw("REM", s_rem)
   dsw("RSHIFT", s_rshift)
   dsw("RV", s_rv)
   dsw("REPEAT", s_repeat)
   dsw("REPEATWHILE", s_repeatwhile)
   dsw("REPEATUNTIL", s_repeatuntil)
   dsw("SWITCHON", s_switchon)
   dsw("STATIC", s_static)
   dsw("SECTION", s_section)
   dsw("TO", s_to)
   dsw("TEST", s_test)
   dsw("TRUE", s_true)
   dsw("THEN", s_do)
   dsw("TABLE", s_table)
   dsw("UNTIL", s_until)
   dsw("UNLESS", s_unless)
   dsw("VEC", s_vec)
   dsw("VALOF", s_valof)
   dsw("WHILE", s_while)
   dsw("$", 0)
 
   nulltag := wordnode
$) 
 
LET rch() BE
$( ch := rdch()
   chcount := chcount + 1
   chbuf%(chcount&63) := ch
$)
 
AND wrchbuf() BE
$( writes("*n...")
   FOR p = chcount-63 TO chcount DO
   $( LET k = chbuf%(p&63)
      IF 0<k<255 DO wrch(k)
   $)
   newline()
$)
 
 
AND rdtag(ch1) = VALOF
$( LET len = 1
   IF eqcases & 'a'<=ch1<='z' DO ch1 := ch1 + 'A' - 'a'
   charv%1 := ch1
 
   $( rch()
      UNLESS 'a'<=ch<='z' | 'A'<=ch<='Z' |
             '0'<=ch<='9' | ch='.' | ch='_' BREAK
      IF eqcases & 'a'<=ch<='z' DO ch := ch + 'A' - 'a'
      len := len+1
      charv%len := ch
   $) REPEAT
 
   charv%0 := len
   RESULTIS charv
$)
 
 
AND performget() BE
$( LET stream = ?
   lex()
   UNLESS symb=s_string DO synerr("Bad GET directive")
   stream := findinput(charv)
   TEST stream=0
   THEN synerr("Unable to find GET file %s", charv)
   ELSE $( getstreams := list4(getstreams, sourcestream, lineno, ch)
           sourcestream := stream
           selectinput(sourcestream)
           lineno := 1
           rch()
        $)
$)
 
AND readnumber(radix) BE
$( LET d = value(ch)
   decval := d
   IF d>=radix DO synerr("Bad number")
 
   $( rch()
      d := value(ch)
      IF d>=radix RETURN
      decval := radix*decval + d
   $) REPEAT
$)
 
 
AND value(ch) = '0'<=ch<='9' -> ch-'0',
                'A'<=ch<='F' -> ch-'A'+10,
                'a'<=ch<='f' -> ch-'a'+10,
                100
 
AND rdstrch() = VALOF
$( LET k = ch

   IF k='*n' | k='*p' DO
   $( lineno := lineno+1
      synerr("Unescaped newline character")
   $)
 
   IF k='**' DO
   $( rch()
      k := ch
      IF 'a'<=k<='z' DO k := k + 'A' - 'a'
      SWITCHON k INTO
      $( CASE '*n':
         CASE '*p':
         CASE '*s':
         CASE '*t': WHILE ch='*n' | ch='*p' | ch='*s' | ch='*t' DO
                    $( IF ch='*n' | ch='*p' DO lineno := lineno+1
                       rch()
                    $)
                    IF ch='**' DO $( rch(); LOOP  $)

         DEFAULT:   synerr("Bad string or character constant")
         
         CASE '**':
         CASE '*'':
         CASE '"':                    ENDCASE
         
         CASE 'T':  k := c_tab;       ENDCASE
         CASE 'S':  k := c_space;     ENDCASE
         CASE 'N':  k := c_newline;   ENDCASE
         CASE 'E':  k := c_escape;    ENDCASE
         CASE 'B':  k := c_backspace; ENDCASE
         CASE 'P':  k := c_newpage;   ENDCASE
         CASE 'C':  k := c_return;    ENDCASE
         
         CASE 'X':  RESULTIS readoctalorhex(16,2)
         
         CASE '0':CASE '1':CASE '2':CASE '3':CASE '4':
         CASE '5':CASE '6':CASE '7':CASE '8':CASE '9':
                    k:=value(ch)*64+readoctalorhex(8,2)
                    IF k>255 DO 
                       synerr("Bad string or character constant")
                    RESULTIS k
      $)
   $)
   
   rch()
   RESULTIS k
$) REPEAT
 
 
AND readoctalorhex(radix, digits) = VALOF
$( LET answer, dig = 0, ?
   FOR j = 1 TO digits DO
   $( rch()
      dig := value(ch)
      IF dig > radix DO synerr("Bad string or character constant")
      answer:=answer*radix + dig
   $)
   rch()
   RESULTIS answer
$)

LET newvec(n) = VALOF
$( treep := treep - n - 1;
   IF treep<=treevec DO
   $( errmax := 0  // Make it fatal
      synerr("More workspace needed")
   $)
   RESULTIS treep
$)
 
AND list1(x) = VALOF
$( LET p = newvec(0)
   p!0 := x
   RESULTIS p
$)
 
AND list2(x, y) = VALOF
$( LET p = newvec(1)
   p!0, p!1 := x, y
   RESULTIS p
$)
 
AND list3(x, y, z) = VALOF
$( LET p = newvec(2)
   p!0, p!1, p!2 := x, y, z
   RESULTIS p
$)
 
AND list4(x, y, z, t) = VALOF
$( LET p = newvec(3)
   p!0, p!1, p!2, p!3 := x, y, z, t
   RESULTIS p
$)
 
AND list5(x, y, z, t, u) = VALOF
$( LET p = newvec(4)
   p!0, p!1, p!2, p!3, p!4 := x, y, z, t, u
   RESULTIS p
$)
 
AND list6(x, y, z, t, u, v) = VALOF
$( LET p = newvec(5)
   p!0, p!1, p!2, p!3, p!4, p!5 := x, y, z, t, u, v
   RESULTIS p
$)
 
AND list7(x, y, z, t, u, v, w) = VALOF
$( LET p = newvec(6)
   p!0, p!1, p!2, p!3, p!4, p!5, p!6 := x, y, z, t, u, v, w
   RESULTIS p
$)
 
AND formtree() =  VALOF
$( LET res = 0

   nametablesize := 541

   getstreams := 0
   charv      := newvec(256/bytesperword)     
   nametable  := newvec(nametablesize) 
   FOR i = 0 TO nametablesize DO nametable!i := 0
   skiptag := 0
   declsyswords()
 
   rec_p, rec_l := level(), rec
 
   lex()

   IF symb=s_query DO            // For debugging lex.
   $( lex()
      IF symb=s_end RESULTIS 0
      writef("symb =%i3  decval = %i8   charv = %s*n",
              symb,      decval,        charv)
   $) REPEAT

rec:res := symb=s_section -> rprog(s_section),
           symb=s_needs   -> rprog(s_needs), rdblockbody(TRUE)
   UNLESS symb=s_end DO synerr("Incorrect termination")
 
   RESULTIS res
$)
 
AND rprog(thing) = VALOF
$( LET a = 0
   lex()
   a := rbexp()
   UNLESS h1!a=s_string THEN synerr("Bad SECTION or NEEDS name")
   RESULTIS list3(thing, a,
                  symb=s_needs -> rprog(s_needs),rdblockbody(TRUE))
$)
 
 
AND synerr(mess, a) BE
$( errcount := errcount + 1
   writef("*nError near line %n:  ", lineno)
   writef(mess, a)
   wrchbuf()
   IF errcount > errmax DO
   $( writes("*nCompilation aborted*n")
      longjump(fin_p, fin_l)
   $)
   nlpending := FALSE
 
   UNTIL symb=s_lsect | symb=s_rsect |
         symb=s_let | symb=s_and |
         symb=s_end | nlpending DO lex()

   IF symb=s_and DO symb := s_let
   longjump(rec_p, rec_l)
$)
 
LET rdblockbody(outerlevel) = VALOF
$( LET p, l = rec_p, rec_l
   LET a, ln = 0, ?
 
   rec_p, rec_l := level(), recover

recover:  
   IF symb=s_semicolon DO lex()
 
   ln := lineno
   
   SWITCHON symb INTO
   $( CASE s_manifest:
      CASE s_static:
      CASE s_global:
              $(  LET op = symb
                  lex()
                  a := rdsect(rdcdefs, op=s_global->s_colon,s_eq)
                  a := list4(op, a, rdblockbody(outerlevel), ln)
                  ENDCASE
              $)
 
 
      CASE s_let: lex()
                  a := rdef(outerlevel)
                  WHILE symb=s_and DO
                  $( LET ln1 = lineno
                     lex()
                     a := list4(s_and, a, rdef(outerlevel), ln1)
                  $)
                  a := list4(s_let, a, rdblockbody(outerlevel), ln)
                  ENDCASE
 
      DEFAULT:    IF outerlevel DO
                  $( errmax := 0 // Make it fatal.
                     synerr("Bad outer level declaration")
                  $)
                  a := rdseq()
                  UNLESS symb=s_rsect DO synerr("Error in command")
 
      CASE s_rsect:IF outerlevel DO lex()
      CASE s_end:
   $)
 
   rec_p, rec_l := p, l
   RESULTIS a
$)
 
AND rdseq() = VALOF
$( LET a = 0
   IF symb=s_semicolon DO lex()
   a := rcom()
   IF symb=s_rsect | symb=s_end RESULTIS a
   RESULTIS list3(s_seq, a, rdseq())
$)

AND rdcdefs(sep) = VALOF
$( LET res, id = 0, 0
   LET ptr = @res
   LET p, l = rec_p, rec_l
   rec_p, rec_l := level(), recov
 
   $( id := rname()
      UNLESS symb=sep DO synerr("Bad declaration")
      !ptr := list4(s_constdef, 0, id, rnexp(0))
      ptr := @h2!(!ptr)

recov:IF symb=s_semicolon DO lex()
   $) REPEATWHILE symb=s_name
 
   rec_p, rec_l := p, l
   RESULTIS res
$)
 
AND rdsect(r, arg) = VALOF
$( LET tag, res = wordnode, 0
   UNLESS symb=s_lsect DO synerr("'$(' expected")
   lex()
   res := r(arg)
   UNLESS symb=s_rsect DO synerr("'$)' expected")
   TEST tag=wordnode THEN lex()
                     ELSE IF wordnode=nulltag DO
                          $( symb := 0
                             synerr("Untagged '$)' mismatch")
                          $)
   RESULTIS res
$)

AND rnamelist() = VALOF
$( LET a = rname()
   UNLESS symb=s_comma RESULTIS a
   lex()
   RESULTIS list3(s_comma, a, rnamelist())
$)

AND rname() = VALOF
$( LET a = wordnode
   UNLESS symb=s_name DO synerr("Name expected")
   lex()
   RESULTIS a
$)
 
LET rbexp() = VALOF
$( LET a, op = 0, symb
 
   SWITCHON symb INTO
 
   $( DEFAULT: synerr("Error in expression")

      CASE s_query:  lex()
                     RESULTIS list1(s_query)
 
      CASE s_true:
      CASE s_false:
      CASE s_name:
      CASE s_string: a := wordnode
                     lex()
                     RESULTIS a
 
      CASE s_number: a := list2(s_number, decval)
                     lex()
                     RESULTIS a
 
      CASE s_lparen: a := rnexp(0)
                     UNLESS symb=s_rparen DO synerr("')' missing")
                     lex()
                     RESULTIS a
 
      CASE s_valof:  lex()
                     RESULTIS list2(s_valof, rcom())
 
      CASE s_vecap:  op := s_rv
      CASE s_lv:
      CASE s_rv:     RESULTIS list2(op, rnexp(7))
 
      CASE s_plus:   RESULTIS rnexp(5)
 
      CASE s_minus:  a := rnexp(5)
                     TEST h1!a=s_number THEN h2!a := - h2!a
                                        ELSE a := list2(s_neg, a)
                     RESULTIS a
 
      CASE s_abs:    RESULTIS list2(s_abs, rnexp(5))
 
      CASE s_not:    RESULTIS list2(s_not, rnexp(3))
 
      CASE s_table:  lex()
                     RESULTIS list2(s_table, rexplist())
  $)
$)
 
AND rnexp(n) = VALOF $( lex(); RESULTIS rexp(n) $)
 
AND rexp(n) = VALOF
$( LET a, b, p = rbexp(), 0, 0

   UNTIL nlpending DO 
   $( LET op = symb
 
      SWITCHON op INTO
 
      $( DEFAULT:       RESULTIS a
 
         CASE s_lparen: lex()
                        b := 0
                        UNLESS symb=s_rparen DO b := rexplist()
                        UNLESS symb=s_rparen DO synerr("')' missing")
                        lex()
                        a := list4(s_fnap, a, b, 0)
                        LOOP
 
         CASE s_vecap:  p := 8; ENDCASE
         CASE s_byteap: p := 7; ENDCASE
         CASE s_mult:
         CASE s_div:
         CASE s_rem:    p := 6; ENDCASE
         CASE s_plus:
         CASE s_minus:  p := 5; ENDCASE
 
         CASE s_eq:CASE s_le:CASE s_ls:
         CASE s_ne:CASE s_ge:CASE s_gr:
                        IF n>=4 RESULTIS a
                        b := rnexp(4)
                        a := list3(op, a, b)
                        WHILE  s_eq<=symb<=s_ge DO
                        $( LET c = b
                           op := symb
                           b := rnexp(4)
                           a := list3(s_logand, a, list3(op, c, b))
                        $)
                        LOOP
 
         CASE s_lshift:
         CASE s_rshift: IF n>=4 RESULTIS a
                        a := list3(op, a, rnexp(4))
                        LOOP

         CASE s_logand: p := 3; ENDCASE
         CASE s_logor:  p := 2; ENDCASE
         CASE s_eqv:
         CASE s_neqv:   p := 1; ENDCASE
 
         CASE s_cond:   IF n>=1 RESULTIS a
                        b := rnexp(0)
                        UNLESS symb=s_comma DO
                               synerr("Bad conditional expression")
                        a := list4(s_cond, a, b, rnexp(0))
                        LOOP
      $)
      
      IF n>=p RESULTIS a
      a := list3(op, a, rnexp(p))
   $)
   
   RESULTIS a
$)
 
LET rexplist() = VALOF
$( LET res, a = 0, rexp(0)
   LET ptr = @res
 
   WHILE symb=s_comma DO $( !ptr := list3(s_comma, a, 0)
                            ptr := @h3!(!ptr)
                            a := rnexp(0)
                         $)
   !ptr := a
   RESULTIS res
$)
 
LET rdef(outerlevel) = VALOF
$( LET n = rnamelist()
 
   SWITCHON symb INTO
 
   $( CASE s_lparen:
        $( LET a = 0
           lex()
           UNLESS h1!n=s_name DO synerr("Bad formal parameter")
           IF symb=s_name DO a := rnamelist()
           UNLESS symb=s_rparen DO synerr("')' missing")
           lex()
 
           IF symb=s_be DO
           $( lex()
              RESULTIS list5(s_rtdef, n, a, rcom(), 0)
           $)
 
           IF symb=s_eq RESULTIS list5(s_fndef, n, a, rnexp(0), 0)
 
           synerr("Bad procedure heading")
        $)
 
      DEFAULT: synerr("Bad declaration")
 
      CASE s_eq:
           IF outerlevel DO synerr("Bad outer level declaration")
           lex()
           IF symb=s_vec DO
           $( UNLESS h1!n=s_name DO synerr("Name required before = VEC")
              RESULTIS list3(s_vecdef, n, rnexp(0))
           $)
           RESULTIS list3(s_valdef, n, rexplist())
   $)
$)
 
LET rbcom() = VALOF
$( LET a, b, op, ln = 0, 0, symb, lineno
 
   SWITCHON symb INTO
   $( DEFAULT: RESULTIS 0
 
      CASE s_name:CASE s_number:CASE s_string:CASE s_lparen:
      CASE s_true:CASE s_false:CASE s_lv:CASE s_rv:CASE s_vecap:
      CASE s_plus:CASE s_minus:CASE s_abs:CASE s_not:
      CASE s_table:CASE s_valof:CASE s_query:
      // All tokens that can start an expression.
            a := rexplist()
 
            IF symb=s_ass DO
            $( op := symb
               lex()
               RESULTIS list4(op, a, rexplist(), ln)
            $)
 
            IF symb=s_colon DO
            $( UNLESS h1!a=s_name DO synerr("Unexpected ':'")
               lex()
               RESULTIS list5(s_colon, a, rbcom(), 0, ln)
            $)
 
            IF h1!a=s_fnap DO
            $( h1!a, h4!a := s_rtap, ln
               RESULTIS a
            $)
 
            synerr("Error in command")
            RESULTIS a
 
      CASE s_goto:
      CASE s_resultis:
            RESULTIS list3(op, rnexp(0), ln)
 
      CASE s_if:
      CASE s_unless:
      CASE s_while:
      CASE s_until:
            a := rnexp(0)
            IF symb=s_do DO lex()
            RESULTIS list4(op, a, rcom(), ln)
 
      CASE s_test:
            a := rnexp(0)
            IF symb=s_do DO lex()
            b := rcom()
            UNLESS symb=s_else DO synerr("ELSE missing")
            lex()
            RESULTIS list5(s_test, a, b, rcom(), ln)
 
      CASE s_for:
         $( LET i, j, k = 0, 0, 0
            lex()
            a := rname()
            UNLESS symb=s_eq DO synerr("'=' missing")
            i := rnexp(0)
            UNLESS symb=s_to DO synerr("TO missing")
            j := rnexp(0)
            IF symb=s_by DO k := rnexp(0)
            IF symb=s_do DO lex()
            RESULTIS list7(s_for, a, i, j, k, rcom(), ln)
         $)
 
      CASE s_loop:
      CASE s_break:
      CASE s_return:
      CASE s_finish:
      CASE s_endcase:
            lex()
            RESULTIS list2(op, ln)
 
      CASE s_switchon:
            a := rnexp(0)
            UNLESS symb=s_into DO synerr("INTO missing")
            lex()
            RESULTIS list4(s_switchon, a, rdsect(rdseq), ln)
 
      CASE s_case:
            a := rnexp(0)
            UNLESS symb=s_colon DO synerr("Bad CASE label")
            lex()
            RESULTIS list4(s_case, a, rbcom(), ln)
 
      CASE s_default:
            lex()
            UNLESS symb=s_colon DO synerr("Bad DEFAULT label")
            lex()
            RESULTIS list3(s_default, rbcom(), ln)
 
      CASE s_lsect:
            RESULTIS rdsect(rdblockbody, FALSE)
   $)
$)

AND rcom() = VALOF
$( LET a = rbcom()
 
   IF a=0 DO synerr("Error in command")
 
   WHILE symb=s_repeat | symb=s_repeatwhile | symb=s_repeatuntil DO
   $( LET op, ln = symb, lineno
      UNLESS op=s_repeat $( a := list4(op, a, rnexp(0), ln); LOOP $)
      a := list3(op, a, ln)
      lex()
   $)
 
   RESULTIS a
$)
/*
LET plist(x) BE
$( writef("*nName table contents, size = %n*n", nametablesize)
   FOR i = 0 TO nametablesize-1 DO
   $( LET p, n = nametable!i, 0
      UNTIL p=0 DO p, n := p!1, n+1
      writef("%i3:%n", i, n)
      p := nametable!i
      UNTIL p=0 DO $( writef(" %s", p+2); p := p!1  $)
      newline()
   $)
$)
*/
LET plist(x, n, d) BE
$( LET size, ln = 0, 0
   LET v = TABLE 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

   IF x=0 DO $( writes("Nil"); RETURN  $)
 
   SWITCHON h1!x INTO
   $( CASE s_number: writen(h2!x);         RETURN
 
      CASE s_name:   writes(x+2);          RETURN
 
      CASE s_string: writef("*"%s*"",x+1); RETURN
 
      CASE s_for:    size, ln := 6, h7!x;  ENDCASE
 
      CASE s_cond:CASE s_fndef:CASE s_rtdef:CASE s_constdef:
                     size := 4;            ENDCASE
 
      CASE s_test:
                     size, ln := 4, h5!x;  ENDCASE
 
      CASE s_needs:CASE s_section:CASE s_vecap:CASE s_byteap:CASE s_fnap:
      CASE s_mult:CASE s_div:CASE s_rem:CASE s_plus:CASE s_minus:
      CASE s_eq:CASE s_ne:CASE s_ls:CASE s_gr:CASE s_le:CASE s_ge:
      CASE s_lshift:CASE s_rshift:CASE s_logand:CASE s_logor:
      CASE s_eqv:CASE s_neqv:CASE s_comma:
      CASE s_valdef:CASE s_vecdef:
      CASE s_seq:
                     size := 3;            ENDCASE
                     
      CASE s_colon:
                     size, ln := 3, h5!x;  ENDCASE
 
      CASE s_and:
      CASE s_ass:CASE s_rtap:CASE s_if:CASE s_unless:
      CASE s_while:CASE s_until:CASE s_repeatwhile:
      CASE s_repeatuntil:
      CASE s_switchon:CASE s_case:CASE s_let:
      CASE s_manifest:CASE s_static:CASE s_global:
                     size, ln := 3, h4!x;  ENDCASE
 
      CASE s_valof:CASE s_lv:CASE s_rv:CASE s_neg:CASE s_not:
      CASE s_table:CASE s_abs:
                     size := 2;            ENDCASE
 
      CASE s_goto:CASE s_resultis:CASE s_repeat:CASE s_default:
                     size, ln := 2, h3!x;  ENDCASE
 
      CASE s_true:CASE s_false:CASE s_query:
                     size := 1;            ENDCASE
      
      CASE s_loop:CASE s_break:CASE s_return:
      CASE s_finish:CASE s_endcase:
                     size, ln := 1, h2!x;  ENDCASE

      DEFAULT:       size := 1
   $)
 
   IF n=d DO $( writes("Etc"); RETURN $)
 
   writef("Op %n", h1!x)
   IF ln>0 DO writef("  line %n", ln)
   FOR i = 2 TO size DO $( newline()
                           FOR j=0 TO n-1 DO writes( v!j )
                           writes("**-")
                           v!n := i=size->"  ","! "
                           plist(h1!(x+i-1), n+1, d)
                        $)
$)
 
