SECTION "Solit"

GET "libhdr"

GLOBAL $( scorev:150; fn:151  $)

MANIFEST $(
pbits = #77777; hfac = #X10000; vecupb = pbits

p1 = 1<<0;    p2 = 1<<1;    p3 = 1<<2;    p4 = 1<<3;    p5 = 1<<4
p6 = 1<<5;    p7 = 1<<6;    p8 = 1<<7;    p9 = 1<<8;    pa = 1<<9
pb = 1<<10;   pc = 1<<11;   pd = 1<<12;   pe = 1<<13;   pf = 1<<14

h1 = p1*hfac; h2 = p2*hfac; h3 = p3*hfac; h4 = p4*hfac; h5 = p5*hfac
h6 = p6*hfac; h7 = p7*hfac; h8 = p8*hfac; h9 = p9*hfac; ha = pa*hfac
hb = pb*hfac; hc = pc*hfac; hd = pd*hfac; he = pe*hfac; hf = pf*hfac

ph1 = p1+h1;  ph2 = p2+h2;  ph3 = p3+h3;  ph4 = p4+h4;  ph5 = p5+h5
ph6 = p6+h6;  ph7 = p7+h7;  ph8 = p8+h8;  ph9 = p9+h9;  pha = pa+ha
phb = pb+hb;  phc = pc+hc;  phd = pd+hd;  phe = pe+he;  phf = pf+hf

t124=h1+h2+p4; m124=ph1+ph2+ph4; t136=h1+h3+p6; m136=ph1+ph3+ph6
t247=h2+h4+p7; m247=ph2+ph4+ph7; t259=h2+h5+p9; m259=ph2+ph5+ph9
t358=h3+h5+p8; m358=ph3+ph5+ph8; t36a=h3+h6+pa; m36a=ph3+ph6+pha
t421=h4+h2+p1; m421=ph4+ph2+ph1; t456=h4+h5+p6; m456=ph4+ph5+ph6
t47b=h4+h7+pb; m47b=ph4+ph7+phb; t48d=h4+h8+pd; m48d=ph4+ph8+phd
t58c=h5+h8+pc; m58c=ph5+ph8+phc; t59e=h5+h9+pe; m59e=ph5+ph9+phe
t631=h6+h3+p1; m631=ph6+ph3+ph1; t654=h6+h5+p4; m654=ph6+ph5+ph4
t69d=h6+h9+pd; m69d=ph6+ph9+phd; t6af=h6+ha+pf; m6af=ph6+pha+phf
t742=h7+h4+p2; m742=ph7+ph4+ph2; t789=h7+h8+p9; m789=ph7+ph8+ph9
t853=h8+h5+p3; m853=ph8+ph5+ph3; t89a=h8+h9+pa; m89a=ph8+ph9+pha
t952=h9+h5+p2; m952=ph9+ph5+ph2; t987=h9+h8+p7; m987=ph9+ph8+ph7
ta63=ha+h6+p3; ma63=pha+ph6+ph3; ta98=ha+h9+p8; ma98=pha+ph9+ph8
tb74=hb+h7+p4; mb74=phb+ph7+ph4; tbcd=hb+hc+pd; mbcd=phb+phc+phd
tc85=hc+h8+p5; mc85=phc+ph8+ph5; tcde=hc+hd+pe; mcde=phc+phd+phe
td84=hd+h8+p4; md84=phd+ph8+ph4; td96=hd+h9+p6; md96=phd+ph9+ph6
tdcb=hd+hc+pb; mdcb=phd+phc+phb; tdef=hd+he+pf; mdef=phd+phe+phf
te95=he+h9+p5; me95=phe+ph9+ph5; tedc=he+hd+pc; medc=phe+phd+phc
tfa6=hf+ha+p6; mfa6=phf+pha+ph6; tfed=hf+he+pd; mfed=phf+phe+phd

initpos  = h1+p2+p3+p4+p5+p6+p7+p8+p9+pa+pb+pc+pd+pe+pf
$)

LET trypos(pos) = VALOF
$( LET poss = pos & pbits
   LET score = scorev!poss
   IF score<0 DO $( score := 0  // Calculate score for this position.
                    UNTIL poss=0 DO $( LET p = poss & -poss
                                       poss := poss - p
                                       score := score + (fn!p)(pos)
                                    $)
                    // Fill in the score for this position.
                    scorev!(pos&pbits) := score
                 $)
   RESULTIS score
$)

AND trymove(pos, tijk, mijk) = (pos&tijk)=0 -> trypos(pos NEQV mijk), 0

AND f1(pos) = trymove(pos, t124, m124) + trymove(pos, t136, m136)
   
AND f2(pos) = trymove(pos, t247, m247) + trymove(pos, t259, m259)

AND f3(pos) = trymove(pos, t358, m358) + trymove(pos, t36a, m36a)

AND f4(pos) = trymove(pos, t421, m421) + trymove(pos, t456, m456) +
              trymove(pos, t47b, m47b) + trymove(pos, t48d, m48d)

AND f5(pos) = trymove(pos, t58c, m58c) + trymove(pos, t59e, m59e)

AND f6(pos) = trymove(pos, t631, m631) + trymove(pos, t654, m654) +
              trymove(pos, t69d, m69d) + trymove(pos, t6af, m6af)

AND f7(pos) = trymove(pos, t742, m742) + trymove(pos, t789, m789)

AND f8(pos) = trymove(pos, t853, m853) + trymove(pos, t89a, m89a)

AND f9(pos) = trymove(pos, t952, m952) + trymove(pos, t987, m987)

AND fa(pos) = trymove(pos, ta63, ma63) + trymove(pos, ta98, ma98)

AND fb(pos) = trymove(pos, tb74, mb74) + trymove(pos, tbcd, mbcd)

AND fc(pos) = trymove(pos, tc85, mc85) + trymove(pos, tcde, mcde)

AND fd(pos) = trymove(pos, td84, md84) + trymove(pos, td96, md96) +
              trymove(pos, tdcb, mdcb) + trymove(pos, tdef, mdef)

AND fe(pos) = trymove(pos, te95, me95) + trymove(pos, tedc, medc)

AND ff(pos) = trymove(pos, tfa6, mfa6) + trymove(pos, tfed, mfed)

LET start() = VALOF
$( LET v1 = getvec(vecupb)
   LET v2 = getvec(vecupb)

   scorev, fn := v1, v2
   FOR i = 0 TO vecupb DO scorev!i := -1

   fn!p1 := f1; fn!p2 := f2; fn!p3 := f3; fn!p4 := f4; fn!p5 := f5
   fn!p6 := f6; fn!p7 := f7; fn!p8 := f8; fn!p9 := f9; fn!pa := fa
   fn!pb := fb; fn!pc := fc; fn!pd := fd; fn!pe := fe; fn!pf := ff

   scorev!p1 := 1       // Set score for final position
   writef("Number of solutions = %n*n", trypos(initpos))
   
   $( LET k1, k2 = 0, 0
      FOR i = 0 TO vecupb IF scorev!i>=0 DO
      $( k1 := k1+1
         IF scorev!i>0 DO k2 := k2+1
      $)
      writef("%i4 positions reachable from the initial position*n", k1)
      writef("%i4 positions on paths to a solution*n", k2)
   $)
   freevec(v1)
   freevec(v2)
   RESULTIS 0
$)

