/*
This program draws sym-lshift.bmp
*/

GET "libhdr"
GET "plotflow.h"

/*
.--           --.    < y2
|               |
    --------
---| << n<4 |---    < y1
    --------
|               |
.--           --.    < y0 
^  ^            ^
x0 x1           x2
*/

MANIFEST {
  x0 = 0
  x1 = x0 + 20
  x2 = x1 + wl6 + 20

  y0 = 0
  y1 = y0 + catHby2 + 5
  y2 = y1 + catHby2 + 5

  width  = x2+3 & -4
  height = y2 + 5
}

LET drawdiagram() BE
{
  drawtestboxL(y1, x0, x1, x2, "<< n<4")
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("%s: width = %n pixels  height = %n pixels    %5.1d mm*n",
            tofilename, width, height, mmwidth)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

