GET "libhdr"

GET "plotflow.h"

/*
The coords used in b-exp.b


y19
y18            x03---------------------------------------------------x19
y17            |                              x12--[,]--x13          |
        x02    |   x05      x07               |         |            |
y16 x01-(Bexp)-----[nonl]---[n<10      (]---x14-- (E0)----x15--[)]---|
                 x04      x06               |             |    x18   |
y15		 |        |                 x14-----------x15        |
y14		 |        |                   x12-------x13          |
                 |        |                   |         |            |
y13		 |        |-[n<10     #(]----x12--(E0)--x13----------|
y12		 |        |-[n<10      []--------(E10)---------[]]---|
y11		 |        |-[n<9  OF ! %]---------(E9)---------------|
y10		 |        |-[n<8   mulop]---------(E8)---------------|
y09		 |        |-[n<7   addop]---------(E7)---------------|
y08              |        |                x08-[n<6 relop]-x09       !
		 |        |                |       x10     |         |
y07		 |        |-[n<6   relop]--x08----(E6)-----x09-------|
y06		 |        |-[n<5   << >>]---------(E5)---------------|
y05		 |        |-[n<4       &]---------(E4)---------------|
y04		 |        |-[n<3       |]---------(E3)---------------|
y03		 |        |-[n<2 EQV XOR]---------(E2)---------------|
y02		 |        |-[n<1   fcond]----(E0)--[,]--(E0)---------x19
                 |                           x16        x17             
y01		 x05------------------------------------------------->
*/

MANIFEST {
  y00 = 0             // Bottom edge
  y01 = 40            // line arrow
  y02 = y01+hcl+20    // fcond E0 -> E0, E0
  y03 = y02+hcc       // EQV XOR   E1 
  y04 = y03+hcc       // |         E2
  y05 = y04+hcc       // &         E3
  y06 = y05+hcc       // << >>     E5
  y07 = y06+hcc       // E5 below relop
  y08 = y07+htc       // relop
  y09 = y08+htc       // addop   E5
  y10 = y09+hcc       // mulop   E6
  y11 = y10+hcc       // OF ! %    E8
  y12 = y11+hcc       // [ E0 ]    subscription
  y13 = y12+hcc       // #( E0 ,..., E0 )    method call
  y14 = y13+hcc       // ,  above #( E0 )
  y15 = y14+htl       // line
  y16 = y15+hlc       // ( E0 ,..., E0 )    function call
  y17 = y16+hct       // ,  above ( E0 )
  y18 = y17+htl       // line above ,  above ( E0 )
  y19 = y18+30        // top edge


  x01 = 20
  x02 = x01+30           // Bexp
  x03 = x02+wl4+wcl      // first vertical after Bexp
  x04 = x03+wcc+10       // second vertical after Bexp
  x05 = x04+wtl          // start of nonl
  x06 = x05+wl4+wlt      // vertical after nonl
  x07 = x06+wcc          // start of the test boxes
  x08 = x07+wl11+wlt     // Vertical after first [n<5 relop]
  x09 = x08+wcc+wl11+wcc // Vertical after second [n<5 relop]
  x10 = (x08+x09)/2      // middle of second [n<5 relop]

  x12 = x10-wl2/2-wcc    // Vertical left of [,] level y17
  x13 = x10+wl1/2+wcc    // Corner to the right of [,] level y17
  x14 = x12-wcc          // vertical left of x12
  x15 = x13+wcc          // vertical right of x13
  x16 = x10-wl1/2-wct-wl2 // E0 after fcond
  x17 = x10+wl1/2+wct     // First E0 on level y02
  x18 = x15+wcc           // First E0 on level y02
  x19 = x09+wl1+wcc       // Right hand vertical
  x20 = x19+40
  
  width = (x20+3) &-4
  height = y19+20
}

LET drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  rndcorner(1, x03, y18, r)
  rndcorner(0, x19, y18, r)
  moveto(x03+r, y18); drawto(x19-r, y18)
  moveto(x03, y18-r); drawto(x03, y16+r)
  moveto(x19, y18-r); drawto(x19, y02+r)

  rndcorner(1, x12, y17, r)
  rndcorner(0, x13, y17, r)
  drawtestboxC(y17, x12+r, x10, x13-r, ",")
  moveto(x12, y17-r); drawto(x12, y16+r)
  moveto(x13, y17-r); drawto(x13, y16+r)


  drawcatboxL (y16, x01,   x02, x05,   "Bexp")
  drawcatboxL (y16, x05,   x05, x07,   "nonl")
  drawtestboxL(y16, x07,   x07, x12,   "n<10      (")
  drawcatboxC (y16, x12,   x10, x13,   "E0")
  drawtestboxL(y16, x13, x09, x19-r, ")")
  rndcorner(2, x03, y16, r)
  rndcorner(0, x04, y16, r)
  rndcorner(0, x06, y16, r)
  rndcorner(0, x14, y16, r)
  rndcorner(2, x12, y16, r)
  rndcorner(3, x13, y16, r)
  rndcorner(1, x15, y16, r)
  rndcorner(3, x19, y16, r)
  moveto(x04, y16-r); drawto(x04, y01+r)
  moveto(x06, y16-r); drawto(x06, y02+r)
  moveto(x14, y16-r); drawto(x14, y15+r)
  moveto(x15, y16-r); drawto(x15, y15+r)

  moveto(x14+r, y15); drawto(x15-r, y15)
  rndcorner(2, x14, y15, r)
  rndcorner(3, x15, y15, r)

  rndcorner(1, x12, y14, r)
  rndcorner(0, x13, y14, r)
  drawtestboxC(y14, x12+r, x10, x13-r, ",")
  moveto(x12, y14-r); drawto(x12, y13+r)
  moveto(x13, y14-r); drawto(x13, y13+r)

  drawtestboxL(y13, x06+r, x07, x08,   "n<10     #(")
  drawcatboxC (y13, x08, x10, x09, "E0")
  drawtestboxL(y13, x09, x09, x19-r, ")")
  rndcorner(2, x06, y13, r)
  rndcorner(2, x12, y13, r)
  rndcorner(3, x13, y13, r)
  rndcorner(3, x19, y13, r)

  drawtestboxL(y12, x06+r, x07, x08,   "n<10      [")
  drawcatboxC (y12, x08, x10, x09, "E0")
  drawtestboxL(y12, x09, x09, x19-r, "]")
  rndcorner(2, x06, y12, r)
  rndcorner(3, x19, y12, r)

  drawtestboxL(y11, x06+r, x07, x08,   "n<9  OF ! %")
  drawcatboxC (y11, x08, x10, x09, "E9")
  moveto(x09, y11); drawto(x19-r, y11)
  rndcorner(2, x06, y11, r)
  rndcorner(3, x19, y11, r)

  drawtestboxL(y10, x06+r, x07, x08,   "n<8   mulop")
  drawcatboxC (y10, x08, x10, x09, "E8")
  moveto(x09, y10); drawto(x19-r, y10)
  rndcorner(2, x06, y10, r)
  rndcorner(3, x19, y10, r)

  drawtestboxL(y09, x06+r, x07, x08,   "n<7   posop")
  drawcatboxC (y09, x08, x10, x09, "E7")
  moveto(x09, y09); drawto(x19-r, y09)
  rndcorner(2, x06, y09, r)
  rndcorner(3, x19, y09, r)

  drawtestboxC(y08, x08+r, x10, x09-r,   "n<6   relop")
  rndcorner(1, x08, y08, r)
  rndcorner(0, x09, y08, r)
  moveto(x08, y08-r); drawto(x08, y07+r)
  moveto(x09, y08-r); drawto(x09, y07+r)
  
  drawtestboxL(y07, x06+r, x07, x08, "n<6   relop")
  drawcatboxC (y07, x08, x10, x09, "E6")
  moveto(x09, y07); drawto(x19-r, y07)
  rndcorner(2, x06, y07, r)
  rndcorner(2, x08, y07, r)
  rndcorner(3, x09, y07, r)
  rndcorner(3, x19, y07, r)

  drawtestboxL(y06, x06+r, x07, x08,   "n<5   << >>")
  drawcatboxC (y06, x08, x10, x09, "E5")
  moveto(x09, y06); drawto(x19-r, y06)
  rndcorner(2, x06, y06, r)
  rndcorner(3, x19, y06, r)

  drawtestboxL(y05, x06+r, x07, x08,   "n<4       &")
  drawcatboxC (y05, x08, x10, x09, "E4")
  moveto(x09, y05); drawto(x19-r, y05)
  rndcorner(2, x06, y05, r)
  rndcorner(3, x19, y05, r)

  drawtestboxL(y04, x06+r, x07, x08,   "n<3       |")
  drawcatboxC (y04, x08, x10, x09, "E3")
  moveto(x09, y04); drawto(x19-r, y04)
  rndcorner(2, x06, y04, r)
  rndcorner(3, x19, y04, r)

  drawtestboxL(y03, x06+r, x07, x08,   "n<2 EQV XOR")
  drawcatboxC (y03, x08, x10, x09, "E2")
  moveto(x09, y03); drawto(x19-r, y03)
  rndcorner(2, x06, y03, r)
  rndcorner(3, x19, y03, r)

  drawtestboxL(y02, x06+r,    x07,    x08,       "n<1   fcond")
  drawcatboxL (y02, x08,      x16,    x16+wl2,   "E0")
  drawtestboxC(y02, x16+wl2,  x10,    x17,       ",")
  drawcatboxL (y02, x17,      x17,    x19-r,    "E0")
  rndcorner(2, x06, y02, r)
  rndcorner(3, x19, y02, r)



  rndcorner(2, x04, y01, r)
  moveto(x04+r, y01); drawto(x19, y01)

  drawarrow(0, x19, y01, 20)  // Arrow at bottom right
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("%s: width = %n pixels  height = %n pixels    %5.1d mm*n",
            tofilename, width, height, mmwidth)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

