
GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  boxH    = 24*3/2 // Assuming 24x16 font
  boxHby2 = boxH/2

  catH    = 24*2   // Assuming 24x16 font
  catHby2 = catH/2

  bendradius = 15      // Radius of bends
  catradius  = 15      // Radius of cat box round corners

  wl1  =  3*16 +  2*3  // Length of a box containing 1 character 
  wl2  =  4*16 +  3*3  // Length of a box containing 2 characters 
  wl3  =  5*16 +  4*3  // Length of a box containing 3 characters
  wl4  =  6*16 +  5*3  // Length of a box containing 4 characters
  wl5  =  7*16 +  6*3  // Length of a box containing 5 characters
  wl6  =  8*16 +  7*3  // Length of a box containing 6 characters
  wl7  =  9*16 +  8*3  // Length of a box containing 7 characters
  wl8  = 10*16 +  9*3  // Length of a box containing 8 characters
  wl9  = 11*16 + 10*3  // Length of a box containing 8 characters
  wl10 = 12*16 + 11*3  // Length of a box containing 8 characters
  wl11 = 13*16 + 12*3  // Length of a box containing 8 characters
  wl12 = 14*16 + 13*3  // Length of a box containing 8 characters

  fac = 130

  htt  = 50*fac/100    // Vertical distance between test boxes
  htc  = 55*fac/100    // Vertical distance between a test and cat box
  hcc  = 60*fac/100    // Vertical distance between two cat boxes
  
  htl  = 40*fac/100    // Vertical distance between a test box and a line
  hcl  = 40*fac/100    // Vertical distance between a cat box and a line
  hll  = 25*fac/100    // Vertical distance between two horizontal lines
  
  wbb   = 40
  wbv   = 30
  wvb   = 30
  wvv   = 40
  
  x01 = 40
  x01a = x01+30
  x02 = x01a+wvv
  x03 = x02+wbv
  
//  y01  = 50              // ,  fname  E0
 // y02  = y01+htc        // , above fname and E0

//  y03  = y02+htl         // line below VEC

//  y04  = 50            // 

  y04m = 50              // mlist   bottom line of n2prog

  y05  = y04m+htc        // E0 C
  y07  = y05+hcc/2       // LET
  y06  = y07-htl         // line
  y08  = y07+hcc/2       // E0
  y09  = y07+htc         // ,
  y10  = y09+htl         // AND
  
  y15  = y10+htt         // STATIC           
  y16  = y15+hll         // line
  y17  = y15+htt         // MANIFEST
  y17a = y17+htt         // GLOBAL
  y18  = y16+htl         // fname
  y19  = y18+htt         // line above defop
  y20  = y19+htt         // second line above defop
  y21  = y20+htl         // third line above defop
  y22  = y21+htl         // NEEEDS
  y23  = y22+hcc         // line above NEEDS
  y24  = y23+hll         // second line above NEEDS
  y25  = y24+htl         // SECTION
  y26  = y25+hcc         // top line

  xay07 = x03+wl3+wbv    // Vertical after LET
  xpy07 = xay07+wbv+10   // Second vertical after LET    not needed
  xby07 = xpy07+wbv      // name
  xcy07 = xby07+wl5+wbv  // Vertical after name on line y07
  xdy07 = xcy07+wvb      // (
  xey07 = xdy07+wl1+wbv  // Vertical
  xfy07 = xey07+wvv-10   // Vertical
  xgy07 = xfy07+wvb      // fname
  xhy07 = xgy07+wl5+wbv  // Vertical
  xiy07 = xhy07+wvv-10   // Vertical
  xjy07 = xiy07+wvb      // }
  xky07 = xjy07+wl1+wbv  // Vertical
  xly07 = xky07+wvb      // =
  xmy07 = xly07+wl2+wbb  // E0
  xny07 = xmy07+wl2+wvb  // Vertical

  xay04 = xdy07+wl1+wbv  // Vertical after =
  xby04 = xay04+wvb      // VEC
  xcy04 = xby04+wl3+wbv  // Vertical
  xdy04 = xcy04+wbv      // E0

  xay01 = xdy07+wl1+wbv  // Vertical after ,
  xby01 = xay01+wvb      // fname
  xcy01 = xby01+wl5+wbv  // Vertical
  xdy01 = xcy01+wvb      // =
  xey01 = xdy01+wl1+wvb  // Vertical
  xfy01 = xey01+wvb      // E0
  xgy01 = xfy01+wl2+wvb  // Vertical

  xmy18 = xny07+wvv      // second verticalafter }
  xny18 = xmy18+wvb      // ; before eof
  xoy18 = xny18+wl1+wvb  // vertical after ;
  xpy18 = xoy18+wvv      // vertical before eof
  xqy18 = xpy18+wvb      // eof
  xry18 = xqy18+wl3+40   // arrow


  xly18 = xny07          // Vertical after }
  xky18 = xly18-wl1-wbv  // }
  xjy18 = xky18-wbv      // Vertical
  xiy18 = xjy18-wvv      // Vertical
  xhy18 = xiy18-wl1-wbv  // ;
  xgy18 = xhy18-wbv      // Vertical
  xfy18 = xgy18-wvv      // Vertical
  xey18 = xfy18-wl2-wbv  // E0
  xdy18 = xey18-wl5-wbb  // defop
  xcy18 = xdy18-wvb      // Vertical
  xby18 = xcy18-wl5-wbv  // fname
  xay18 = xby18-wvb      // Vertical before name

  xay15 = x03+wl8+wbv    // Vertical after STATIC
  xby15 = xay15+wbv      // {

  width = (xry18+53) & #xFFFC
  height = y26+40

  xay25 = x03+wl7+wbb    // string after SECTION
  xby25 = xay25+wl6+wbv  // vertical after SECTION string
  xcy25 = xby25+wvb      // ; after SECTION string
  xdy25 = xcy25+wl1+wbv  // vertical after SECTION string ;
  xey25 = xdy25+wvv      // second vertical after SECTION string ;

  xay26 = (x01a+xpy18)/2 // centre of top line
}

LET drawtestboxL(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // left justified at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET bx1, by1 = x2,          y-boxHby2
  LET bx2, by2 = x2+boxwidth, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(x2, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstr(x2+fontW+charHsep, y, str)
  // draw the final line
  moveto(x2+boxwidth, y); drawto(x3, y)  
}

AND drawtestboxC(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // centred at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET boxwidthby2 = boxwidth/2
  LET bx1, by1 = x2-boxwidthby2, y-boxHby2
  LET bx2, by2 = x2+boxwidthby2, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxL(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2, y-catHby2
  LET bx2, by2 = x2+catwidth, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2+catwidthby2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxC(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2-catwidthby2, y-catHby2
  LET bx2, by2 = x2+catwidthby2, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(x2+catwidthby2, y); drawto(x3, y)
}

AND drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  drawtestboxC(y26, x01a+r, xay26, xpy18-r, ".")

  drawtestboxL(y25,   x01,    x03, xay25,   "SECTION")
  drawtestboxL(y25, xay25,  xay25, xcy25,   "string")
  drawtestboxL(y25, xcy25,  xcy25, xey25-r, ";")

  drawtestboxL(y22, x02+r,    x03, xay25,   "NEEDS")
  drawtestboxL(y22, xay25,  xay25, xcy25,   "string")
  drawtestboxL(y22, xcy25,  xcy25, xey25-r, ";")


  drawtestboxL(y18, xay18+r, xby18, xdy18,   "fname")
  drawtestboxL(y18, xdy18,   xdy18, xey18,   "defop")
  drawcatboxL (y18, xey18,   xey18, xhy18,   "E0")
  drawtestboxL(y18, xhy18,   xhy18, xky18,   ";")
  drawtestboxL(y18, xky18,   xky18, xny18,   "}")
  drawtestboxL(y18, xny18,   xny18, xqy18,   ";")
  drawtestboxL(y18, xqy18,   xqy18, xry18,   "eof")

  drawtestboxL(y17a, x02+r,    x03, xay15-r, "GLOBAL")
  drawtestboxL(y17,  x02+r,    x03, xay15-r, "MANIFEST")

  drawtestboxL(y15, x02+r,     x03, xby15,   "STATIC")
  drawtestboxL(y15, xby15,   xby15, xiy18-r, "{")

  drawtestboxL(y10, xay07+r, xby07, xny07-r, "AND")

  drawtestboxL(y09, xfy07+r, xgy07+(wl4-wl1)/2, xhy07-r, ",")

  drawtestboxL(y08, xky07+r, xly07,   xmy07, "=")
  drawcatboxL (y08, xmy07,   xmy07, xny07-r, "E0")

  drawtestboxL(y07, x02+r,     x03, xby07,   "LET")
  drawtestboxL(y07, xby07,   xby07, xdy07,   "name")
  drawtestboxL(y07, xdy07,   xdy07, xgy07,   "(")
  drawtestboxL(y07, xgy07,   xgy07, xjy07,   "fname")
  drawtestboxL(y07, xjy07,   xjy07, xky07-r, ")")

  drawtestboxL(y05, xky07+r, xly07,   xmy07, "BE")
  drawcatboxL (y05, xmy07,   xmy07, xny07-r, "C")

  //drawtestboxL(y04, xcy07+r,  xdy07,   xby04, "=")
  //drawcatboxL (y04, xby04,    xby04,   xdy04, "VEC")
  //drawcatboxL (y04, xdy04,    xdy04, xny07-r, "E0")

  //drawtestboxL(y02, xay01+r,  xby01+(wl4-wl1)/2,   xcy01-r, ",")
  //drawtestboxL(y02, xey01+r,  xfy01+(wl2-wl1)/2,   xgy01-r, ",")

  drawcatboxL (y04m, xcy07+r, xdy07, xny07-r, "Mlist")

  //drawtestboxL(y01, xpy07+r,  xby07,   xdy07, "fname")
  //drawtestboxL(y01, xdy07,    xdy07,   xby01, ",")
  //drawtestboxL(y01, xby01,    xby01,   xdy01, "fname")
  //drawtestboxL(y01, xdy01,    xdy01,   xfy01, "=")
  //drawcatboxL (y01, xfy01,    xfy01,   xny07-r, "E0")



  // Draw the vertical lines

  moveto( x01a, y25+r);   drawto( x01a, y26-r)
  moveto(  x02, y25-r);   drawto(  x02, y07+r)
  moveto(xpy18, y26-r);   drawto(xpy18, y18+r)

  moveto(xby25, y25-r);   drawto(xby25, y24+r)
  moveto(xdy25, y25-r);   drawto(xdy25, y24+r)
  moveto(xey25, y25-r);   drawto(xey25, y23+r)

  moveto(xey25, y23-r);   drawto(xey25, y22+r)

  moveto(xby25, y22-r);   drawto(xby25, y21+r)
  moveto(xdy25, y22-r);   drawto(xdy25, y21+r)

  moveto(xay18, y19-r);   drawto(xay18, y18+r)
  moveto(xjy18, y19-r);   drawto(xjy18, y18+r)

  moveto(xcy18, y18-r);   drawto(xcy18, y16+r)
  moveto(xfy18, y18-r);   drawto(xfy18, y16+r)
  moveto(xgy18, y18-r);   drawto(xgy18, y16+r)
  moveto(xiy18, y18-r);   drawto(xiy18, y15+r)
  moveto(xly18, y18-r);   drawto(xly18, y04m+r)
  moveto(xmy18, y18-r);   drawto(xmy18, y16+r)
  moveto(xoy18, y18-r);   drawto(xoy18, y16+r)

  moveto(  x02, y17a-r);  drawto(  x02, y07+r)
  moveto(xay15, y17a-r);  drawto(xay15, y15+r)

  moveto(xay07, y10-r);   drawto(xay07, y07+r)

  moveto(xfy07, y09-r);   drawto(xfy07, y07+r)
  moveto(xhy07, y09-r);   drawto(xhy07, y07+r)

  moveto(xky07, y08-r);   drawto(xky07, y07+r)

  moveto(xcy07, y07-r);   drawto(xcy07, y04m+r)
  moveto(xey07, y07-r);   drawto(xey07, y06+r)
  moveto(xiy07, y07-r);   drawto(xiy07, y06+r)
  moveto(xky07, y07-r);   drawto(xky07, y05+r)


  // Draw the horizontal lines

  moveto(xby25+r, y24); drawto(xdy25-r, y24)
  moveto(x02+r  , y23); drawto(xey25-r, y23)
  moveto(xby25+r, y21); drawto(xdy25-r, y21)

  moveto(x02+r, y20); drawto(xpy18-r, y20)

  moveto(xay18+r, y19); drawto(xjy18-r, y19)
  moveto(xcy18+r, y16); drawto(xfy18-r, y16)
  moveto(xgy18+r, y16); drawto(xiy18-r, y16)
  moveto(xmy18+r, y16); drawto(xoy18-r, y16)
//  moveto(xay18+r, y14); drawto(xjy18-r, y14)
//  moveto(xcy18+r, y12); drawto(xfy18-r, y12)
  moveto(xey07+r, y06); drawto(xiy07-r, y06)
  //moveto(xay04+r, y03); drawto(xcy04-r, y03)

  // Draw the arrow heads
  drawarrow(0, xry18, y18, 20)  // Arrow at bottom right

  // Draw path bends

  rndcorner(1,  x01a, y26, r)  // . above SECTION
  rndcorner(0, xpy18, y26, r)  // . above SECTION

  rndcorner(2,  x01a, y25, r)  // SECTION first vertical
  rndcorner(0,   x02, y25, r)  // SECTION second vertical
  rndcorner(0, xby25, y25, r)  //
  rndcorner(1, xdy25, y25, r)  //
  rndcorner(0, xey25, y25, r)  // SECTION

  rndcorner(2, xby25, y24, r)  // line below NEEDS 
  rndcorner(3, xdy25, y24, r)  // line below NEEDS 

  rndcorner(1,   x02, y23, r)  // line above NEEDS 
  rndcorner(0, xey25, y23, r)  // line above NEEDS 
  rndcorner(3, xey25, y23, r)  // line above NEEDS 

  rndcorner(2,   x02, y22, r)  // NEEDS 
  rndcorner(0, xby25, y22, r)  //
  rndcorner(1, xdy25, y22, r)  //
  rndcorner(3, xey25, y22, r)  // NEEDS 

  rndcorner(2, xby25, y21, r)  // line below NEEDS 
  rndcorner(3, xdy25, y21, r)  // line below NEEDS 

  rndcorner(1,   x02, y20, r)  // second line below NEEDS 
  rndcorner(0, xpy18, y20, r)  // second line below NEEDS 

  rndcorner(1, xay18, y19, r)
  rndcorner(0, xjy18, y19, r)

  rndcorner(2, xay18, y18, r)
  rndcorner(0, xcy18, y18, r)
  rndcorner(1, xfy18, y18, r)
  rndcorner(0, xgy18, y18, r)
  rndcorner(1, xiy18, y18, r)
  rndcorner(3, xjy18, y18, r)
  rndcorner(1, xly18, y18, r)
  rndcorner(0, xmy18, y18, r)
  rndcorner(1, xoy18, y18, r)
  rndcorner(3, xpy18, y18, r)

  rndcorner(2,   x02, y17a, r)  // GLOBAL
  rndcorner(0, xay15, y17a, r)
  rndcorner(2,   x02, y17, r)   //MANIFEST
  rndcorner(0, xay15, y17, r)
  rndcorner(2, xgy18, y16, r)   // line
  rndcorner(3, xiy18, y16, r)   // line
  rndcorner(2, xmy18, y16, r)   // line
  rndcorner(3, xoy18, y16, r)

  rndcorner(2, xcy18, y16, r)
  rndcorner(3, xfy18, y16, r)

  rndcorner(2,   x02, y15, r)
  rndcorner(2, xay15, y15, r)
  rndcorner(3, xiy18, y15, r)

  //rndcorner(1, xay18, y14, r)
  //rndcorner(0, xjy18, y14, r)

  //rndcorner(2, xay18, y13, r)
  //rndcorner(0, xcy18, y13, r)
  //rndcorner(1, xfy18, y13, r)
  //rndcorner(0, xgy18, y13, r)
  //rndcorner(1, xiy18, y13, r)
  //rndcorner(3, xjy18, y13, r)
  //rndcorner(3, xly18, y13, r)

  //rndcorner(2, xcy18, y12, r)
  //rndcorner(3, xfy18, y12, r)

  //rndcorner(2,   x02, y11, r)
  //rndcorner(2, xgy18, y11, r)
  //rndcorner(3, xiy18, y11, r)

  rndcorner(1, xay07, y10, r)
  rndcorner(0, xny07, y10, r)

  rndcorner(1, xfy07, y09, r)
  rndcorner(0, xhy07, y09, r)

  rndcorner(1, xky07, y08, r)
  rndcorner(3, xny07, y08, r)

  rndcorner(2,   x02, y07, r)
  rndcorner(2, xay07, y07, r)
  //rndcorner(0, xpy07, y07, r)    // only in n2decl
  rndcorner(0, xcy07, y07, r)
  rndcorner(0, xey07, y07, r)
  rndcorner(2, xfy07, y07, r)
  rndcorner(3, xhy07, y07, r)
  rndcorner(1, xiy07, y07, r)
  rndcorner(0, xky07, y07, r)
  rndcorner(3, xky07, y07, r)

  rndcorner(2, xey07, y06, r)
  rndcorner(3, xiy07, y06, r)

  rndcorner(2, xky07, y05, r)
  rndcorner(3, xny07, y05, r)

  rndcorner(2, xcy07, y04m, r)  // mlist
  rndcorner(3, xny07, y04m, r)  // mlist

//  rndcorner(2, xcy07, y04, r) // = VEC E0
//  rndcorner(0, xay04, y04, r)
//  rndcorner(1, xcy04, y04, r)
//  rndcorner(3, xny07, y04, r)

//  rndcorner(2, xay04, y03, r)
//  rndcorner(3, xcy04, y03, r)

//  rndcorner(1, xay01, y02, r)
//  rndcorner(0, xcy01, y02, r)
//  rndcorner(1, xey01, y02, r)
//  rndcorner(0, xgy01, y02, r)

//  rndcorner(2, xcy07, y01, r)
//  rndcorner(2, xay01, y01, r)
//  rndcorner(3, xcy01, y01, r)
//  rndcorner(2, xey01, y01, r)
//  rndcorner(3, xgy01, y01, r)
//  rndcorner(3, xny07, y01, r)
//  rndcorner(2, xpy07, y01, r)    // only in n2decl


  writef("width = %n height = %n %5.1d in*n",
          width, height, 10*width / 300 *120/100) // 300 DPI
}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }


  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}


