GET "libhdr"
GET "plotflow.h"

/*
y08  x01
y07          Save space           Procedure arguments
y06         /----^-----\/------------------^------------------\
y05       x02-x04-x06-x08-x10-x12-------------x13 --x15-x16--x18
y04        | P1| L | B | A1| A2|                \ \  |   | An |
y03         x03-x05-x07-x09-x11------------------ x14 -----x17-  x19   x20
             ^                                                   ^ 
y02          |<------------------------------------------------->|
             |                        S 
y01          P
y00
*/

MANIFEST {
  y00 = 10            // bottome edge
  y01 = y00+40        // P
  y02 = y01+60        //        |<------S---->|
  y03 = y02+60        // Low edge of static data
  y04 = y03+cellH/2   // P1 L B A1 A2 ... An
  y05 = y03+cellH     // Upper edge of static data
  y06 = y05+15        // Curly brackets
  y07 = y06+40        // Save spave     Procedure arguments
  y08 = y07+40        // Top edge
  
  x00 = 10            // Left edge
  x01 = x00+20        // 
  x02 = x01+20        // Left end of cells
  x03 = x02+cellW/2   // G arrow
  x04 = x02+cellW
  x05 = x04+cellW/2
  x06 = x04+cellW
  x07 = x06+cellW/2
  x08 = x06+cellW
  x09 = x08+cellW/2
  x10 = x08+cellW
  x11 = x10+cellW/2
  x12 = x10+cellW
  x13 = x12+180
  x14 = x13+zigzagW
  x15 = x14+80
  x16 = x15+cellW
  x17 = x16+cellW/2
  x18 = x16+cellW
  x19 = x18+cellW/2
  x20 = x19+40

  width  = x20+3 & -4
  height = y08
}


LET drawdiagram() BE
{
  drawstrcentred((x02+x08)/2, y07, "Save space")
  drawstrcentred((x08+x18)/2, y07, "Procedure arguments")

  drawcurlyH(x02, y06, x08-x02, 20)
  drawcurlyH(x08, y06, x18-x08, 20)

  moveto(x02, y05); drawto(x13, y05)
  moveto(x14, y05); drawto(x18, y05)

  
  drawstrcentred(x03, y04, "P1")
  drawstrcentred(x05, y04, "L")
  drawstrcentred(x07, y04, "B")
  drawstrcentred(x09, y04, "A1")
  drawstrcentred(x11, y04, "A2")
  drawstrcentred(x17, y04, "An")

  moveto(x02, y03); drawto(x13, y03)
  moveto(x14, y03); drawto(x18, y03)
  strut(x02,  y03)
  strut(x04,  y03)
  strut(x06,  y03)
  strut(x08,  y03)
  strut(x10,  y03)
  strut(x12,  y03)
  zigzag(x13, y03)
  zigzag(x14, y03)
  strut(x15,  y03)
  strut(x16,  y03)
  strut(x18,  y03)
  drawarrow(1, x03, y03-10, 15)
  moveto(x03, y03-15); drawto(x03, y01+15)
  drawstrcentred(x03, y01, "P")
  drawarrow(1, x19, y03-10, 15)
  moveto(x19, y03-15); drawto(x19, y02)

  drawarrow(2, x03+15, y02, 15)
  moveto(x03+15, y02); drawto(x19-15, y02)
  drawstrcentred((x03+x19)/2, y02-20, "S")
  drawarrow(0, x19-15, y02, 15)

}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("*n%s: width = %n pixels  height = %n pixels       width in mms = %5.1d*n*n",
            tofilename, width, height, mmwidth)
    delay(10_000)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

