GET "libhdr"
GET "plotflow.h"

/*
y11  x01
y10                 Global vector                                        Current stack frome
y09         /-------------^-------------\                             /-----------^-----------\
y08       x02-x04-x05-x06-x07-x08 --x10-x11     x14 x15-x16-x17-----x19-x21-x22--------x23----x25
           |   |   |   |   |    \ \  |   |       |   |   |    \ \    |   |   |          \ \    |
y07         x03------------------x09-----         -------------x18----x20-----------------x24--  ^
             ^                                                         ^                         |
y06          |                                                         |<----------------------->|
             |                                                         |           S            x26  x27
y05          G                                                         P
    
y04                      Memory for program and static data
y03       x02--------------x28------x30-x32---------X33-x34-x35-x36-----x38-x40------x41 -------x43
           |                 \ \     |   |           |   |   |    \ \    |   |         \ \       |
y02         ------------------x29-----X31--------------------------x37----x39-----------x42------
y01                                    Li                                  Lj
y00
*/

MANIFEST {
  y00 = 10            // bottome edge
  y01 = y00+40        // Li   Lj
  y02 = y01+30        // Low edge of static data
  y03 = y02+cellH     // Upper edge of static data
  y04 = y03+40        // Memory for program and static data
  y05 = y04+80        // G   P
  y06 = y05+80        //        |<------S---->|
  y07 = y06+30        // Low edge of static data
  y08 = y07+cellH     // Upper edge of static data
  y09 = y08+20        // Curly brackets
  y10 = y09+60        // Global vector      Current stack frame
  y11 = y10+40        // Top edge
  
  x00 = 10            // Left edge
  x01 = x00+20        // Left edge of memory and registers
  x02 = x01+20        // Left end of cells
  x03 = x02+cellW/2   // G arrow
  x04 = x02+cellW
  x05 = x04+40
  x06 = x05+cellW
  x07 = x06+cellW
  x08 = x07+cellW
  x09 = x08+zigzagW
  x10 = x09+30
  x11 = x10+cellW

  x14 = x11+60        // Left end of stack cells
  x15 = x14+cellW
  x16 = x15+cellW
  x17 = x16+cellW
  x18 = x17+zigzagW

  x19 = x18+30        // Left end of current stack cells
  x20 = x19+cellW/2
  x21 = x19+cellW
  x22 = x21+cellW
  x23 = x22+40
  x24 = x23+zigzagW
  x25 = x24+70
  x26 = x25+cellW/2
  x27 = x26+30

  x28 = x07
  x29 = x28+zigzagW
  x30 = x29+30
  x31 = x30+cellW/2
  x32 = x30+cellW

  x33 = x32+40
  x34 = x33+cellW
  x35 = x34+cellW
  x36 = x35+cellW
  x37 = x36+zigzagW
  x38 = x37+30
  x39 = x38+cellW/2
  x40 = x38+cellW
  x41 = x40+40
  x42 = x41+zigzagW
  x43 = x42+70

  width  = x27+3 & -4
  height = y11
}


LET drawdiagram() BE
{ LET r = bendradius
  currpen := penS3

  drawstrcentred((x11+x02)/2, y10, "Global vector")
  drawstrcentred((x19+x25)/2, y10, "Stack frame")

  drawcurlyH(x02, y09, x11-x02, 20)
  drawcurlyH(x19, y09, x25-x19, 20)

  moveto(x02, y08); drawto(x08, y08)
  moveto(x09, y08); drawto(x11, y08)
  moveto(x14, y08); drawto(x17, y08)
  moveto(x18, y08); drawto(x23, y08)
  moveto(x24, y08); drawto(x25, y08)

  moveto(x02, y07); drawto(x08, y07)
  moveto(x09, y07); drawto(x11, y07)
  moveto(x14, y07); drawto(x17, y07)
  moveto(x18, y07); drawto(x23, y07)
  moveto(x24, y07); drawto(x25, y07)

  strut(x02,  y07)
  strut(x04,  y07)
  strut(x05,  y07)
  strut(x06,  y07)
  strut(x07,  y07)
  zigzag(x08, y07)
  zigzag(x09, y07)
  strut(x10,  y07)
  strut(x11,  y07)
  strut(x14,  y07)
  strut(x15,  y07)
  strut(x16,  y07)
  zigzag(x17, y07)
  zigzag(x18, y07)
  strut(x19,  y07)
  strut(x21,  y07)
  zigzag(x23, y07)
  zigzag(x24, y07)
  strut(x25,  y07)
  
  drawarrow(1, x03, y07-10, 15)
  moveto(x03, y07-15); drawto(x03, y05+cellH/2)
  drawarrow(1, x20, y07-10, 15)
  moveto(x20, y07-15); drawto(x20, y05+cellH/2)
  drawarrow(1, x26, y07-15, 15)
  moveto(x26, y07-15); drawto(x26, y05+cellH/2)


  moveto(x20+10, y06); drawto(x26-10, y06)
  drawarrow(2, x20+10, y06, 15)
  drawarrow(0, x26-10, y06, 15)
  drawstrcentred((x20+x26)/2, y06-15, "S")

  drawstrcentred(x03, y05, "G")
  drawstrcentred(x20, y05, "P")

  drawstrcentred((x02+x43)/2, y04, "Memory for program and static data")

  moveto(x02, y03); drawto(x28, y03)
  moveto(x29, y03); drawto(x36, y03)
  moveto(x37, y03); drawto(x41, y03)
  moveto(x42, y03); drawto(x43, y03)

  moveto(x02, y02); drawto(x28, y02)
  moveto(x29, y02); drawto(x36, y02)
  moveto(x37, y02); drawto(x41, y02)
  moveto(x42, y02); drawto(x43, y02)

  strut(x02,  y02)
  zigzag(x28, y02)
  zigzag(x29, y02)
  strut(x30,  y02)
  strut(x32,  y02)
  strut(x33,  y02)
  strut(x34,  y02)
  strut(x35,  y02)
  zigzag(x36, y02)
  zigzag(x37, y02)
  strut(x38,  y02)
  strut(x40,  y02)
  zigzag(x41, y02)
  zigzag(x42, y02)
  strut(x43,  y02)
  
  drawstrcentred(x31, y01, "Li")
  drawstrcentred(x39, y01, "Lj")
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("*n%s: width = %n pixels  height = %n pixels       width in mms = %5.1d*n*n",
            tofilename, width, height, mmwidth)
    delay(10_000)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

