GET "libhdr"

GET "plotflow.h"

/*
y4
y3    ------     -------     ----     ---     -----     --     -----------
y2   ( BCPL )---[LEX|SYN]---(Tree)---[TRN]---(OCODE)---[CG]---(Target code)
y1    ------     -------     ----     ---     -----     --     -----------
y0   x1     x2  x3      x4  x5   x6  x7  x8  x9   x10 x11x12 x13         x14  x15
*/

MANIFEST {
  cellH   = 48
  cellW   = 48
  cellHby2   = cellH/2
  cellWby2   = cellW/2
  cellHby4   = cellH/4
  cellWby4   = cellW/4
  zigzagW    = cellWby2

  y0  = 40                 // Bottom edge
  y1  = y0  + cellHby2
  y2  = y1  + cellHby2     // BCPL ... Target code
  y3  = y2  + cellHby2
  y4  = y3  + 40
}

GLOBAL {
  x0:ug
  x1; x2; x3; x4; x5; x6; x7; x8; x9; x10; x11; x12; x13; x14; x15
  width; height
}

LET setcoords() BE
{ LET rx = 0

  x1 := 40

  rx := wl4/2+5     // (BCPL}
  x2 := x1 + 2*rx
  x3 := x2 + 50
  x4 := x3 + wl7     // [LEX|SYN]
  x5 := x4 + 50

  rx := wl4/2+5     // (Tree}
  x6 := x5 + 2*rx
  x7 := x6 + 50
  x8 := x7 + wl3     // [TRN]
  x9 := x8 + 50

  rx := wl5/2+5     // (Ocode)
  x10 := x9 + 2*rx
  x11 := x10 + 50
  x12 := x11 + wl2   // [CG]
  x13 := x12 + 50

  rx := wl11/2+5    // (Target code)
  x14 := x13 + 2*rx
  x15 := x14 + 50

  width  := x15+3 & -4
  height := y4+20
}

LET strut(x, y) BE
{ LET prevpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby(0, cellH)
  currpen := prevpen
}

AND zigzag(x, y) BE
{ LET prevpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby( cellHby4, cellHby4)
  drawby(-cellHby2, cellHby2)
  drawby( cellHby4, cellHby4)
  currpen := prevpen
}

AND drawdiagram() BE
{ LET r = bendradius
  LET len = 0
  LET rx = 0
  
  currpen := penS3
  selectfont(16)
  charleveloffset := charmidleveloffset


  rx := (x2-x1)/2
  drawellipse(x1+rx, y2, rx, 60)
  drawstrcentred(x1+rx, y2, "BCPL")
  drawtestboxL(y2, x2,  x3,  x5,  "LEX|SYN")

  rx := (x6-x5)/2
  drawellipse(x5+rx, y2, rx, 60)
  drawstrcentred(x5+rx, y2, "Tree")
  drawtestboxL(y2, x6,  x7,  x9,  "TRN")

  rx := (x10-x9)/2
  drawellipse(x9+rx, y2, rx, 60)
  drawstrcentred(x9+rx, y2, "Ocode")
  drawtestboxL(y2, x10, x11, x13, "CG")

  rx := (x14-x13)/2
  drawellipse(x13+rx, y2, rx, 60)
  drawstrcentred(x13+rx, y2, "Target code")
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  setcoords()
  writef("width=%n height=%n*n", width, height)
  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
  

    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("*n%s: width = %n pixels  height = %n pixels       width in mms = %5.1d*n*n",
            tofilename, width, height, mmwidth)
    delay(10_000)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}
