GET "libhdr"

GET "plotflow.h"

/*
y33 x1
y32                                  createco              changeco
y31                                 stack frame          stack frame
y30                           /----------^---------- \/-------^--------\
y29        -------------------------------------------
y28       |                   |                       |
y27       |                   v                       | 
y26     x2|-x4----x7 --------x14---------------------x27--------------------x37 -----x39   x40
y25     |   |   |  \ \      | P2| L2|   | fn| sz| c | P1| L1|   | 0 | c |      \ \     |
y24      -x3----x6--x8 ----x13-x15-x17-x19-x21-x24|x26-x28|x30-x32-x34|x36----- x38----
          ^                                       |       |           |
y22       |   x5------------------------------------------|-----------
y21       |   |                                           |  x31
y20       |   |                                  PC---------> LP5    { c
y19       |   |                                           |   K9G 24   cowait(c)
y18       |   |                                          x29  LP3      fn
y17       |   |                                           |   K6       fn(cowait(c))
y16       |   |                                           |   SP5      c := fn(cowait(c))
y15       x3--x5--x7   -----> coroutine chain              -- J -7   } REPEAT
              |   |   |      x14
              v   |   |
y12         x4--x6|--x10-------------------x21--------x29
y11         |   |   |   | fn| sz| c |        \ \       |
y10          -x5----x9-x11-x13-x15-x17------- x22-------
              ^                  x16
     x1       |                   |
y07  colist --|------------------------- A
y05  currco --|
y03           P
y02         \---------------------v--------------------/
y01        x04             The new coroutine          x29
y00 

*/

MANIFEST {
  cellH   = 48
  cellW   = 48
  cellHby2   = cellH/2
  cellWby2   = cellW/2
  cellHby4   = cellH/4
  cellWby4   = cellW/4
  zigzagW    = cellWby2

  y00 = 5              // Bottom edge
  y01 = 80             // The new coroutine
  y02 = y01+50         // curly bracket
  y03 = y02+cellH      //
  y05 = y03+cellH      // currco
  y07 = y05+cellH      // colist
  y08 = y07+24         //
  y10 = y08+24         // New cortn bottom line
  y11 = y10+24         // fn sz c
  y12 = y11+24         // New cortn top line
  y15 = y12+40         // J -7 
  y16 = y15+32         // SP8
  y17 = y16+32         // K6
  y18 = y17+32         // LP3
  y19 = y18+32         // K9G 24
  y20 = y19+32         // LP6
  y21 = y20+20         // 
  y22 = y21+20         // H line above PC
  y24 = y22+40         // Main coroutine bottom line
  y25 = y24+20         // P2 L2   fn sz c P1 L1  0 c
  y26 = y24+cellH      // Main coroutine top line
  y27 = y26+20         // 
  y28 = y27+20         // 
  y29 = y28+20         // H line above main coroutine
  y30 = y29+32         // Curly brackets
  y31 = y30+cellH      // stack frame   stack frame
  y32 = y31+32         //  createco       changeco
  y33 = y32+50         // Top edge
    
    

  x00 = 10             // Left edge
  x01 = x00+40         //
  x02 = x01+cellW      // Main coroutine
  x03 = x02+cellWby2
  x04 = x03+cellWby2   //
  x05 = x04+cellWby2
  x06 = x05+cellWby2   //
  x07 = x06+cellWby2   // Zigzag 1 L
  x08 = x07++zigzagW   // zigzag 1 R
  x09 = x06+cellW      //
  x10 = x09+cellWby2   //
  x11 = x09+cellW
  x12 = x11+cellWby2  // fn
  x13 = x11+cellW     //
  x14 = x13+cellWby2  // sz
  x15 = x13+cellW     //
  x16 = x15+cellWby2  // c
  x17 = x15+cellW     //
  x18 = x17+cellWby2  //
  x19 = x17+cellW     //
  x20 = x19+cellWby2  // fn
  x21 = x19+cellW     // zigzag L
  x22 = x21+zigzagW   // zigzag R
  x23 = x21+cellWby2  // sz
  x24 = x21+cellW     //
  x25 = x24+cellWby2  // c
  x26 = x24+cellW     //
  x27 = x26+cellWby2  // P1
  x28 = x26+cellW     //
  x29 = x28+cellWby2  // L1
  x30 = x28+cellW     //
  x31 = x30+cellWby2  //
  x32 = x30+cellW     //
  x33 = x32+cellWby2  // 0
  x34 = x32+cellW     //
  x35 = x34+cellWby2  // c
  x36 = x34+cellW     //
  x37 = x36+50        // zigzag L
  x38 = x37+zigzagW   // zigzag R
  x39 = x37+150        //
  x40 = x39+220        // Right edge
  
    
  height = y33
  width = x40+3 & -4
}

LET strut(x, y) BE
{ LET prevpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby(0, cellH)
  currpen := prevpen
}

AND zigzag(x, y) BE
{ LET prevpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby( cellHby4, cellHby4)
  drawby(-cellHby2, cellHby2)
  drawby( cellHby4, cellHby4)
  currpen := prevpen
}

AND drawdiagram() BE
{ LET r = bendradius 
  currpen := penS3
  selectfont(16)
  charleveloffset := charmidleveloffset

  moveto(x04+r, y05); drawto(x05-r, y05) // H line after currco

  drawstrcentred((x13+x26)/2, y32, "createco")
  drawstrcentred((x26+x36)/2, y32, "changeco")
  
  drawstrcentred((x13+x26)/2, y31, "stack frame")
  drawstrcentred((x26+x36)/2, y31, "stack frame")

  drawcurlyH(x13, y30, x26-x13, 20)
  drawcurlyH(x26, y30, x36-x26, 20)

  moveto(x03+r, y29);  drawto(x14-r, y29)
  moveto(x14+r, y29);  drawto(x27-r, y29)
  moveto(x03,  y29-r); drawto(x03,  y26-10)
  moveto(x14,  y29-r); drawto(x14,  y26+10)
  moveto(x27,  y29-r); drawto(x27,  y26-10)
  rndcorner(1, x03, y29, r)
  rndcorner(0, x14, y29, r)
  rndcorner(1, x14, y29, r)
  rndcorner(0, x27, y29, r)

  moveto(x02, y26); drawto(x07, y26)        // Upper edge part 1
  moveto(x08, y26); drawto(x37, y26)        // Upper edge part 2
  moveto(x38, y26); drawto(x39, y26)        // Upper edge part 3
  drawarrow(3, x14, y26+10, r)

  drawstrcentred(x14, y25, "P2")
  drawstrcentred(x16, y25, "L2")
  drawstrcentred(x20, y25, "fn")
  drawstrcentred(x23, y25, "sz")
  drawstrcentred(x25, y25, "c")
  drawstrcentred(x27, y25, "P1")
  drawstrcentred(x29, y25, "L1")
  drawstrcentred(x33, y25, "0")
  drawstrcentred(x35, y25, "c")

  moveto(x02, y24);    drawto(x07, y24)     // Lower edge part 1
  moveto(x08, y24);    drawto(x37, y24)     // Lower edge part 2
  moveto(x38, y24);    drawto(x39, y24)     // Lower edge part 3
  moveto(x03, y24-10); drawto(x03, y15+r)   // V line below (x03,y24)
  moveto(x25, y24+7);  drawto(x25, y22+r)   // V line (x25,y24)
  moveto(x29, y24+7);  drawto(x29, y20+r)   // V line (x29,y24)
  moveto(x35, y24+7);  drawto(x35, y22+r)   // V line (x35,y24)
  strut( x02,  y24);   strut(x02+2, y24)    // Cell boundaries
  strut( x04,  y24)
  strut( x06,  y24)
  zigzag(x07,  y24)   // zigzag 1 L
  zigzag(x08,  y24)   // zigzag 1 R
  strut( x13,  y24)
  strut( x15,  y24)   //
  strut( x17,  y24)
  strut( x19,  y24)
  strut( x21,  y24)
  strut( x24,  y24)
  strut( x26,  y24)
  strut( x28,  y24)
  strut( x30,  y24)
  strut( x32,  y24)   // zigzag 3
  strut( x34,  y24)
  strut( x36,  y24)
  zigzag(x37,  y24)   // zigzag 2 L
  zigzag(x38,  y24)   // zigzag 2 R
  strut( x39,  y24)

  moveto(x05+r, y22); drawto(x35-r, y22)
  rndcorner(1, x05, y22, r)
  moveto(x05,   y22-r); drawto(x05, y12+10)
  rndcorner(3, x25, y22, r)
  rndcorner(3, x35, y22, r)

  drawstr(x25,  y20, "PC")
  moveto(x27, y20); drawto(x31-10, y20)
  moveto(x27, y20); drawto(x31-10, y20)
  drawarrow(0, x31-10, y20, r)
  moveto(x29, y20-r); drawto(x29, y15+r)
  rndcorner(2, x29, y20, r)
  rndcorner(1, x29, y20, r)
  drawstr(x31,  y20, "LP5    { c")
  drawstr(x31,  y19, "K9G 24   cowait(c)")
  drawstr(x31,  y18, "LP3      fn")
  drawstr(x31,  y17, "K6       fn(cowait(c))")
  drawstr(x31,  y16, "SP5      c := fn(cowait(c))")
  drawstr(x31,  y15, "J -7   } REPEAT")
  moveto(x03+r, y15); drawto(x07-r, y15)
  rndcorner(2, x03, y15, r)
  rndcorner(0, x07, y15, r)
  rndcorner(1, x10, y15, r)
  moveto(x10+r, y15); drawto(x14-10, y15)
  drawarrow(0, x14-10, y15, r)
  drawstr(x14, y15, "coroutine chain")
  rndcorner(2, x29, y15, r)
  moveto(x07, y15-r); drawto(x07, y12-10)
  moveto(x10, y15-r); drawto(x10, y12-10)
  moveto(x29+r, y15); drawto(x31-10, y15)

  drawarrow(3, x05, y12+10, r)
  moveto(x04, y12); drawto(x21, y12)        // Upper edge part 1
  moveto(x22, y12); drawto(x29, y12)        // Upper edge part 2

  drawstrcentred(x12, y11, "fn")
  drawstrcentred(x14, y11, "sz")
  drawstrcentred(x16, y11, "c")

  moveto(x04, y10); drawto(x21, y10)        // Lower edge part 1
  moveto(x22, y10); drawto(x29, y10)        // Lower edge part 2
  moveto(x05, y10-10); drawto(x05, y03+20)  // V line above P
  drawarrow(1, x05, y10-10, r)
  moveto(x16, y10+7); drawto(x16, y07+r)   // V line down from (x16,y10)
  strut( x04,  y10); strut(x04+2, y10)
  strut( x06,  y10)
  strut( x09,  y10)
  strut( x11,  y10)
  strut( x11,  y10)
  strut( x13,  y10)
  strut( x15,  y10)
  strut( x17,  y10)
  zigzag(x21,  y10)   // zigzag L
  zigzag(x22,  y10)   // zigzag R
  strut( x29,  y10)
  
  drawstr(x00, y07, "colist")
  moveto(x05+r,y07); drawto(x18-10, y07)
  drawstr(x18, y07, "A")
  rndcorner(3, x05, y07, r)
  rndcorner(2, x05, y07, r)
  rndcorner(3, x16, y07, r)

  drawstr(x00, y05, "currco")
  moveto(x04, y05); drawto(x05-r, y05)
  rndcorner(3, x05, y05, r)

  drawstrcentred(x05, y03, "P")

  drawcurlyH(x04, y02, x29-x04, -20)
  drawstrcentred((x04+x29)/2, y01, "The new coroutine")
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("*n%s: width = %n pixels  height = %n pixels       width in mms = %5.1d*n*n",
            tofilename, width, height, mmwidth)
    delay(10_000)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

