/*
This program draws f3costack.bmp
*/

GET "libhdr"

GET "plotflow.h"


/*
y11
y10                  resumption point
y9     -------------------------------------------
      |                                           |
      |                                           v
y8  x1|-x3--x5--x7--x9-x11-x13-x15------x17 ---x19-x21-x23-----x24--x26--------x28  x29
y7  |   |   |   | fn| sz| c |   |        \ \    | P1| L1|       |    \ \        |
    |   |   |   |   |   |   |   |        / /    |   |   |       |    / /        |
y6   -x2--x4--x6--x8-x10-x12-x14-x16-------x18---------x30-------------x27-------
y5    ^   |   |                                 \-------v-------/       
y4    |   |   |                                     suspended
y3a   |   |   |                                    stack frame
y3    |   |    ---> coroutine chain
y2    |    -------> parent link
y1   cptr           
y0
*/

MANIFEST {
  cellH   = 48
  cellW   = 48
  cellHby2   = cellH/2
  cellWby2   = cellW/2
  cellHby4   = cellH/4
  cellWby4   = cellW/4
  zigzagW    = cellWby2
  radius = 15             // Radius of round corners

 
y0  = 10
y1  = y0  + 10
y2  = y1  + cellHby2
y3  = y2  + cellH
y3a = y3  + cellH
y4  = y3a + cellHby2
y5  = y4  + cellHby2 + 10
y6  = y5  + cellHby2
y7  = y6  + cellHby2
y8  = y7  + cellHby2
y9  = y8  + cellH
y10 = y9  + cellHby2
y11 = y10 + cellH

x0  = 10
x1  = x0  + cellW
x2  = x1  + cellWby2
x3  = x2  + cellWby2
x4  = x3  + cellWby2
x5  = x4  + cellWby2
x6  = x5  + cellWby2
x7  = x6  + cellWby2
x8  = x7  + cellWby2
x9  = x8  + cellWby2
x10 = x9  + cellWby2
x11 = x10 + cellWby2
x12 = x11 + cellWby2
x13 = x12 + cellWby2
x14 = x13 + cellWby2
x15 = x14 + cellWby2
x16 = x15 + cellWby2
x17 = x16 + cellWby2
x18 = x17 + cellWby2
x19 = x18 + cellWby2
x20 = x19 + cellWby2
x21 = x20 + cellWby2
x22 = x21 + cellWby2
x23 = x22 + cellWby2
x24 = x23 + cellW*3
x25 = x24 + cellWby2
x26 = x25 + cellWby2
x27 = x26 + cellWby2
x28 = x27 + cellW*3
x29 = x28 + cellW
x30 = (x19+x24)/2

height = y11
width  = x29 + 3 & -4
}

LET strut(x, y) BE
{ LET prevcurrpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby(0, cellH)
  currpen := prevcurrpen
}

AND zigzag(x, y) BE
{ LET prevcurrpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby( cellHby4, cellHby4)
  drawby(-cellHby2, cellHby2)
  drawby( cellHby4, cellHby4)
  currpen := prevcurrpen
}

AND drawdiagram() BE
{ LET r = bendradius
  
  currpen := penS3

  drawstrcentred((x2+x20)/2, y10, "resumption point")

  moveto(x2+r, y9); drawto(x20-r, y9)     // H Line under resumption
  moveto(x2, y9-r); drawto(x2, y7)        // V Line left of resumption
  moveto(x20, y9-r); drawto(x20, y8+10)   // V Line left of resumption
  drawarrow(3, x20, y8+10, r)
  rndcorner(1, x2,  y9, r)
  rndcorner(0, x20, y9, r)

  moveto(x1,  y8); drawto(x17, y8)        // Upper edge part 1
  moveto(x18, y8); drawto(x26, y8)        // Upper edge part 2
  moveto(x27, y8); drawto(x28, y8)        // Upper edge part 3

  moveto(x4, y7); drawto(x4, y2+r)        // V line for parent link
  moveto(x6, y7); drawto(x6, y3+r)        // V line for coroutine chain
  charleveloffset := charmidleveloffset
  drawstrcentred(x8,  y7, "fn")
  drawstrcentred(x10, y7, "sz")
  drawstrcentred(x12, y7, "c")
  drawstrcentred(x20, y7, "P1")
  drawstrcentred(x22, y7, "L1")

  moveto(x1,  y6); drawto(x17, y6)        // Lower edge part 1
  moveto(x18, y6); drawto(x26, y6)        // Lower edge part 2
  moveto(x27, y6); drawto(x28, y6)        // Lower edge part 3
  drawarrow(1, x2, y6-10, r)
  moveto(x2, y6-10); drawto(x2, y2)       // V line above cptr
  strut(x1,   y6)
  strut(x3,   y6)
  strut(x5,   y6)
  strut(x7,   y6)
  strut(x9,   y6)
  strut(x11,  y6)
  strut(x13,  y6)
  strut(x15,  y6)
  zigzag(x17, y6)
  zigzag(x18, y6)
  strut(x19,  y6)
  strut(x21,  y6)
  strut(x23,  y6)
  strut(x24,  y6)
  zigzag(x26, y6)
  zigzag(x27, y6)
  strut(x28,  y6)

  drawcurlyH(x19, y5, x24-x19, -20)

  drawstrcentred(x30, y4, "suspended")

  drawstrcentred(x30, y3a, "stack frame")
  
  moveto(x6+r,  y3); drawto(x8, y3) 
  drawarrow(0, x8, y3, r)
  drawstr       (x9,  y3, "coroutine chain")
  rndcorner(2, x6, y3, r)

  moveto(x4+r,  y2); drawto(x8, y2)
  drawarrow(0, x8, y2, r)
  drawstr       (x9,  y2, "parent link")
  rndcorner(2, x4, y2, r)

  drawstrcentred(x2,  y1, "cptr")

/*

  currpen := penS3
  //moveto(x201m, y6-r); drawto(x2, y2)
  //rndcorner(1, x01m, y5, r)
  //moveto(x01m+radius, y5); drawto(x10m-radius, y5)   // Top line
  //rndcorner(0, x10m, y5, r)
  //moveto(x10m, y5-radius); drawto(x10m, y4+16)
  //drawarrow(3, x2, y5-20, 20)

  strut(x1,   y6)
  strut(x1+2, y3)    // Cell boundaries
  strut(x3,   y6)
  strut(x5,   y6)
  strut(x7,   y6)
  strut(x9,   y6)
  strut(x11,  y6)
  strut(x13,  y6)
  zigzag(x17, y6)
  zigzag(x18, y6)
  strut(x19,  y6)
  strut(x21,  y6)
  strut(x23,  y6)
  strut(x24,  y6)
  zigzag(x26, y6)
  zigzag(x27, y6)

  currpen := penS3

  strut(x16, y3); strut(x16-2, y3)
//  moveto(x16, y3); drawto(x16, y4)

  moveto(x7, y3); drawto(x7, y2+radius)
  rndcorner(2, x7, y2, radius)
  moveto(x7+radius, y2); drawto(x11, y2)
  drawarrow(0, x11, y2, 20)

  moveto(x4, y8); drawto(x4, y1+radius)
  rndcorner(2, x4, y1, r)
  moveto(x4+radius, y1); drawto(x11, y1)
  drawarrow(0, x9, y2, 20)

  moveto(x2, y6-20); drawto(x2, y2)
  drawarrow(1, x2, y6-20, 20)
  
  drawstr(x10, y3, "coroutine chain")
  drawstr(x10, y2, "parent link")

  charleveloffset := 0
  drawstrcentred(x30, y4, "suspended")
  drawstrcentred(x30, y4, "stack frame")
  drawstrcentred(x2,   y1, "cptr")
*/
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("%s: width = %n pixels  height = %n pixels    %5.1d mm*n",
            tofilename, width, height, mmwidth)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}
