/*
This program draws f3changeco.bmp
*/
GET "libhdr"
GET "plotflow.h"

/* 
y19
y18                                        changeco
y17                                       stack frame
y16                                          x16
y15 //#
y14   currco		             /--------^---------\                  resumption point
y13   x02               x08----------x12                                x26---------------x32
        |                |            |                                  |                 |
        v                v            |                                  |                 v
y12  x01-x03-x04-x05--x07----x09 --x11|----x15-x17-x19-x21-x22 ---x24----|----x28-x29 --x31--x33----x35
y11   |   |   |   \ \  |       \ \  | P1| L1|   | a |   |    \ \   |   |   |   |    \ \  |    \ \    |
y10   -------------z05----------x10-----x14---|-------|-------x23---- x25-x27--------x30-------x34---
                                      ^      x16     x20                 ^
			             x12      v       |                  |
y09                                   |     -----      -----------------x26
y08                                   P    |CHGCO|            cptr
y07                                         -----
                                              ^
			                      |
y06    x02--------------x08-------- -x12      |        ------------------
y05     |                |            |       PC      |                  |
        |  	         v            |               |                  v
y04  x01|x03-x04-x05--x07----x09  -x11|x13-x15-x17-x19-x21-x22 ---x24 --------x28-x29 --x31--x33----x35
y03   |   |   |   \ \  |       \ \  | P1| L1|   | a |   |    \ \   |   |   |   |    \ \  |    \ \    |
y02   -------------x06----------x10------|--------------------x23-----x25-x27------- x30-------x34---
                                        x14                              ^                 ^
                                         |                               |                 |
y01                              PC ----------->                       currco              P
y00

*/

MANIFEST {
  cellH   = 48
  cellW   = 48
  cellHby2   = cellH/2
  cellWby2   = cellW/2
  cellHby4   = cellH/4
  cellWby4   = cellW/4
  zigzagW    = cellWby2

  y00 = 0
  y01 = y00+40         // PC      currco parent link
  y02 = y01+70         // Lower edge 1
  y03 = y02+cellHby2
  y04 = y02+cellH      // Upper edge 1
  y05 = y04+40         // level of PC
  y06 = y04+60         // Middle line
  y07 = y06+50         // P     CHGCO
  y08 = y07+cellHby2
  y09 = y07+cellH      // cprt line
  y10 = y09+80         // Lower edge 2
  y11 = y10+cellHby2
  y12 = y10+cellH      // Upper edge 1
  y13 = y12+60         // resumption line
  y14 = y13+25         // curly bracket
  y15 = y14+20         // curly bracket top
  y16 = y15+10
  y17 = y14+40
  // stack frame
  y18 = y17+35         // changeco
  y19 = y18+30         // top edge
 
  x00 = 20
  x01 = 40            // curroc
  x02 = x01+cellWby2
  x03 = x01+cellW
  x04 = x03+cellW
  x05 = x04+40        // zigzag 1 L
  x06 = x05+zigzagW   // zigzag 1 R
  x07 = x06+30        // calling stack frame
  x08 = x07+cellWby2
  x09 = x07+100       // zigzag 2 L
  x10 = x09+zigzagW   // zigzag 2 R
  x11 = x10+40        // P1   changeco stack frame
  x12 = x11+cellWby2
  x13 = x11+cellW     // L1
  x14 = x13+cellWby2
  x15 = x13+cellW     // pointer to CHGCO
  x16 = x15+cellWby2
  x17 = x15+cellW     // a
  x18 = x17+cellWby2
  x19 = x17+cellW     // cptr
  x20 = x19+cellWby2
  x21 = x19+cellW
  x22 = x21+40        // zigzag 3 L
  x23 = x22+zigzagW   // zigzag 3 R
  x24 = x23+50        // currco
  x25 = x24+20
  x26 = x25+cellWby2
  x27 = x25+cellW
  x28 = x27+cellW     // cptr
  x29 = x28+30
  x30 = x29+zigzagW   // zigzag 4 L
  x31 = x30+30
  x32 = x31+cellWby2
  x33 = x31+50        // P     zigzag 5 L
  x34 = x33+zigzagW   // zigzag 5 R
  x35 = x34+30        // Last strut position
  x36 = x35+30        // right hand edge

  height = y19
  width  = x36 + 3 & -4
}

LET strut(x, y) BE
{ LET prevcurrpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby(0, cellH)
  currpen := prevcurrpen
}

AND zigzag(x, y) BE
{ LET prevcurrpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby( cellHby4, cellHby4)
  drawby(-cellHby2, cellHby2)
  drawby( cellHby4, cellHby4)
  currpen := prevcurrpen
}

LET drawdiagram() BE
{ LET r = bendradius 
  currpen := penS3
  selectfont(16)
  charleveloffset := charmidleveloffset


  drawstrcentred(x16, y18, "changeco")


  drawstrcentred(x16, y17, "stack frame")


  drawstrcentred(x02, y14, "currco")
  drawcurlyH(x11, y14, x21-x11, 20)
  drawstrcentred((x26+x32)/2, y14, "resumption point")  


  moveto(x02,  y13);    drawto(x02,  y12+20)   // V line below currco
  moveto(x08,  y13-r);  drawto(x08,  y12+20)  //
  moveto(x12, y13-r);  drawto(x12, y12-10)
  moveto(x26, y12-10); drawto(x26, y13-r)  //
  moveto(x32, y12+20); drawto(x32, y13-r)  //
  moveto(x08 +r, y13);  drawto(x12-r, y13)
  moveto(x26+r, y13);  drawto(x32-r, y13)
  rndcorner(1, x08,  y13, r)
  rndcorner(0, x12, y13, r)
  rndcorner(1, x26, y13, r)
  rndcorner(0, x32, y13, r)



  moveto(x01, y12); drawto(x05, y12)        // Upper edge part 1
  moveto(x06, y12); drawto(x09, y12)        // Upper edge part 2
  moveto(x10, y12); drawto(x22, y12)        // Upper edge part 3
  moveto(x23, y12); drawto(x24, y12)        // Lower edge part 4
  moveto(x25, y12); drawto(x29, y12)        // Upper edge part 5
  moveto(x30, y12); drawto(x33, y12)        // Lower edge part 6
  moveto(x34, y12); drawto(x35, y12)        // Upper edge part 8
  drawarrow(3, x02, y12+16, r)  // Arrow from currco
  drawarrow(3, x08,  y12+16, r)  // Arrow from P1
  drawarrow(3, x32, y12+16, r)  // Arrow from for resumption point


  moveto(x01, y10); drawto(x05, y10)        // Lower edge part 1
  moveto(x06, y10); drawto(x09, y10)        // Lower edge part 2
  moveto(x10, y10); drawto(x22, y10)        // Lower edge part 3
  moveto(x23, y10); drawto(x24, y10)        // Lower edge part 4
  moveto(x25, y10); drawto(x29, y10)        // Lower edge part 5
  moveto(x30, y10); drawto(x33, y10)        // Lower edge part 6
  moveto(x34, y10); drawto(x35, y10)        // Lower edge part 8
  strut( x01,  y10); strut(x01+2, y10)      // Cell boundaries
  strut( x03,  y10)
  strut( x04,  y10)
  zigzag(x05,  y10)   // zigzag 1
  zigzag(x06,  y10)
  strut( x07,  y10)
  zigzag(x09,  y10)   // zigzag 2
  zigzag(x10,  y10)
  strut( x11,  y10)
  strut( x13,  y10)
  strut( x15,  y10)
  strut( x17,  y10)
  strut( x19,  y10)
  strut( x21,  y10)
  zigzag(x22,  y10)   // zigzag 3
  zigzag(x23,  y10)
  strut( x24,  y10)
  strut( x25,  y10)
  strut( x27,  y10)
  
  strut( x28,  y10)
  zigzag(x29,  y10)   // zigzag 4
  zigzag(x30,  y10)
  strut( x31,  y10)
  zigzag(x33,  y10)   // zigzag 5
  zigzag(x34,  y10)
  strut( x35,  y10)
  strut( x35+2, y10)
  drawarrow(1, x12, y10-16, r)  // Arrow above P
  drawarrow(1, x26, y10-16, r)  // Arrow to cptr coroutine
  moveto(x12, y10-20); drawto(x12, y09)     // above P
  moveto(x16, y10+10); drawto(x16, y09+20)  // above CHGCO
  moveto(x20, y10+10); drawto(x20, y09+r)   // cptr line
  moveto(x26, y10-20); drawto(x26, y09+r)



  drawstrcentred(x12, y11, "P1")
  drawstrcentred(x14, y11, "L1")
  drawstrcentred(x18, y11, "a")



  drawarrow(3, x16, y09+20, r)  // Arrow above CHGCO
  moveto(x20+r, y09); drawto(x26-r, y09)
  moveto(x13+8, y09); drawto(x19-9, y09)
  rndcorner(2, x20, y09, r)
  rndcorner(3, x26, y09, r)


  moveto(x13+8, y07); drawto(x19-8, y07)
  strut( x13+8,  y07)
  strut( x19-8,  y07)
  drawarrow(1, x16, y07-16, r)  // Arrow above PC
  moveto(x16, y05+15); drawto(x16, y07-16) // line beteen PC and chgco
  drawstrcentred(x12, y08, "P")
  drawstrcentred(x16, y08, "CHGCO")
  drawstrcentred((x20+x26)/2, y08, "cptr")
  drawstrcentred(x16, y05, "PC")


  


  moveto(x02+r, y06);   drawto(x08 -r, y06)     // Resumption lines
  moveto(x08 +r, y06);  drawto(x12-r, y06)
  moveto(x20+r, y06);  drawto(x26-r, y06)
  moveto(x08,  y06-r);  drawto(x08,    y04+16)  // resumption to x08 
  moveto(x12, y04-10);  drawto(x12,  y06-r)   // resumption from x12
  moveto(x20, y04-10); drawto(x20,   y06-r)   // resumption from x01
  moveto(x26, y06-r);  drawto(x26,   y04+16)  // resumption to x08 
  moveto(x02,  y04-10); drawto(x02,    y06-r)   // resumption from x01
  rndcorner(1, x02,  y06, r)
  rndcorner(0, x08,  y06, r)
  rndcorner(1, x08,  y06, r)
  rndcorner(0, x12, y06, r)
  rndcorner(1, x20, y06, r)
  rndcorner(0, x26, y06, r)






  moveto(x01, y04); drawto(x05, y04)        // Upper edge part 1
  moveto(x06, y04); drawto(x09, y04)        // Upper edge part 2
  moveto(x10, y04); drawto(x22, y04)        // Upper edge part 3
  moveto(x23, y04); drawto(x24, y04)        // Lower edge part 4
  moveto(x25, y04); drawto(x29, y04)        // Upper edge part 5
  moveto(x30, y04); drawto(x33, y04)        // Lower edge part 6
  moveto(x34, y04); drawto(x35, y04)        // Upper edge part 8
  drawarrow(3, x08,  y04+16, r)  // Arrow resumption point
  drawarrow(3, x26, y04+16, r)  // Arrow currco

  
  moveto(x01, y02); drawto(x05, y02)        // Lower edge part 1
  moveto(x06, y02); drawto(x09, y02)        // Lower edge part 2
  moveto(x10, y02); drawto(x22, y02)        // Lower edge part 3
  moveto(x23, y02); drawto(x24, y02)        // Lower edge part 4
  moveto(x25, y02); drawto(x29, y02)        // Lower edge part 5
  moveto(x30, y02); drawto(x33, y02)        // Lower edge part 6
  moveto(x34, y02); drawto(x35, y02)        // Lower edge part 8
  strut( x01,   y02)
  strut(x01+2,  y02)   // Cell boundaries
  strut( x03,   y02
  )
  strut( x04,   y02)
  zigzag(x05,   y02)   // zigzag 1
  zigzag(x06,   y02)
  strut( x07,   y02)
  zigzag(x09,   y02)   // zigzag 2
  zigzag(x10,   y02)
  strut( x11,   y02)
  strut( x13,   y02)
  strut( x15,   y02)
  strut( x17,   y02)
  strut( x19,   y02)
  strut( x21,   y02)
  zigzag(x22,   y02)   // zigzag 3
  zigzag(x23,   y02)
  strut( x24,   y02)
  strut( x25,   y02)
  strut( x27,   y02)
  strut( x28,   y02)
  zigzag(x29,   y02)   // zigzag 4
  zigzag(x30,   y02)
  strut( x31,   y02)
  zigzag(x33,   y02)   // zigzag 5
  zigzag(x34,   y02)
  strut( x35,   y02)
  strut( x35+2, y02)
  drawarrow(1, x26, y02-20, r)                  // Arrow above currco
  drawarrow(1, x32, y02-16, r)                  // Arrow above P
  moveto(x14, y02+8);  drawto(x14, y01+r)       // vertical line below L1
  moveto(x26, y02-16); drawto(x26, y01+16)      // vertical line above currco
  moveto(x32, y02-16); drawto(x32, y01+16)      // vertical line above P
  drawstrcentred(x12, y03, "P1")
  drawstrcentred(x14, y03, "L1")
  drawstrcentred(x18, y03, "a")

  

  drawstr(x10,  y01, "PC")             // PC on the bottom line
  moveto(x11+8, y01); drawto(x17, y01) // line between PC arrow
  drawarrow(0, x17,  y01, r)           // The arrow on the bottom line
  rndcorner(2, x14, y01, r)           // The corner on the bottom line below L1
  drawstrcentred(x26, y01, "currco")  // currco on the bottom line
  drawstrcentred(x32, y01, "P")       // P on the bottom line
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("*n%s: width = %n pixels  height = %n pixels       width in mms = %5.1d*n*n",
            tofilename, width, height, mmwidth)
    delay(10_000)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

