GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  boxH    = 24*3/2 // Assuming 24x16 font
  boxHby2 = boxH/2

  catH    = 24*2   // Assuming 24x16 font
  catHby2 = catH/2

  bendradius = 15      // Radius of bends
  catradius  = 15      // Radius of cat box round corners

  dl1  =  3*16 +  2*3  // Length of a box containing 1 character 
  dl2  =  4*16 +  3*3  // Length of a box containing 2 characters 
  dl3  =  5*16 +  4*3  // Length of a box containing 3 characters
  dl4  =  6*16 +  5*3  // Length of a box containing 4 characters
  dl5  =  7*16 +  6*3  // Length of a box containing 5 characters
  dl6  =  8*16 +  7*3  // Length of a box containing 6 characters
  dl7  =  9*16 +  8*3  // Length of a box containing 7 characters
  dl8  = 10*16 +  9*3  // Length of a box containing 8 characters
  dl9  = 11*16 + 10*3  // Length of a box containing 8 characters
  dl10 = 12*16 + 11*3  // Length of a box containing 8 characters
  dl11 = 13*16 + 12*3  // Length of a box containing 8 characters
  dl12 = 14*16 + 13*3  // Length of a box containing 8 characters

  fac = 130

  dtt  = 50*fac/100    // Vertical distance between test boxes
  dtc  = 55*fac/100    // Vertical distance between a test and cat box
  dcc  = 60*fac/100    // Vertical distance between two cat boxes
  
  dtl  = 40*fac/100    // Vertical distance between a test box and a line
  dcl  = 40*fac/100    // Vertical distance between a cat box and a line
  dll  = 25*fac/100
  
  wbb   = 40
  wbv   = 30
  wvb   = 30
  wvv   = 45
  
  dw1 =  80
  dw2 = 100
  dw3 = 150
  
  x01 = 10
  x02 = x01+40         // Left virtical line
  x03 = x02+40         // Monadic ops
  x04 = x03+80         // Colons
  x05 = x04+70         // Verticals before E7 and E8
  x06 = x03+180        // E0 after (
  x07 = x05+100        // Operands, eg E7 and E8
  x08 = x07+80         // Verticals after E0 in eg TABLE
  x09 = x08+150        // Vertical at end of bexp
  x10 = x09+100        // Vertical before dyadic ops
  x11 = x10+50         // Dyadic ops
  x12 = x11+230        // Vertical after dyadic ops
  x13 = x12+80         // E0 after ->
  x14 = x13+50         // Position to the right of E0
  x15 = x12+dw3        // Operands of eg << and &
  x16 = x15+dw3        // Categories such as E8 and E6
  x17 = x15+200        // Second E0 after ->
  x18 = x17+100        // Right hand vertical line
    
  width = x18+30

//  dtt  = 55      // Vertical distance between test boxes
//  dtc  = 65      // Vertical distance between a test and cat box
//  dcc  = 70      // Vertical distance between two cat boxes
  
//  dtl  = 50      // Vertical distance between a test box and a line
//  dcl  = 55      // Vertical distance between a cat box and a line
//  dclc = 75      // Vertical distance between a two cat boxes and a line
  
  y01 = 20             // Bottom line
  y02 = y01+dcl         // ->
  y03 = y02+dtt         // XOR
  y04 = y03+dtt        // EQV
  y05 = y04+dcc         // |
  y06 = y05+dcc         // &
  y07 = y06+dtt         // >>
  y08 = y07+dtt         // <<
  y09 = y08+dcc         // E4 below relops
  y10 = y09+dtc         // >=
  y11 = y10+dtt         // <=
  y12 = y11+dtt         // >
  y13 = y12+dtt         // <
  y14 = y13+dtt         // ~=
  y15 = y14+dtt         // =
  y16 = y15+dtt         // -
  y17 = y16+dtt         // +
  y18 = y17+dtt         // MOD
  y19 = y18+dtt         // /
  y20 = y19+dtt         // *
  y21 = y20+dtt         // OF
  y22 = y21+dtt         // %
  y23 = y22+dtt         // !
  y24 = y23+dcl        // Horizontal line below (
  y25 = y24+dcl        // (
  y26 = y25+dtc         // Comma box above (
  y27 = y26+dtl         // Top line
  
  height = y27+10


  c23 = y25          // TRUE, level with ( 
  c22 = c23-dtt       // FALSE
  c21 = c22-dtt       // ?
  c20 = c21-dtt       // name
  c19 = c20-dtt       // number
  c18 = c19-dtt       // character
  c17 = c18-dtt       // string
  c16 = c17-dtc       // (
  c15 = c16-dtc       // !
  c14 = c15-dtt       // @
  c13 = c14-dtt       // +
  c12 = c13-dtt       // -
  c11 = c12-dtt       // ABS
  c10 = c11-dtt       // NOT
  c09 = c10-dtc       // Comma above TALBLE
  c08 = c09-dtc       // TABLE
  c07 = c08-dcc       // VALOF
  c06 = c07-dcc       // SLCT
  c05 = c06-dcl      // Line after SLCT
  c04 = c05-dcl      // First colon
  c03 = c04-dcl      // Line between colons
  c02 = c03-dcl      // Second colon
  c01 = c02-dcl      // Bottom line
}

LET drawtestboxL(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // left justified at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET bx1, by1 = x2,          y-boxHby2
  LET bx2, by2 = x2+boxwidth, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(x2, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstr(x2+fontW+charHsep, y, str)
  // draw the final line
  moveto(x2+boxwidth, y); drawto(x3, y)  
}

AND drawtestboxC(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // centred at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET boxwidthby2 = boxwidth/2
  LET bx1, by1 = x2-boxwidthby2, y-boxHby2
  LET bx2, by2 = x2+boxwidthby2, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxC(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2-catwidthby2, y-catHby2
  LET bx2, by2 = x2+catwidthby2, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(x2+catwidthby2, y); drawto(x3, y)
  
}

AND drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  drawtestboxL(c23, x01,   x03, x09,   "TRUE")
  drawtestboxL(c22, x02+r, x03, x09-r, "FALSE")
  drawtestboxL(c21, x02+r, x03, x09-r, "?")
  drawtestboxL(c20, x02+r, x03, x09-r, "name")
  drawtestboxL(c19, x02+r, x03, x09-r, "number")
  drawtestboxL(c18, x02+r, x03, x09-r, "character")
  drawtestboxL(c17, x02+r, x03, x09-r, "string")
  drawtestboxL(c16, x02+r, x03, x05,   "(")
  drawcatboxC (c16, x05,   x06, x07,   "E0")
  drawtestboxL(c16, x07,   x08, x09-r, ")")

  drawtestboxL(c15, x02+r, x03, x05,   "!")
  drawcatboxC (c15, x05,   x07, x09-r, "E7")
  drawtestboxL(c14, x02+r, x03, x05-r, "@")

  drawtestboxL(c13, x02+r, x03, x05,   "+")
  drawcatboxC (c13, x05,   x07, x09-r, "E5")
  drawtestboxL(c12, x02+r, x03, x05-r, "-")
  drawtestboxL(c11, x02+r, x03, x05-r, "ABS")

  drawtestboxL(c10, x02+r, x03, x05, "NOT")
  drawcatboxC (c10, x05, x07, x09-r, "E5")

  drawtestboxC(c09, x07-dw1+r, x07, x07+dw1-r, ",")
  
  drawtestboxL(c08, x02+r, x03, x05, "TABLE")
  drawcatboxC (c08, x05, x07, x09-r, "E0")

  drawtestboxL(c07, x02+r, x03, x05, "VALOF")
  drawcatboxC (c07, x05, x07, x09-r, "C")

  drawtestboxL(c06, x02+r, x03, x05, "SLCT")
  drawcatboxC (c06, x05, x07, x08-r, "E0")

  drawtestboxL(c04, x03+r, x04, x05, ":")
  drawcatboxC (c04, x05, x07, x08-r, "E0")

  drawtestboxL(c02, x03+r, x04, x05, ":")
  drawcatboxC (c02, x05, x07, x09-r, "E0")



  drawtestboxC(y26, x15-dw1+r, x15, x15+dw1-r,   ",")
  
  drawtestboxL(y25, x09,   x11, x12,   "(   n<9")

  drawcatboxC (y25, x12,   x15, x16,   "E0")
  drawtestboxL(y25, x16,   x17, x18-r, ")")
  
  drawtestboxL(y23, x10+r, x11, x12,   "!   n<8")
  drawcatboxC (y23, x12,   x15, x18-r, "E8")
  drawtestboxL(y22, x10+r, x11, x12-r, "%   n<8")
  drawtestboxL(y21, x10+r, x11, x12-r, "OF  n<8")
  
  drawtestboxL(y20, x10+r, x11, x12,   "**   n<6")
  drawcatboxC (y20, x12,   x15, x18-r, "E6")
  drawtestboxL(y19, x10+r, x11, x12-r, "/    n<6")
  drawtestboxL(y18, x10+r, x11, x12-r, "MOD n<6")
  
  drawtestboxL(y17, x10+r, x11, x12,   "+   n<5")
  drawcatboxC (y17, x12,   x15, x18-r, "E5")
  drawtestboxL(y16, x10+r, x11, x12-r, "-   n<5")

  drawtestboxL(y15, x10+r, x11, x12-r, "=   n<5")
  drawtestboxC(y15, x12+r, x15, x16-r, "=   n<5")

  drawtestboxL(y14, x10+r, x11, x12-r, "~=  n<5")
  drawtestboxC(y14, x12+r, x15, x16-r, "~=  n<5")

  drawtestboxL(y13, x10+r, x11, x12-r, "<   n<5")
  drawtestboxC(y13, x12+r, x15, x16-r, "<   n<5")

  drawtestboxL(y12, x10+r, x11, x12-r, ">   n<5")
  drawtestboxC(y12, x12+r, x15, x16-r, ">   n<5")

  drawtestboxL(y11, x10+r, x11, x12-r, "<=  n<5")
  drawtestboxC(y11, x12+r, x15, x16-r, "<=  n<5")

  drawtestboxL(y10, x10+r, x11, x12-r, ">=  n<5")
  drawtestboxC(y10, x12+r, x15, x16-r, ">=  n<5")

  drawcatboxC (y09, x12+r, x15, x18-r, "E4")

  drawtestboxL(y08, x10+r, x11, x12,   "<<  n<4")
  drawcatboxC (y08, x12,   x15, x18-r, "E4")
  drawtestboxL(y07, x10+r, x11, x12-r, ">>  n<4")

  drawtestboxL(y06, x10+r, x11, x12,   "&   n<3")
  drawcatboxC (y06, x12,   x15, x18-r, "E3")

  drawtestboxL(y05, x10+r, x11, x12,   "|   n<2")
  drawcatboxC (y05, x12,   x15, x18-r, "E2")

  drawtestboxL(y04, x10+r, x11, x12,   "EQV n<1")
  drawcatboxC (y04, x12,   x15, x18-r, "E1")
  drawtestboxL(y03, x10+r, x11, x12-r, "XOR n<4")

  drawtestboxL(y02, x10+r, x11, x12,   "->  n<1")
  drawcatboxC(y02, x12, x13, x14, "E0")
  drawtestboxC(y02, x14, (x13+x17)/2, x16, ".")
  drawcatboxC(y02, x16, x17, x18-r, "E0")

  
  // Draw the vertical lines
  moveto(x02, c06+r); drawto(x02, c23-r)
  moveto(x03, c01+r); drawto(x03, c05-r)
  moveto(x09, c01+r); drawto(x09, c23-r)
  moveto(x05, c14+r); drawto(x05, c15-r)
  moveto(x05, c11+r); drawto(x05, c13-r)
  moveto(x07-dw1, c08+r); drawto(x07-dw1, c09-r)
  moveto(x07+dw1, c08+r); drawto(x07+dw1, c09-r)
  moveto(x07+dw1, c05+r); drawto(x07+dw1, c06-r)
  moveto(x07+dw1, c03+r); drawto(x07+dw1, c04-r)
  
  moveto(x15-dw1, y25+r); drawto(x15-dw1, y26-r)
  moveto(x15+dw1, y25+r); drawto(x15+dw1, y26-r)
  moveto(x15-dw2, y24+r); drawto(x15-dw2, y25-r)
  moveto(x15+dw2, y24+r); drawto(x15+dw2, y25-r)
  moveto(x12, y21+r); drawto(x12, y23-r)
  moveto(x12, y18+r); drawto(x12, y20-r)
  moveto(x12, y16+r); drawto(x12, y17-r)
  moveto(x12, y09+r); drawto(x12, y15-r)
  moveto(x16, y09+r); drawto(x16, y15-r)
  moveto(x12, y07+r); drawto(x12, y08-r)
  moveto(x12, y03+r); drawto(x12, y04-r)

  
  moveto(x09, y25+r); drawto(x09, y27-r)

  moveto(x10, y01+r); drawto(x10, y25-r)
  moveto(x18, y02+r); drawto(x18, y27-r)
  
  // Draw the horizontal lines
  
  moveto(x03+r, c05); drawto(x08-r, c05)
  moveto(x03+r, c03); drawto(x08-r, c03)
  moveto(x03+r, c01); drawto(x09-r, c01)
  
  moveto(x09+r, y27); drawto(x18-r, y27)
  moveto(x15-dw2+r, y24); drawto(x15+dw2-r, y24)
  
  moveto(x10+r, y01); drawto(x18, y01)

  // Draw the arrow heads
  drawarrow(0, x18, y01, 20)  // Arrow at bottom right

  // Draw path bends
  rndcorner(0, x02, c23, r)
  rndcorner(1, x09, c23, r)
  rndcorner(2, x02, c22, r)
  rndcorner(3, x09, c22, r)
  rndcorner(2, x02, c21, r)
  rndcorner(3, x09, c21, r)
  rndcorner(2, x02, c20, r)
  rndcorner(3, x09, c20, r)
  rndcorner(2, x02, c19, r)
  rndcorner(3, x09, c19, r)
  rndcorner(2, x02, c18, r)
  rndcorner(3, x09, c18, r)
  rndcorner(2, x02, c17, r)
  rndcorner(3, x09, c17, r)
  rndcorner(2, x02, c16, r)
  rndcorner(3, x09, c16, r)
  rndcorner(2, x02, c15, r)
  rndcorner(1, x05, c15, r)
  rndcorner(3, x09, c15, r)
  rndcorner(2, x02, c14, r)
  rndcorner(3, x05, c14, r)
  rndcorner(2, x02, c13, r)
  rndcorner(1, x05, c13, r)
  rndcorner(3, x09, c13, r)
  rndcorner(2, x02, c12, r)
  rndcorner(3, x05, c12, r)
  rndcorner(2, x02, c11, r)
  rndcorner(3, x05, c11, r)
  rndcorner(2, x02, c10, r)
  rndcorner(3, x09, c10, r)
  rndcorner(1, x07-dw1, c09, r)
  rndcorner(0, x07+dw1, c09, r)
  rndcorner(2, x02, c08, r)
  rndcorner(2, x07-dw1, c08, r)
  rndcorner(3, x07+dw1, c08, r)
  rndcorner(3, x09, c08, r)
  rndcorner(2, x02, c07, r)
  rndcorner(3, x09, c07, r)
  rndcorner(2, x02, c06, r)
  rndcorner(0, x08, c06, r)
  rndcorner(1, x03, c05, r)
  rndcorner(3, x08, c05, r)
  rndcorner(2, x03, c04, r)
  rndcorner(0, x08, c04, r)
  rndcorner(1, x03, c03, r)
  rndcorner(3, x08, c03, r)
  rndcorner(2, x03, c02, r)
  rndcorner(3, x09, c02, r)
  rndcorner(2, x03, c01, r)
  rndcorner(3, x09, c01, r)

  rndcorner(1, x09, y27, r)
  rndcorner(0, x18, y27, r)

  rndcorner(1, x15-dw1, y26, r)
  rndcorner(0, x15+dw1, y26, r)

  rndcorner(2, x09,     y25, r)
  rndcorner(0, x10,     y25, r)
  rndcorner(0, x15-dw2, y25, r)
  rndcorner(2, x15-dw1, y25, r)
  rndcorner(3, x15+dw1, y25, r)
  rndcorner(1, x15+dw2, y25, r)
  rndcorner(3, x18,     y25, r)

  rndcorner(2, x15-dw2, y24, r)
  rndcorner(3, x15+dw2, y24, r)
  rndcorner(2, x10, y23, r)
  rndcorner(1, x12, y23, r)
  rndcorner(3, x18, y23, r)
  rndcorner(2, x10, y22, r)
  rndcorner(3, x12, y22, r)
  rndcorner(2, x10, y21, r)
  rndcorner(3, x12, y21, r)

  rndcorner(2, x10, y20, r)
  rndcorner(1, x12, y20, r)
  rndcorner(3, x18, y20, r)
  rndcorner(2, x10, y19, r)
  rndcorner(3, x12, y19, r)
  rndcorner(2, x10, y18, r)
  rndcorner(3, x12, y18, r)

  rndcorner(2, x10, y17, r)
  rndcorner(1, x12, y17, r)
  rndcorner(3, x18, y17, r)
  rndcorner(2, x10, y16, r)
  rndcorner(3, x12, y16, r)

  rndcorner(2, x10, y15, r)
  rndcorner(0, x12, y15, r)
  rndcorner(1, x12, y15, r)
  rndcorner(0, x16, y15, r)

  rndcorner(2, x10, y14, r)
  rndcorner(0, x12, y14, r)
  rndcorner(1, x12, y14, r)
  rndcorner(0, x16, y14, r)

  rndcorner(2, x10, y13, r)
  rndcorner(0, x12, y13, r)
  rndcorner(1, x12, y13, r)
  rndcorner(0, x16, y13, r)

  rndcorner(2, x10, y12, r)
  rndcorner(0, x12, y12, r)
  rndcorner(1, x12, y12, r)
  rndcorner(0, x16, y12, r)

  rndcorner(2, x10, y11, r)
  rndcorner(0, x12, y11, r)
  rndcorner(1, x12, y11, r)
  rndcorner(0, x16, y11, r)

  rndcorner(2, x10, y10, r)
  rndcorner(0, x12, y10, r)
  rndcorner(1, x12, y10, r)
  rndcorner(0, x16, y10, r)

  rndcorner(2, x12, y09, r)
  rndcorner(3, x16, y09, r)
  rndcorner(3, x18, y09, r)

  rndcorner(2, x10, y08, r)
  rndcorner(1, x12, y08, r)
  rndcorner(3, x18, y08, r)

  rndcorner(2, x10, y07, r)
  rndcorner(3, x12, y07, r)

  rndcorner(2, x10, y06, r)
  rndcorner(3, x18, y06, r)

  rndcorner(2, x10, y05, r)
  rndcorner(3, x18, y05, r)

  rndcorner(2, x10, y04, r)
  rndcorner(1, x12, y04, r)
  rndcorner(3, x18, y04, r)

  rndcorner(2, x10, y03, r)
  rndcorner(3, x12, y03, r)

  rndcorner(2, x10, y02, r)
  rndcorner(3, x18, y02, r)

  rndcorner(2, x10, y01, r)

  // Draw the text
  charleveloffset := charmidleveloffset

  //drawstr(x00,  y02, "currco")
  //drawstrcentred(c05m,  y04m,  "fn")

  charleveloffset := 0

  //drawcurlyH(x06, y18, x12-x06, 20)
  //drawcurlyH(x12, y18, x17-x12, 20)

  writef("width = %n height = %n %5.1d in*n",
          width, height, 10*width / 300 *120/100) // 300 DPI
}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }


  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}


