
GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  boxH    = 24*3/2 // Assuming 24x16 font
  boxHby2 = boxH/2

  catH    = 24*2   // Assuming 24x16 font
  catHby2 = catH/2

  bendradius = 15      // Radius of bends
  catradius  = 15      // Radius of cat box round corners

  dl1  =  3*16 +  2*3  // Length of a box containing 1 character 
  dl2  =  4*16 +  3*3  // Length of a box containing 2 characters 
  dl3  =  5*16 +  4*3  // Length of a box containing 3 characters
  dl4  =  6*16 +  5*3  // Length of a box containing 4 characters
  dl5  =  7*16 +  6*3  // Length of a box containing 5 characters
  dl6  =  8*16 +  7*3  // Length of a box containing 6 characters
  dl7  =  9*16 +  8*3  // Length of a box containing 7 characters
  dl8  = 10*16 +  9*3  // Length of a box containing 8 characters
  dl9  = 11*16 + 10*3  // Length of a box containing 8 characters
  dl10 = 12*16 + 11*3  // Length of a box containing 8 characters
  dl11 = 13*16 + 12*3  // Length of a box containing 8 characters
  dl12 = 14*16 + 13*3  // Length of a box containing 8 characters

  fac = 130

  dtt  = 50*fac/100    // Vertical distance between test boxes
  dtc  = 55*fac/100    // Vertical distance between a test and cat box
  dcc  = 60*fac/100    // Vertical distance between two cat boxes
  
  dtl  = 40*fac/100    // Vertical distance between a test box and a line
  dcl  = 40*fac/100    // Vertical distance between a cat box and a line
  dll  = 25*fac/100
  
  wbb   = 40
  wbv   = 30
  wvb   = 30
  wvv   = 45
  
  x01 = 40
  x02 = x01+40
  x03 = x02+wbv
  
  y01  = 50              // ,
  y02  = y01+dtc         // ,
  y03  = y02+dtl         // line
  y04  = y03+dtl         // =
  y05  = y04+dtc         // E0 C
  y07  = y05+dcc/2       // LET
  y06  = y07-dtl         // line
  y08  = y07+dcc/2       // E0
  y09  = y07+dtc         // ,
  y10  = y09+dtl         // AND
  y11  = y10+dtt         // GLOBAL
  y12  = y11+dll         // line
  y13  = y12+dcl         // name
  y14  = y13+dtl         // line
  y15  = y14+dtl         // STATIC           
  y16  = y15+dll         // line
  y17  = y15+dtt         // MANIFEST
  y18  = y16+dcl         // name
  y19  = y18+dcl         // top line

  xay07 = x03+dl3+wbv    // Vertical after LET
  xby07 = xay07+wbv      // name
  xcy07 = xby07+dl4+wbv  // Vertical
  xdy07 = xcy07+wvb      // (
  xey07 = xdy07+dl1+wbv  // Vertical
  xfy07 = xey07+wvv      // Vertical
  xgy07 = xfy07+wvb      // name
  xhy07 = xgy07+dl4+wbv  // Vertical
  xiy07 = xhy07+wvv      // Vertical
  xjy07 = xiy07+wvb      // }
  xky07 = xjy07+dl1+wbv  // Vertical
  xly07 = xky07+wvb      // =
  xmy07 = xly07+dl2+wbb  // E0
  xny07 = xmy07+dl2+wvb  // Vertical

  xay04 = xdy07+dl1+wbv  // Vertical after =
  xby04 = xay04+wvb      // VEC
  xcy04 = xby04+dl3+wbv  // Vertical
  xdy04 = xcy04+wbv      // E0

  xay01 = xdy07+dl1+wbv  // Vertical after ,
  xby01 = xay01+wvb      // name
  xcy01 = xby01+dl4+wbv  // Vertical
  xdy01 = xcy01+wvb      // =
  xey01 = xdy01+dl1+wvb  // Vertical
  xfy01 = xey01+wvb      // E0
  xgy01 = xfy01+dl2+wvb  // Vertical

  xmy18 = xny07+60       // Arrow
  xly18 = xny07          // Vertical
  xky18 = xly18-dl1-wbv  // }
  xjy18 = xky18-wbv      // Vertical
  xiy18 = xjy18-wvv      // Vertical
  xhy18 = xiy18-dl2-wbv  // E0
  xgy18 = xhy18-wbv      // Vertical
  xfy18 = xgy18-wvv      // Vertical
  xey18 = xfy18-dl2-wbv  // E0
  xdy18 = xey18-dl1-wbb  // =
  xcy18 = xdy18-wvb      // Vertical
  xby18 = xcy18-dl4-wbv  // name
  xay18 = xby18-wvb      // Vertical before name

  xay15 = x03+dl8+wbv    // Vertical after STATIC
  xby15 = xay15+wbv      // {

  width = (xmy18+53) & #xFFFC
  height = y19+40


}

LET drawtestboxL(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // left justified at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET bx1, by1 = x2,          y-boxHby2
  LET bx2, by2 = x2+boxwidth, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(x2, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstr(x2+fontW+charHsep, y, str)
  // draw the final line
  moveto(x2+boxwidth, y); drawto(x3, y)  
}

AND drawtestboxC(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // centred at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET boxwidthby2 = boxwidth/2
  LET bx1, by1 = x2-boxwidthby2, y-boxHby2
  LET bx2, by2 = x2+boxwidthby2, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxL(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2, y-catHby2
  LET bx2, by2 = x2+catwidth, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2+catwidthby2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxC(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2-catwidthby2, y-catHby2
  LET bx2, by2 = x2+catwidthby2, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(x2+catwidthby2, y); drawto(x3, y)
}

AND drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  drawtestboxL(y18, xay18+r, xby18, xdy18,   "name")
  drawtestboxL(y18, xdy18,   xdy18, xey18,   "=")
  drawcatboxL (y18, xey18,   xey18, xhy18,   "E0")
  drawtestboxL(y18, xhy18,   xhy18, xky18,   ";")
  drawtestboxL(y18, xky18,   xky18, xmy18,   "}")

  drawtestboxL(y17,   x01,     x03, xay15-r, "MANIFEST")

  drawtestboxL(y15, x02+r,     x03, xby15,   "STATIC")
  drawtestboxL(y15, xby15,   xby15, xiy18-r, "{")

  drawtestboxL(y13, xay18+r, xby18, xdy18,   "name")
  drawtestboxL(y13, xdy18,   xdy18, xey18,   ":")
  drawcatboxL (y13, xey18,   xey18, xhy18,   "E0")
  drawtestboxL(y13, xhy18,   xhy18, xky18,   ";")
  drawtestboxL(y13, xky18,   xky18, xny07-r, "}")

  drawtestboxL(y11, x02+r,     x03, xby15,   "GLOBAL")
  drawtestboxL(y11, xby15,   xby15, xiy18-r, "{")

  drawtestboxL(y10, xay07+r, xby07, xny07-r, "AND")

  drawtestboxL(y09, xfy07+r, xgy07+(dl4-dl1)/2, xhy07-r, ",")

  drawtestboxL(y08, xky07+r, xly07,   xmy07, "=")
  drawcatboxL (y08, xmy07,   xmy07, xny07-r, "E0")

  drawtestboxL(y07, x02+r,     x03, xby07,   "LET")
  drawtestboxL(y07, xby07,   xby07, xdy07,   "name")
  drawtestboxL(y07, xdy07,   xdy07, xgy07,   "(")
  drawtestboxL(y07, xgy07,   xgy07, xjy07,   "name")
  drawtestboxL(y07, xjy07,   xjy07, xky07-r, ")")

  drawtestboxL(y05, xky07+r, xly07,   xmy07, "=")
  drawcatboxL (y05, xmy07,   xmy07, xny07-r, "E0")

  drawtestboxL(y04, xcy07+r, xdy07,   xby04, "=")
  drawcatboxL (y04, xby04,   xby04,   xdy04, "VEC")
  drawcatboxL (y04, xdy04,   xdy04, xny07-r, "E0")

  drawtestboxL(y02, xay01+r, xby01+(dl4-dl1)/2,   xcy01-r, ",")
  drawtestboxL(y02, xey01+r, xfy01+(dl2-dl1)/2,   xgy01-r, ",")

  drawtestboxL(y01, xcy07+r, xdy07,   xby01, ",")
  drawtestboxL(y01, xby01,   xby01,   xdy01, "name")
  drawtestboxL(y01, xdy01,   xdy01,   xfy01, "=")
  drawcatboxL (y01, xfy01,   xfy01,   xny07-r, "E0")



  // Draw the vertical lines
  
  moveto(xay18, y19-r);   drawto(xay18, y18+r)
  moveto(xjy18, y19-r);   drawto(xjy18, y18+r)

  moveto(xcy18, y18-r);   drawto(xcy18, y16+r)
  moveto(xfy18, y18-r);   drawto(xfy18, y16+r)
  moveto(xgy18, y18-r);   drawto(xgy18, y15+r)
  moveto(xiy18, y18-r);   drawto(xiy18, y15+r)
  moveto(xly18, y18-r);   drawto(xly18, y01+r)

  moveto(  x02, y17-r);   drawto(  x02, y07+r)
  moveto(xay15, y17-r);   drawto(xay15, y15+r)

  moveto(xay18, y14-r);   drawto(xay18, y13+r)
  moveto(xjy18, y14-r);   drawto(xjy18, y13+r)

  moveto(xcy18, y13-r);   drawto(xcy18, y12+r)
  moveto(xfy18, y13-r);   drawto(xfy18, y12+r)
  moveto(xgy18, y13-r);   drawto(xgy18, y11+r)
  moveto(xiy18, y13-r);   drawto(xiy18, y11+r)

  moveto(xay07, y10-r);   drawto(xay07, y07+r)

  moveto(xfy07, y09-r);   drawto(xfy07, y07+r)
  moveto(xhy07, y09-r);   drawto(xhy07, y07+r)

  moveto(xky07, y08-r);   drawto(xky07, y07+r)

  moveto(xcy07, y07-r);   drawto(xcy07, y01+r)
  moveto(xey07, y07-r);   drawto(xey07, y06+r)
  moveto(xiy07, y07-r);   drawto(xiy07, y06+r)
  moveto(xky07, y07-r);   drawto(xky07, y05+r)

  moveto(xay04, y04-r);   drawto(xay04, y03+r)
  moveto(xcy04, y04-r);   drawto(xcy04, y03+r)

  moveto(xay01, y02-r);   drawto(xay01, y01+r)
  moveto(xcy01, y02-r);   drawto(xcy01, y01+r)
  moveto(xey01, y02-r);   drawto(xey01, y01+r)
  moveto(xgy01, y02-r);   drawto(xgy01, y01+r)

  // Draw the horizontal lines
  
  moveto(xay18+r, y19); drawto(xjy18-r, y19)
  moveto(xcy18+r, y16); drawto(xfy18-r, y16)
  moveto(xay18+r, y14); drawto(xjy18-r, y14)
  moveto(xcy18+r, y12); drawto(xfy18-r, y12)
  moveto(xey07+r, y06); drawto(xiy07-r, y06)
  moveto(xay04+r, y03); drawto(xcy04-r, y03)

  // Draw the arrow heads
  drawarrow(0, xmy18, y18, 20)  // Arrow at bottom right

  // Draw path bends

  rndcorner(1, xay18, y19, r)
  rndcorner(0, xjy18, y19, r)

  rndcorner(2, xay18, y18, r)
  rndcorner(0, xcy18, y18, r)
  rndcorner(1, xfy18, y18, r)
  rndcorner(0, xgy18, y18, r)
  rndcorner(1, xiy18, y18, r)
  rndcorner(3, xjy18, y18, r)
  rndcorner(1, xly18, y18, r)

  rndcorner(0,   x02, y17, r)
  rndcorner(0, xay15, y17, r)

  rndcorner(2, xcy18, y16, r)
  rndcorner(3, xfy18, y16, r)

  rndcorner(2,   x02, y15, r)
  rndcorner(2, xay15, y15, r)
  rndcorner(2, xgy18, y15, r)
  rndcorner(3, xiy18, y15, r)

  rndcorner(1, xay18, y14, r)
  rndcorner(0, xjy18, y14, r)

  rndcorner(2, xay18, y13, r)
  rndcorner(0, xcy18, y13, r)
  rndcorner(1, xfy18, y13, r)
  rndcorner(0, xgy18, y13, r)
  rndcorner(1, xiy18, y13, r)
  rndcorner(3, xjy18, y13, r)
  rndcorner(3, xly18, y13, r)

  rndcorner(2, xcy18, y12, r)
  rndcorner(3, xfy18, y12, r)

  rndcorner(2,   x02, y11, r)
  rndcorner(2, xgy18, y11, r)
  rndcorner(3, xiy18, y11, r)

  rndcorner(1, xay07, y10, r)
  rndcorner(0, xny07, y10, r)

  rndcorner(1, xfy07, y09, r)
  rndcorner(0, xhy07, y09, r)

  rndcorner(1, xky07, y08, r)
  rndcorner(3, xny07, y08, r)

  rndcorner(2,   x02, y07, r)
  rndcorner(2, xay07, y07, r)
  rndcorner(0, xcy07, y07, r)
  rndcorner(0, xey07, y07, r)
  rndcorner(2, xfy07, y07, r)
  rndcorner(3, xhy07, y07, r)
  rndcorner(1, xiy07, y07, r)
  rndcorner(0, xky07, y07, r)
  rndcorner(3, xky07, y07, r)

  rndcorner(2, xey07, y06, r)
  rndcorner(3, xiy07, y06, r)

  rndcorner(2, xky07, y05, r)
  rndcorner(3, xny07, y05, r)

  rndcorner(2, xcy07, y04, r)
  rndcorner(0, xay04, y04, r)
  rndcorner(1, xcy04, y04, r)
  rndcorner(3, xny07, y04, r)

  rndcorner(2, xay04, y03, r)
  rndcorner(3, xcy04, y03, r)

  rndcorner(1, xay01, y02, r)
  rndcorner(0, xcy01, y02, r)
  rndcorner(1, xey01, y02, r)
  rndcorner(0, xgy01, y02, r)

  rndcorner(2, xcy07, y01, r)
  rndcorner(2, xay01, y01, r)
  rndcorner(3, xcy01, y01, r)
  rndcorner(2, xey01, y01, r)
  rndcorner(3, xgy01, y01, r)
  rndcorner(3, xny07, y01, r)


  writef("width = %n height = %n %5.1d in*n",
          width, height, 10*width / 300 *120/100) // 300 DPI
}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }


  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}


