GET "libhdr"

GET "plotflow.h"

/*
    x0 x1
y22
y21                     x9 x11       Tally vector                x22
y20                      -----------------  ----------------------
y19                     |   |             \ \                     |
y18	   	         ------------------  ---------------------
y17       x2  blklist	  ^              x16              
y16        -----------x8 x10
y15       |           |   |
y14       v  	x5    |   | x11 x12 x14 x16 x18 x19------x22   x24         x26                 x28   x29 
y13     ----  --------|---|-------------------------------  -------------------------------------
y12    |    \ \ |   |   |   |   |   |   |   |   |         \ \   | Globals  | Stack               \
y11     -----  -------------------|---|---|----------------  ------------------------------------
y10    x1  x3 x4  ^ x7  x9        |   |   |       x20       x23   ^          x27    ^
  	          |               |   |   |                       |                 |
y9	       Rootnode           |   |   |               PC      G                 P
y8	         x6        ------x13  |  x17------x20    x21     x25               x32
y7	                  |           |           |       |
y6		          x10        x15          |       | Entry to start
y5			  |           |           |       | x22
y4			  v           v           v       v                        x34
y3	    ---------------------------------------------------------- --------------
y2          \           | syslib    | blib      | boot          |     \ \        | 0 |
y1           ----------------------x14----------x19------------x24--x30 x31------x33-x35
y0          x5            x10

*/

MANIFEST {
  cellH   = 48
  cellW   = 48
  cellHby2   = cellH/2
  cellWby2   = cellW/2
  cellHby4   = cellH/4
  cellWby4   = cellW/4
  zigzagW    = cellWby2

  y0  = 10                 // Bottom edge
  y1  = y0  + cellHby2
  y2  = y1  + cellHby2     // syslib  blib   boot
  y3  = y2  + cellHby2
  y4  = y3  + cellHby2
  y5  = y4  + cellHby2
  y6  = y5  + cellHby2
  y7  = y6  + cellHby2
  y8  = y7  + cellHby2
  y9  = y8  + cellH
  y10 = y9  + cellH
  y11 = y10 + cellH
  y12 = y11 + cellHby2
  y13 = y12 + cellHby2
  y14 = y13 + cellHby2
  y15 = y14 + cellHby2
  y16 = y15 + cellHby2
  y17 = y16 + cellHby2 + 10
  y18 = y17 + cellHby2 + 30
  y19 = y18 + cellHby2
  y20 = y19 + cellHby2
  y21 = y20 + cellHby2
  y22 = y21 + cellHby2

  x0  =  10
  x1  =  x0  + cellWby2
  x2  =  x1  + cellWby2
  x3  =  x2  + cellW+20
  x4  =  x3  + 20
  x5  =  x4  + cellWby2
  x6  =  x5  + cellWby2
  x7  =  x6  + cellWby2
  x8  =  x7  + cellWby2
  x9  =  x8  + cellWby2
  x10 =  x9  + cellWby2
  x11 =  x10 + cellWby2
  x12 =  x11 + cellW
  x13 =  x12 + cellWby2
  x14 =  x13 + cellWby2
  x15 =  x14 + cellWby2
  x16 =  x15 + cellWby2
  x16a =  x16 + 20 
  x17 =  x16 + cellWby2
  x18 =  x17 + 20
  x19 =  x18 + cellW
  x20 =  x19 + cellWby2
  x21 =  x20 + 50
  x22 =  x20 + 80
  x23 =  x22 + 20
  x24 =  x23 + cellW
  x25 =  x24 + cellWby2
  x26 =  x25 + 180
  x27 =  x26 + cellW
  x28 =  x27 + 160
  x29 =  x28 + 40
  x30 =  x24 + 60
  x31 =  x30 + 20
  x32 =  x27 + 80
  x33 =  x31 + 80
  x34 =  x33 + cellWby2
  x35 =  x34 + cellWby2
  x26 =  x35 + 40
  
  width = x29+3 & -4
  height = y22+20
}

LET strut(x, y) BE
{ LET prevpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby(0, cellH)
  currpen := prevpen
}

AND zigzag(x, y) BE
{ LET prevpen = currpen
  currpen := penS3
  moveto(x, y)
  drawby( cellHby4, cellHby4)
  drawby(-cellHby2, cellHby2)
  drawby( cellHby4, cellHby4)
  currpen := prevpen
}

AND drawdiagram() BE
{ LET r = bendradius 
  currpen := penS3
  selectfont(16)
  charleveloffset := charmidleveloffset

  drawstrcentred(x16, y21, "Tally vector")
  moveto(x9,   y20); drawto(x16, y20)
  moveto(x16a, y20); drawto(x22, y20)

  strut(x9,   y18)
  strut(x11,  y18)
  zigzag(x16, y18)
  zigzag(x16a, y18)
  strut(x22,  y18)
  moveto(x9,  y18);    drawto(x16, y18)
  moveto(x10, y18-20); drawto(x10, y12)
  moveto(x16a, y18); drawto(x22, y18)
  drawarrow(1, x10, y18-20, r)

  drawstrcentred((x2+x8)/2, y17, "blklist")

  moveto(x2+r, y16);   drawto(x8-r, y16)
  moveto(x2,   y16-r); drawto(x2, y13+10)
  moveto(x8,   y16-r); drawto(x8, y12)
  rndcorner(1, x2, y16, r)
  rndcorner(0, x8, y16, r)

  drawarrow(3, x2, y13+10)
  moveto(x1,  y13); drawto(x3,  y13)
  moveto(x4,  y13); drawto(x22, y13)
  moveto(x23, y13); drawto(x28, y13)

  drawstr(x25, y12, "Globals")
  drawstr(x27, y12, " Stack")
  moveto(x13, y12); drawto(x13, y8+r)
  moveto(x15, y12); drawto(x15, y3+15)
  moveto(x17, y12); drawto(x17, y8+r)

  moveto(x1,  y11); drawto(x3,  y11)
  moveto(x4,  y11); drawto(x22, y11)
  moveto(x23, y11); drawto(x28, y11)
  strut(x1,   y11)
  zigzag(x3,  y11)
  zigzag(x4,  y11)
  strut(x5,   y11)
  moveto(x6, y11-20); drawto(x6, y9+cellHby2)
  drawarrow(1, x6, y11-20, r)
  strut(x7,   y11)
  strut(x9,   y11)
  strut(x11,  y11)
  strut(x12,  y11)
  strut(x14,  y11)
  strut(x16,  y11)
  strut(x18,  y11)
  moveto(x25, y11-20); drawto(x25, y9+cellHby2)
  drawarrow(1, x25, y11-20, r)
  zigzag(x22, y11)
  zigzag(x23, y11)
  strut(x24,  y11)
  strut(x26,  y11)
  moveto(x32, y11-20); drawto(x32, y9+cellHby2)
  drawarrow(1, x32, y11-20, r)
  zigzag(x28, y11)
  
  drawstrcentred(x6, y9, "Rootnode")
  drawstrcentred(x21, y9, "PC")
  moveto(x21, y9-r); drawto(x21, y3+20)
  drawstrcentred(x25, y9, "G")
  drawstrcentred(x32, y9, "P")

  moveto(x10+r, y8); drawto(x13-r, y8)
  moveto(x17+r, y8); drawto(x20-r, y8)
  moveto(x10, y8-r);  drawto(x10, y3+20)
  moveto(x20, y8-r); drawto(x20, y3+20)
  rndcorner(1, x10, y8, r)
  rndcorner(3, x13, y8, r)
  rndcorner(2, x17, y8, r)
  rndcorner(0, x20, y8, r)

  moveto(x5,  y3); drawto(x30, y3)
  moveto(x31, y3); drawto(x35,y3)
  drawarrow(3, x10, y3+20, r)
  drawarrow(3, x15, y3+20, r)
  drawarrow(3, x20, y3+20, r)
  drawarrow(3, x21, y3+20, r)

  drawstr(x10, y2, "syslib")
  drawstr(x15, y2, "blib")
  drawstr(x20, y2, "boot")
  drawstrcentred(x34, y2, "0")

  moveto(x5,  y1);  drawto(x30, y1)
  moveto(x31, y1);  drawto(x35, y1)
  zigzag(x5,  y1)
  strut(x9,   y1)
  strut(x14,  y1)
  strut(x19,  y1)
  strut(x24,  y1)
  zigzag(x30, y1)
  zigzag(x31, y1)
  strut(x33,  y1)
  strut(x35,  y1)
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("*n%s: width = %n pixels  height = %n pixels       width in mms = %5.1d*n*n",
            tofilename, width, height, mmwidth)
    delay(10_000)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}
