GET "libhdr"
GET "plotflow.h"

/*
y24
y23                    Stack frame            Global vector         Program
y22   x01------x04----x06-x08---x09---x10---x12---x14---x15-x16 -------------------x19-------x21   x22
       |         \ \   |         |     \ \   |           |    \ \                    \ \      |
y21    ---------- x05---x07------------ x11---x13------------- x17---x18------------- x20-----
                         ^                     ^                      ^
y20    Registers         |                     |                      |
y19     ---x2--x3        |                     |                      |
y18    |   A   |         |                     |                      |
y17    |-------|         |                     |                      |
y16    |   B   |         |                     |                      |
y15    |-------|         |                     |                      |
y14    |   C   |         |                     |                      |
y13    |-------|         |                     |                      |
y12    |   P --|---------                      |                      |
y11    |-------|                               |                      |
y10    |   G --|-------------------------------                       |
y09    |-------|                                                      |
y08    |  ST   |                                                      |
y07    |-------|                                                      |
y06    |  PC --|------------------------------------------------------
y05    |-------|
y04    | Count |
y03    |-------|
y02    |  MW   |
y01     -------
y00
*/

MANIFEST {
  y00 = 10             // bottome edge
  y01 = y00+50         // Bottom line of registers
  y02 = y01+20         // MW
  y03 = y02+20
  y04 = y03+20         // Count
  y05 = y04+20
  y06 = y05+20         // PC
  y07 = y06+20
  y08 = y07+20         // ST
  y09 = y08+20
  y10 = y09+20         // G
  y11 = y10+20
  y12 = y11+20         // P
  y13 = y12+20
  y14 = y13+20         // C
  y15 = y14+20
  y16 = y15+20         // B
  y17 = y16+20
  y18 = y17+20         // A
  y19 = y18+20         // Top line of the registers
  y20 = y19+cellH      // Registers
  y21 = y20+cellH      // Memory bottom line
  y22 = y21+cellH      // Memory top line
  y23 = y22+cellH      // Stack frame ...
  y24 = y23+cellH      // Top edge

  regW = wl7
    
  x00 = 10            // Left edge
  x01 = 100           // Left edge of memory and registers
  x02 = x01+regW/2    // Centre of register cells
  x03 = x01+regW      // Right edge of registers
  x04 = x03+20        // Zigzag 1 L
  x05 = x04+zigzagW   // zigzag 1 R
  x06 = x05+40        //
  x07 = x06+cellWby2  //
  x08 = x07+cellW*2   // Centre of Stack frame
  x09 = x07+cellW*4   //
  x10 = x09+25        // zigzag 1 L
  x11 = x10+cellW/2   // zigzag 1 R
  x12 = x11+cellW     // Start of Global vector
  x13 = x12+cellWby2  //
  x14 = x13+wl13/2    //
  x15 = x14+wl13/2    // End of Global vector
  x16 = x15+cellW     // zigzag 1 L
  x17 = x16+zigzagW   // zigzag 1 R
  x18 = x17+wl7/2     //
  x19 = x18+wl7/2     // zigzag 1 L
  x20 = x19+zigzagW   // zigzag 1 R
  x21 = x20+60        // End of memory
  x22 = x21+60        // Right hand edge

  width  = x22+3 & -4
  height = y24
}


LET drawdiagram() BE
{ LET r = bendradius
  currpen := penS3

  drawstrcentred(x08, y23, "Stack frame")
  drawstrcentred(x14, y23, "Global vector")
  drawstrcentred(x18, y23, "Program")

  moveto(x01, y22); drawto(x04, y22)
  moveto(x05, y22); drawto(x10, y22)
  moveto(x11, y22); drawto(x16, y22)
  moveto(x17, y22); drawto(x19, y22)
  moveto(x20, y22); drawto(x21, y22)
  
  moveto(x01, y21); drawto(x04, y21)
  moveto(x05, y21); drawto(x10, y21)
  moveto(x11, y21); drawto(x16, y21)
  moveto(x17, y21); drawto(x19, y21)
  moveto(x20, y21); drawto(x21, y21)
  
  strut(x01, y21)
  zigzag(x04, y21)
  zigzag(x05, y21)
  strut(x06, y21)
  strut(x09, y21)
  zigzag(x10, y21)
  zigzag(x11, y21)
  strut(x12, y21)
  strut(x15, y21)
  zigzag(x16, y21)
  zigzag(x17, y21)
  zigzag(x19, y21)
  zigzag(x20, y21)
  strut(x21, y21)
  drawarrow(1, x07, y21-10, r)
  moveto(x07, y21-10); drawto(x07, y12+r)
  drawarrow(1, x13, y21-10, r)
  moveto(x13, y21-10); drawto(x13, y10+r)
  drawarrow(1, x18, y21-10, r)
  moveto(x18, y21-18); drawto(x18, y06+r)


  drawstrcentred(x02, y20, "Registers")

  moveto(x01, y19); drawto(x03, y19)
  moveto(x01, y19); drawto(x01, y01)
  moveto(x03, y19); drawto(x03, y01)
  moveto(x01, y19); drawto(x03, y19)

  drawstrcentred(x02, y18, "A")
  moveto(x01, y17); drawto(x03, y17)

  drawstrcentred(x02, y16, "B")
  moveto(x01, y15); drawto(x03, y15)

  drawstrcentred(x02, y14, "C")
  moveto(x01, y13); drawto(x03, y13)

  drawstrcentred(x02, y12, "P")
  moveto(x03-25, y12); drawto(x07-r, y12)
  rndcorner(3, x07, y12, r)
  moveto(x01, y11); drawto(x03, y11)

  drawstrcentred(x02, y10, "G")
  moveto(x03-25, y10); drawto(x13-r, y10)
  rndcorner(3, x13, y10, r)
  moveto(x01, y09); drawto(x03, y09)

  drawstrcentred(x02, y08, "ST")
  moveto(x01, y07); drawto(x03, y07)

  drawstrcentred(x02, y06, "PC")
  moveto(x03-25, y06); drawto(x18-r, y06)
  rndcorner(3, x18, y06, r)
  moveto(x01, y05); drawto(x03, y05)

  drawstrcentred(x02, y04, "Count")
  moveto(x01, y03); drawto(x03, y03)

  drawstrcentred(x02, y02, "MW")
  moveto(x01, y01); drawto(x03, y01)
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("*n%s: width = %n pixels  height = %n pixels       width in mms = %5.1d*n*n",
            tofilename, width, height, mmwidth)
    delay(10_000)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}


