
GET "libhdr"
GET "plotflow.h"

/*
y9
y8                                           x9-------------------------x13
         x3           x5    x6     x7        |        x11        x12    |
y7  --x2-[relop]--x4--[(]---(E0)---[)]---x8--x9--x10--[n<1  ,]---(P1)---|
      |           |                      |        |                     |
y6    |           x4-------[bpat]--------x8       |---[n<2  |]---(P2)---|
      |                                  |        |                     |
y5    |--[jcom]--------------------------|        |---[n<3   ]---(P3)---x13
      |        x14    x15                |        |
y4    |--[(]---(P0)---[)]----------------|        x10------------------->
      |                                  |
y3    |--[[]---(P0)---[]]----------------|
      |              x17      x18        |
y2    |--[bpat]--x16-[range]--[bpat]-----|
      |          |                       |
y1    x2-[fname]-x16---------------------x8
y0                                                                      x13 x19

*/

MANIFEST {
y0   = 0
y1 = y0+50     // |--[fname]------------------x8
y2 = y1+hcc    // |--[bpat]
y3 = y2+hcc    // |--[[]---
y4 = y3+hcc    // |--[(]--                     x9------------------>
y5 = y4+hcc    // |--[jcom]--
y6 = y5+hcc    // |          x4----[bpat]-----x8
y7 = y6+hcc    // |--[relop]---[(]--(E0)--[)]-----[n<1  ,]---(P1)--|
y8 = y7+hcc    // |                            x9------------------>
y9 = y8+20     // |                                                x13 x19

x0  = 0
x1  = 20
x2  = x1+wcc       // left vertical
x3  = x2+wcc       // before relop
x4  = x3+wl5+wcc   // vertical after relop
x5  = x4+wcc       // before [{] on y7
x6  = x5+wl1+wcc   // before {E0} on on y7
x7  = x6+wl2+wcc   // before [)] on y7
x8  = x7+wl1+wcc   // first vertical after [)] on y7
x9  = x8+wcc       // first vertical after [)] on y7
x10 = x9+wcc       // third vertical after [)] on y7
x11 = x10+wcc      // before [n<1  ,] ony7
x12 = x11+wl6+wcc  // before (P3} on y5
x13 = x12+wl2++wcc // right arrow
x14 = x3+wl1+wcc   // before (P0) on y4
x15 = x14+wl2+wcc  // before []] on y4
x16 = x3+wl4+wcc   // vertival after [bpat] on y2
x17 = x16+wcc      // before [range] on y2
x18 = x17+wl5+wcc  // before [bpat] on y2
x19 = x13+20       // right edge

width = (x19+3) & -4
height = y9
}

LET drawdiagram() BE
{ LET r = bendradius

  currpen := penS3

  moveto(x9+r, y8); drawto(x13-r, y8)
  moveto(x9,  y8-r); drawto(x9,  y7+r)
  moveto(x13, y8-r); drawto(x13, y5+r)
  rndcorner(1, x9,  y8, r)
  rndcorner(0, x13, y8, r)
  
  drawtestboxL(y7, x1,   x3,  x5,    "relop") 
  drawtestboxL(y7, x5,   x5,  x6,    "(") 
  drawcatboxL (y7, x6,   x6,  x7,    "E0") 
  drawtestboxL(y7, x7,   x7,  x11,   ")") 
  drawtestboxL(y7, x11,  x11, x12,   "n<1  ,") 
  drawcatboxL (y7, x12,  x12, x13-r, "P1") 
  moveto(x2,  y7-r); drawto(x2,  y1+r)
  moveto(x4,  y7-r); drawto(x4,  y6+r)
  moveto(x8,  y7-r); drawto(x8,  y1+r)
  moveto(x10, y7-r); drawto(x10, y4+r)
  rndcorner(0, x2,  y7, r)
  rndcorner(0, x4,  y7, r)
  rndcorner(1, x8,  y7, r)
  rndcorner(2, x9,  y7, r)
  rndcorner(0, x10, y7, r)
  rndcorner(3, x13, y7, r)


  drawtestboxC(y6, x4+r,  (x4+x8)/2,  x8-r, "bpat") 
  drawtestboxL(y6, x10+r, x11,  x12,   "n<2  |") 
  drawcatboxL (y6, x12,   x12,  x13-r, "P2") 
  rndcorner(2, x4,  y6, r)
  rndcorner(3, x8,  y6, r)
  rndcorner(2, x10, y6, r)
  rndcorner(3, x13, y6, r)

  drawtestboxL(y5, x2+r,  x3,  x8-r,   "jcom") 
  drawtestboxL(y5, x10+r, x11, x12,    "n<3   ") 
  drawcatboxL (y5, x12,   x12, x13-r,  "P3") 
  rndcorner(2, x2,  y5, r)
  rndcorner(2, x2,  y5, r)
  rndcorner(3, x8,  y5, r)
  rndcorner(2, x10, y5, r)
  rndcorner(3, x13, y5, r)


  drawtestboxL(y4, x2+r,  x3,  x14,  "(") 
  drawcatboxL (y4, x14,  x14,  x15,  "P0") 
  drawtestboxL(y4, x15,  x15, x8-r,  ")") 
  moveto(x10+r, y4); drawto(x13, y4)
  drawarrow(0, x13, y4, 20)  // Arrow at bottom right
  rndcorner(2, x2,  y4, r)
  rndcorner(3, x8,  y4, r)
  rndcorner(2, x10, y4, r)

  drawtestboxL(y3, x2+r, x3,  x14,   "[") 
  drawcatboxL (y3, x14,  x14, x15,   "P0") 
  drawtestboxL(y3, x15,  x15, x8-r,  "]") 
  rndcorner(2, x2, y3, r)
  rndcorner(3, x8, y3, r)

  drawtestboxL(y2, x2+r, x3,  x17,   "bpat") 
  drawtestboxL(y2, x17,  x17, x18,   "range") 
  drawtestboxL(y2, x18,  x18, x8-r,   "bpat") 
  rndcorner(2, x2, y2, r)
  rndcorner(3, x8, y2, r)

  drawtestboxL(y1,  x2+r, x3, x8-r,  "fname")
  rndcorner(2, x2, y1, r)
  rndcorner(3, x8, y1, r)


}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("%s: width = %n pixels  height = %n pixels    %5.1d mm*n",
            tofilename, width, height, mmwidth)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}


