
GET "libhdr"

GET "plotflow.h"

/*
y05
y04      ------------------------------------------------
        |                                                |
y03a    |         x04---------       ----     ----       |
y03     |          |          | x07-[ => ]---{ E6 )--x10 |
        |  x03--   | x05---   |  |   ----     ----    |  |    x13--
y02 ---x02--[ : ]-----( P0 )-x06--                     -x11----[ . ]------->
             ---       ----       | x08--   x09--     |     |   ---   |   x15
y01                               --[ BE ]---( C )----     x12-------x14
y00	  		             ----     ---
*/

MANIFEST {
  x01  = 20
  x02  = x01+60         // Left virtical line
  x03  = x02+wtl        // :
  x04  = x03+wl1+wlt    // vertical after :
  x05  = x04+wlt        // P0
  x06  = x05+wl2+wtl    // Vertical after P0
  x07  = x06+wcl        // Two verticals after P0
  x08  = x07+wlt        // BE
  x09  = x08+wl2+wlt    // C
  x10  = x09+wl2+wtl    // Two verticals after C
  x11  = x10+wcl        // middle vertical
  x12  = x11+wll        // vertical before .
  x13  = x12+wlt        // .
  x14  = x13+wl1+wtl    // vertical after .
  x15  = x14+50         // Arrow

  y00 = 10
  y01 = y00 + hcc       // BE  C
  y02 = y01+hcc/2       // : P0
  y03 = y02+hcc/2       // => E0
  y03a = y02+hcl        // line above P0
  y04 = y03a+hcl        // top line
  y05 = y04 + 40
  
  width = (x15+53) & -4
  height = y05
}

LET drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  drawtestboxL(y01, x07+r, x08, x09,   "BE") 
  drawcatboxL (y01, x09,   x09, x10-r, "C") 

  drawtestboxL(y02, x01,   x03, x05,   ":") 
  drawcatboxL (y02, x05,   x05, x07-r, "P0") 
  drawtestboxL(y02, x10+r, x13, x15,   ".") 

  drawtestboxL(y03, x07+r, x08, x09,   "=>") 
  drawcatboxL (y03, x09,   x09, x10-r, "E0") 

  // Draw the vertical lines
  moveto(x02, y02+r);   drawto(x02, y04-r)
  moveto(x04, y02+r);   drawto(x04, y03a-r)
  moveto(x06, y02+r);   drawto(x06, y03a-r)
  moveto(x07, y02+r);   drawto(x07, y03-r)
  moveto(x07, y02-r);   drawto(x07, y01+r)
  moveto(x10, y02+r);   drawto(x10, y03-r)
  moveto(x10, y02-r);   drawto(x10, y01+r)
  moveto(x11, y02+r);   drawto(x11, y04-r)
  moveto(x12, y02-r);   drawto(x12, y01+r)
  moveto(x14, y02-r);   drawto(x14, y01+r)
  
  // Draw the horizontal lines
  
  moveto(x02+r, y04);  drawto(x11-r, y04)
  moveto(x04+r, y03a); drawto(x06-r, y03a)
  moveto(x12+r, y01);  drawto(x14-r, y01)

  // Draw the arrow heads
  drawarrow(0, x15, y02, 20)  // Arrow at bottom right

  // Draw path bends
  rndcorner(2, x02, y02,  r)
  rndcorner(1, x02, y04,  r)
  rndcorner(3, x04, y02,  r)
  rndcorner(1, x04, y03a, r)
  rndcorner(2, x06, y02,  r)
  rndcorner(0, x06, y03a, r)
  rndcorner(2, x07, y01,  r)
  rndcorner(0, x07, y02,  r)
  rndcorner(3, x07, y02,  r)
  rndcorner(1, x07, y03,  r)

  rndcorner(3, x10, y01, r)
  rndcorner(1, x10, y02, r)
  rndcorner(2, x10, y02, r)
  rndcorner(0, x10, y03, r)

  rndcorner(3, x11, y02, r)
  rndcorner(0, x11, y04, r)

  rndcorner(2, x12, y01, r)
  rndcorner(0, x12, y02, r)

  rndcorner(3, x14, y01, r)
  rndcorner(1, x14, y02, r)
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("%s: width = %n pixels  height = %n pixels    %5.1d mm*n",
            tofilename, width, height, mmwidth)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}



