/*
This program draws sym-prog.bmp
*/

GET "libhdr"
GET "plotflow.h"

/*
.--      --.    < y2
|          |
    ----
---(Prog)---    < y1
    ----
|          |
.--      --.    < y0 
^  ^       ^
x0 x1      x2
*/

MANIFEST {
  x0 = 0
  x1 = x0 + 20
  x2 = x1 + wl4 + 20

  y0 = 0
  y1 = y0 + catboxHby2 + 5
  y2 = y1 + catboxHby2 + 5

  width  = x2+3 & -4
  height = y2 + 5
}

LET drawdiagram() BE
{ LET mmwidth = width *
                      10 *         // scaled with one digit
				   // after the decimal point
                      254/10 /     // 25.4 mm per inch
		      300          // at 300 DPI
                                
  writef("File name: %s width = %n = %5.1d mm*n",
          tofilename, width, mmwidth*130/100)

  drawcatboxL(y1, x0, x1, x2, "Prog")
}

LET drawdiagram1() BE
{ LET mmwidth = width*10/300*254/10 // mm at 300 DPI
                                    // scaled with one digit
				    // after the decimal point
 
  drawcatboxL(y1, x0, x1, x2, "Prog")
  writef("width = %n = %5.1d mm*n", width, mmwidth*130/100)
}

LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
  charleveloffset := 0
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  drawdiagram()
  
  writef("Writing file %s*n", tofilename)
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}

