/*
Program to draw the syntax diagram for Prog
*/

GET "libhdr"
GET "plotflow.h"

/*
.--                        --.   <y2
|                            |
       ----     -----
   ---( E0 )---| eof |--->       <y1
       ----    ------
|                            |
.--                        --.   <y0
^  ^  ^        ^         ^  ^ 
x0 x1 x2      x3         x4 x5

*/

MANIFEST {
  x0 = 5
  x1 = x0 + 20
  x2 = x1 + wtl
  x3 = x2 + wl2 + wcl
  x4 = x3 + wl3 + 60
  x5 = x4 + 20
  
  y0 = 5
  y1 = y0 + htt
  y2 = y1 + htt
  
  width  = x5+3 & -4
  height = y2 + 15
}

LET drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  drawcatboxL (y1, x1, x2, x3, "E0")
  drawtestboxL(y1, x3, x3, x4, "eof")

  drawarrow(0, x4, y1, 20)

  { LET mmwidth = width * 10 / 150 * 254 / 10 // mm at 150 DPI
    newline()
    sawritef("width = %n = %5.1d mm*n*n*n", width, mmwidth)
  }
}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for n2prog, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }

sawritef("*nBefore calling drawdiagram xsize=%n ysize=%n*n", xsize, ysize)

  drawdiagram()

draw:
  wrbmp(tofilename)
sawritef("*nAfter calling mrbmp xsize=%n ysize=%n*n", xsize, ysize)

fin:
  closebdraw()

  RESULTIS 0
}


