/*
Program to draw the syntax diagram for Bexp
*/

GET "libhdr"
GET "plotflow.h"

/*
.--                                                   --.   <y8
|                                                       |
                 -----------------------------              <y7
       ------   |      -------       ----     |
   ---( Bexp )--------| n<3 ^ |-----( E2 )----|             <y6
       ------      |   -------       ----     |
^  ^  ^         ^  ^  ^          ^  ^         ^    ^    ^
x0 x1 x2        x3 x4 x5         x6 x7        x8   x9   x10
                   |   -------       ----     |
                   |--| n<2 * |-----( E2 )----|             <y5
                   |   -------   |   ----     |
                   |   -------   |            |
                   |--| n<2 / |--             |             <y4
                   |   -------                |
                   |   -------       ----     |
                   |--| n<1 + |-----( E1 )----              <y3
                   |   -------   |   ----
                   |   -------   |
                   |--| n<1 - |--                           <y2
                   |   -------
                    ------------------------------->        <y1
|                                                       |
.--                                                   --.   <y0
^  ^  ^         ^  ^  ^          ^  ^         ^    ^    ^
x0 x1 x2        x3 x4 x5         x6 x7        x8   x9   x10
*/

MANIFEST {
  x0 = 5
  x1 = x0 + 20
  x2 = x1 + wtl
  x3 = x2 + wl4 + wll
  x4 = x3 + wcc 
  x5 = x4 + wtl
  x6 = x5 + wl5 + wtl
  x7 = x6 + wtl
  x8 = x7 + wl2 + wtl
  x9 = x8 + 60
  x10 = x9 + 60
  
  y0 = 5
  y1 = y0 + 30
  y2 = y1 + htt
  y3 = y2 + htt
  y4 = y3 + htt
  y5 = y4 + htt
  y6 = y5 + hcc
  y7 = y6 + htt
  y8 = y7 + 20
  
  width  = x10+3 & -4
  height = y8 + 15
}

LET drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  moveto(x3+r, y7)
  drawto(x8-r, y7)
  rndcorner(1,  x3, y7, r)
  rndcorner(0,  x8, y7, r)
  moveto(x3, y7-r)
  drawto(x3, y6+r)
  moveto(x8, y7-r)
  drawto(x8, y3+r)

  drawcatboxL(y6, x1, x2, x5, "Bexp")
  drawtestboxL(y6, x5, x5, x7, "n<3 ^")
  drawcatboxL(y6, x7, x7, x8-r, "E2")
  rndcorner(2, x3, y6, r)
  rndcorner(0, x4, y6, r)
  rndcorner(3, x8, y6, r)
  moveto(x4, y6-r); drawto(x4, y1+r)

  drawtestboxL(y5, x4+r, x5, x7, "n<2 **")
  drawcatboxL(y5, x7, x7, x8-r, "E2")
  rndcorner(2, x4, y5, r)
  rndcorner(1, x6, y5, r)
  rndcorner(3, x8, y5, r)
  moveto(x6, y5-r)
  drawto(x6, y4+r)

  drawtestboxL(y4, x4+r, x5, x6-r, "n<2 /")
  rndcorner(2, x4, y4, r)
  rndcorner(3, x6, y4, r)

  drawtestboxL(y3, x4+r, x5, x7, "n<1 +")
  drawcatboxL(y3, x7, x7, x8-r, "E1")
  rndcorner(2, x4, y3, r)
  rndcorner(1, x6, y3, r)
  rndcorner(3, x8, y3, r)
  moveto(x6, y3-r)
  drawto(x6, y2+r)

  drawtestboxL(y2, x4+r, x5, x6-r, "n<1 -")
  rndcorner(2, x4, y2, r)
  rndcorner(3, x6, y2, r)

  moveto(x4+r, y1)
  drawto(x9, y1)
  rndcorner(2, x4, y1, r)
  drawarrow(0, x9, y1, 20)

  { LET mmwidth = width * 10 / 150 * 254 / 10 // mm at 150 DPI
    newline()
    //sawritef("hll=%n htl=%n htt=%n htc=%n hcc=%n*n",
    //          hll,   htl,   htt,   htc,   hcc)
    //sawritef("width = %n height = %n*n", width, height)
    sawritef("width = %5.1d mm*n*n*n", mmwidth)
  }

}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for exp*n")
    RESULTIS 0
  }

  tofilename := "junk.bmp"
  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }

//sawritef("*nBefore calling drawdiagram xsize=%n ysize=%n*n", xsize, ysize)

  drawdiagram()

draw:
  wrbmp(tofilename)
//sawritef("*nAfter calling mrbmp xsize=%n ysize=%n*n", xsize, ysize)

fin:
  closebdraw()

  RESULTIS 0
}


