GET "libhdr"

// Insert the graphics library
//MANIFEST { g_bdrawbase=450 }

GET "bdrawlib.h"
GET "bdrawlib.b"

MANIFEST {
  boxH    = 24*3/2 // Assuming 24x16 font
  boxHby2 = boxH/2

  catH    = 24*2   // Assuming 24x16 font
  catHby2 = catH/2

  bendradius = 15      // Radius of bends
  catradius  = 15      // Radius of cat box round corners

  dl1  =  3*16 +  2*3  // Length of a box containing 1 character 
  dl2  =  4*16 +  3*3  // Length of a box containing 2 characters 
  dl3  =  5*16 +  4*3  // Length of a box containing 3 characters
  dl4  =  6*16 +  5*3  // Length of a box containing 4 characters
  dl5  =  7*16 +  6*3  // Length of a box containing 5 characters
  dl6  =  8*16 +  7*3  // Length of a box containing 6 characters
  dl7  =  9*16 +  8*3  // Length of a box containing 7 characters
  dl8  = 10*16 +  9*3  // Length of a box containing 8 characters
  dl9  = 11*16 + 10*3  // Length of a box containing 8 characters
  dl10 = 12*16 + 11*3  // Length of a box containing 8 characters
  dl11 = 13*16 + 12*3  // Length of a box containing 8 characters
  dl12 = 14*16 + 13*3  // Length of a box containing 8 characters

  fac = 130

  dtt  = 50*fac/100    // Vertical distance between test boxes
  dtc  = 55*fac/100    // Vertical distance between a test and cat box
  dct  = dtc
  dcc  = 60*fac/100    // Vertical distance between two cat boxes
  
  dtl  = 40*fac/100    // Vertical distance between a test box and a line
  dlt  = dtl           // Vertical distance between a test box and a line
  dcl  = 40*fac/100    // Vertical distance between a cat box and a line
  dlc  = dcl           // Vertical distance between a cat box and a line
  dll  = 25*fac/100
  
  wbb   = 40
  wbv   = 30
  wvb   = 30
  wvv   = 45
  
  hw1 =  80 // Half length of a box containing 1 character
  hw2 = 100 // Half length of a box containing 2 characters
  hw3 = 150 // Half length of a box containing 3 characters

  // Left side -- basic expresssions  y01 to y50
  // Boxes on even line numbers
  
  
  y01 = 20              // bottom edge
  
  y04 = y01+20             // VALOF C

  y06 = y04+dtt         // EVERY 
  
  y08 = y06+dtt         // MATCH mlist
  y09 = y08+dtt         // . above MATCH ( E0 ) Mlist
  y10 = y09+dtt         // TABLE E0 ,..., E0
  y11 = y10+dtt         // , above TABLE

  y12 = y11+dtt         // NOT      E3
  y14 = y12+dtt         // posop    E5

  y16 = y14+dtt         // @
  y18 = y16+dtt         // !
  y20 = y18+dtt         // FIX
  y22 = y20+dtt         // FLOAT    E7

  y24 = y22+dct         // ( E0 )
  y26 = y24+dtc         // jcom

  y33 = y26+dlc         // line
  y34 = y33+dtt         // SLCT
  
  y36 = y34+dtt         // string
  y38 = y36+dtt         // const
  y40 = y38+dtt         // name




  x01 = 20
  x02 = x01+wbv+40     // Left virtical line
  x03 = x02+wvb        // Monadic ops
  x04 = x03+dl5+wbv    // Vertical after FLOAT
  
  x05  = x03+dl4+wbb   // E0 after SLCT
  x05a = x05+dl2+wbv   // Vertical after first E0 in SLCT
  x05b = x05a+wvb      // colon
  x05c = x05b+dl1+wbb  // second E0
  x05d = x05c+dl2+wbv  // Vertical after second E0
  x05e = x05d+wvb      // colon
  x05f = x05e+dl1+wbb  // third E0
  x05g = x05f+dl2+wbv  // Vertical after third E0

  x05am = x03+dl5+wbv    // Vertical after MATCH
  x05bm = x05am+wvb      // ( in MATCH
  x05cm = x05bm+dl1+wvb  // vertical after (
  x05dm = x05cm+wvb      // E0
  x05em = x05dm+dl2+wbv  // Vertical before )
  x05fm = x05em+wvb      // )
  x05gm = x05fm+dl1+wbb  // Mlist
  x05hm = x05gm+dl5+wbv  // Vertical after Mlist

  x06 = x03+180        // E0 between ( and )
  x07 = x05+100        // Operands, eg E7 and E8
  x08 = x07+80         // Verticals after E0 in eg TABLE
  x09 = x05g           // Vertical at end of bexp
  x09a = x09+wvv       // Vertical between bexp and the dyadic operators
  x10 = x09a+wvv       // Vertical before dyadic ops
  x11 = x10+50         // Dyadic ops
  x12 = x11+250        // Vertical after dyadic ops
  x13 = x12+80         // E0 after ->
  x14 = x13+50         // Position to the right of E0
  x15 = x12+hw3        // Operands of eg << and &
  x16 = x15+hw3        // Categories such as E8 and E6
  x17 = x15+200        // Second E0 after fcond
  x18 = x17+100        // Right hand vertical line
    
  width = (x10+50) &-4
  height = y40+30
}

LET drawtestboxL(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // left justified at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET bx1, by1 = x2,          y-boxHby2
  LET bx2, by2 = x2+boxwidth, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(x2, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstr(x2+fontW+charHsep, y, str)
  // draw the final line
  moveto(x2+boxwidth, y); drawto(x3, y)  
}

AND drawtestboxC(y, x1, x2, x3, str) BE
{ // Draw a test box with initial and final lines at level y
  // centred at x2.
  LET boxwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET boxwidthby2 = boxwidth/2
  LET bx1, by1 = x2-boxwidthby2, y-boxHby2
  LET bx2, by2 = x2+boxwidthby2, y+boxHby2
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  // Draw the box
  moveto(bx1, by1)
  drawto(bx1, by2)
  drawto(bx2, by2)
  drawto(bx2, by1)
  drawto(bx1, by1)
  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)
  
}

AND drawcatboxL(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2, y-catHby2
  LET bx2, by2 = x2+catwidth, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2+catwidthby2, y, str)
  // draw the final line
  moveto(bx2, y); drawto(x3, y)  
}

AND drawcatboxC(y, x1, x2, x3, str) BE
{ // Draw a category box with initial and final lines at level y
  // centres at x2.
  LET catwidth = (str%0+2) * (fontW+charHsep) - charHsep
  LET catwidthby2 = catwidth/2
  LET bx1, by1 = x2-catwidthby2, y-catHby2
  LET bx2, by2 = x2+catwidthby2, y+catHby2
  LET r = catradius
  
  // Draw the initial line
  moveto(x1, y); drawto(bx1, y)
  
  // Draw the rounded box
  moveto(bx1, by1+r); drawto(bx1, by2-r); drawarc90(1, bx1+r, by2-r, r)
  moveto(bx1+r, by2); drawto(bx2-r, by2); drawarc90(0, bx2-r, by2-r, r)
  moveto(bx2, by2-r); drawto(bx2, by1+r); drawarc90(3, bx2-r, by1+r, r)
  moveto(bx2-r, by1); drawto(bx1+r, by1); drawarc90(2, bx1+r, by1+r, r)

  // Draw the string
  drawstrcentred(x2, y, str)
  // draw the final line
  moveto(x2+catwidthby2, y); drawto(x3, y)
}

AND drawdiagram() BE
{ LET r = bendradius

  // Draw the boxes
  currpen := penS3

  drawtestboxL(y40, x01,   x03, x10,   "name")

  drawtestboxL(y38, x02+r, x03, x09-r, "const")
  drawtestboxL(y36, x02+r, x03, x09-r, "string")

  drawtestboxL(y34, x02+r,  x03, x05,   "SLCT")
  
  drawcatboxL (y34, x05,    x05, x05b,  "E9")
  drawtestboxL(y34, x05b,  x05b, x05c,  ":")
  drawcatboxL (y34, x05c,  x05c, x05e,  "E9")
  drawtestboxL(y34, x05e,  x05e, x05f,  ":")
  drawcatboxL (y34, x05f,  x05f, x09-r, "E9")

  drawtestboxL(y26, x02+r, x03, x09-r, "jcom")

  drawtestboxL(y24, x02+r, x03, x05,   "(")
  drawcatboxL (y24, x05,   x06, x07,   "E0")
  drawtestboxL(y24, x07,   x08, x09-r, ")")

  drawtestboxL(y22, x02+r, x03, x06,   "FLOAT")
  drawcatboxC (y22, x06,   x07, x09-r, "E7")
  drawtestboxL(y20, x02+r, x03, x04-r, "FIX")
  drawtestboxL(y18, x02+r, x03, x04-r, "!")
  drawtestboxL(y16, x02+r, x03, x04-r, "@")

  drawtestboxL(y14, x02+r, x03, x05,   "posop")
  drawcatboxC (y14, x05,   x07, x09-r, "E5")

  drawtestboxL(y12, x02+r, x03, x05, "NOT")
  drawcatboxC (y12, x05, x07, x09-r, "E3")

  drawtestboxC(y11, x07-hw1+r, x07, x07+hw1-r, ",")
  drawtestboxL(y10, x02+r, x03, x05, "TABLE")
  drawcatboxC (y10, x05, x07, x09-r, "E0")

  drawtestboxL(y09, x05cm+r, x05dm+(dl2-dl1)/2, x05em-r, ",")

  drawtestboxL(y08, x02+r, x03,   x05bm, "MATCH")
  drawtestboxL(y08, x05bm, x05bm, x05dm, "(")
  drawcatboxL (y08, x05dm, x05dm, x05fm, "E0")
  drawtestboxL(y08, x05fm, x05fm, x05gm, ")")
  drawcatboxL (y08, x05gm, x05gm, x09-r, "Mlist")

  drawtestboxL(y06, x02+r, x03, x05, "EVERY")

  drawtestboxL(y04, x02+r, x03, x05, "VALOF")
  drawcatboxC (y04, x05, x07, x09-r, "C")

  // Draw the vertical lines
  moveto(x02, y04+r); drawto(x02, y40-r) // Left line
  moveto(x04, y16+r); drawto(x04, y22-r) // FLOAT line
  moveto(x04, y06+r); drawto(x04, y08-r) // MATCH line
  
  moveto(x05a, y33+r); drawto(x05a, y34-r) // left line of SLCT

  moveto(x07-hw1, y10+r); drawto(x07-hw1, y11-r) // left vertical of TABLE
  moveto(x07+hw1, y10+r); drawto(x07+hw1, y11-r) // right vertical of TABLE

  moveto(x05d, y33+r);    drawto(x05d, y34-r)    // right vertical of SLCT

  moveto(x05cm, y08+r);    drawto(x05cm, y09-r) // vertical in MATCH
  moveto(x05em, y08+r);    drawto(x05em, y09-r) // vertical in MATCH


  moveto(x09,  y04+r); drawto(x09,  y40-r)
/*
  moveto(x09a, y90+r); drawto(x09a, y94-r)

  moveto(x15-hw1, y90+r); drawto(x15-hw1, y92-r)
  moveto(x15+hw1, y90+r); drawto(x15+hw1, y92-r)
  moveto(x15-hw2, y89+r); drawto(x15-hw2, y90-r)
  moveto(x15+hw2, y89+r); drawto(x15+hw2, y90-r)

  moveto(x15-hw1, y86+r); drawto(x15-hw1, y88-r)
  moveto(x15+hw1, y86+r); drawto(x15+hw1, y88-r)

  moveto(x12, y78+r); drawto(x12, y82-r)

  moveto(x12, y66+r); drawto(x12, y68-r)
  moveto(x16, y66+r); drawto(x16, y68-r)

  moveto(x12, y62+r); drawto(x12, y64-r)
  moveto(x12, y55+r); drawto(x12, y56-r)

  moveto(x10, y53+r); drawto(x10, y90-r)
  moveto(x18, y54+r); drawto(x18, y94-r)
*/
  // Draw the horizontal lines

/*
  moveto(x09a+r,    y94);  drawto(x18-r,     y94)
  moveto(x15-hw2+r, y89);  drawto(x15+hw2-r, y89)
*/
  moveto(x05a+r, y33);  drawto(x09-r, y33)
  //moveto(x05a+r, y31);  drawto(x09-r,  y31)
  //moveto(x10+r, y53);   drawto(x18,    y53)
/*
  
  moveto(x09+r, y27); drawto(x18-r, y27)
  moveto(x15-hw2+r, y24); drawto(x15+hw2-r, y24)
  
  moveto(x10+r, y01); drawto(x18, y01)
*/

  // Draw the arrow heads
  drawarrow(0, x10, y40, 20)  // Arrow

  // Draw path bends
  
  rndcorner(0, x02, y40, r)  // name
  rndcorner(2, x02, y38, r)  // const
  rndcorner(2, x02, y36, r)  // string
  rndcorner(2, x02, y34, r)  // SLCT
  rndcorner(2, x02, y26, r)  // jcom
  rndcorner(2, x02, y24, r)  // ( E0 )
  rndcorner(2, x02, y22, r)  // FLOAT
  rndcorner(2, x02, y20, r)  // FIX
  rndcorner(2, x02, y18, r)  // rv
  rndcorner(2, x02, y16, r)  // @
  rndcorner(2, x02, y14, r)  // posop
  rndcorner(2, x02, y12, r)  // NOT
  rndcorner(2, x02, y10, r)  // TABLE
  rndcorner(2, x02, y08, r)  // MATCH
  rndcorner(2, x02, y06, r)  // EVERY
  rndcorner(2, x02, y04, r)  // VALOF
  
  rndcorner(0, x05a,  y34, r) // SLCT
  rndcorner(0, x05d,  y34, r) // SLCT
  rndcorner(3, x09,   y34, r) // SLCT
  rndcorner(2, x05a,  y33, r) // line
  rndcorner(2, x05d,  y33, r) // line

  rndcorner(1, x04, y22, r)  // FLOAT
  rndcorner(3, x04, y20, r)  // FLOAT
  rndcorner(3, x04, y18, r)  // FLOAT
  rndcorner(3, x04, y16, r)  // FLOAT

  rndcorner(1, x04, y08, r)  // FLOAT
  rndcorner(3, x04, y06, r)  // FLOAT

  rndcorner(1, x05cm, y09, r)  // , above MATCH
  rndcorner(0, x05em, y09, r)  // , above MATCH
  rndcorner(2, x05cm, y08, r)  // MATCH
  rndcorner(3, x05em, y08, r)  // MATCH

  rndcorner(1, x09, y40, r)  // name
  rndcorner(3, x09, y38, r)  // const
  rndcorner(3, x09, y36, r)  // string
  rndcorner(3, x09, y33, r)  // line of SLCT
  //rndcorner(3, x09, y31, r)  // bottom line of SLCT
  rndcorner(3, x09, y26, r)  // jcom
  rndcorner(3, x09, y24, r)  // ( E0 )
  rndcorner(3, x09, y22, r)  // FLOAT
  rndcorner(3, x09, y14, r)  // posop
  rndcorner(3, x09, y12, r)  // NOT
  rndcorner(3, x09, y10, r)  // TABLE
  rndcorner(3, x09, y08, r)  // MATCH
  rndcorner(3, x09, y04, r)  // VALOF

/*
  rndcorner(1, x09a, y94, r)  // 
  rndcorner(2, x09a, y90, r)  // 

  rndcorner(1, x15-hw1, y92, r)  // , above ( E0 )
  rndcorner(0, x15+hw1, y92, r)  // . above ( E0 )
  rndcorner(2, x15-hw1, y90, r)  // ( E0  )
  rndcorner(3, x15+hw1, y90, r)  // ( E0  )

  rndcorner(0, x15-hw2, y90, r)  // ( E0  )
  rndcorner(1, x15+hw2, y90, r)  // ( E0  )
  rndcorner(2, x15-hw2, y89, r)  // , below ( E0 )
  rndcorner(3, x15+hw2, y89, r)  // , below ( E0 )

  rndcorner(0, x10, y90, r)  // ( E0  )

  rndcorner(1, x15-hw1, y88, r)  // , above #( E0 )
  rndcorner(0, x15+hw1, y88, r)  // . above #( E0 )
  rndcorner(2, x15-hw1, y86, r)  // #( E0  )
  rndcorner(3, x15+hw1, y86, r)  // #( E0  )

  rndcorner(2, x10, y86, r)  // #( E0  )
  rndcorner(2, x10, y84, r)  // [  E0  ]
  rndcorner(2, x10, y82, r)  // OF
  rndcorner(2, x10, y80, r)  // !
  rndcorner(2, x10, y78, r)  // %
  rndcorner(2, x10, y76, r)  // mulop
  rndcorner(2, x10, y72, r)  // addop
  rndcorner(2, x10, y68, r)  // relop
  rndcorner(2, x10, y64, r)  // <<
  rndcorner(2, x10, y62, r)  // >>
  rndcorner(2, x10, y60, r)  // &
  rndcorner(2, x10, y58, r)  // |
  rndcorner(2, x10, y56, r)  // EQV
  rndcorner(2, x10, y55, r)  // XOR
  rndcorner(2, x10, y54, r)  // fcond

  rndcorner(1, x12, y82, r)  // OF
  rndcorner(3, x12, y80, r)  // !
  rndcorner(3, x12, y78, r)  // %
  rndcorner(0, x12, y68, r)  // relop
  rndcorner(1, x12, y68, r)  // relop
  rndcorner(2, x12, y66, r)  // E4

  rndcorner(1, x12, y64, r)  // <<
  rndcorner(3, x12, y62, r)  // >>

  rndcorner(1, x12, y56, r)  // EQV
  rndcorner(3, x12, y55, r)  // XOR

  rndcorner(0, x16, y68, r)  // relop
  rndcorner(3, x16, y66, r)  // E4


  rndcorner(0, x18, y94, r)  // top line
  rndcorner(3, x18, y90, r)  // ( E0  )
  rndcorner(3, x18, y86, r)  // #( E0  )
  rndcorner(3, x18, y84, r)  // [  E0  ]
  rndcorner(3, x18, y82, r)  // OF

  rndcorner(3, x18, y76, r)  // mulop
  rndcorner(3, x18, y72, r)  // addop
  rndcorner(3, x18, y66, r)  // E4 below relop
  rndcorner(3, x18, y64, r)  // <<

  rndcorner(3, x18, y60, r)  // &
  rndcorner(3, x18, y58, r)  // |
  rndcorner(3, x18, y56, r)  // EQV

  rndcorner(3, x18, y54, r)  // fcond

  rndcorner(2, x10, y53, r)  // arrow
*/
/*
  rndcorner(2, x02, c14, r)  // 
  rndcorner(3, x05, c14, r)  // 
  rndcorner(2, x02, c13, r)  // 
  rndcorner(1, x05, c13, r)  // 
  rndcorner(3, x09, c13, r)  // 
  rndcorner(2, x02, c12, r)  // 
  rndcorner(3, x05, c12, r)  // 
  rndcorner(2, x02, c11, r)  // 
  rndcorner(3, x05, c11, r)  // 
  rndcorner(2, x02, c10, r)  // 
  rndcorner(3, x09, c10, r)  //
*/
  rndcorner(1, x07-hw1, y11, r)  // , above TABLE
  rndcorner(2, x07-hw1, y10, r)  // TABLE
  rndcorner(0, x07+hw1, y11, r)  // , above TABLE
  rndcorner(3, x07+hw1, y10, r)  // TABLE
/*
  rndcorner(3, x09, c08, r)  // 
  rndcorner(2, x02, c07, r)  // 
  rndcorner(3, x09, c07, r)  // 
  rndcorner(2, x02, c06, r)  // 
  rndcorner(0, x08, c06, r)  // 
  rndcorner(1, x03, c05, r)  // 
  rndcorner(3, x08, c05, r)  // 
  rndcorner(2, x03, c04, r)  // 
  rndcorner(0, x08, c04, r)  // 
  rndcorner(1, x03, c03, r)  // 
  rndcorner(3, x08, c03, r)  // 
  rndcorner(2, x03, c02, r)  // 
  rndcorner(3, x09, c02, r)  // 
  rndcorner(2, x03, c01, r)  // 
  rndcorner(3, x09, c01, r)  //
  rndcorner(1, x09, y27, r)  // 
  rndcorner(0, x18, y27, r)  // 

  rndcorner(1, x15-hw1, y26, r)  // 
  rndcorner(0, x15+hw1, y26, r)  // 

  rndcorner(2, x09,     y25, r)  // 
  rndcorner(0, x10,     y25, r)  // 
  rndcorner(0, x15-hw2, y25, r)  // 
  rndcorner(2, x15-hw1, y25, r)  // 
  rndcorner(3, x15+hw1, y25, r)  // 
  rndcorner(1, x15+hw2, y25, r)  // 
  rndcorner(3, x18,     y25, r)  // 

  rndcorner(2, x15-hw2, y24, r)  // 
  rndcorner(3, x15+hw2, y24, r)  // 
  rndcorner(2, x10, y23, r)  // 
  rndcorner(1, x12, y23, r)  // 
  rndcorner(3, x18, y23, r)  // 
  rndcorner(2, x10, y22, r)  // 
  rndcorner(3, x12, y22, r)  // 
  rndcorner(2, x10, y21, r)  // 
  rndcorner(3, x12, y21, r)  // 

  rndcorner(2, x10, y20, r)  // 
  rndcorner(1, x12, y20, r)  // 
  rndcorner(3, x18, y20, r)  // 
  rndcorner(2, x10, y19, r)  // 
  rndcorner(3, x12, y19, r)  // 
  rndcorner(2, x10, y18, r)  // 
  rndcorner(3, x12, y18, r)  // 

  rndcorner(2, x10, y17, r)  // 
  rndcorner(1, x12, y17, r)  // 
  rndcorner(3, x18, y17, r)  // 
  rndcorner(2, x10, y16, r)  // 
  rndcorner(3, x12, y16, r)  // 

  rndcorner(2, x10, y15, r)  // 
  rndcorner(0, x12, y15, r)  // 
  rndcorner(1, x12, y15, r)  // 
  rndcorner(0, x16, y15, r)  // 

  rndcorner(2, x10, y14, r)  // 
  rndcorner(0, x12, y14, r)  // 
  rndcorner(1, x12, y14, r)  // 
  rndcorner(0, x16, y14, r)  // 

  rndcorner(2, x10, y13, r)  // 
  rndcorner(0, x12, y13, r)  // 
  rndcorner(1, x12, y13, r)  // 
  rndcorner(0, x16, y13, r)  // 

  rndcorner(2, x10, y12, r)  // 
  rndcorner(0, x12, y12, r)  // 
  rndcorner(1, x12, y12, r)  //
  rndcorner(0, x16, y12, r)  // 

  rndcorner(2, x10, y11, r)  // 
  rndcorner(0, x12, y11, r)  // 
  rndcorner(1, x12, y11, r)  // 
  rndcorner(0, x16, y11, r)  // 

  rndcorner(2, x10, y10, r)  // 
  rndcorner(0, x12, y10, r)  // 
  rndcorner(1, x12, y10, r)  // 
  rndcorner(0, x16, y10, r)  // 

  rndcorner(2, x12, y09, r)  // 
  rndcorner(3, x16, y09, r)  // 

  rndcorner(2, x10, y08, r)  // 
  rndcorner(1, x12, y08, r)  // 
  rndcorner(3, x18, y08, r)  // 

  rndcorner(2, x10, y07, r)  // 
  rndcorner(3, x12, y07, r)  // 

  rndcorner(2, x10, y06, r)  // 
  rndcorner(3, x18, y06, r)  // 

  rndcorner(2, x10, y05, r)  // 
  rndcorner(3, x18, y05, r)  // 

  rndcorner(2, x10, y04, r)  // 
  rndcorner(1, x12, y04, r)  // 
  rndcorner(3, x18, y04, r)  // 

  rndcorner(2, x10, y03, r)  // 
  rndcorner(3, x12, y03, r)  // 

  rndcorner(2, x10, y02, r)  // 
  rndcorner(3, x18, y02, r)  // 

  rndcorner(2, x10, y01, r)  // 
*/
  // Draw the text
  charleveloffset := charmidleveloffset

  //drawstr(x00,  y02, "currco")
  //drawstrcentred(c05m,  y04m,  "fn")

  charleveloffset := 0

  //drawcurlyH(x06, y18, x12-x06, 20)
  //drawcurlyH(x12, y18, x17-x12, 20)

  writef("width = %n height = %n %5.1d in*n",
          width, height, 10*width / 300 *120/100) // 300 DPI
  { LET mmwidth = width * 10 / 150 * 254 / 10 // mm at 150 DPI
    newline()
    sawritef("width = %5.1d mm*n*n*n", mmwidth)
  }
}

AND start() = VALOF
{ LET stdout = output()
  LET xsize, ysize = width, height

  LET tofilename = "junk.bmp"
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0

  UNLESS openbdraw(xsize, ysize) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(24)
  charleveloffset := 0
  charleveloffset := charmidleveloffset

IF FALSE DO           // Draw the frame
  { currpen := penS3
    moveto(1, yupb-1); drawto(xupb-2, yupb-1)
    moveto(1, 1);      drawto(xupb-2, 1)
    moveto(xupb-1, yupb-1); drawto(xupb-1, 1)
    moveto(1, 1);      drawto(1, yupb-1)
  }


  drawdiagram()

draw:
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}


