GET "libhdr"

GET "plotflow.h"

/*

y15           x3                                                       x17
y14 x0 x1-x2--[namme]---------------------------------------------x16-->
          |                                                       |
y13       |---[canst string]--------------------------------------|
          !            x4        x6    x7        x9    x10        |
y12       |---[SLCT]---(E9)--x5--[:]---(E9)--x8=-[:]---(E9)-------|
          !                  |               |                    |
y11       |                   ------------------------------------|
          !                                                       |
y10       |---[jcom]----------------------------------------------|
          !         x18    x19                                    |
y9        |---[(]---(E0)---[)]------------------------------------|
          !                      x20                              |
y8        |---[(FLOAT FIX ! @]---(E7)-----------------------------|
          !               x21                                     |
y7        |---[posop]-----(E5)------------------------------------|
          !               x22                                     |
y6        |---[~]---------(E5)------------------------------------|
          !                                                       |
y5        !                       x12--[,]---x13                  |
          !                       |          |                    |
y4        |---[TABLE]-----------------(E0)------------------------|
          !                                                       |
y3        !                        ----[,]---                     |
          !                  x11  |          |  x14   x15         |
y2        |---[MATCH EVERY]--[(]-----(E0)-------[)]---(Mlist}-----x16
          !               x23                                     |
y1        x2--[VALOF]-----(C)-------------------------------------x16
y0
*/

MANIFEST {
y0  = 0
y1  = y0+hcc
y2  = y1+hcc
y3  = y2+hcc
y4  = y3+hcc
y5  = y4+hcc
y6  = y5+hcc
y7  = y6+hcc
y8  = y7+hcc
y9  = y8+hcc
y10 = y9+hcc
y11 = y10+hcc
y12 = y11+hcc
y13 = y12+hcc
y14 = y13+hcc
y15 = y14+hcc


x0  = 0
x1  = x0+20
x2  = x1+wcc
x3  = x2+wcc
x4  = x3+wl4+wcc       //  (E9) after [SLCT]
x5  = x4+wl2+wcc       //  vertical
x6  = x5+wcc           //  [:]
x7  = x6+wl1+wcc       //  (E9)
x8  = x7+wl2+wcc       //  vertical
x9  = x8+wcc           //  [:]
x10 = x9+wl1+wcc       // (E9)
x11 = x3+wl11+wcc      // [(] after [MATCH EVERY]    
x12 = x11+wl1+wcc      // vertical on left of [,] on y5 
x13 = x12+wcc+wl1+wcc  // vertical on right of [,] on y5 
x14 = x13+wcc          // vertical after x13 on y4
x15 = x14+wl1+wcc      // (Mlist) after [)] on y2
x16 = x15+wl5+wcc      // righthand vertical
x17 = x16+wcc          // righthand edge
x18 = x3+wl1+wcc       // (E0) after [(] on y9
x19 = x18+wl2+wcc      // [)] after (E0) on y9
x20 = x3+wl13+wcc      // (E0) after [FLOAT FIX ! @] on y8
x21 = x3+wl5++wcc      // (E0) after [(] on y7
x22 = x21              // (E5) after [~] on y6
x23 = x22       // (C) after [VALOF] on y1

  width = (x17+50) &-4
  height = y15+30

}


LET drawdiagram() BE
{ LET r = bendradius

  currpen := penS3

  drawtestboxL(y14, x1, x3, x17, "name")
  drawarrow(0, x17, y14, 20)  // Arrow
  moveto(x2,  y14-r); drawto(x2,  y1+r)
  moveto(x16, y14-r); drawto(x16, y1+r)
  rndcorner(0, x2,  y14, r)
  rndcorner(1, x16, y14, r)

  drawtestboxL(y13, x2+r, x3,  x16-r,     "const string")
  rndcorner(2, x2,  y13, r)
  rndcorner(3, x16, y13, r)

  drawtestboxL(y12, x2+r, x3,  x4,    "SLCT")
  drawcatboxL (y12, x4,   x4,  x6,    "E9")
  drawtestboxL(y12, x6,   x6,  x7,    ":")
  drawcatboxL (y12, x7,   x7,  x9,    "E9")
  drawtestboxL(y12, x9,   x9,  x10,   ":")
  drawcatboxL (y12, x10,  x10, x16-r, "E9")
  moveto(x5,  y12-r); drawto(x5,  y11+r)
  moveto(x8,  y12-r); drawto(x8,  y11+r)
  rndcorner(2, x2,  y12, r)
  rndcorner(0, x5,  y12, r)
  rndcorner(0, x8,  y12, r)
  rndcorner(3, x16, y12, r)

  moveto(x5+r,  y11); drawto(x16-r,  y11)
  rndcorner(2, x5,  y11, r)
  rndcorner(2, x8,  y11, r)
  rndcorner(3, x16, y11, r)

  drawtestboxL(y10, x2+r, x3,  x16-r,     "jcom")
  rndcorner(2, x2,  y10, r)
  rndcorner(3, x16, y10, r)

  drawtestboxL(y9, x2+r, x3,  x18,     "(")
  drawcatboxL (y9, x18, x18,  x19,     "E7")
  drawtestboxL(y9, x19, x19,  x16-r,   ")")
  rndcorner(2, x2,  y9, r)
  rndcorner(3, x16, y9, r)



  drawtestboxL(y8, x2+r, x3,   x20,     "FLOAT FIX ! @")
  drawcatboxL (y8, x20,  x20,  x16-r,     "E7")
  rndcorner(2, x2,  y8, r)
  rndcorner(3, x16, y8, r)

  drawtestboxL(y7, x2+r, x3,   x21,     "posop")
  drawcatboxL (y7, x21,  x21,  x16-r,   "E5")
  rndcorner(2, x2,  y7, r)
  rndcorner(3, x16, y7, r)

  drawtestboxL(y6, x2+r, x3,   x22,     "~")
  drawcatboxL (y6, x22,  x22,  x16-r,   "E5")
  rndcorner(2, x2,  y6, r)
  rndcorner(3, x16, y6, r)

  drawtestboxC(y5, x12+r, (x12+x13)/2,   x13-r,     ",")
  moveto(x12,  y5-r); drawto(x12,  y4+r)
  moveto(x13,  y5-r); drawto(x13,  y4+r)
  rndcorner(1, x12,  y5, r)
  rndcorner(0, x13, y5, r)

  drawtestboxL(y4, x2+r, x3, x12,     "TABLE")
  drawcatboxC (y4, x12,  (x12+x13)/2, x13,    "E0")
  moveto(x13,  y4); drawto(x16-r,  y4)
  rndcorner(2, x2,  y4, r)
  rndcorner(2, x12, y4, r)
  rndcorner(3, x13, y4, r)
  rndcorner(3, x16, y4, r)



  drawtestboxC(y3, x12+r, (x12+x13)/2,   x13-r,     ",")
  moveto(x12,  y3-r); drawto(x12,  y2+r)
  moveto(x13,  y3-r); drawto(x13,  y2+r)
  rndcorner(1, x12, y3, r)
  rndcorner(0, x13, y3, r)

  drawtestboxL(y2, x2+r, x3, x11,     "MATCH EVERY")
  drawtestboxL(y2, x11, x11, x12,     "(")
  drawcatboxC (y2, x12,  (x12+x13)/2, x13,    "E0")
  drawtestboxL(y2, x13, x14, x15,     ")")
  drawcatboxL (y2, x15, x15, x16-r,   "Mlist")
  rndcorner(2, x2,  y2, r)
  rndcorner(2, x12, y2, r)
  rndcorner(3, x13, y2, r)
  rndcorner(3, x16, y2, r)

  drawtestboxL(y1, x2+r, x3,  x23,    "VALOF")
  drawcatboxL (y1, x23,  x23, x16-r,  "C")
  rndcorner(2, x2,  y1, r)
  rndcorner(3, x16, y1, r)

}


LET start() = VALOF
{ LET stdout = output()
  LET tofilename = "junk.bmp"
  LET widthonly = FALSE
  LET argv = VEC 50
  
  UNLESS rdargs("to/k,-d/S,-w/S", argv, 50) DO
  { writef("Bad arguments for tst, format: -s/s*n")
    RESULTIS 0
  }

  IF argv!0 DO tofilename := argv!0
  widthonly := argv!2

  UNLESS openbdraw(width, height) DO
  { writef("Unable to open the graphics library*n")
    GOTO fin
  }

  currcol := col_black
  selectfont(16)
  charleveloffset := charmidleveloffset
  currpen := penS3
  
  { // Assume 12 chars per inch ie 12*(fontW+charHsep) pixels per inch
    // or 12*(charW+charHsep) pixels per 25.4 mm
    // so one pixel has a width of 25.4 / (12*(fontW+charHsep)) mm
    // So the width in mm of the image is width * 25.4 / (12*(fontW+charHsep))
    LET mmwidth = width * 254 / (12*(fontW+charHsep))
    // The is a scaled with 1 digit after the decimal point. 
    writef("%s: width = %n pixels  height = %n pixels    %5.1d mm*n",
            tofilename, width, height, mmwidth)
  }

  IF widthonly GOTO fin
  
draw:
  drawdiagram()
  wrbmp(tofilename)

fin:
  closebdraw()

  RESULTIS 0
}
